/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyNameError;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.builtin.IRubyObject;

@JRubyClass(name={"NoMethodError"}, parent="NameError")
public class RubyNoMethodError
extends RubyNameError {
    private IRubyObject args;
    private static final ObjectAllocator NOMETHODERROR_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyNoMethodError(runtime, klass);
        }
    };

    public static RubyClass createNoMethodErrorClass(Ruby runtime, RubyClass nameErrorClass) {
        RubyClass noMethodErrorClass = runtime.defineClass("NoMethodError", nameErrorClass, NOMETHODERROR_ALLOCATOR);
        noMethodErrorClass.defineAnnotatedMethods(RubyNoMethodError.class);
        return noMethodErrorClass;
    }

    protected RubyNoMethodError(Ruby runtime, RubyClass exceptionClass) {
        super(runtime, exceptionClass, exceptionClass.getName());
        this.args = runtime.getNil();
    }

    public RubyNoMethodError(Ruby runtime, RubyClass exceptionClass, String message, String name, IRubyObject args) {
        super(runtime, exceptionClass, message, name);
        this.args = args;
    }

    @Override
    @JRubyMethod(name={"initialize"}, optional=3, frame=true)
    public IRubyObject initialize(IRubyObject[] args, Block block) {
        if (args.length > 2) {
            this.args = args[args.length - 1];
            IRubyObject[] tmpArgs = new IRubyObject[args.length - 1];
            System.arraycopy(args, 0, tmpArgs, 0, tmpArgs.length);
            args = tmpArgs;
        } else {
            this.args = this.getRuntime().getNil();
        }
        super.initialize(args, block);
        return this;
    }

    @JRubyMethod(name={"args"})
    public IRubyObject args() {
        return this.args;
    }
}

