/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import org.joni.encoding.specific.ASCIIEncoding;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyBignum;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyComplex;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyFloat;
import org.jruby.nb.RubyInteger;
import org.jruby.nb.RubyMatchData;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyNumeric;
import org.jruby.nb.RubyObject;
import org.jruby.nb.RubyRegexp;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.common.IRubyWarnings;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Frame;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.Numeric;
import org.jruby.util.ByteList;

@JRubyClass(name={"Rational"}, parent="Numeric", include={"Precision"})
public class RubyRational
extends RubyNumeric {
    private static ObjectAllocator RATIONAL_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyRational(runtime, klass, RubyFixnum.zero(runtime), RubyFixnum.one(runtime));
        }
    };
    private IRubyObject num;
    private IRubyObject den;
    private static long ML = (long)(Math.log(Double.MAX_VALUE) / Math.log(2.0) - 1.0);

    public static RubyClass createRationalClass(Ruby runtime) {
        RubyClass rationalc = runtime.defineClass("Rational", runtime.getNumeric(), RATIONAL_ALLOCATOR);
        runtime.setRational(rationalc);
        rationalc.index = 21;
        rationalc.kindOf = new RubyModule.KindOf(){

            @Override
            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyRational;
            }
        };
        ThreadContext context = runtime.getCurrentContext();
        rationalc.callMethod(context, "private_class_method", runtime.newSymbol("allocate"));
        rationalc.defineAnnotatedMethods(RubyRational.class);
        return rationalc;
    }

    private RubyRational(Ruby runtime, IRubyObject clazz, IRubyObject num, IRubyObject den) {
        super(runtime, (RubyClass)clazz);
        this.num = num;
        this.den = den;
    }

    static RubyRational newRationalRaw(Ruby runtime, IRubyObject x, RubyObject y) {
        return new RubyRational(runtime, runtime.getRational(), x, y);
    }

    static RubyRational newRationalRaw(Ruby runtime, IRubyObject x) {
        return new RubyRational(runtime, runtime.getRational(), x, RubyFixnum.one(runtime));
    }

    static IRubyObject newRationalCanonicalize(ThreadContext context, IRubyObject x) {
        return RubyRational.newRationalCanonicalize(context, x, RubyFixnum.one(context.getRuntime()));
    }

    private static IRubyObject newRationalCanonicalize(ThreadContext context, IRubyObject x, IRubyObject y) {
        return RubyRational.canonicalizeInternal(context, context.getRuntime().getRational(), x, y);
    }

    private static IRubyObject newRational(ThreadContext context, IRubyObject clazz, IRubyObject x, IRubyObject y) {
        assert (x instanceof RubyRational && y instanceof RubyRational);
        return RubyRational.canonicalizeInternal(context, clazz, x, y);
    }

    private static IRubyObject newRational(ThreadContext context, IRubyObject clazz, IRubyObject x) {
        assert (x instanceof RubyRational);
        return RubyRational.canonicalizeInternal(context, clazz, x, RubyFixnum.one(context.getRuntime()));
    }

    private static IRubyObject newRationalNoReduce(ThreadContext context, IRubyObject clazz, IRubyObject x, IRubyObject y) {
        assert (x instanceof RubyRational && y instanceof RubyRational);
        return RubyRational.canonicalizeInternalNoReduce(context, clazz, x, y);
    }

    private static IRubyObject newRationalNoReduce(ThreadContext context, IRubyObject clazz, IRubyObject x) {
        assert (x instanceof RubyRational);
        return RubyRational.canonicalizeInternalNoReduce(context, clazz, x, RubyFixnum.one(context.getRuntime()));
    }

    private static RubyRational newRationalBang(ThreadContext context, IRubyObject clazz, IRubyObject x, IRubyObject y) {
        assert (!Numeric.f_negative_p(context, y) && !Numeric.f_zero_p(context, y));
        return new RubyRational(context.getRuntime(), clazz, x, y);
    }

    private static RubyRational newRationalBang(ThreadContext context, IRubyObject clazz, IRubyObject x) {
        return RubyRational.newRationalBang(context, clazz, x, RubyFixnum.one(context.getRuntime()));
    }

    @Deprecated
    public static IRubyObject newInstanceBang(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        switch (args.length) {
            case 1: {
                return RubyRational.newInstanceBang(context, recv, args[0]);
            }
            case 2: {
                return RubyRational.newInstanceBang(context, recv, args[0], args[1]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args.length, 1, 1);
        return null;
    }

    @JRubyMethod(name={"new!"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject newInstanceBang(ThreadContext context, IRubyObject recv, IRubyObject num) {
        return RubyRational.newInstanceBang(context, recv, num, RubyFixnum.one(context.getRuntime()));
    }

    @JRubyMethod(name={"new!"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject newInstanceBang(ThreadContext context, IRubyObject recv, IRubyObject num, IRubyObject den) {
        Ruby runtime;
        IRubyObject res;
        if (!(num instanceof RubyInteger)) {
            num = Numeric.f_to_i(context, num);
        }
        if (!(den instanceof RubyInteger)) {
            den = Numeric.f_to_i(context, den);
        }
        if ((res = Numeric.f_cmp(context, den, RubyFixnum.zero(runtime = context.getRuntime()))) == RubyFixnum.minus_one(runtime)) {
            num = Numeric.f_negate(context, num);
            den = Numeric.f_negate(context, den);
        } else if (res == RubyFixnum.zero(runtime)) {
            throw runtime.newZeroDivisionError();
        }
        return new RubyRational(runtime, recv, num, den);
    }

    private static void intCheck(IRubyObject num) {
        if (!(num instanceof RubyFixnum) && !(num instanceof RubyBignum)) {
            throw num.getRuntime().newArgumentError("not an integer");
        }
    }

    private static IRubyObject canonicalizeInternal(ThreadContext context, IRubyObject clazz, IRubyObject num, IRubyObject den) {
        Ruby runtime = context.getRuntime();
        IRubyObject res = Numeric.f_cmp(context, den, RubyFixnum.zero(runtime));
        if (res == RubyFixnum.minus_one(runtime)) {
            num = Numeric.f_negate(context, num);
            den = Numeric.f_negate(context, den);
        } else if (res == RubyFixnum.zero(runtime)) {
            throw runtime.newZeroDivisionError();
        }
        IRubyObject gcd = Numeric.f_gcd(context, num, den);
        num = Numeric.f_idiv(context, num, gcd);
        den = Numeric.f_idiv(context, den, gcd);
        if (Numeric.f_one_p(context, den) && ((RubyModule)clazz).fastHasConstant("Unify")) {
            return num;
        }
        return new RubyRational(context.getRuntime(), clazz, num, den);
    }

    private static IRubyObject canonicalizeInternalNoReduce(ThreadContext context, IRubyObject clazz, IRubyObject num, IRubyObject den) {
        Ruby runtime = context.getRuntime();
        IRubyObject res = Numeric.f_cmp(context, den, RubyFixnum.zero(runtime));
        if (res == RubyFixnum.minus_one(runtime)) {
            num = Numeric.f_negate(context, num);
            den = Numeric.f_negate(context, den);
        } else if (res == RubyFixnum.zero(runtime)) {
            throw runtime.newZeroDivisionError();
        }
        if (Numeric.f_equal_p(context, den, RubyFixnum.one(runtime)) && ((RubyModule)clazz).fastHasConstant("Unify")) {
            return num;
        }
        return new RubyRational(context.getRuntime(), clazz, num, den);
    }

    @Deprecated
    public static IRubyObject newInstance(ThreadContext context, IRubyObject clazz, IRubyObject[] args) {
        switch (args.length) {
            case 1: {
                return RubyRational.newInstance(context, clazz, args[0]);
            }
            case 2: {
                return RubyRational.newInstance(context, clazz, args[0], args[1]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args.length, 1, 1);
        return null;
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject clazz, IRubyObject num) {
        RubyRational.intCheck(num);
        return RubyRational.canonicalizeInternal(context, clazz, num, RubyFixnum.one(context.getRuntime()));
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject clazz, IRubyObject num, IRubyObject den) {
        RubyRational.intCheck(num);
        RubyRational.intCheck(den);
        return RubyRational.canonicalizeInternal(context, clazz, num, den);
    }

    public static IRubyObject newRationalConvert(ThreadContext context, IRubyObject x) {
        return RubyRational.newRationalConvert(context, x, RubyFixnum.one(context.getRuntime()));
    }

    public static IRubyObject newRationalConvert(ThreadContext context, IRubyObject x, IRubyObject y) {
        return RubyRational.convert(context, context.getRuntime().getRational(), x, y);
    }

    @Deprecated
    public static IRubyObject convert(ThreadContext context, IRubyObject clazz, IRubyObject[] args) {
        switch (args.length) {
            case 0: {
                return RubyRational.convert(context, clazz);
            }
            case 1: {
                return RubyRational.convert(context, clazz, args[0]);
            }
            case 2: {
                return RubyRational.convert(context, clazz, args[0], args[1]);
            }
        }
        Arity.raiseArgumentError(context.getRuntime(), args.length, 0, 2);
        return null;
    }

    @JRubyMethod(name={"convert"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject convert(ThreadContext context, IRubyObject recv) {
        IRubyObject nil = context.getRuntime().getNil();
        return RubyRational.convertCommon(context, recv, nil, nil);
    }

    @JRubyMethod(name={"convert"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject convert(ThreadContext context, IRubyObject recv, IRubyObject a1) {
        return RubyRational.convertCommon(context, recv, a1, context.getRuntime().getNil());
    }

    @JRubyMethod(name={"convert"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject convert(ThreadContext context, IRubyObject recv, IRubyObject a1, IRubyObject a2) {
        return RubyRational.convertCommon(context, recv, a1, a2);
    }

    private static IRubyObject convertCommon(ThreadContext context, IRubyObject recv, IRubyObject a1, IRubyObject a2) {
        Frame frame;
        IRubyObject backref;
        if (a1 instanceof RubyComplex) {
            RubyComplex a1Complex = (RubyComplex)a1;
            if (a1Complex.getImage() instanceof RubyFloat || !Numeric.f_zero_p(context, a1Complex.getImage())) {
                IRubyObject s = Numeric.f_to_s(context, a1);
                throw context.getRuntime().newArgumentError("can't accept " + s.convertToString());
            }
            a1 = a1Complex.getReal();
        }
        if (a2 instanceof RubyComplex) {
            RubyComplex a2Complex = (RubyComplex)a2;
            if (a2Complex.getImage() instanceof RubyFloat || !Numeric.f_zero_p(context, a2Complex.getImage())) {
                IRubyObject s = Numeric.f_to_s(context, a2);
                throw context.getRuntime().newArgumentError("can't accept " + s.convertToString());
            }
            a2 = a2Complex.getReal();
        }
        if ((backref = (frame = context.getCurrentFrame()).getBackRef()) != null && backref instanceof RubyMatchData) {
            ((RubyMatchData)backref).use();
        }
        if (a1 instanceof RubyFloat) {
            a1 = Numeric.f_to_r(context, a1);
        } else if (a1 instanceof RubyString) {
            a1 = RubyRational.str_to_r_strict(context, a1);
        }
        if (a2 instanceof RubyFloat) {
            a2 = Numeric.f_to_r(context, a2);
        } else if (a2 instanceof RubyString) {
            a2 = RubyRational.str_to_r_strict(context, a2);
        }
        frame.setBackRef(backref);
        if (a1 instanceof RubyRational) {
            if (a2.isNil() || Numeric.f_zero_p(context, a2)) {
                return a1;
            }
            return Numeric.f_div(context, a1, a2);
        }
        if (a2 instanceof RubyRational) {
            return Numeric.f_div(context, a1, a2);
        }
        return a2.isNil() ? RubyRational.newInstance(context, recv, a1) : RubyRational.newInstance(context, recv, a1, a2);
    }

    @JRubyMethod(name={"induced_from"}, meta=true)
    public static IRubyObject induced_from(ThreadContext context, IRubyObject recv, IRubyObject arg) {
        return Numeric.f_to_r(context, arg);
    }

    @Override
    @JRubyMethod(name={"numerator"})
    public IRubyObject numerator(ThreadContext context) {
        return this.num;
    }

    @Override
    @JRubyMethod(name={"denominator"})
    public IRubyObject denominator(ThreadContext context) {
        return this.den;
    }

    private static IRubyObject f_imul(ThreadContext context, long a, long b) {
        Ruby runtime = context.getRuntime();
        if (a == 0L || b == 0L) {
            return RubyFixnum.zero(runtime);
        }
        if (a == 1L) {
            return RubyFixnum.newFixnum(runtime, b);
        }
        if (b == 1L) {
            return RubyFixnum.newFixnum(runtime, a);
        }
        long c = a * b;
        if (c / a != b) {
            return RubyBignum.newBignum(runtime, a).op_mul(context, RubyBignum.newBignum(runtime, b));
        }
        return RubyFixnum.newFixnum(runtime, c);
    }

    private IRubyObject f_addsub(ThreadContext context, IRubyObject anum, IRubyObject aden, IRubyObject bnum, IRubyObject bden, boolean plus) {
        IRubyObject b;
        IRubyObject a;
        IRubyObject g;
        Ruby runtime = context.getRuntime();
        if (anum instanceof RubyFixnum && aden instanceof RubyFixnum && bnum instanceof RubyFixnum && bden instanceof RubyFixnum) {
            long an = ((RubyFixnum)anum).getLongValue();
            long ad = ((RubyFixnum)aden).getLongValue();
            long bn = ((RubyFixnum)bnum).getLongValue();
            long bd = ((RubyFixnum)bden).getLongValue();
            long ig = Numeric.i_gcd(ad, bd);
            g = RubyFixnum.newFixnum(runtime, ig);
            a = RubyRational.f_imul(context, an, bd / ig);
            b = RubyRational.f_imul(context, bn, ad / ig);
        } else {
            g = Numeric.f_gcd(context, aden, bden);
            a = Numeric.f_mul(context, anum, Numeric.f_idiv(context, bden, g));
            b = Numeric.f_mul(context, bnum, Numeric.f_idiv(context, aden, g));
        }
        IRubyObject c = plus ? Numeric.f_add(context, a, b) : Numeric.f_sub(context, a, b);
        b = Numeric.f_idiv(context, aden, g);
        g = Numeric.f_gcd(context, c, g);
        IRubyObject num = Numeric.f_idiv(context, c, g);
        a = Numeric.f_idiv(context, bden, g);
        IRubyObject den = Numeric.f_mul(context, a, b);
        return RubyRational.newRationalNoReduce(context, this.getMetaClass(), num, den);
    }

    @JRubyMethod(name={"+"})
    public IRubyObject op_add(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: {
                return this.f_addsub(context, this.num, this.den, other, RubyFixnum.one(context.getRuntime()), true);
            }
            case 11: {
                return Numeric.f_add(context, Numeric.f_to_f(context, this), other);
            }
            case 21: {
                RubyRational otherRational = (RubyRational)other;
                return this.f_addsub(context, this.num, this.den, otherRational.num, otherRational.den, true);
            }
        }
        return this.coerceBin(context, "+", other);
    }

    @JRubyMethod(name={"-"})
    public IRubyObject op_sub(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: {
                return this.f_addsub(context, this.num, this.den, other, RubyFixnum.one(context.getRuntime()), false);
            }
            case 11: {
                return Numeric.f_sub(context, Numeric.f_to_f(context, this), other);
            }
            case 21: {
                RubyRational otherRational = (RubyRational)other;
                return this.f_addsub(context, this.num, this.den, otherRational.num, otherRational.den, false);
            }
        }
        return this.coerceBin(context, "-", other);
    }

    private IRubyObject f_muldiv(ThreadContext context, IRubyObject anum, IRubyObject aden, IRubyObject bnum, IRubyObject bden, boolean mult) {
        IRubyObject den;
        IRubyObject num;
        if (!mult) {
            if (Numeric.f_negative_p(context, bnum)) {
                anum = Numeric.f_negate(context, anum);
                bnum = Numeric.f_negate(context, bnum);
            }
            IRubyObject tmp = bnum;
            bnum = bden;
            bden = tmp;
        }
        if (anum instanceof RubyFixnum && aden instanceof RubyFixnum && bnum instanceof RubyFixnum && bden instanceof RubyFixnum) {
            long an = ((RubyFixnum)anum).getLongValue();
            long ad = ((RubyFixnum)aden).getLongValue();
            long bn = ((RubyFixnum)bnum).getLongValue();
            long bd = ((RubyFixnum)bden).getLongValue();
            long g1 = Numeric.i_gcd(an, bd);
            long g2 = Numeric.i_gcd(ad, bn);
            num = RubyRational.f_imul(context, an / g1, bn / g2);
            den = RubyRational.f_imul(context, ad / g2, bd / g1);
        } else {
            IRubyObject g1 = Numeric.f_gcd(context, anum, bden);
            IRubyObject g2 = Numeric.f_gcd(context, aden, bnum);
            num = Numeric.f_mul(context, Numeric.f_idiv(context, anum, g1), Numeric.f_idiv(context, bnum, g2));
            den = Numeric.f_mul(context, Numeric.f_idiv(context, aden, g2), Numeric.f_idiv(context, bden, g1));
        }
        return RubyRational.newRationalNoReduce(context, this.getMetaClass(), num, den);
    }

    @JRubyMethod(name={"*"})
    public IRubyObject op_mul(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: {
                return this.f_muldiv(context, this.num, this.den, other, RubyFixnum.one(context.getRuntime()), true);
            }
            case 11: {
                return Numeric.f_mul(context, Numeric.f_to_f(context, this), other);
            }
            case 21: {
                RubyRational otherRational = (RubyRational)other;
                return this.f_muldiv(context, this.num, this.den, otherRational.num, otherRational.den, true);
            }
        }
        return this.coerceBin(context, "*", other);
    }

    @JRubyMethod(name={"/"})
    public IRubyObject op_div(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: {
                if (Numeric.f_zero_p(context, other)) {
                    throw context.getRuntime().newZeroDivisionError();
                }
                return this.f_muldiv(context, this.num, this.den, other, RubyFixnum.one(context.getRuntime()), false);
            }
            case 11: {
                return Numeric.f_to_f(context, this).callMethod(context, "/", other);
            }
            case 21: {
                if (Numeric.f_zero_p(context, other)) {
                    throw context.getRuntime().newZeroDivisionError();
                }
                RubyRational otherRational = (RubyRational)other;
                return this.f_muldiv(context, this.num, this.den, otherRational.num, otherRational.den, false);
            }
        }
        return this.coerceBin(context, "/", other);
    }

    @JRubyMethod(name={"fdiv"})
    public IRubyObject op_fdiv(ThreadContext context, IRubyObject other) {
        return Numeric.f_div(context, Numeric.f_to_f(context, this), other);
    }

    @JRubyMethod(name={"**"})
    public IRubyObject op_expt(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.getRuntime();
        if (Numeric.f_zero_p(context, other)) {
            return RubyRational.newRationalBang(context, this.getMetaClass(), RubyFixnum.one(runtime));
        }
        if (other instanceof RubyRational) {
            RubyRational otherRational = (RubyRational)other;
            if (Numeric.f_one_p(context, otherRational.den)) {
                other = otherRational.num;
            }
        }
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: {
                IRubyObject tden;
                IRubyObject tnum;
                IRubyObject res = Numeric.f_cmp(context, other, RubyFixnum.zero(runtime));
                if (res == RubyFixnum.one(runtime)) {
                    tnum = Numeric.f_expt(context, this.num, other);
                    tden = Numeric.f_expt(context, this.den, other);
                } else if (res == RubyFixnum.minus_one(runtime)) {
                    tnum = Numeric.f_expt(context, this.den, Numeric.f_negate(context, other));
                    tden = Numeric.f_expt(context, this.num, Numeric.f_negate(context, other));
                } else {
                    tden = RubyFixnum.one(runtime);
                    tnum = tden;
                }
                return RubyRational.newRational(context, this.getMetaClass(), tnum, tden);
            }
            case 11: 
            case 21: {
                return Numeric.f_expt(context, Numeric.f_to_f(context, this), other);
            }
        }
        return this.coerceBin(context, "**", other);
    }

    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: {
                if (this.den instanceof RubyFixnum && ((RubyFixnum)this.den).getLongValue() == 1L) {
                    return Numeric.f_cmp(context, this.num, other);
                }
                return Numeric.f_cmp(context, this, RubyRational.newRationalBang(context, this.getMetaClass(), other));
            }
            case 11: {
                return Numeric.f_cmp(context, Numeric.f_to_f(context, this), other);
            }
            case 21: {
                IRubyObject num2;
                IRubyObject num1;
                RubyRational otherRational = (RubyRational)other;
                if (this.num instanceof RubyFixnum && this.den instanceof RubyFixnum && otherRational.num instanceof RubyFixnum && otherRational.den instanceof RubyFixnum) {
                    num1 = RubyRational.f_imul(context, ((RubyFixnum)this.num).getLongValue(), ((RubyFixnum)otherRational.den).getLongValue());
                    num2 = RubyRational.f_imul(context, ((RubyFixnum)otherRational.num).getLongValue(), ((RubyFixnum)this.den).getLongValue());
                } else {
                    num1 = Numeric.f_mul(context, this.num, otherRational.den);
                    num2 = Numeric.f_mul(context, otherRational.num, this.den);
                }
                return Numeric.f_cmp(context, Numeric.f_sub(context, num1, num2), RubyFixnum.zero(context.getRuntime()));
            }
        }
        return this.coerceBin(context, "<=>", other);
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.getRuntime();
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: {
                if (Numeric.f_zero_p(context, this.num) && Numeric.f_zero_p(context, this.den)) {
                    return runtime.getTrue();
                }
                if (!(this.den instanceof RubyFixnum) || ((RubyFixnum)this.den).getLongValue() != 1L) {
                    return runtime.getFalse();
                }
                if (Numeric.f_equal_p(context, this.num, other)) {
                    return runtime.getTrue();
                }
                return runtime.getFalse();
            }
            case 11: {
                return Numeric.f_equal_p(context, Numeric.f_to_f(context, this), other) ? runtime.getTrue() : runtime.getFalse();
            }
            case 21: {
                RubyRational otherRational = (RubyRational)other;
                if (Numeric.f_zero_p(context, this.num) && Numeric.f_zero_p(context, otherRational.num)) {
                    return runtime.getTrue();
                }
                if (Numeric.f_equal_p(context, this.num, otherRational.num) && Numeric.f_equal_p(context, this.den, otherRational.den)) {
                    return runtime.getTrue();
                }
                return runtime.getFalse();
            }
        }
        return Numeric.f_equal_p(context, other, this) ? runtime.getTrue() : runtime.getFalse();
    }

    @JRubyMethod(name={"coerce"})
    public IRubyObject op_coerce(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.getRuntime();
        switch (other.getMetaClass().index) {
            case 1: 
            case 2: {
                return runtime.newArray(RubyRational.newRationalBang(context, this.getMetaClass(), other), this);
            }
            case 11: {
                return runtime.newArray(other, Numeric.f_to_f(context, this));
            }
        }
        throw runtime.newTypeError(other.getMetaClass() + " can't be coerced into " + this.getMetaClass());
    }

    @JRubyMethod(name={"div"})
    public IRubyObject op_idiv(ThreadContext context, IRubyObject other) {
        return Numeric.f_floor(context, Numeric.f_div(context, this, other));
    }

    @JRubyMethod(name={"modulo", "%"})
    public IRubyObject op_mod(ThreadContext context, IRubyObject other) {
        IRubyObject val = Numeric.f_floor(context, Numeric.f_div(context, this, other));
        return Numeric.f_sub(context, this, Numeric.f_mul(context, other, val));
    }

    @JRubyMethod(name={"divmod"})
    public IRubyObject op_divmod(ThreadContext context, IRubyObject other) {
        IRubyObject val = Numeric.f_floor(context, Numeric.f_div(context, this, other));
        return context.getRuntime().newArray(val, Numeric.f_sub(context, this, Numeric.f_mul(context, other, val)));
    }

    @JRubyMethod(name={"remainder"})
    public IRubyObject op_rem(ThreadContext context, IRubyObject other) {
        IRubyObject val = Numeric.f_truncate(context, Numeric.f_div(context, this, other));
        return Numeric.f_sub(context, this, Numeric.f_mul(context, other, val));
    }

    @JRubyMethod(name={"abs"})
    public IRubyObject op_abs(ThreadContext context) {
        if (!Numeric.f_negative_p(context, this)) {
            return this;
        }
        return Numeric.f_negate(context, this);
    }

    @JRubyMethod(name={"floor"})
    public IRubyObject op_floor(ThreadContext context) {
        return Numeric.f_idiv(context, this.num, this.den);
    }

    @JRubyMethod(name={"ceil"})
    public IRubyObject op_ceil(ThreadContext context) {
        return Numeric.f_negate(context, Numeric.f_idiv(context, Numeric.f_negate(context, this.num), this.den));
    }

    @JRubyMethod(name={"truncate", "to_i"})
    public IRubyObject op_truncate(ThreadContext context) {
        if (Numeric.f_negative_p(context, this.num)) {
            return Numeric.f_negate(context, Numeric.f_idiv(context, Numeric.f_negate(context, this.num), this.den));
        }
        return Numeric.f_idiv(context, this.num, this.den);
    }

    @JRubyMethod(name={"round"})
    public IRubyObject op_round(ThreadContext context) {
        RubyFixnum two = RubyFixnum.two(context.getRuntime());
        if (Numeric.f_negative_p(context, this.num)) {
            IRubyObject tnum = Numeric.f_negate(context, this.num);
            tnum = Numeric.f_add(context, Numeric.f_mul(context, tnum, two), this.den);
            IRubyObject tden = Numeric.f_mul(context, this.den, two);
            return Numeric.f_negate(context, Numeric.f_idiv(context, tnum, tden));
        }
        IRubyObject tnum = Numeric.f_add(context, Numeric.f_mul(context, this.num, two), this.den);
        IRubyObject tden = Numeric.f_mul(context, this.den, two);
        return Numeric.f_idiv(context, tnum, tden);
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f(ThreadContext context) {
        long e;
        Ruby runtime = context.getRuntime();
        if (Numeric.f_zero_p(context, this.num)) {
            return runtime.newFloat(0.0);
        }
        IRubyObject num = this.num;
        IRubyObject den = this.den;
        boolean minus = false;
        if (Numeric.f_negative_p(context, num)) {
            num = Numeric.f_negate(context, num);
            minus = true;
        }
        long nl = Numeric.i_ilog2(context, num);
        long dl = Numeric.i_ilog2(context, den);
        long ne = 0L;
        if (nl > ML) {
            ne = nl - ML;
            num = Numeric.f_rshift(context, num, RubyFixnum.newFixnum(runtime, ne));
        }
        long de = 0L;
        if (dl > ML) {
            de = dl - ML;
            den = Numeric.f_rshift(context, den, RubyFixnum.newFixnum(runtime, de));
        }
        if ((e = ne - de) > 1023L || e < -1022L) {
            runtime.getWarnings().warn(IRubyWarnings.ID.FLOAT_OUT_OF_RANGE, "out of Float range", this.getMetaClass());
            return runtime.newFloat(e > 0L ? Double.MAX_VALUE : 0.0);
        }
        double f = RubyNumeric.num2dbl(num) / RubyNumeric.num2dbl(den);
        if (minus) {
            f = -f;
            f = Numeric.ldexp(f, e);
        }
        if (Double.isInfinite(f) || Double.isNaN(f)) {
            runtime.getWarnings().warn(IRubyWarnings.ID.FLOAT_OUT_OF_RANGE, "out of Float range", this.getMetaClass());
        }
        return runtime.newFloat(f);
    }

    @JRubyMethod(name={"to_r"})
    public IRubyObject to_r(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"hash"})
    public IRubyObject hash(ThreadContext context) {
        return Numeric.f_xor(context, this.num, this.den);
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext context) {
        return RuntimeHelpers.invoke(context, (IRubyObject)context.getRuntime().getKernel(), "format", (IRubyObject)context.getRuntime().newString("%d/%d"), this.num, this.den);
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        return RuntimeHelpers.invoke(context, (IRubyObject)context.getRuntime().getKernel(), "format", (IRubyObject)context.getRuntime().newString("(%d/%d)"), this.num, this.den);
    }

    @JRubyMethod(name={"marshal_dump"})
    public IRubyObject marshal_dump(ThreadContext context) {
        return context.getRuntime().newArray(this.num, this.den);
    }

    @JRubyMethod(name={"marshal_load"})
    public IRubyObject marshal_load(ThreadContext context, IRubyObject arg) {
        RubyArray a = arg.convertToArray();
        this.num = a.size() > 0 ? a.eltInternal(0) : context.getRuntime().getNil();
        IRubyObject iRubyObject = this.den = a.size() > 1 ? a.eltInternal(1) : context.getRuntime().getNil();
        if (Numeric.f_zero_p(context, this.den)) {
            throw context.getRuntime().newZeroDivisionError();
        }
        return this;
    }

    @JRubyMethod(name={"gcd"})
    public IRubyObject gcd(ThreadContext context, IRubyObject other) {
        RubyRational.intCheck(other);
        return Numeric.f_gcd(context, this, other);
    }

    @JRubyMethod(name={"lcm"})
    public IRubyObject lcm(ThreadContext context, IRubyObject other) {
        RubyRational.intCheck(other);
        return Numeric.f_lcm(context, this, other);
    }

    @JRubyMethod(name={"gcdlcm"})
    public IRubyObject gcdlcm(ThreadContext context, IRubyObject other) {
        RubyRational.intCheck(other);
        return context.getRuntime().newArray(Numeric.f_gcd(context, this, other), Numeric.f_lcm(context, this, other));
    }

    static RubyArray str_to_r_internal(ThreadContext context, IRubyObject recv) {
        RubyString s = recv.callMethod(context, "strip").convertToString();
        ByteList bytes = s.getByteList();
        Ruby runtime = context.getRuntime();
        if (bytes.realSize == 0) {
            return runtime.newArray(runtime.getNil(), recv);
        }
        IRubyObject m = RubyRegexp.newRegexp(runtime, Numeric.RationalPatterns.rat_pat).callMethod(context, "match", s);
        if (!m.isNil()) {
            IRubyObject si = m.callMethod(context, "[]", RubyFixnum.one(runtime));
            IRubyObject nu = m.callMethod(context, "[]", RubyFixnum.two(runtime));
            IRubyObject de = m.callMethod(context, "[]", RubyFixnum.three(runtime));
            IRubyObject re = m.callMethod(context, "post_match");
            RubyArray a = nu.callMethod(context, "split", RubyRegexp.newRegexp(runtime, Numeric.RationalPatterns.an_e_pat)).convertToArray();
            IRubyObject ifp = a.eltInternal(0);
            IRubyObject exp = a.size() != 2 ? runtime.getNil() : a.eltInternal(1);
            a = ifp.callMethod(context, "split", RubyRegexp.newRegexp(runtime, Numeric.RationalPatterns.a_dot_pat)).convertToArray();
            IRubyObject ip = a.eltInternal(0);
            IRubyObject fp = a.size() != 2 ? runtime.getNil() : a.eltInternal(1);
            IRubyObject v = RubyRational.newRationalCanonicalize(context, Numeric.f_to_i(context, ip));
            if (!fp.isNil()) {
                bytes = fp.convertToString().getByteList();
                int count = 0;
                byte[] buf = bytes.bytes;
                int i = bytes.begin;
                int end = i + bytes.realSize;
                while (i < end) {
                    if (!ASCIIEncoding.INSTANCE.isDigit((int)buf[i++])) continue;
                    ++count;
                }
                IRubyObject l = Numeric.f_expt(context, RubyFixnum.newFixnum(runtime, 10L), RubyFixnum.newFixnum(runtime, count));
                v = Numeric.f_mul(context, v, l);
                v = Numeric.f_add(context, v, Numeric.f_to_i(context, fp));
                v = Numeric.f_div(context, v, l);
            }
            if (!exp.isNil()) {
                v = Numeric.f_mul(context, v, Numeric.f_expt(context, RubyFixnum.newFixnum(runtime, 10L), Numeric.f_to_i(context, exp)));
            }
            if (!si.isNil() && (bytes = si.convertToString().getByteList()).length() > 0 && bytes.get(0) == 45) {
                v = Numeric.f_negate(context, v);
            }
            if (!de.isNil()) {
                v = Numeric.f_div(context, v, Numeric.f_to_i(context, de));
            }
            return runtime.newArray(v, re);
        }
        return runtime.newArray(runtime.getNil(), recv);
    }

    private static IRubyObject str_to_r_strict(ThreadContext context, IRubyObject recv) {
        RubyArray a = RubyRational.str_to_r_internal(context, recv);
        if (a.eltInternal(0).isNil() || a.eltInternal(1).convertToString().getByteList().length() > 0) {
            IRubyObject s = recv.callMethod(context, "inspect");
            throw context.getRuntime().newArgumentError("invalid value for Rational: " + s.convertToString());
        }
        return a.eltInternal(0);
    }
}

