/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.MetaClass;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyModule;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.INameNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.ASTInterpreter;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class ClassVarNode
extends Node
implements INameNode {
    private String name;

    public ClassVarNode(ISourcePosition position, String name) {
        super(position, NodeType.CLASSVARNODE);
        this.name = name;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitClassVarNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        RubyModule rubyClass = ASTInterpreter.getClassVariableBase(context, runtime);
        if (rubyClass == null) {
            rubyClass = self.getMetaClass();
        }
        return rubyClass.getClassVar(this.name);
    }

    @Override
    public String definition(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject attached;
        RubyModule module = context.getCurrentScope().getStaticScope().getModule();
        if (module == null && self.getMetaClass().fastIsClassVarDefined(this.name)) {
            return "class variable";
        }
        if (module.fastIsClassVarDefined(this.name)) {
            return "class variable";
        }
        IRubyObject iRubyObject = attached = module.isSingleton() ? ((MetaClass)module).getAttached() : null;
        if (attached instanceof RubyModule && ((RubyModule)attached).fastIsClassVarDefined(this.name)) {
            return "class variable";
        }
        return null;
    }
}

