/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyRegexp;
import org.jruby.nb.RubyString;
import org.jruby.nb.ast.DStrNode;
import org.jruby.nb.ast.ListNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.StrNode;
import org.jruby.nb.ast.types.ILiteralNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class DRegexpNode
extends ListNode
implements ILiteralNode {
    private final int options;
    private final boolean once;
    private RubyRegexp onceRegexp;

    public DRegexpNode(ISourcePosition position) {
        this(position, 0, false);
    }

    public DRegexpNode(ISourcePosition position, DStrNode node, int options, boolean once) {
        this(position, options, once);
        this.addAll(node);
    }

    public DRegexpNode(ISourcePosition position, int options, boolean once) {
        super(position, NodeType.DREGEXPNODE);
        this.options = options;
        this.once = once;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitDRegxNode(this);
    }

    public boolean getOnce() {
        return this.once;
    }

    public int getOptions() {
        return this.options;
    }

    public RubyRegexp getOnceRegexp() {
        return this.onceRegexp;
    }

    public void setOnceRegexp(RubyRegexp regexp) {
        if (this.once && this.onceRegexp == null) {
            this.onceRegexp = regexp;
        }
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        RubyRegexp regexp;
        if (this.once && this.onceRegexp != null) {
            return this.onceRegexp;
        }
        RubyString string = runtime.newString(new ByteList());
        for (int i = 0; i < this.size(); ++i) {
            Node iterNode = this.get(i);
            if (iterNode instanceof StrNode) {
                string.getByteList().append(((StrNode)iterNode).getValue());
                continue;
            }
            string.append(iterNode.interpret(runtime, context, self, aBlock));
        }
        try {
            regexp = RubyRegexp.newRegexp(runtime, string.getByteList(), this.options);
        }
        catch (Exception e) {
            throw runtime.newRegexpError(e.getMessage());
        }
        if (this.once) {
            this.setOnceRegexp(regexp);
        }
        return regexp;
    }
}

