/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class EnsureNode
extends Node {
    private final Node bodyNode;
    private final Node ensureNode;

    public EnsureNode(ISourcePosition position, Node bodyNode, Node ensureNode) {
        super(position, NodeType.ENSURENODE);
        assert (bodyNode != null) : "bodyNode is not null";
        this.bodyNode = bodyNode;
        this.ensureNode = ensureNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitEnsureNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getEnsureNode() {
        return this.ensureNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.bodyNode, this.ensureNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        if (this.ensureNode != null) {
            try {
                IRubyObject iRubyObject = this.bodyNode.interpret(runtime, context, self, aBlock);
                return iRubyObject;
            }
            finally {
                this.ensureNode.interpret(runtime, context, self, aBlock);
            }
        }
        return this.bodyNode.interpret(runtime, context, self, aBlock);
    }
}

