/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyRegexp;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.ILiteralNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class RegexpNode
extends Node
implements ILiteralNode {
    private RubyRegexp pattern;
    private final ByteList value;
    private final int options;

    public RegexpNode(ISourcePosition position, ByteList value, int options) {
        super(position, NodeType.REGEXPNODE);
        this.value = value;
        this.options = options;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitRegexpNode(this);
    }

    public int getOptions() {
        return this.options;
    }

    public ByteList getValue() {
        return this.value;
    }

    public void setPattern(RubyRegexp p) {
        this.pattern = p;
        this.pattern.setLiteral();
    }

    public RubyRegexp getPattern() {
        return this.pattern;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        if (this.pattern == null) {
            this.setPattern(RubyRegexp.newRegexp(runtime, this.value, this.options));
        }
        return this.pattern;
    }
}

