/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext.ffi.jna;

import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jruby.nb.ext.ffi.MemoryIO;
import org.jruby.nb.ext.ffi.Platform;
import org.jruby.util.ByteList;

public abstract class JNAMemoryIO
implements MemoryIO {
    final Object memory;
    static final JNAMemoryIO NULL = new PointerIO(Pointer.NULL, 0L);

    static final JNAMemoryIO allocate(int size) {
        return new BufferIO(size);
    }

    static final JNAMemoryIO allocateDirect(int size) {
        return new PointerIO(size);
    }

    JNAMemoryIO(Object memory) {
        this.memory = memory;
    }

    Object getMemory() {
        return this.memory;
    }

    static final JNAMemoryIO wrap(Pointer ptr) {
        return ptr != null ? new PointerIO(ptr, 0L) : NULL;
    }

    static JNAMemoryIO wrap(ByteList buf) {
        return new BufferIO(ByteBuffer.wrap(buf.unsafeBytes(), buf.begin(), buf.length()));
    }

    public abstract Pointer getAddress();

    public abstract Pointer getPointer(long var1);

    public abstract void putPointer(long var1, Pointer var3);

    public abstract JNAMemoryIO slice(long var1);

    public boolean equals(Object obj) {
        return obj instanceof JNAMemoryIO && ((JNAMemoryIO)obj).memory.equals(this.memory);
    }

    public int hashCode() {
        return this.memory.hashCode();
    }

    @Override
    public JNAMemoryIO getMemoryIO(long offset) {
        return JNAMemoryIO.wrap(this.getPointer(offset));
    }

    @Override
    public void putMemoryIO(long offset, MemoryIO value) {
        this.putPointer(offset, ((JNAMemoryIO)value).getAddress());
    }

    private static class BufferIO
    extends JNAMemoryIO {
        final ByteBuffer buffer;

        BufferIO(int size) {
            this(ByteBuffer.allocate(size).order(ByteOrder.nativeOrder()));
        }

        BufferIO(ByteBuffer buffer) {
            super(buffer);
            this.buffer = buffer;
            throw new RuntimeException("Not implemented");
        }

        @Override
        public Pointer getAddress() {
            return Pointer.NULL;
        }

        @Override
        public boolean isNull() {
            return false;
        }

        static ByteBuffer slice(ByteBuffer buffer, int position, int size) {
            ByteBuffer tmp = buffer.duplicate();
            tmp.position(position).limit(position + size);
            return tmp.slice();
        }

        @Override
        public Pointer getPointer(long offset) {
            if (Platform.getPlatform().longSize() == 32) {
                IntByReference ref = new IntByReference(this.getInt(offset));
                return ref.getPointer().getPointer(0L);
            }
            LongByReference ref = new LongByReference(this.getLong(offset));
            return ref.getPointer().getPointer(0L);
        }

        @Override
        public void putPointer(long offset, Pointer value) {
            PointerByReference ref = new PointerByReference(value);
            if (Platform.getPlatform().longSize() == 32) {
                this.putInt(offset, ref.getPointer().getInt(0L));
            } else {
                this.putLong(offset, ref.getPointer().getLong(0L));
            }
        }

        @Override
        public byte getByte(long offset) {
            return this.buffer.get((int)offset);
        }

        @Override
        public short getShort(long offset) {
            return this.buffer.getShort((int)offset);
        }

        @Override
        public int getInt(long offset) {
            return this.buffer.getInt((int)offset);
        }

        @Override
        public long getLong(long offset) {
            return this.buffer.getLong((int)offset);
        }

        @Override
        public long getNativeLong(long offset) {
            return NativeLong.SIZE == 4 ? (long)this.buffer.getInt((int)offset) : this.buffer.getLong((int)offset);
        }

        @Override
        public float getFloat(long offset) {
            return this.buffer.getFloat((int)offset);
        }

        @Override
        public double getDouble(long offset) {
            return this.buffer.getDouble((int)offset);
        }

        @Override
        public void putByte(long offset, byte value) {
            this.buffer.put((int)offset, value);
        }

        @Override
        public void putShort(long offset, short value) {
            this.buffer.putShort((int)offset, value);
        }

        @Override
        public void putInt(long offset, int value) {
            this.buffer.putInt((int)offset, value);
        }

        @Override
        public void putLong(long offset, long value) {
            this.buffer.putLong((int)offset, value);
        }

        @Override
        public void putNativeLong(long offset, long value) {
            if (NativeLong.SIZE == 4) {
                this.putInt(offset, (int)value);
            } else {
                this.putLong(offset, value);
            }
        }

        @Override
        public void putFloat(long offset, float value) {
            this.buffer.putFloat((int)offset, value);
        }

        @Override
        public void putDouble(long offset, double value) {
            this.buffer.putDouble((int)offset, value);
        }

        @Override
        public void get(long offset, byte[] dst, int off, int len) {
            BufferIO.slice(this.buffer, (int)offset, len).get(dst, off, len);
        }

        @Override
        public void put(long offset, byte[] dst, int off, int len) {
            BufferIO.slice(this.buffer, (int)offset, len).put(dst, off, len);
        }

        @Override
        public void get(long offset, short[] dst, int off, int len) {
            BufferIO.slice(this.buffer, (int)offset, len * 2).asShortBuffer().get(dst, off, len);
        }

        @Override
        public void put(long offset, short[] dst, int off, int len) {
            BufferIO.slice(this.buffer, (int)offset, len * 2).asShortBuffer().put(dst, off, len);
        }

        @Override
        public void get(long offset, int[] dst, int off, int len) {
            BufferIO.slice(this.buffer, (int)offset, len * 4).asIntBuffer().get(dst, off, len);
        }

        @Override
        public void put(long offset, int[] dst, int off, int len) {
            BufferIO.slice(this.buffer, (int)offset, len * 4).asIntBuffer().put(dst, off, len);
        }

        @Override
        public void get(long offset, long[] dst, int off, int len) {
            BufferIO.slice(this.buffer, (int)offset, len * 8).asLongBuffer().get(dst, off, len);
        }

        @Override
        public void put(long offset, long[] dst, int off, int len) {
            BufferIO.slice(this.buffer, (int)offset, len * 8).asLongBuffer().put(dst, off, len);
        }

        @Override
        public void get(long offset, float[] dst, int off, int len) {
            BufferIO.slice(this.buffer, (int)offset, len * 4).asFloatBuffer().get(dst, off, len);
        }

        @Override
        public void put(long offset, float[] dst, int off, int len) {
            BufferIO.slice(this.buffer, (int)offset, len * 4).asFloatBuffer().put(dst, off, len);
        }

        @Override
        public void get(long offset, double[] dst, int off, int len) {
            BufferIO.slice(this.buffer, (int)offset, len * 8).asDoubleBuffer().get(dst, off, len);
        }

        @Override
        public void put(long offset, double[] dst, int off, int len) {
            BufferIO.slice(this.buffer, (int)offset, len * 8).asDoubleBuffer().put(dst, off, len);
        }

        @Override
        public int indexOf(long offset, byte value) {
            return this.indexOf(offset, value, Integer.MAX_VALUE);
        }

        @Override
        public int indexOf(long offset, byte value, int maxlen) {
            while (offset > -1L) {
                if (this.buffer.get((int)offset) == value) {
                    return (int)offset;
                }
                ++offset;
            }
            return -1;
        }

        @Override
        public void setMemory(long offset, long size, byte value) {
            int i = 0;
            while ((long)i < size) {
                this.buffer.put(i, value);
                ++i;
            }
        }

        @Override
        public void clear() {
            this.setMemory(0L, this.buffer.capacity(), (byte)0);
        }

        @Override
        public JNAMemoryIO slice(long offset) {
            return offset == 0L ? this : new BufferIO(BufferIO.slice(this.buffer, (int)offset, this.buffer.capacity() - (int)offset));
        }
    }

    static final class PointerIO
    extends JNAMemoryIO {
        final Pointer ptr;
        final long size;

        private PointerIO() {
            this(Pointer.NULL, 0L);
        }

        private PointerIO(long size) {
            this((Pointer)new Memory(size), size);
        }

        private PointerIO(Pointer ptr, long size) {
            super(ptr);
            this.ptr = ptr;
            this.size = size;
        }

        @Override
        public Pointer getAddress() {
            return this.ptr;
        }

        @Override
        public boolean isNull() {
            return this.ptr == null;
        }

        @Override
        public byte getByte(long offset) {
            return this.ptr.getByte(offset);
        }

        @Override
        public short getShort(long offset) {
            return this.ptr.getShort(offset);
        }

        @Override
        public int getInt(long offset) {
            return this.ptr.getInt(offset);
        }

        @Override
        public long getLong(long offset) {
            return this.ptr.getLong(offset);
        }

        @Override
        public long getNativeLong(long offset) {
            return this.ptr.getNativeLong(offset).longValue();
        }

        @Override
        public float getFloat(long offset) {
            return this.ptr.getFloat(offset);
        }

        @Override
        public double getDouble(long offset) {
            return this.ptr.getDouble(offset);
        }

        @Override
        public Pointer getPointer(long offset) {
            return this.ptr.getPointer(offset);
        }

        @Override
        public void putByte(long offset, byte value) {
            this.ptr.setByte(offset, value);
        }

        @Override
        public void putShort(long offset, short value) {
            this.ptr.setShort(offset, value);
        }

        @Override
        public void putInt(long offset, int value) {
            this.ptr.setInt(offset, value);
        }

        @Override
        public void putLong(long offset, long value) {
            this.ptr.setLong(offset, value);
        }

        @Override
        public void putNativeLong(long offset, long value) {
            this.ptr.setNativeLong(offset, new NativeLong(value));
        }

        @Override
        public void putFloat(long offset, float value) {
            this.ptr.setFloat(offset, value);
        }

        @Override
        public void putDouble(long offset, double value) {
            this.ptr.setDouble(offset, value);
        }

        @Override
        public void putPointer(long offset, Pointer value) {
            this.ptr.setPointer(offset, value);
        }

        @Override
        public void get(long offset, byte[] dst, int off, int len) {
            this.ptr.read(offset, dst, off, len);
        }

        @Override
        public void put(long offset, byte[] dst, int off, int len) {
            this.ptr.write(offset, dst, off, len);
        }

        @Override
        public void get(long offset, short[] dst, int off, int len) {
            this.ptr.read(offset, dst, off, len);
        }

        @Override
        public void put(long offset, short[] dst, int off, int len) {
            this.ptr.write(offset, dst, off, len);
        }

        @Override
        public void get(long offset, int[] dst, int off, int len) {
            this.ptr.read(offset, dst, off, len);
        }

        @Override
        public void put(long offset, int[] dst, int off, int len) {
            this.ptr.write(offset, dst, off, len);
        }

        @Override
        public void get(long offset, long[] dst, int off, int len) {
            this.ptr.read(offset, dst, off, len);
        }

        @Override
        public void put(long offset, long[] dst, int off, int len) {
            this.ptr.write(offset, dst, off, len);
        }

        @Override
        public void get(long offset, float[] dst, int off, int len) {
            this.ptr.read(offset, dst, off, len);
        }

        @Override
        public void put(long offset, float[] dst, int off, int len) {
            this.ptr.write(offset, dst, off, len);
        }

        @Override
        public void get(long offset, double[] dst, int off, int len) {
            this.ptr.read(offset, dst, off, len);
        }

        @Override
        public void put(long offset, double[] dst, int off, int len) {
            this.ptr.write(offset, dst, off, len);
        }

        @Override
        public int indexOf(long offset, byte value) {
            return (int)this.ptr.indexOf(offset, value);
        }

        @Override
        public int indexOf(long offset, byte value, int maxlen) {
            return (int)this.ptr.indexOf(offset, value);
        }

        @Override
        public void setMemory(long offset, long size, byte value) {
            this.ptr.setMemory(offset, size, value);
        }

        @Override
        public void clear() {
            this.setMemory(0L, this.size, (byte)0);
        }

        @Override
        public JNAMemoryIO slice(long offset) {
            return offset == 0L ? this : new PointerIO(this.ptr.share(offset), this.size - offset);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PointerIO other = (PointerIO)obj;
            return this.ptr == other.ptr || this.ptr != null && this.ptr.equals((Object)other.ptr);
        }

        @Override
        public int hashCode() {
            return this.ptr == null ? 0 : this.ptr.hashCode();
        }
    }
}

