/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.internal.runtime.methods;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyModule;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.exceptions.RaiseException;
import org.jruby.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.internal.runtime.methods.CompiledMethod;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.Frame;
import org.jruby.nb.runtime.RubyEvent;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class ReflectedCompiledMethod
extends CompiledMethod {
    private final Method method;

    public ReflectedCompiledMethod(RubyModule implementationClass, Arity arity, Visibility visibility, StaticScope staticScope, Object scriptObject, Method method, CallConfiguration callConfig) {
        super(implementationClass, arity, visibility, staticScope, scriptObject, callConfig);
        this.method = method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
        this.callConfig.pre(context, self, this.getImplementationClass(), name, block, this.staticScope, this);
        Ruby runtime = context.getRuntime();
        try {
            boolean isTrace = runtime.hasEventHooks();
            try {
                if (isTrace) {
                    runtime.callEventHooks(context, RubyEvent.CALL, context.getFile(), context.getLine(), name, this.getImplementationClass());
                }
                IRubyObject iRubyObject = (IRubyObject)this.method.invoke(this.$scriptObject, context, self, args, block);
                if (isTrace) {
                    Frame frame = context.getPreviousFrame();
                    runtime.callEventHooks(context, RubyEvent.RETURN, frame.getFile(), frame.getLine(), name, this.getImplementationClass());
                }
                return iRubyObject;
            }
            catch (Throwable throwable) {
                try {
                    if (isTrace) {
                        Frame frame = context.getPreviousFrame();
                        runtime.callEventHooks(context, RubyEvent.RETURN, frame.getFile(), frame.getLine(), name, this.getImplementationClass());
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException e) {
                    throw RaiseException.createNativeRaiseException(runtime, e);
                }
                catch (IllegalAccessException e) {
                    throw RaiseException.createNativeRaiseException(runtime, e);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof JumpException.ReturnJump) {
                        IRubyObject iRubyObject = this.handleReturn(context, (JumpException.ReturnJump)cause);
                        return iRubyObject;
                    }
                    if (cause instanceof JumpException.RedoJump) {
                        IRubyObject iRubyObject = this.handleRedo(runtime);
                        return iRubyObject;
                    }
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    throw RaiseException.createNativeRaiseException(runtime, cause);
                }
            }
        }
        finally {
            this.callConfig.post(context);
        }
    }
}

