/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.libraries;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyIO;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.load.Library;
import org.jruby.nb.util.io.ChannelDescriptor;
import org.jruby.nb.util.io.OpenFile;

public class IOWaitLibrary
implements Library {
    @Override
    public void load(Ruby runtime, boolean wrap) {
        RubyClass ioClass = runtime.getIO();
        ioClass.defineAnnotatedMethods(IOWaitLibrary.class);
    }

    @JRubyMethod(name={"ready?"})
    public static IRubyObject ready(ThreadContext context, IRubyObject obj) {
        RubyIO io = (RubyIO)obj;
        try {
            OpenFile openFile = io.getOpenFile();
            ChannelDescriptor descriptor = openFile.getMainStream().getDescriptor();
            if (!descriptor.isOpen() || !openFile.getMainStream().getModes().isReadable() || openFile.getMainStream().feof()) {
                return context.getRuntime().getFalse();
            }
            int avail = openFile.getMainStream().ready();
            if (avail > 0) {
                return context.getRuntime().newFixnum(avail);
            }
        }
        catch (Exception anyEx) {
            return context.getRuntime().getFalse();
        }
        return context.getRuntime().getNil();
    }

    @JRubyMethod
    public static IRubyObject io_wait(ThreadContext context, IRubyObject obj) {
        RubyIO io = (RubyIO)obj;
        try {
            OpenFile openFile = io.getOpenFile();
            ChannelDescriptor descriptor = openFile.getMainStream().getDescriptor();
            if (openFile.getMainStream().feof()) {
                return context.getRuntime().getNil();
            }
            openFile.getMainStream().waitUntilReady();
        }
        catch (Exception anyEx) {
            return context.getRuntime().getNil();
        }
        return obj;
    }
}

