/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.parser;

import org.jruby.nb.parser.LocalStaticScope;
import org.jruby.nb.runtime.DynamicScope;
import org.jruby.nb.runtime.scope.ManyVarsDynamicScope;
import org.jruby.nb.util.SafePropertyAccessor;

public class ParserConfiguration {
    private DynamicScope existingScope = null;
    private boolean asBlock = false;
    private int lineNumber = 0;
    private boolean inlineSource = false;
    private boolean isEvalParse = true;
    private boolean extraPositionInformation = false;
    private boolean isDubyExtensionsEnabled = SafePropertyAccessor.getBoolean("jruby.duby.enabled", false);

    public ParserConfiguration(int lineNumber, boolean inlineSource) {
        this(lineNumber, false, inlineSource);
    }

    public ParserConfiguration(int lineNumber, boolean extraPositionInformation, boolean inlineSource) {
        this.inlineSource = inlineSource;
        this.lineNumber = lineNumber;
        this.extraPositionInformation = extraPositionInformation;
    }

    public ParserConfiguration(int lineNumber, boolean extraPositionInformation, boolean inlineSource, boolean isFileParse) {
        this.inlineSource = inlineSource;
        this.lineNumber = lineNumber;
        this.extraPositionInformation = extraPositionInformation;
        this.isEvalParse = !isFileParse;
    }

    public void setEvalParse(boolean isEvalParse) {
        this.isEvalParse = isEvalParse;
    }

    public void setExtraPositionInformation(boolean extraPositionInformation) {
        this.extraPositionInformation = extraPositionInformation;
    }

    public boolean hasExtraPositionInformation() {
        return this.extraPositionInformation;
    }

    public boolean isEvalParse() {
        return this.isEvalParse;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void parseAsBlock(DynamicScope existingScope) {
        this.asBlock = true;
        this.existingScope = existingScope;
    }

    public DynamicScope getScope() {
        if (this.asBlock) {
            return this.existingScope;
        }
        return new ManyVarsDynamicScope(new LocalStaticScope(null), this.existingScope);
    }

    public boolean isInlineSource() {
        return this.inlineSource;
    }

    public boolean isDubyExtensionsEnabled() {
        return this.isDubyExtensionsEnabled;
    }
}

