/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.util;

import java.io.IOException;
import java.io.OutputStream;
import org.jruby.nb.RubyString;
import org.jruby.nb.runtime.CallSite;
import org.jruby.nb.runtime.MethodIndex;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class IOOutputStream
extends OutputStream {
    private final IRubyObject io;
    private final CallSite writeAdapter;
    private final CallSite closeAdapter = MethodIndex.getFunctionalCallSite("close");

    public IOOutputStream(IRubyObject io) {
        if (io.respondsTo("write")) {
            this.writeAdapter = MethodIndex.getFunctionalCallSite("write");
        } else if (io.respondsTo("<<")) {
            this.writeAdapter = MethodIndex.getFunctionalCallSite("<<");
        } else {
            throw new IllegalArgumentException("Object: " + io + " is not a legal argument to this wrapper, cause it doesn't respond to \"write\".");
        }
        this.io = io;
    }

    @Override
    public void write(int bite) throws IOException {
        this.writeAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, RubyString.newStringLight(this.io.getRuntime(), new ByteList(new byte[]{(byte)bite}, false)));
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, RubyString.newStringLight(this.io.getRuntime(), new ByteList(b, off, len, false)));
    }

    @Override
    public void close() throws IOException {
        if (this.io.respondsTo("close")) {
            this.closeAdapter.call(this.io.getRuntime().getCurrentContext(), this.io);
        }
    }
}

