/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;

public class GsfHtmlFormatter
extends HtmlFormatter {
    protected boolean isDeprecated;
    protected boolean isParameter;
    protected boolean isType;
    protected boolean isName;
    protected boolean isEmphasis;
    protected StringBuilder sb = new StringBuilder();

    public void reset() {
        this.textLength = 0;
        this.sb.setLength(0);
    }

    public void appendHtml(String html) {
        this.sb.append(html);
    }

    public void appendText(String text, int fromInclusive, int toExclusive) {
        for (int i = fromInclusive; i < toExclusive; ++i) {
            if (this.textLength >= this.maxLength) {
                if (this.textLength != this.maxLength) break;
                this.sb.append("...");
                this.textLength += 3;
                break;
            }
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    this.sb.append("&lt;");
                    break;
                }
                case '>': {
                    if (i > 1 && text.charAt(i - 2) == ']' && text.charAt(i - 1) == ']') {
                        this.sb.append("&gt;");
                        break;
                    }
                    this.sb.append(c);
                    break;
                }
                case '&': {
                    this.sb.append("&amp;");
                    break;
                }
                default: {
                    this.sb.append(c);
                }
            }
            ++this.textLength;
        }
    }

    public void name(ElementKind kind, boolean start) {
        assert (start != this.isName);
        this.isName = start;
        if (this.isName) {
            this.sb.append("<b>");
        } else {
            this.sb.append("</b>");
        }
    }

    public void parameters(boolean start) {
        assert (start != this.isParameter);
        this.isParameter = start;
        if (this.isParameter) {
            this.sb.append("<font color=\"#808080\">");
        } else {
            this.sb.append("</font>");
        }
    }

    public void active(boolean start) {
        this.emphasis(start);
    }

    public void type(boolean start) {
        assert (start != this.isType);
        this.isType = start;
        if (this.isType) {
            this.sb.append("<font color=\"#808080\">");
        } else {
            this.sb.append("</font>");
        }
    }

    public void deprecated(boolean start) {
        assert (start != this.isDeprecated);
        this.isDeprecated = start;
        if (this.isDeprecated) {
            this.sb.append("<s>");
        } else {
            this.sb.append("</s>");
        }
    }

    public String getText() {
        assert (!(this.isParameter || this.isDeprecated || this.isName || this.isType));
        return this.sb.toString();
    }

    public void emphasis(boolean start) {
        assert (start != this.isEmphasis);
        this.isEmphasis = start;
        if (this.isEmphasis) {
            this.sb.append("<b>");
        } else {
            this.sb.append("</b>");
        }
    }
}

