/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.editor.semantic;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.ColoringAttributes;
import org.netbeans.modules.gsf.api.DataLoadersBridge;
import org.netbeans.modules.gsf.api.OccurrencesFinder;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.annotations.NonNull;
import org.netbeans.modules.gsfret.editor.semantic.MarkOccurrencesHighlighterFactory;
import org.netbeans.modules.gsfret.editor.semantic.OccurrencesMarkProvider;
import org.netbeans.modules.gsfret.hints.infrastructure.Pair;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class MarkOccurrencesHighlighter
implements CancellableTask<CompilationInfo> {
    private FileObject file;
    static ColoringAttributes.Coloring MO = ColoringAttributes.add((ColoringAttributes.Coloring)ColoringAttributes.empty(), (ColoringAttributes)ColoringAttributes.MARK_OCCURRENCES);
    public static final Color ES_COLOR = new Color(175, 172, 102);
    private boolean canceled;

    MarkOccurrencesHighlighter(FileObject file) {
        this.file = file;
    }

    public Document getDocument() {
        return DataLoadersBridge.getDefault().getDocument(this.file);
    }

    public void run(CompilationInfo info) {
        this.resume();
        Document doc = this.getDocument();
        if (doc == null) {
            Logger.global.log(Level.INFO, "MarkOccurencesHighlighter: Cannot get document!");
            return;
        }
        long start = System.currentTimeMillis();
        int caretPosition = MarkOccurrencesHighlighterFactory.getLastPosition(this.file);
        if (this.isCancelled()) {
            return;
        }
        Pair<List<OffsetRange>, Language> pair = this.processImpl(info, doc, caretPosition);
        if (this.isCancelled()) {
            return;
        }
        List<OffsetRange> bag = pair.getA();
        Language language = pair.getB();
        if (bag.size() > 0) {
            Collections.sort(bag);
        }
        OffsetsBag obag = new OffsetsBag(doc);
        obag.clear();
        if (bag.size() > 0) {
            AttributeSet attributes = language.getColoringManager().getColoringImpl(MO);
            for (OffsetRange range : bag) {
                if (range == OffsetRange.NONE) continue;
                obag.addHighlight(range.getStart(), range.getEnd(), attributes);
            }
        }
        MarkOccurrencesHighlighter.getHighlightsBag(doc).setHighlights(obag);
        OccurrencesMarkProvider.get(doc).setOccurrences(OccurrencesMarkProvider.createMarks(doc, bag, ES_COLOR, NbBundle.getMessage(MarkOccurrencesHighlighter.class, (String)"LBL_ES_TOOLTIP")));
    }

    @NonNull
    Pair<List<OffsetRange>, Language> processImpl(CompilationInfo info, Document doc, int caretPosition) {
        List<Language> list = LanguageRegistry.getInstance().getEmbeddedLanguages((BaseDocument)doc, caretPosition);
        Language language = null;
        for (Language l : list) {
            if (l.getOccurrencesFinder() == null) continue;
            language = l;
            break;
        }
        if (language != null) {
            OccurrencesFinder finder = language.getOccurrencesFinder();
            assert (finder != null);
            finder.setCaretPosition(caretPosition);
            OccurrencesFinder task = finder;
            if (task != null) {
                Map highlights;
                try {
                    task.run((Object)info);
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
                if (this.isCancelled()) {
                    task.cancel();
                }
                if ((highlights = task.getOccurrences()) != null) {
                    return new Pair<List<OffsetRange>, Language>(new ArrayList(highlights.keySet()), language);
                }
            }
        }
        return new Pair<List<OffsetRange>, Language>(Collections.emptyList(), info.getLanguage());
    }

    public final synchronized void cancel() {
        this.canceled = true;
    }

    protected final synchronized boolean isCancelled() {
        return this.canceled;
    }

    protected final synchronized void resume() {
        this.canceled = false;
    }

    static OffsetsBag getHighlightsBag(Document doc) {
        OffsetsBag bag = (OffsetsBag)doc.getProperty(MarkOccurrencesHighlighter.class);
        if (bag == null) {
            bag = new OffsetsBag(doc, false);
            doc.putProperty(MarkOccurrencesHighlighter.class, bag);
            final OffsetsBag bagFin = bag;
            DocumentListener l = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    bagFin.removeHighlights(e.getOffset(), e.getOffset(), false);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    bagFin.removeHighlights(e.getOffset(), e.getOffset(), false);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            };
            doc.addDocumentListener(l);
            FileObject stream = DataLoadersBridge.getDefault().getFileObject(doc);
            if (stream instanceof FileObject) {
                Logger.getLogger("TIMER").log(Level.FINE, "MarkOccurrences Highlights Bag", new Object[]{stream, bag});
                Logger.getLogger("TIMER").log(Level.FINE, "MarkOccurrences Highlights Bag Listener", new Object[]{stream, l});
            }
        }
        return bag;
    }
}

