/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.layouts;

import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.netbeans.swing.layouts.LayoutDataProvider;
import org.netbeans.swing.layouts.SharedLayoutData;

public final class DefaultSharedLayoutData
implements SharedLayoutData {
    private final Set<LayoutDataProvider> known = new HashSet<LayoutDataProvider>();

    @Override
    public void register(LayoutDataProvider p) {
        this.known.add(p);
        for (LayoutDataProvider d : this.known) {
            if (!(d instanceof JComponent)) continue;
            ((JComponent)((Object)d)).invalidate();
            ((JComponent)((Object)d)).revalidate();
            ((JComponent)((Object)d)).repaint();
        }
    }

    @Override
    public void unregister(LayoutDataProvider p) {
        this.known.remove(p);
        for (LayoutDataProvider d : this.known) {
            if (!(d instanceof JComponent)) continue;
            ((JComponent)((Object)d)).invalidate();
            ((JComponent)((Object)d)).revalidate();
            ((JComponent)((Object)d)).repaint();
        }
    }

    @Override
    public int xPosForColumn(int column) {
        int xpos = 0;
        for (LayoutDataProvider l : this.known) {
            int colpos = l.getColumnPosition(column);
            xpos = Math.max(colpos, xpos);
        }
        return xpos;
    }

    @Override
    public void expanded(LayoutDataProvider p, boolean state) {
        HashSet<LayoutDataProvider> iter = new HashSet<LayoutDataProvider>(this.known);
        if (state) {
            for (LayoutDataProvider d : iter) {
                if (d != p) {
                    if (!d.isExpanded()) continue;
                    d.doSetExpanded(false);
                    continue;
                }
                if (!(d instanceof JComponent)) continue;
                JComponent jc = (JComponent)((Object)d);
                jc.invalidate();
                jc.revalidate();
                jc.repaint();
            }
        }
    }
}

