/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.IntConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.CppUtils;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringListNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.VectorNodeProp;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public abstract class CCCCompilerConfiguration
extends BasicCompilerConfiguration {
    public static final int LIBRARY_LEVEL_NONE = 0;
    public static final int LIBRARY_LEVEL_RUNTIME = 1;
    public static final int LIBRARY_LEVEL_CLASSIC = 2;
    public static final int LIBRARY_LEVEL_BINARY = 3;
    public static final int LIBRARY_LEVEL_CONFORMING = 4;
    private static final String[] LIBRARY_LEVEL_NAMES = new String[]{CCCCompilerConfiguration.getString("NoneTxt"), CCCCompilerConfiguration.getString("RuntimeOnlyTxt"), CCCCompilerConfiguration.getString("ClassicIostreamsTxt"), CCCCompilerConfiguration.getString("BinaryStandardTxt"), CCCCompilerConfiguration.getString("ConformingStandardTxt")};
    private static final String[] LIBRARY_LEVEL_OPTIONS = null;
    private IntConfiguration libraryLevel;
    public static final int STANDARDS_OLD = 0;
    public static final int STANDARDS_LEGACY = 1;
    public static final int STANDARDS_DEFAULT = 2;
    public static final int STANDARDS_MODERN = 3;
    private static final String[] STANDARDS_NAMES = new String[]{CCCCompilerConfiguration.getString("OldTxt"), CCCCompilerConfiguration.getString("LegacyTxt"), CCCCompilerConfiguration.getString("DefaultTxt"), CCCCompilerConfiguration.getString("ModernTxt")};
    private static final String[] STANDARD_OPTIONS = null;
    private IntConfiguration standardsEvolution;
    public static final int LANGUAGE_EXT_NONE = 0;
    public static final int LANGUAGE_EXT_DEFAULT = 1;
    public static final int LANGUAGE_EXT_ALL = 2;
    private static final String[] LANGUAGE_EXT_NAMES = new String[]{CCCCompilerConfiguration.getString("NoneTxt"), CCCCompilerConfiguration.getString("DefaultTxt"), CCCCompilerConfiguration.getString("AllTxt")};
    private static final String[] LANGUAGE_EXT_OPTIONS = null;
    private IntConfiguration languageExt;
    private VectorConfiguration<String> includeDirectories;
    private BooleanConfiguration inheritIncludes;
    private VectorConfiguration<String> preprocessorConfiguration;
    private BooleanConfiguration inheritPreprocessor;

    protected CCCCompilerConfiguration(String baseDir, CCCCompilerConfiguration master) {
        super(baseDir, master);
        this.libraryLevel = new IntConfiguration(master != null ? master.getLibraryLevel() : null, 3, LIBRARY_LEVEL_NAMES, this.getLibraryLevelOptions());
        this.standardsEvolution = new IntConfiguration(master != null ? master.getStandardsEvolution() : null, 2, STANDARDS_NAMES, this.getStandardsEvolutionOptions());
        this.languageExt = new IntConfiguration(master != null ? master.getLanguageExt() : null, 1, LANGUAGE_EXT_NAMES, this.getLanguageExtOptions());
        this.includeDirectories = new VectorConfiguration<String>(master != null ? master.getIncludeDirectories() : null);
        this.inheritIncludes = new BooleanConfiguration(true);
        this.preprocessorConfiguration = new VectorConfiguration<String>(master != null ? master.getPreprocessorConfiguration() : null);
        this.inheritPreprocessor = new BooleanConfiguration(true);
    }

    public void fixupMasterLinks(CCCCompilerConfiguration compilerConfiguration) {
        super.fixupMasterLinks(compilerConfiguration);
        this.getMTLevel().setMaster(compilerConfiguration.getMTLevel());
        this.getLibraryLevel().setMaster(compilerConfiguration.getLibraryLevel());
        this.getStandardsEvolution().setMaster(compilerConfiguration.getStandardsEvolution());
        this.getLanguageExt().setMaster(compilerConfiguration.getLanguageExt());
    }

    @Override
    public boolean getModified() {
        return super.getModified() || this.libraryLevel.getModified() || this.standardsEvolution.getModified() || this.languageExt.getModified() || this.includeDirectories.getModified() || this.inheritIncludes.getModified() || this.preprocessorConfiguration.getModified() || this.inheritPreprocessor.getModified();
    }

    protected String[] getLibraryLevelOptions() {
        return LIBRARY_LEVEL_OPTIONS;
    }

    protected String[] getStandardsEvolutionOptions() {
        return STANDARD_OPTIONS;
    }

    protected String[] getLanguageExtOptions() {
        return LANGUAGE_EXT_OPTIONS;
    }

    public void setLibraryLevel(IntConfiguration libraryLevel) {
        this.libraryLevel = libraryLevel;
    }

    public IntConfiguration getLibraryLevel() {
        return this.libraryLevel;
    }

    public void setStandardsEvolution(IntConfiguration standardsEvolution) {
        this.standardsEvolution = standardsEvolution;
    }

    public IntConfiguration getStandardsEvolution() {
        return this.standardsEvolution;
    }

    public void setLanguageExt(IntConfiguration languageExt) {
        this.languageExt = languageExt;
    }

    public IntConfiguration getLanguageExt() {
        return this.languageExt;
    }

    public VectorConfiguration<String> getIncludeDirectories() {
        return this.includeDirectories;
    }

    public void setIncludeDirectories(VectorConfiguration<String> includeDirectories) {
        this.includeDirectories = includeDirectories;
    }

    public BooleanConfiguration getInheritIncludes() {
        return this.inheritIncludes;
    }

    public void setInheritIncludes(BooleanConfiguration inheritIncludes) {
        this.inheritIncludes = inheritIncludes;
    }

    public VectorConfiguration<String> getPreprocessorConfiguration() {
        return this.preprocessorConfiguration;
    }

    public void setPreprocessorConfiguration(VectorConfiguration<String> preprocessorConfiguration) {
        this.preprocessorConfiguration = preprocessorConfiguration;
    }

    public BooleanConfiguration getInheritPreprocessor() {
        return this.inheritPreprocessor;
    }

    public void setInheritPreprocessor(BooleanConfiguration inheritPreprocessor) {
        this.inheritPreprocessor = inheritPreprocessor;
    }

    protected void assign(CCCCompilerConfiguration conf) {
        super.assign(conf);
        this.getLibraryLevel().assign(conf.getLibraryLevel());
        this.getStandardsEvolution().assign(conf.getStandardsEvolution());
        this.getLanguageExt().assign(conf.getLanguageExt());
        this.getIncludeDirectories().assign(conf.getIncludeDirectories());
        this.getInheritIncludes().assign(conf.getInheritIncludes());
        this.getPreprocessorConfiguration().assign(conf.getPreprocessorConfiguration());
        this.getInheritPreprocessor().assign(conf.getInheritPreprocessor());
    }

    protected Sheet.Set getSet() {
        OptionToString visitor = new OptionToString(null, null);
        Sheet.Set set1 = new Sheet.Set();
        set1.setName("General");
        set1.setDisplayName(CCCCompilerConfiguration.getString("GeneralTxt"));
        set1.setShortDescription(CCCCompilerConfiguration.getString("GeneralHint"));
        StringBuilder inheritedValues = new StringBuilder();
        CCCCompilerConfiguration master = (CCCCompilerConfiguration)this.getMaster();
        while (master != null) {
            inheritedValues.append(master.getIncludeDirectories().toString(visitor));
            if (master.getInheritIncludes().getValue()) {
                master = (CCCCompilerConfiguration)master.getMaster();
                continue;
            }
            master = null;
        }
        set1.put((Node.Property)new VectorNodeProp(this.getIncludeDirectories(), this.getInheritIncludes(), this.getBaseDir(), new String[]{"IncludeDirectories", CCCCompilerConfiguration.getString("IncludeDirectoriesTxt"), CCCCompilerConfiguration.getString("IncludeDirectoriesHint"), inheritedValues.toString()}, true, new HelpCtx("AddtlIncludeDirectories")));
        inheritedValues = new StringBuilder();
        master = (CCCCompilerConfiguration)this.getMaster();
        while (master != null) {
            inheritedValues.append(master.getPreprocessorConfiguration().toString(visitor));
            if (master.getInheritPreprocessor().getValue()) {
                master = (CCCCompilerConfiguration)master.getMaster();
                continue;
            }
            master = null;
        }
        set1.put((Node.Property)new StringListNodeProp(this.getPreprocessorConfiguration(), this.getInheritPreprocessor(), new String[]{"preprocessor-definitions", CCCCompilerConfiguration.getString("PreprocessorDefinitionsTxt"), CCCCompilerConfiguration.getString("PreprocessorDefinitionsHint"), CCCCompilerConfiguration.getString("PreprocessorDefinitionsLbl"), inheritedValues.toString()}, true, new HelpCtx("preprocessor-definitions")));
        return set1;
    }

    protected Sheet getSheet(Project project) {
        Sheet sheet = new Sheet();
        sheet.put(this.getSet());
        return sheet;
    }

    private static String getString(String s) {
        return NbBundle.getMessage(CCCCompilerConfiguration.class, (String)s);
    }

    protected abstract String getUserIncludeFlag(CompilerSet var1);

    protected abstract String getUserMacroFlag(CompilerSet var1);

    public static class OptionToString
    implements VectorConfiguration.ToString<String> {
        private final CompilerSet compilerSet;
        private final String prepend;

        public OptionToString(CompilerSet compilerSet, String prepend) {
            this.compilerSet = compilerSet;
            this.prepend = prepend;
        }

        @Override
        public String toString(String item) {
            if (0 < item.length()) {
                if (this.compilerSet != null) {
                    item = CppUtils.normalizeDriveLetter(this.compilerSet, item);
                }
                item = CndPathUtilitities.escapeOddCharacters((String)item);
                return this.prepend == null ? item : this.prepend + item;
            }
            return "";
        }
    }
}

