/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.ResourceBundle;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringNodeProp;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.cnd.utils.ui.FileChooser;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class MakefileConfiguration {
    private MakeConfiguration makeConfiguration;
    private StringConfiguration buildCommandWorkingDir;
    private StringConfiguration buildCommand;
    private StringConfiguration cleanCommand;
    private StringConfiguration output;
    private static ResourceBundle bundle;

    public MakefileConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
        this.buildCommandWorkingDir = new StringConfiguration(null, ".");
        this.buildCommand = new StringConfiguration(null, "${MAKE}");
        this.cleanCommand = new StringConfiguration(null, "${MAKE} clean");
        this.output = new StringConfiguration(null, "");
    }

    public void setMakeConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
    }

    public MakeConfiguration getMakeConfiguration() {
        return this.makeConfiguration;
    }

    public StringConfiguration getBuildCommandWorkingDir() {
        return this.buildCommandWorkingDir;
    }

    public String getBuildCommandWorkingDirValue() {
        if (this.buildCommandWorkingDir.getValue().length() == 0) {
            return ".";
        }
        return this.buildCommandWorkingDir.getValue();
    }

    public void setBuildCommandWorkingDir(StringConfiguration buildCommandWorkingDir) {
        this.buildCommandWorkingDir = buildCommandWorkingDir;
    }

    public StringConfiguration getBuildCommand() {
        return this.buildCommand;
    }

    public void setBuildCommand(StringConfiguration buildCommand) {
        this.buildCommand = buildCommand;
    }

    public StringConfiguration getCleanCommand() {
        return this.cleanCommand;
    }

    public void setCleanCommand(StringConfiguration cleanCommand) {
        this.cleanCommand = cleanCommand;
    }

    public StringConfiguration getOutput() {
        return this.output;
    }

    public void setOutput(StringConfiguration output) {
        this.output = output;
    }

    public boolean canBuild() {
        return this.getBuildCommand().getValue().length() > 0;
    }

    public String getAbsBuildCommandWorkingDir() {
        if (this.getBuildCommandWorkingDirValue().length() > 0 && CndPathUtilitities.isPathAbsolute((String)this.getBuildCommandWorkingDirValue())) {
            return this.getBuildCommandWorkingDirValue();
        }
        return this.getMakeConfiguration().getBaseDir() + "/" + this.getBuildCommandWorkingDirValue();
    }

    public boolean canClean() {
        return this.getCleanCommand().getValue().length() > 0;
    }

    public String getAbsOutput() {
        if (this.getOutput().getValue().length() == 0) {
            return "";
        }
        if (CndPathUtilitities.isPathAbsolute((String)this.getOutput().getValue())) {
            return this.getOutput().getValue();
        }
        return this.getMakeConfiguration().getBaseDir() + "/" + this.getOutput().getValue();
    }

    public void assign(MakefileConfiguration conf) {
        this.getBuildCommandWorkingDir().assign(conf.getBuildCommandWorkingDir());
        this.getBuildCommand().assign(conf.getBuildCommand());
        this.getCleanCommand().assign(conf.getCleanCommand());
        this.getOutput().assign(conf.getOutput());
    }

    public MakefileConfiguration clone() {
        MakefileConfiguration clone = new MakefileConfiguration(this.getMakeConfiguration());
        clone.setBuildCommandWorkingDir(this.getBuildCommandWorkingDir().clone());
        clone.setBuildCommand(this.getBuildCommand().clone());
        clone.setCleanCommand(this.getCleanCommand().clone());
        clone.setOutput(this.getOutput().clone());
        return clone;
    }

    public Sheet getSheet() {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("Makefile");
        set.setDisplayName(MakefileConfiguration.getString("MakefileTxt"));
        set.setShortDescription(MakefileConfiguration.getString("MakefileHint"));
        set.put((Node.Property)new DirStringNodeProp(this.getBuildCommandWorkingDir(), "WorkingDirectory", MakefileConfiguration.getString("WorkingDirectory_LBL"), MakefileConfiguration.getString("WorkingDirectory_TT")));
        set.put((Node.Property)new StringNodeProp(this.getBuildCommand(), "BuildCommandLine", MakefileConfiguration.getString("BuildCommandLine_LBL"), MakefileConfiguration.getString("BuildCommandLine_TT")));
        set.put((Node.Property)new StringNodeProp(this.getCleanCommand(), "CleanCommandLine", MakefileConfiguration.getString("CleanCommandLine_LBL"), MakefileConfiguration.getString("CleanCommandLine_TT")));
        set.put((Node.Property)new OutputStringNodeProp(this.getOutput(), "BuildResult", MakefileConfiguration.getString("BuildResult_LBL"), MakefileConfiguration.getString("BuildResult_TT")));
        sheet.put(set);
        return sheet;
    }

    private static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(MakefileConfiguration.class);
        }
        return bundle.getString(s);
    }

    private final class ElfPanel
    extends FileChooser
    implements PropertyChangeListener {
        private PropertyEditorSupport editor;

        public ElfPanel(String seed, PropertyEditorSupport editor, PropertyEnv propenv) {
            super("", "", 0, null, seed, true);
            this.setControlButtonsAreShown(false);
            if (Utilities.isWindows()) {
                this.addChoosableFileFilter(FileFilterFactory.getPeExecutableFileFilter());
                this.addChoosableFileFilter(FileFilterFactory.getPeStaticLibraryFileFilter());
                this.addChoosableFileFilter(FileFilterFactory.getPeDynamicLibraryFileFilter());
            } else if (Utilities.getOperatingSystem() == 4096) {
                this.addChoosableFileFilter(FileFilterFactory.getMacOSXExecutableFileFilter());
                this.addChoosableFileFilter(FileFilterFactory.getElfStaticLibraryFileFilter());
                this.addChoosableFileFilter(FileFilterFactory.getMacOSXDynamicLibraryFileFilter());
            } else {
                this.addChoosableFileFilter(FileFilterFactory.getElfExecutableFileFilter());
                this.addChoosableFileFilter(FileFilterFactory.getElfStaticLibraryFileFilter());
                this.addChoosableFileFilter(FileFilterFactory.getElfDynamicLibraryFileFilter());
            }
            this.setFileFilter(this.getAcceptAllFileFilter());
            this.editor = editor;
            propenv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            propenv.addPropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID && this.getSelectedFile() != null) {
                String path = CndPathUtilitities.toRelativePath((String)MakefileConfiguration.this.makeConfiguration.getBaseDir(), (String)this.getSelectedFile().getPath());
                path = CndPathUtilitities.normalize((String)path);
                this.editor.setValue(path);
            }
        }
    }

    private final class ElfEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private PropertyEnv propenv;
        private String seed;

        public ElfEditor(String seed) {
            this.seed = seed;
        }

        @Override
        public void setAsText(String text) {
            MakefileConfiguration.this.getOutput().setValue(text);
        }

        @Override
        public String getAsText() {
            return MakefileConfiguration.this.getOutput().getValue();
        }

        @Override
        public Object getValue() {
            return MakefileConfiguration.this.getOutput().getValue();
        }

        @Override
        public void setValue(Object v) {
            MakefileConfiguration.this.getOutput().setValue((String)v);
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        @Override
        public Component getCustomEditor() {
            return new ElfPanel(this.seed, this, this.propenv);
        }

        public void attachEnv(PropertyEnv propenv) {
            this.propenv = propenv;
        }
    }

    private final class DirPanel
    extends FileChooser
    implements PropertyChangeListener {
        private PropertyEditorSupport editor;

        public DirPanel(String seed, PropertyEditorSupport editor, PropertyEnv propenv) {
            super(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/api/Bundle").getString("Run_Directory"), ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/api/Bundle").getString("SelectLabel"), 1, null, seed, true);
            this.setControlButtonsAreShown(false);
            this.editor = editor;
            propenv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            propenv.addPropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID) {
                String path = CndPathUtilitities.toRelativePath((String)MakefileConfiguration.this.makeConfiguration.getBaseDir(), (String)this.getSelectedFile().getPath());
                path = CndPathUtilitities.normalize((String)path);
                this.editor.setValue(path);
            }
        }
    }

    private class DirEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private PropertyEnv propenv;
        private String seed;

        public DirEditor(String seed) {
            this.seed = seed;
        }

        @Override
        public void setAsText(String text) {
            MakefileConfiguration.this.getBuildCommandWorkingDir().setValue(text);
        }

        @Override
        public String getAsText() {
            return MakefileConfiguration.this.getBuildCommandWorkingDir().getValue();
        }

        @Override
        public Object getValue() {
            return MakefileConfiguration.this.getBuildCommandWorkingDir().getValue();
        }

        @Override
        public void setValue(Object v) {
            MakefileConfiguration.this.getBuildCommandWorkingDir().setValue((String)v);
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        @Override
        public Component getCustomEditor() {
            return new DirPanel(this.seed, this, this.propenv);
        }

        public void attachEnv(PropertyEnv propenv) {
            this.propenv = propenv;
        }
    }

    private class OutputStringNodeProp
    extends StringNodeProp {
        public OutputStringNodeProp(StringConfiguration stringConfiguration, String txt1, String txt2, String txt3) {
            super(stringConfiguration, txt1, txt2, txt3);
        }

        @Override
        public void setValue(String v) {
            String path = CndPathUtilitities.toRelativePath((String)MakefileConfiguration.this.getMakeConfiguration().getBaseDir(), (String)v);
            path = CndPathUtilitities.normalize((String)path);
            super.setValue(path);
        }

        public PropertyEditor getPropertyEditor() {
            String seed = MakefileConfiguration.this.getAbsOutput();
            if (seed.length() == 0) {
                seed = MakefileConfiguration.this.getMakeConfiguration().getBaseDir();
            }
            return new ElfEditor(seed);
        }
    }

    private class DirStringNodeProp
    extends StringNodeProp {
        public DirStringNodeProp(StringConfiguration stringConfiguration, String txt1, String txt2, String txt3) {
            super(stringConfiguration, txt1, txt2, txt3);
        }

        @Override
        public void setValue(String v) {
            String path = CndPathUtilitities.toRelativePath((String)MakefileConfiguration.this.getMakeConfiguration().getBaseDir(), (String)v);
            path = CndPathUtilitities.normalize((String)path);
            super.setValue(path);
        }

        public PropertyEditor getPropertyEditor() {
            return new DirEditor(MakefileConfiguration.this.getAbsBuildCommandWorkingDir());
        }
    }
}

