/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.cnd.makeproject.api.PackagerInfoElement;
import org.netbeans.modules.cnd.makeproject.api.configurations.PackagingConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.ui.PackagingNewEntryPanel;
import org.netbeans.modules.cnd.utils.ui.ListEditorPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class PackagingInfoPanel
extends ListEditorPanel<PackagerInfoElement> {
    private PackagingConfiguration packagingConfiguration;
    private JTable targetList;
    private MyTableCellRenderer myTableCellRenderer = new MyTableCellRenderer();
    private JButton addButton;
    private JButton addEntryButton;
    private JTextArea docArea;
    private static ResourceBundle bundle;

    public PackagingInfoPanel(List<PackagerInfoElement> infoList, PackagingConfiguration packagingConfiguration) {
        super(infoList, new JButton[]{new JButton(), new JButton()});
        this.getAddButton().setVisible(false);
        this.packagingConfiguration = packagingConfiguration;
        this.addButton = this.extraButtons[0];
        this.addButton.setText(PackagingInfoPanel.getString("PackagingFilesPanel.addButton.text"));
        this.addButton.setMnemonic(PackagingInfoPanel.getString("PackagingFilesPanel.addButton.mn").charAt(0));
        this.addButton.getAccessibleContext().setAccessibleDescription(PackagingInfoPanel.getString("PackagingFilesPanel.addButton.ad"));
        this.addButton.addActionListener(new AddButtonAction());
        this.addEntryButton = this.extraButtons[1];
        this.addEntryButton.setText(PackagingInfoPanel.getString("PackagingFilesPanel.addParameterButton.text"));
        this.addEntryButton.setMnemonic(PackagingInfoPanel.getString("PackagingFilesPanel.addParameterButton.mn").charAt(0));
        this.addEntryButton.getAccessibleContext().setAccessibleDescription(PackagingInfoPanel.getString("PackagingFilesPanel.addParameterButton.ad"));
        this.addEntryButton.addActionListener(new AddEntryButtonAction());
        this.getEditButton().setVisible(false);
        this.getDefaultButton().setVisible(false);
        if (infoList.size() > 0 && infoList.get(0).isMandatory()) {
            this.getRemoveButton().setEnabled(false);
        }
    }

    public void setDocArea(JTextArea docArea) {
        this.docArea = docArea;
    }

    public PackagerInfoElement copyAction(PackagerInfoElement o) {
        PackagerInfoElement elem = o;
        return new PackagerInfoElement(elem.getPackager(), new String(elem.getName()), new String(elem.getValue()));
    }

    public String getCopyButtonText() {
        return PackagingInfoPanel.getString("PackagingFilesPanel.duplicateButton.text");
    }

    public char getCopyButtonMnemonics() {
        return PackagingInfoPanel.getString("PackagingFilesPanel.duplicateButton.mn").charAt(0);
    }

    public String getCopyButtonAD() {
        return PackagingInfoPanel.getString("PackagingFilesPanel.duplicateButton.ad");
    }

    public String getListLabelText() {
        return PackagingInfoPanel.getString("PackagingInfoPanel.listlabel.text");
    }

    public char getListLabelMnemonic() {
        return PackagingInfoPanel.getString("PackagingInfoPanel.listlabel.mn").toCharArray()[0];
    }

    public int getSelectedIndex() {
        int index = this.getTargetList().getSelectedRow();
        if (index >= 0 && index < this.listData.size()) {
            return index;
        }
        return 0;
    }

    protected void setSelectedIndex(int i) {
        this.getTargetList().getSelectionModel().setSelectionInterval(i, i);
    }

    protected void setData(Vector data) {
        this.getTargetList().setModel(new MyTableModel());
        this.getTargetList().getColumnModel().getColumn(0).setPreferredWidth(100);
        this.getTargetList().getColumnModel().getColumn(0).setMaxWidth(400);
        this.getTargetList().getSelectionModel().setSelectionMode(0);
        this.getTargetList().getSelectionModel().addListSelectionListener(new TargetSelectionListener());
        ((DefaultTableCellRenderer)this.getTargetList().getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
    }

    protected void ensureIndexIsVisible(int selectedIndex) {
    }

    protected Component getViewComponent() {
        return this.getTargetList();
    }

    private JTable getTargetList() {
        if (this.targetList == null) {
            this.targetList = new MyTable();
            this.getListLabel().setLabelFor(this.targetList);
            this.setData(null);
        }
        return this.targetList;
    }

    public void refresh() {
        this.updateDoc();
    }

    public void updateDoc() {
        if (this.docArea == null) {
            return;
        }
        this.docArea.setText("");
        int i = this.targetList.getSelectedRow();
        if (this.listData.size() == 0 || i < 0 || i >= this.listData.size()) {
            return;
        }
        PackagerInfoElement elem = (PackagerInfoElement)this.listData.get(i);
        if (elem.getName().equals("ARCH")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_ARCH_DOC"));
        } else if (elem.getName().equals("CATEGORY")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_CATEGORY_DOC"));
        } else if (elem.getName().equals("NAME")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_NAME_DOC"));
        } else if (elem.getName().equals("PKG")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_PKG_DOC"));
        } else if (elem.getName().equals("VERSION")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_VERSION_DOC"));
        } else if (elem.getName().equals("BASEDIR")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_BASEDIR_DOC"));
        } else if (elem.getName().equals("CLASSES")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_CLASSES_DOC"));
        } else if (elem.getName().equals("DESC")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_DESC_DOC"));
        } else if (elem.getName().equals("EMAIL")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_EMAIL_DOC"));
        } else if (elem.getName().equals("HOTLINE")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_HOTLINE_DOC"));
        } else if (elem.getName().equals("INTONLY")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_INTONLY_DOC"));
        } else if (elem.getName().equals("ISTATES")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_ISTATES_DOC"));
        } else if (elem.getName().equals("MAXINST")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_MAXINST_DOC"));
        } else if (elem.getName().equals("ORDER")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_ORDER_DOC"));
        } else if (elem.getName().equals("PSTAMP")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_PSTAMP_DOC"));
        } else if (elem.getName().equals("RSTATES")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_RSTATES_DOC"));
        } else if (elem.getName().equals("SUNW_ISA")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_SUNW_ISA_DOC"));
        } else if (elem.getName().equals("SUNW_LOC")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_SUNW_LOC_DOC"));
        } else if (elem.getName().equals("SUNW_PKG_DIR")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_SUNW_PKG_DIR_DOC"));
        } else if (elem.getName().equals("SUNW_PKG_ALLZONES")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_SUNW_PKG_ALLZONES_DOC"));
        } else if (elem.getName().equals("SUNW_PKG_HOLLOW")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_SUNW_PKG_HOLLOW_DOC"));
        } else if (elem.getName().equals("SUNW_PKG_THISZONE")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_SUNW_PKG_THISZONE_DOC"));
        } else if (elem.getName().equals("SUNW_PKGLIST")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_SUNW_PKGLIST_DOC"));
        } else if (elem.getName().equals("SUNW_PKGTYPE")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_SUNW_PKGTYPE_DOC"));
        } else if (elem.getName().equals("SUNW_PKGVERS")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_SUNW_PKGVERS_DOC"));
        } else if (elem.getName().equals("SUNW_PRODNAME")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_SUNW_PRODNAME_DOC"));
        } else if (elem.getName().equals("SUNW_PRODVERS")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_SUNW_PRODVERS_DOC"));
        } else if (elem.getName().equals("ULIMIT")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_ULIMIT_DOC"));
        } else if (elem.getName().equals("VENDOR")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_VENDOR_DOC"));
        } else if (elem.getName().equals("VSTOCK")) {
            this.docArea.setText(PackagingInfoPanel.getString("PACKAGING_VSTOCK_DOC"));
        }
    }

    private static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(PackagingInfoPanel.class);
        }
        return bundle.getString(s);
    }

    class MyTableModel
    extends DefaultTableModel {
        private String[] columnNames = new String[]{PackagingInfoPanel.access$100("PackagingInfoPanel.column.0.text"), PackagingInfoPanel.access$100("PackagingInfoPanel.column.1.text")};

        MyTableModel() {
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return PackagingInfoPanel.this.listData.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            PackagerInfoElement elem = (PackagerInfoElement)PackagingInfoPanel.this.listData.elementAt(row);
            if (col == 0) {
                return elem.getName();
            }
            if (col == 1) {
                return elem.getValue();
            }
            assert (false);
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            PackagerInfoElement elem = (PackagerInfoElement)PackagingInfoPanel.this.listData.elementAt(row);
            if (col == 0) {
                elem.setName((String)value);
            } else if (col == 1) {
                elem.setValue((String)value);
            } else assert (false);
            elem.setDefaultValue(false);
        }
    }

    class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        MyTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int col) {
            String val;
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, color, isSelected, hasFocus, row, col);
            PackagerInfoElement elem = (PackagerInfoElement)PackagingInfoPanel.this.listData.elementAt(row);
            if (col != 0 && col == 1 && (val = elem.getValue()).indexOf("${") >= 0) {
                String expandedVal = PackagingInfoPanel.this.packagingConfiguration.expandMacros(val);
                label.setText(expandedVal);
            }
            return label;
        }
    }

    class MyListSelectionListener
    implements ListSelectionListener {
        MyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent arg0) {
            PackagingInfoPanel.this.updateDoc();
        }
    }

    class MyTable
    extends JTable {
        public MyTable() {
            this.getAccessibleContext().setAccessibleDescription("");
            this.getAccessibleContext().setAccessibleName("");
            this.getSelectionModel().addListSelectionListener(new MyListSelectionListener());
            this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        }

        @Override
        public boolean getShowHorizontalLines() {
            return false;
        }

        @Override
        public boolean getShowVerticalLines() {
            return false;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            return PackagingInfoPanel.this.myTableCellRenderer;
        }
    }

    private class TargetSelectionListener
    implements ListSelectionListener {
        private TargetSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            PackagerInfoElement infoElement;
            if (e.getValueIsAdjusting()) {
                return;
            }
            PackagingInfoPanel.this.checkSelection();
            int i = PackagingInfoPanel.this.getSelectedIndex();
            if (PackagingInfoPanel.this.listData.size() >= 0 && i >= 0 && i < PackagingInfoPanel.this.listData.size() && (infoElement = (PackagerInfoElement)PackagingInfoPanel.this.listData.get(i)).isMandatory()) {
                PackagingInfoPanel.this.getRemoveButton().setEnabled(false);
            }
        }
    }

    class AddEntryButtonAction
    implements ActionListener {
        AddEntryButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            PackagingNewEntryPanel packagingNewEntryPanel = new PackagingNewEntryPanel(PackagingInfoPanel.this.packagingConfiguration);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)packagingNewEntryPanel, PackagingInfoPanel.getString("AddNewParameterDialogTitle"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (dialogDescriptor.getValue() != DialogDescriptor.OK_OPTION) {
                return;
            }
            PackagingInfoPanel.this.addObjectAction(packagingNewEntryPanel.getInfoElement());
        }
    }

    class AddButtonAction
    implements ActionListener {
        AddButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            PackagingInfoPanel.this.addObjectAction(new PackagerInfoElement(PackagingInfoPanel.this.packagingConfiguration.getType().getValue(), "", ""));
        }
    }
}

