/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.indent;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.php.editor.indent.CodeStyle;
import org.netbeans.modules.php.editor.indent.WSTransformer;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayElement;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ExpressionStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ForEachStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.InfixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.ReturnStatement;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.SwitchCase;
import org.netbeans.modules.php.editor.parser.astnodes.SwitchStatement;
import org.netbeans.modules.php.editor.parser.astnodes.TryStatement;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.openide.util.Exceptions;

public class IndentLevelCalculator
extends DefaultTreePathVisitor {
    private Map<Position, Integer> indentLevels;
    private int indentSize;
    private int continuationIndentSize;
    private int itemsInArrayDeclarationSize;
    private BaseDocument doc;
    private Collection<Class<? extends ASTNode>> PARENTS_WITHOUT_CONT_INDENT = Arrays.asList(Assignment.class, FieldsDeclaration.class, ReturnStatement.class, InfixExpression.class, ExpressionStatement.class, SingleFieldDeclaration.class, FunctionInvocation.class);

    public IndentLevelCalculator(Document doc, Map<Position, Integer> indentLevels) {
        this.indentLevels = indentLevels;
        this.doc = (BaseDocument)doc;
        CodeStyle codeStyle = CodeStyle.get(doc);
        this.indentSize = codeStyle.getIndentSize();
        this.continuationIndentSize = codeStyle.getContinuationIndentSize();
        this.itemsInArrayDeclarationSize = codeStyle.getItemsInArrayDeclarationIndentSize();
    }

    @Override
    public void visit(Block node) {
        super.visit(node);
        ASTNode parent = this.getPath().get(0);
        if (parent instanceof NamespaceDeclaration) {
            return;
        }
        CodeStyle.BracePlacement openingBraceStyle = CodeStyle.BracePlacement.PRESERVE_EXISTING;
        openingBraceStyle = parent instanceof ClassDeclaration ? CodeStyle.get((Document)this.doc).getClassDeclBracePlacement() : (parent instanceof FunctionDeclaration || parent instanceof MethodDeclaration ? CodeStyle.get((Document)this.doc).getMethodDeclBracePlacement() : (parent instanceof IfStatement ? CodeStyle.get((Document)this.doc).getIfBracePlacement() : (parent instanceof ForStatement || parent instanceof ForEachStatement ? CodeStyle.get((Document)this.doc).getForBracePlacement() : (parent instanceof WhileStatement || parent instanceof DoStatement ? CodeStyle.get((Document)this.doc).getWhileBracePlacement() : (parent instanceof SwitchStatement ? CodeStyle.get((Document)this.doc).getSwitchBracePlacement() : (parent instanceof CatchClause || parent instanceof TryStatement ? CodeStyle.get((Document)this.doc).getCatchBracePlacement() : CodeStyle.get((Document)this.doc).getOtherBracePlacement()))))));
        TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)this.doc, node.getStartOffset());
        ts.move(node.getStartOffset());
        if (ts.movePrevious() && ts.moveNext()) {
            while (ts.token().id() != PHPTokenId.PHP_CURLY_OPEN && (ts.token().id() != PHPTokenId.PHP_TOKEN || !":".equals(((Object)ts.token().text()).toString())) && ts.moveNext()) {
                LexUtilities.findNextToken(ts, Arrays.asList(PHPTokenId.PHP_CURLY_OPEN, PHPTokenId.PHP_TOKEN));
            }
            if (openingBraceStyle != CodeStyle.BracePlacement.NEW_LINE_INDENTED) {
                ts.moveNext();
            }
            this.addIndentLevel(ts.offset(), this.indentSize);
            ts.move(node.getEndOffset());
            ts.movePrevious();
            ts.movePrevious();
            LexUtilities.findNextToken(ts, Arrays.asList(PHPTokenId.PHP_CURLY_CLOSE, PHPTokenId.PHP_TOKEN, PHPTokenId.PHP_ENDIF, PHPTokenId.PHP_ENDFOR, PHPTokenId.PHP_ENDFOREACH, PHPTokenId.PHP_ENDSWITCH, PHPTokenId.PHP_ENDWHILE));
            if (ts.token().id() == PHPTokenId.PHP_CURLY_CLOSE || ts.token().id() == PHPTokenId.PHP_TOKEN || ts.token().id() == PHPTokenId.PHP_ENDIF || ts.token().id() == PHPTokenId.PHP_ENDFOR || ts.token().id() == PHPTokenId.PHP_ENDFOREACH || ts.token().id() == PHPTokenId.PHP_ENDSWITCH || ts.token().id() == PHPTokenId.PHP_ENDWHILE) {
                if (ts.token().id() == PHPTokenId.PHP_TOKEN && ":".equals(((Object)ts.token().text()).toString())) {
                    ts.movePrevious();
                    LexUtilities.findPrevious(ts, WSTransformer.WS_AND_COMMENT_TOKENS);
                }
                if (openingBraceStyle != CodeStyle.BracePlacement.NEW_LINE_INDENTED) {
                    ts.movePrevious();
                }
                this.addIndentLevel(ts.offset() + ts.token().length(), -1 * this.indentSize);
            }
        }
    }

    @Override
    public void visit(IfStatement node) {
        this.indentNonBlockStatement(node.getFalseStatement());
        this.indentNonBlockStatement(node.getTrueStatement());
        super.visit(node);
    }

    @Override
    public void visit(DoStatement node) {
        this.indentNonBlockStatement(node.getBody());
        super.visit(node);
    }

    @Override
    public void visit(ForEachStatement node) {
        this.indentNonBlockStatement(node.getStatement());
        super.visit(node);
    }

    @Override
    public void visit(ForStatement node) {
        this.indentNonBlockStatement(node.getBody());
        super.visit(node);
    }

    @Override
    public void visit(WhileStatement node) {
        this.indentNonBlockStatement(node.getBody());
        super.visit(node);
    }

    @Override
    public void visit(ArrayCreation node) {
        Class<?> parentClass = this.getPath().get(0).getClass();
        if (node.getElements().size() > 0) {
            int start = node.getElements().get(0).getStartOffset();
            ArrayElement lastElem = node.getElements().get(node.getElements().size() - 1);
            int end = lastElem.getEndOffset();
            if (parentClass == FunctionInvocation.class && ((FunctionInvocation)this.getPath().get(0)).getParameters().size() > 1 || !this.PARENTS_WITHOUT_CONT_INDENT.contains(parentClass)) {
                this.addIndentLevel(start, this.itemsInArrayDeclarationSize);
                this.addIndentLevel(end, -1 * this.itemsInArrayDeclarationSize);
            } else {
                this.addIndentLevel(start, this.itemsInArrayDeclarationSize - this.continuationIndentSize);
                this.addIndentLevel(end, this.continuationIndentSize - this.itemsInArrayDeclarationSize);
            }
        }
        super.visit(node);
    }

    @Override
    public void visit(InfixExpression node) {
        Class<?> parentClass = this.getPath().get(0).getClass();
        if (!this.PARENTS_WITHOUT_CONT_INDENT.contains(parentClass)) {
            this.indentContinuationWithinStatement(node);
        }
        super.visit(node);
    }

    @Override
    public void visit(FunctionInvocation node) {
        Class<?> parentClass = this.getPath().get(0).getClass();
        if (!this.PARENTS_WITHOUT_CONT_INDENT.contains(parentClass)) {
            this.indentContinuationWithinStatement(node);
        }
        super.visit(node);
    }

    @Override
    public void visit(ExpressionStatement node) {
        Class<?> parentClass = this.getPath().get(0).getClass();
        if (!this.PARENTS_WITHOUT_CONT_INDENT.contains(parentClass)) {
            this.indentContinuationWithinStatement(node);
        }
        super.visit(node);
    }

    @Override
    public void visit(ReturnStatement node) {
        this.indentContinuationWithinStatement(node);
        super.visit(node);
    }

    @Override
    public void visit(FieldsDeclaration node) {
        this.indentContinuationWithinStatement(node);
        super.visit(node);
    }

    @Override
    public void visit(SingleFieldDeclaration node) {
    }

    @Override
    public void visit(Program node) {
        for (Comment comment : node.getComments()) {
            if (!(comment instanceof PHPDocBlock)) continue;
            try {
                int endOfFirstLine = Utilities.getRowEnd((BaseDocument)this.doc, (int)comment.getStartOffset());
                if (endOfFirstLine >= comment.getEndOffset()) continue;
                this.addIndentLevel(endOfFirstLine, 1);
                this.addIndentLevel(comment.getEndOffset(), -1);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        super.visit(node);
    }

    @Override
    public void visit(SwitchCase node) {
        this.indentListOfStatements(node.getActions());
        super.visit(node);
    }

    private void indentContinuationWithinStatement(ASTNode node) {
        try {
            int endOfFirstLine = Utilities.getRowEnd((BaseDocument)this.doc, (int)node.getStartOffset());
            if (endOfFirstLine < node.getEndOffset()) {
                this.addIndentLevel(endOfFirstLine + 1, this.continuationIndentSize);
                TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)this.doc, node.getEndOffset());
                int end = node.getEndOffset();
                if (ts != null) {
                    ts.move(node.getEndOffset());
                    do {
                        ts.movePrevious();
                    } while (IndentLevelCalculator.indentContinuationWithinStatement_skipToken(ts.token()));
                    end = ts.offset() + ts.token().length();
                }
                this.addIndentLevel(end, -1 * this.continuationIndentSize);
            }
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static boolean indentContinuationWithinStatement_skipToken(Token token) {
        TokenId tokenID = token.id();
        if (tokenID == PHPTokenId.PHP_SEMICOLON) {
            return true;
        }
        return tokenID == PHPTokenId.PHP_TOKEN && ")".equals(((Object)token.text()).toString());
    }

    private void indentListOfStatements(List<Statement> stmts) {
        if (stmts.size() > 0) {
            ASTNode firstNode = stmts.get(0);
            ASTNode lastNode = stmts.get(stmts.size() - 1);
            int start = IndentLevelCalculator.firstNonWSBwd(this.doc, firstNode.getStartOffset()) + 1;
            int end = IndentLevelCalculator.firstNonWSFwd(this.doc, lastNode.getEndOffset()) - 1;
            this.addIndentLevel(start, this.indentSize);
            this.addIndentLevel(end, -1 * this.indentSize);
        }
    }

    @Override
    public void visit(FunctionDeclaration node) {
        int paramCount = node.getFormalParameters().size();
        if (paramCount > 0) {
            FormalParameter firstParam = node.getFormalParameters().get(0);
            FormalParameter lastParam = node.getFormalParameters().get(paramCount - 1);
            this.addIndentLevel(firstParam.getStartOffset(), this.continuationIndentSize);
            this.addIndentLevel(lastParam.getEndOffset(), -1 * this.continuationIndentSize);
        }
        super.visit(node);
    }

    private void indentNonBlockStatement(ASTNode node) {
        if (node == null || node instanceof Block) {
            return;
        }
        if (node instanceof IfStatement) {
            TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)this.doc, node.getStartOffset());
            ts.move(node.getStartOffset());
            ts.moveNext();
            if (ts.token().id() == PHPTokenId.PHP_ELSEIF) {
                return;
            }
            if (ts.token().id() == PHPTokenId.PHP_IF && ts.movePrevious() && ts.token().id() == PHPTokenId.WHITESPACE && ts.movePrevious() && ts.token().id() == PHPTokenId.PHP_ELSE) {
                return;
            }
        }
        int start = IndentLevelCalculator.firstNonWSBwd(this.doc, node.getStartOffset()) + 1;
        int end = IndentLevelCalculator.firstNonWSFwd(this.doc, node.getEndOffset()) - 1;
        this.addIndentLevel(start, this.indentSize);
        this.addIndentLevel(end, -1 * this.indentSize);
    }

    private static int firstNonWSBwd(BaseDocument doc, int offset) {
        int r = offset;
        try {
            int v = Utilities.getFirstNonWhiteBwd((BaseDocument)doc, (int)offset);
            int rs = Utilities.getRowStart((BaseDocument)doc, (int)offset);
            if (v >= 0) {
                r = v;
            }
            if (r < rs) {
                r = rs - 1;
            }
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return r;
    }

    private static int firstNonWSFwd(BaseDocument doc, int offset) {
        int r = offset;
        try {
            int v = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)offset);
            int re = Utilities.getRowEnd((BaseDocument)doc, (int)offset);
            if (v >= 0) {
                r = v;
            }
            if (r > re) {
                r = re + 1;
            }
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return r;
    }

    private void addIndentLevel(int offset, int indent) {
        try {
            this.indentLevels.put(this.doc.createPosition(offset), indent);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private Integer getExistingIndentLevel(int offset) {
        for (Position pos : this.indentLevels.keySet()) {
            if (pos.getOffset() != offset) continue;
            return this.indentLevels.get(pos);
        }
        return 0;
    }
}

