/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.verification.PHPRule;
import org.openide.util.NbBundle;

public class ClassNotFoundRule
extends PHPRule {
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public String getId() {
        return "class.not.found";
    }

    @Override
    public void visit(ClassDeclaration classDeclaration) {
        Expression superClass = classDeclaration.getSuperClass();
        this.check(superClass);
    }

    @Override
    public void visit(ClassInstanceCreation classInstanceCreation) {
        Expression className = classInstanceCreation.getClassName().getName();
        this.check(className);
    }

    private void check(Expression expression) {
        String className;
        if (expression instanceof Identifier && !"self".equalsIgnoreCase(className = ((Identifier)expression).getName()) && this.context.getIndex().getClasses(NameKind.exact(className)).isEmpty()) {
            this.addHint(expression);
        }
    }

    public String getDescription() {
        return NbBundle.getMessage(ClassNotFoundRule.class, (String)"ClassNotFoundHintDesc");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ClassNotFoundRule.class, (String)"ClassNotFoundHintDispName");
    }

    private void addHint(ASTNode node) {
        OffsetRange range = new OffsetRange(node.getStartOffset(), node.getEndOffset());
        Hint hint = new Hint((Rule)this, this.getDisplayName(), this.context.parserResult.getSnapshot().getSource().getFileObject(), range, null, 500);
        this.addResult(hint);
    }

    @Override
    public boolean getDefaultEnabled() {
        return false;
    }
}

