/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.PredefinedSymbols;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.FunctionElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ForEachStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.GlobalStatement;
import org.netbeans.modules.php.editor.parser.astnodes.GotoLabel;
import org.netbeans.modules.php.editor.parser.astnodes.GotoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.InfixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultTreePathVisitor;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.PHPRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

class PHPVerificationVisitor
extends DefaultTreePathVisitor {
    private PHPRuleContext context;
    private Collection<PHPRule> rules;
    private List<Hint> result = new LinkedList<Hint>();
    private VariableStack varStack = new VariableStack();
    private boolean maintainVarStack;

    public PHPVerificationVisitor(PHPRuleContext context, Collection<PHPRule> rules, boolean maintainVarStack) {
        this.maintainVarStack = maintainVarStack;
        this.context = context;
        if (maintainVarStack) {
            context.variableStack = this.varStack;
        }
        context.path = this.getPath();
        this.rules = rules;
    }

    public List<Hint> getResult() {
        return this.result;
    }

    @Override
    public void visit(Program node) {
        for (PHPRule rule : this.rules) {
            rule.setContext(this.context);
            rule.visit(node);
            this.result.addAll(rule.getResult());
            rule.resetResult();
        }
        super.visit(node);
    }

    @Override
    public void visit(StaticFieldAccess node) {
        for (PHPRule rule : this.rules) {
            rule.setContext(this.context);
            rule.visit(node);
            this.result.addAll(rule.getResult());
            rule.resetResult();
        }
        super.visit(node);
    }

    @Override
    public void visit(ClassDeclaration node) {
        for (PHPRule rule : this.rules) {
            rule.setContext(this.context);
            rule.visit(node);
            this.result.addAll(rule.getResult());
            rule.resetResult();
        }
        super.visit(node);
        for (PHPRule rule : this.rules) {
            rule.leavingClassDeclaration(node);
        }
    }

    @Override
    public void visit(ClassInstanceCreation node) {
        for (PHPRule rule : this.rules) {
            rule.setContext(this.context);
            rule.visit(node);
            this.result.addAll(rule.getResult());
            rule.resetResult();
        }
        super.visit(node);
    }

    @Override
    public void visit(LambdaFunctionDeclaration node) {
        for (PHPRule rule : this.rules) {
            rule.setContext(this.context);
            rule.visit(node);
            this.result.addAll(rule.getResult());
            rule.resetResult();
        }
        super.visit(node);
    }

    @Override
    public void visit(NamespaceName node) {
        for (PHPRule rule : this.rules) {
            rule.setContext(this.context);
            rule.visit(node);
            this.result.addAll(rule.getResult());
            rule.resetResult();
        }
        super.visit(node);
    }

    @Override
    public void visit(NamespaceDeclaration node) {
        for (PHPRule rule : this.rules) {
            rule.setContext(this.context);
            rule.visit(node);
            this.result.addAll(rule.getResult());
            rule.resetResult();
        }
        super.visit(node);
    }

    @Override
    public void visit(GotoLabel node) {
        for (PHPRule rule : this.rules) {
            rule.setContext(this.context);
            rule.visit(node);
            this.result.addAll(rule.getResult());
            rule.resetResult();
        }
        super.visit(node);
    }

    @Override
    public void visit(GotoStatement node) {
        for (PHPRule rule : this.rules) {
            rule.setContext(this.context);
            rule.visit(node);
            this.result.addAll(rule.getResult());
            rule.resetResult();
        }
        super.visit(node);
    }

    @Override
    public void visit(UseStatement node) {
        for (PHPRule rule : this.rules) {
            rule.setContext(this.context);
            rule.visit(node);
            this.result.addAll(rule.getResult());
            rule.resetResult();
        }
        super.visit(node);
    }

    @Override
    public void visit(IfStatement node) {
        IsSetFinder isSetFinder = new IsSetFinder();
        node.getCondition().accept(isSetFinder);
        for (Expression checkedVar : isSetFinder.checkedVars) {
            this.varStack.addVariableDefinition(checkedVar);
        }
        for (PHPRule rule : this.rules) {
            rule.setContext(this.context);
            rule.visit(node);
            this.result.addAll(rule.getResult());
            rule.resetResult();
        }
        super.visit(node);
    }

    @Override
    public void visit(DoStatement node) {
        for (PHPRule rule : this.rules) {
            rule.setContext(this.context);
            rule.visit(node);
            this.result.addAll(rule.getResult());
            rule.resetResult();
        }
        super.visit(node);
    }

    @Override
    public void visit(InfixExpression node) {
        for (PHPRule rule : this.rules) {
            rule.setContext(this.context);
            rule.visit(node);
            this.result.addAll(rule.getResult());
            rule.resetResult();
        }
        super.visit(node);
    }

    @Override
    public void visit(FieldAccess node) {
        for (PHPRule rule : this.rules) {
            rule.setContext(this.context);
            rule.visit(node);
            this.result.addAll(rule.getResult());
            rule.resetResult();
        }
        super.visit(node);
    }

    @Override
    public void visit(FieldsDeclaration node) {
        for (PHPRule rule : this.rules) {
            rule.setContext(this.context);
            rule.visit(node);
            this.result.addAll(rule.getResult());
            rule.resetResult();
        }
        super.visit(node);
    }

    @Override
    public void visit(ForStatement node) {
        for (PHPRule rule : this.rules) {
            rule.setContext(this.context);
            rule.visit(node);
            this.result.addAll(rule.getResult());
            rule.resetResult();
        }
        super.visit(node);
    }

    @Override
    public void visit(WhileStatement node) {
        for (PHPRule rule : this.rules) {
            rule.setContext(this.context);
            rule.visit(node);
            this.result.addAll(rule.getResult());
            rule.resetResult();
        }
        super.visit(node);
    }

    @Override
    public void visit(MethodInvocation node) {
        if (this.maintainVarStack) {
            VariableWrapper wrapper;
            Variable var;
            String varName;
            String className = null;
            String fname = null;
            if (node.getDispatcher() instanceof Variable && (varName = CodeUtils.extractVariableName(var = (Variable)node.getDispatcher())) != null && varName.startsWith("$") && (wrapper = this.context.variableStack.getVariableWraper(varName.substring(1))) != null) {
                className = wrapper.type;
            }
            if ((fname = CodeUtils.extractFunctionName(node.getMethod())) != null && className != null) {
                FileObject source = this.context.parserResult.getSnapshot().getSource().getFileObject();
                ArrayList<ElementFilter> filters = new ArrayList<ElementFilter>();
                filters.add(ElementFilter.forPublicModifiers(true));
                if (source != null) {
                    filters.add(ElementFilter.forFiles(source));
                }
                Set<MethodElement> allMethods = ElementFilter.allOf(filters).filter(this.context.getIndex().getAllMethods(NameKind.exact(className), NameKind.exact(fname)));
                this.assumeParamsPassedByRefInitialized(allMethods, node.getMethod());
            }
        }
        for (PHPRule rule : this.rules) {
            rule.setContext(this.context);
            rule.visit(node);
            this.result.addAll(rule.getResult());
            rule.resetResult();
        }
        super.visit(node);
    }

    @Override
    public void visit(StaticMethodInvocation node) {
        if (this.maintainVarStack) {
            String className = CodeUtils.extractUnqualifiedClassName(node);
            String fname = CodeUtils.extractFunctionName(node.getMethod());
            if (fname != null && className != null) {
                FileObject source = this.context.parserResult.getSnapshot().getSource().getFileObject();
                ArrayList<ElementFilter> filters = new ArrayList<ElementFilter>();
                filters.add(ElementFilter.forAllOfFlags(9));
                if (source != null) {
                    filters.add(ElementFilter.forFiles(source));
                }
                Set<MethodElement> methods = ElementFilter.allOf(filters).filter(this.context.getIndex().getAllMethods(NameKind.exact(className), NameKind.exact(fname)));
                this.assumeParamsPassedByRefInitialized(methods, node.getMethod());
            }
        }
        for (PHPRule rule : this.rules) {
            rule.setContext(this.context);
            rule.visit(node);
            this.result.addAll(rule.getResult());
            rule.resetResult();
        }
        super.visit(node);
    }

    @Override
    public void visit(FunctionInvocation node) {
        String fname;
        if (this.maintainVarStack && (fname = CodeUtils.extractFunctionName(node)) != null) {
            FileObject source = this.context.parserResult.getSnapshot().getSource().getFileObject();
            Set<FunctionElement> functions = this.context.getIndex().getFunctions(NameKind.exact(fname));
            if (source != null) {
                functions = ElementFilter.forFiles(source).filter(functions);
            }
            this.assumeParamsPassedByRefInitialized(functions, node);
        }
        for (PHPRule rule : this.rules) {
            rule.setContext(this.context);
            rule.visit(node);
            this.result.addAll(rule.getResult());
            rule.resetResult();
        }
        super.visit(node);
    }

    @Override
    public void visit(FunctionDeclaration node) {
        this.varStack.blockStart(VariableStack.BlockType.FUNCTION);
        for (FormalParameter param : node.getFormalParameters()) {
            this.varStack.addVariableDefinition(param);
        }
        for (PHPRule rule : this.rules) {
            rule.setContext(this.context);
            rule.visit(node);
            this.result.addAll(rule.getResult());
            rule.resetResult();
        }
        super.visit(node);
        this.varStack.blockEnd();
    }

    @Override
    public void visit(Variable node) {
        for (PHPRule rule : this.rules) {
            rule.setContext(this.context);
            rule.visit(node);
            this.result.addAll(rule.getResult());
            rule.resetResult();
        }
        super.visit(node);
    }

    @Override
    public void visit(MethodDeclaration node) {
        for (PHPRule rule : this.rules) {
            rule.setContext(this.context);
            rule.visit(node);
            this.result.addAll(rule.getResult());
            rule.resetResult();
        }
        super.visit(node);
    }

    @Override
    public void visit(GlobalStatement node) {
        for (Variable var : node.getVariables()) {
            this.varStack.addVariableDefinition(var);
        }
        super.visit(node);
    }

    @Override
    public void visit(Block node) {
        this.varStack.blockStart(VariableStack.BlockType.BLOCK);
        super.visit(node);
        this.varStack.blockEnd();
    }

    @Override
    public void visit(Assignment node) {
        if (node.getLeftHandSide() instanceof Variable) {
            Variable var = (Variable)node.getLeftHandSide();
            String type = CodeUtils.extractVariableType(node);
            this.varStack.addVariableDefinition(var, type);
        }
        for (PHPRule rule : this.rules) {
            rule.setContext(this.context);
            rule.visit(node);
            this.result.addAll(rule.getResult());
            rule.resetResult();
        }
        super.visit(node);
    }

    @Override
    public void visit(ForEachStatement node) {
        Expression key = node.getKey();
        while (key instanceof Reference) {
            key = ((Reference)key).getExpression();
        }
        if (key instanceof Variable) {
            Variable var = (Variable)key;
            this.varStack.addVariableDefinition(var);
        }
        Expression value = node.getValue();
        while (value instanceof Reference) {
            value = ((Reference)value).getExpression();
        }
        if (value instanceof Variable) {
            Variable var = (Variable)value;
            this.varStack.addVariableDefinition(var);
        }
        super.visit(node);
    }

    @Override
    public void visit(CatchClause node) {
        String type = CodeUtils.extractUnqualifiedTypeName(node);
        Variable var = node.getVariable();
        this.varStack.addVariableDefinition(var, type);
        super.visit(node);
    }

    private void assumeParamsPassedByRefInitialized(Set<? extends BaseFunctionElement> functions, FunctionInvocation node) {
        boolean[] refParam = new boolean[node.getParameters().size()];
        for (BaseFunctionElement baseFunctionElement : functions) {
            for (int i = 0; i < baseFunctionElement.getParameters().size() && i < refParam.length; ++i) {
                ParameterElement param = baseFunctionElement.getParameters().get(i);
                String name = param.getName();
                if (!name.startsWith("&")) continue;
                refParam[i] = true;
            }
        }
        for (int i = 0; i < node.getParameters().size(); ++i) {
            if (!refParam[i]) continue;
            Expression expression = node.getParameters().get(i);
            this.varStack.addVariableDefinition(expression);
        }
    }

    private class IsSetFinder
    extends DefaultVisitor {
        private List<Expression> checkedVars = new ArrayList<Expression>();

        private IsSetFinder() {
        }

        @Override
        public void visit(FunctionInvocation node) {
            String fname = CodeUtils.extractFunctionName(node);
            if (fname == null || !"isset".equalsIgnoreCase(fname)) {
                return;
            }
            this.checkedVars.addAll(node.getParameters());
        }
    }

    public static class VariableStack {
        private LinkedList<LinkedHashMap<VariableWrapper, String>> vars = new LinkedList();
        private LinkedList<BlockType> blockTypes = new LinkedList();
        private LinkedList<ASTNode> unreferencesVars = new LinkedList();

        VariableStack() {
            this.blockStart(BlockType.BLOCK);
        }

        void blockStart(BlockType blockType) {
            this.vars.add(new LinkedHashMap());
            this.blockTypes.add(blockType);
        }

        void blockEnd() {
            for (VariableWrapper varw : this.vars.getLast().keySet()) {
                if (varw.referenced) continue;
                this.unreferencesVars.add(varw.var);
            }
            this.vars.removeLast();
            this.blockTypes.removeLast();
        }

        void addVariableDefinition(ASTNode var) {
            this.addVariableDefinition(var, null);
        }

        void addVariableDefinition(ASTNode var, String type) {
            Variable variable = null;
            if (var instanceof Variable) {
                variable = (Variable)var;
            } else if (var instanceof FormalParameter) {
                Reference reference;
                FormalParameter formalParameter = (FormalParameter)var;
                if (formalParameter.getParameterName() instanceof Variable) {
                    variable = (Variable)formalParameter.getParameterName();
                } else if (formalParameter.getParameterName() instanceof Reference && (reference = (Reference)formalParameter.getParameterName()).getExpression() instanceof Variable) {
                    variable = (Variable)reference.getExpression();
                }
            }
            if (variable != null && variable.getName() instanceof Identifier) {
                Identifier identifier = (Identifier)variable.getName();
                String varName = identifier.getName();
                VariableWrapper wrapper = this.getVariableWraper(varName);
                if (wrapper == null) {
                    wrapper = new VariableWrapper(var);
                    this.vars.getLast().put(wrapper, varName);
                }
                if (type != null) {
                    wrapper.type = type;
                }
            }
        }

        public boolean isVariableDefined(String varName) {
            if (PredefinedSymbols.isSuperGlobalName(varName) || "this".equals(varName)) {
                return true;
            }
            return this.getVariableWraper(varName) != null;
        }

        public VariableWrapper getVariableWraper(String varName) {
            for (int i = this.vars.size() - 1; i >= 0; --i) {
                LinkedHashMap<VariableWrapper, String> cvars = this.vars.get(i);
                VariableWrapper[] varsInCurrentBlock = cvars.keySet().toArray(new VariableWrapper[cvars.size()]);
                for (int j = varsInCurrentBlock.length - 1; j >= 0; --j) {
                    VariableWrapper var = varsInCurrentBlock[j];
                    String vName = cvars.get(var);
                    if (!varName.equals(vName)) continue;
                    var.referenced = true;
                    return var;
                }
                if (this.blockTypes.get(i) == BlockType.FUNCTION) break;
            }
            return null;
        }

        public List<ASTNode> getUnreferencedVars() {
            return this.unreferencesVars;
        }

        private static enum BlockType {
            BLOCK,
            FUNCTION;

        }
    }

    static class VariableWrapper {
        ASTNode var;
        boolean referenced = false;
        String type;

        public VariableWrapper(ASTNode var) {
            this.var = var;
        }
    }
}

