/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.MavenTools;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MissingRepositoryElementException;
import org.apache.maven.project.aspect.PBEDerivativeReporterAspect;

public class DefaultMavenTools
implements MavenTools {
    private ArtifactRepositoryFactory artifactRepositoryFactory;

    public List buildArtifactRepositories(List repositories) throws InvalidRepositoryException {
        ArrayList<ArtifactRepository> repos = new ArrayList<ArtifactRepository>();
        for (Repository mavenRepo : repositories) {
            ArtifactRepository artifactRepo = this.buildArtifactRepository(mavenRepo);
            if (repos.contains(artifactRepo)) continue;
            repos.add(artifactRepo);
        }
        return repos;
    }

    public ArtifactRepository buildDeploymentArtifactRepository(DeploymentRepository repo) throws InvalidRepositoryException {
        if (repo != null) {
            String id = repo.getId();
            String url = repo.getUrl();
            if (id == null || url == null) {
                return null;
            }
            return this.artifactRepositoryFactory.createDeploymentArtifactRepository(id, url, repo.getLayout(), repo.isUniqueVersion());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public ArtifactRepository buildArtifactRepository(Repository repository) throws InvalidRepositoryException {
        Repository repository2 = repository;
        try {
            try {
                void repo;
                if (repo != null) {
                    String id = repo.getId();
                    String url = repo.getUrl();
                    if (id == null || id.trim().length() < 1) {
                        throw new MissingRepositoryElementException("Repository ID must not be empty (URL is: " + url + ").");
                    }
                    if (url == null || url.trim().length() < 1) {
                        throw new MissingRepositoryElementException("Repository URL must not be empty (ID is: " + id + ").", id);
                    }
                    ArtifactRepositoryPolicy snapshots = this.buildArtifactRepositoryPolicy(repo.getSnapshots());
                    ArtifactRepositoryPolicy releases = this.buildArtifactRepositoryPolicy(repo.getReleases());
                    return this.artifactRepositoryFactory.createArtifactRepository(id, url, repo.getLayout(), snapshots, releases);
                }
                return null;
            }
            catch (InvalidRepositoryException invalidRepositoryException) {
                if (PBEDerivativeReporterAspect.ajc$cflowStack$0.isValid()) {
                    PBEDerivativeReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$2$6bdd8078((MavenProject)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(0), (File)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(1), repository2, invalidRepositoryException);
                }
                throw invalidRepositoryException;
            }
        }
        catch (InvalidRepositoryException invalidRepositoryException) {
            if (PBEDerivativeReporterAspect.ajc$cflowStack$1.isValid()) {
                PBEDerivativeReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$3$46ee9284((Model)PBEDerivativeReporterAspect.ajc$cflowStack$1.get(0), (File)PBEDerivativeReporterAspect.ajc$cflowStack$1.get(1), repository2, invalidRepositoryException);
            }
            throw invalidRepositoryException;
        }
    }

    public ArtifactRepositoryPolicy buildArtifactRepositoryPolicy(RepositoryPolicy policy) {
        boolean enabled = true;
        String updatePolicy = null;
        String checksumPolicy = null;
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updatePolicy = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksumPolicy = policy.getChecksumPolicy();
            }
        }
        return new ArtifactRepositoryPolicy(enabled, updatePolicy, checksumPolicy);
    }
}

