/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.extension;

import java.io.File;
import java.io.IOException;
import org.apache.maven.extension.ExtensionManagerException;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.interpolation.ModelInterpolationException;

public class ExtensionScanningException
extends Exception {
    private File pomFile;
    private String extensionId;
    private String modelId;
    private String moduleSubpath;

    public ExtensionScanningException(String message, File pomFile, ProjectBuildingException cause) {
        super(message, cause);
        this.pomFile = pomFile;
    }

    public ExtensionScanningException(String message, Model model, Extension extension, ExtensionManagerException cause) {
        super(message, cause);
        this.modelId = model.getId();
        this.extensionId = String.valueOf(extension.getGroupId()) + ":" + extension.getArtifactId();
    }

    public ExtensionScanningException(String message, ProjectBuildingException cause) {
        super(message, cause);
    }

    public ExtensionScanningException(String message, File pomFile, String moduleSubpath, IOException cause) {
        super(message, cause);
        this.pomFile = pomFile;
        this.moduleSubpath = moduleSubpath;
    }

    public ExtensionScanningException(String message, File pomFile, ModelInterpolationException cause) {
        super(message, cause);
        this.pomFile = pomFile;
    }

    public ExtensionScanningException(String message, Model model, Plugin plugin, ExtensionManagerException cause) {
        super(message, cause);
        this.modelId = model.getId();
        this.extensionId = String.valueOf(plugin.getGroupId()) + ":" + plugin.getArtifactId();
    }

    public File getPomFile() {
        return this.pomFile;
    }

    public String getExtensionId() {
        return this.extensionId;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getModuleSubpath() {
        return this.moduleSubpath;
    }
}

