/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import hidden.org.codehaus.plexus.util.IOUtil;
import hidden.org.codehaus.plexus.util.ReaderFactory;
import hidden.org.codehaus.plexus.util.StringUtils;
import hidden.org.codehaus.plexus.util.xml.XmlStreamReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.MavenTools;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactStatus;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.ManagedVersionMap;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Repository;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.profiles.MavenProfilesBuilder;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.profiles.activation.DefaultProfileActivationContext;
import org.apache.maven.profiles.activation.ProfileActivationContext;
import org.apache.maven.profiles.activation.ProfileActivationException;
import org.apache.maven.profiles.build.ProfileAdvisor;
import org.apache.maven.project.DefaultProjectBuilderConfiguration;
import org.apache.maven.project.InvalidProjectModelException;
import org.apache.maven.project.InvalidProjectVersionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MavenProjectBuildingResult;
import org.apache.maven.project.ModelUtils;
import org.apache.maven.project.ProjectBuilderConfiguration;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.aspect.PBEDerivativeReporterAspect;
import org.apache.maven.project.aspect.ProjectIOErrorReporterAspect;
import org.apache.maven.project.build.model.DefaultModelLineage;
import org.apache.maven.project.build.model.ModelLineageBuilder;
import org.apache.maven.project.build.model.ModelLineageIterator;
import org.apache.maven.project.inheritance.ModelInheritanceAssembler;
import org.apache.maven.project.injection.ModelDefaultsInjector;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.interpolation.ModelInterpolator;
import org.apache.maven.project.path.PathTranslator;
import org.apache.maven.project.validation.ModelValidationResult;
import org.apache.maven.project.validation.ModelValidator;
import org.apache.maven.project.workspace.ProjectWorkspace;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultMavenProjectBuilder
implements MavenProjectBuilder,
Initializable,
LogEnabled {
    protected MavenProfilesBuilder profilesBuilder;
    protected ArtifactResolver artifactResolver;
    protected ArtifactMetadataSource artifactMetadataSource;
    private ArtifactFactory artifactFactory;
    private ModelInheritanceAssembler modelInheritanceAssembler;
    private ModelValidator validator;
    private MavenXpp3Reader modelReader;
    private PathTranslator pathTranslator;
    private ModelDefaultsInjector modelDefaultsInjector;
    private ModelInterpolator modelInterpolator;
    private ModelLineageBuilder modelLineageBuilder;
    private ProfileAdvisor profileAdvisor;
    private MavenTools mavenTools;
    private ProjectWorkspace projectWorkspace;
    private Map processedProjectCache = new HashMap();
    public static final String MAVEN_MODEL_VERSION = "4.0.0";
    private Logger logger;
    private Model superModel;
    static /* synthetic */ Class class$0;

    public void initialize() {
        this.modelReader = new MavenXpp3Reader();
    }

    public MavenProject build(File projectDescriptor, ArtifactRepository localRepository, ProfileManager profileManager) throws ProjectBuildingException {
        ProjectBuilderConfiguration config = new DefaultProjectBuilderConfiguration().setLocalRepository(localRepository).setGlobalProfileManager(profileManager);
        return this.buildFromSourceFileInternal(projectDescriptor, config);
    }

    public MavenProject build(File projectDescriptor, ProjectBuilderConfiguration config) throws ProjectBuildingException {
        return this.buildFromSourceFileInternal(projectDescriptor, config);
    }

    public MavenProject buildFromRepository(Artifact artifact, List remoteArtifactRepositories, ArtifactRepository localRepository, boolean allowStub) throws ProjectBuildingException {
        return this.buildFromRepository(artifact, remoteArtifactRepositories, localRepository);
    }

    public MavenProject buildFromRepository(Artifact artifact, List remoteArtifactRepositories, ArtifactRepository localRepository) throws ProjectBuildingException {
        artifact.getId();
        MavenProject project = null;
        if (!"LATEST".equals(artifact.getVersion()) && !"RELEASE".equals(artifact.getVersion())) {
            project = this.projectWorkspace.getProject(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        }
        if (project == null) {
            Model model = this.findModelFromRepository(artifact, remoteArtifactRepositories, localRepository);
            ProjectBuilderConfiguration config = new DefaultProjectBuilderConfiguration().setLocalRepository(localRepository);
            project = this.buildInternal(model, config, remoteArtifactRepositories, artifact.getFile(), false, false, false);
        }
        return project;
    }

    public MavenProject buildStandaloneSuperProject() throws ProjectBuildingException {
        return this.buildStandaloneSuperProject(new DefaultProjectBuilderConfiguration());
    }

    public MavenProject buildStandaloneSuperProject(ProfileManager profileManager) throws ProjectBuildingException {
        return this.buildStandaloneSuperProject(new DefaultProjectBuilderConfiguration().setGlobalProfileManager(profileManager));
    }

    public MavenProject buildStandaloneSuperProject(ProjectBuilderConfiguration config) throws ProjectBuildingException {
        Model superModel = this.getSuperModel();
        superModel.setGroupId("org.apache.maven");
        superModel.setArtifactId("super-pom");
        superModel.setVersion("2.1");
        superModel = ModelUtils.cloneModel(superModel);
        ProfileManager profileManager = config.getGlobalProfileManager();
        ArrayList activeProfiles = new ArrayList();
        if (profileManager != null) {
            List activated = this.profileAdvisor.applyActivatedProfiles(superModel, null, false, profileManager.getProfileActivationContext());
            if (!activated.isEmpty()) {
                activeProfiles.addAll(activated);
            }
            if (!(activated = this.profileAdvisor.applyActivatedExternalProfiles(superModel, null, profileManager)).isEmpty()) {
                activeProfiles.addAll(activated);
            }
        }
        MavenProject project = new MavenProject(superModel);
        String projectId = this.safeVersionlessKey("org.apache.maven", "super-pom");
        project.setManagedVersionMap(this.createManagedVersionMap(projectId, superModel.getDependencyManagement(), null));
        this.getLogger().debug("Activated the following profiles for standalone super-pom: " + activeProfiles);
        project.setActiveProfiles(activeProfiles);
        try {
            this.processProjectLogic(project, null, config, null, true, true);
            project.setRemoteArtifactRepositories(this.mavenTools.buildArtifactRepositories(superModel.getRepositories()));
            project.setPluginArtifactRepositories(this.mavenTools.buildArtifactRepositories(superModel.getRepositories()));
        }
        catch (InvalidRepositoryException e) {
            throw new ProjectBuildingException("org.apache.maven:super-pom", "Maven super-POM contains an invalid repository!", e);
        }
        catch (ModelInterpolationException e) {
            throw new ProjectBuildingException("org.apache.maven:super-pom", "Maven super-POM contains an invalid expressions!", e);
        }
        project.setOriginalModel(superModel);
        project.setExecutionRoot(true);
        return project;
    }

    public MavenProject buildWithDependencies(File projectDescriptor, ArtifactRepository localRepository, ProfileManager profileManager) throws ProjectBuildingException {
        return this.buildProjectWithDependencies(projectDescriptor, localRepository, profileManager).getProject();
    }

    public MavenProjectBuildingResult buildProjectWithDependencies(File projectDescriptor, ArtifactRepository localRepository, ProfileManager profileManager) throws ProjectBuildingException {
        ProjectBuilderConfiguration config = new DefaultProjectBuilderConfiguration().setLocalRepository(localRepository).setGlobalProfileManager(profileManager);
        return this.buildProjectWithDependencies(projectDescriptor, config);
    }

    public MavenProjectBuildingResult buildProjectWithDependencies(File projectDescriptor, ProjectBuilderConfiguration config) throws ProjectBuildingException {
        MavenProject project = this.build(projectDescriptor, config);
        Artifact projectArtifact = project.getArtifact();
        String projectId = this.safeVersionlessKey(project.getGroupId(), project.getArtifactId());
        Map managedVersions = project.getManagedVersionMap();
        try {
            project.setDependencyArtifacts(project.createArtifacts(this.artifactFactory, null, null));
        }
        catch (InvalidDependencyVersionException e) {
            throw new ProjectBuildingException(projectId, "Unable to build project due to an invalid dependency version: " + e.getMessage(), projectDescriptor, e);
        }
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(projectArtifact).setArtifactDependencies(project.getDependencyArtifacts()).setLocalRepository(config.getLocalRepository()).setRemoteRepostories(project.getRemoteArtifactRepositories()).setManagedVersionMap(managedVersions).setMetadataSource(this.artifactMetadataSource);
        ArtifactResolutionResult result = this.artifactResolver.resolve(request);
        project.setArtifacts(result.getArtifacts());
        return new MavenProjectBuildingResult(project, result);
    }

    /*
     * WARNING - void declaration
     */
    private Map createManagedVersionMap(String string, DependencyManagement dependencyManagement, File file) throws ProjectBuildingException {
        String string2 = string;
        DependencyManagement dependencyManagement2 = dependencyManagement;
        File file2 = file;
        try {
            List deps;
            void dependencyManagement3;
            Map map = null;
            if (dependencyManagement3 != null && (deps = dependencyManagement3.getDependencies()) != null && deps.size() > 0) {
                void projectId;
                map = new ManagedVersionMap(map);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Adding managed dependencies for " + (String)projectId);
                }
                for (Dependency d : dependencyManagement3.getDependencies()) {
                    try {
                        VersionRange versionRange = VersionRange.createFromVersionSpec(d.getVersion());
                        Artifact artifact = this.artifactFactory.createDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope(), d.isOptional());
                        if (Artifact.SCOPE_SYSTEM.equals(d.getScope()) && d.getSystemPath() != null) {
                            artifact.setFile(new File(d.getSystemPath()));
                        }
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("  " + artifact);
                        }
                        if (d.getExclusions() != null && !d.getExclusions().isEmpty()) {
                            ArrayList<String> exclusions = new ArrayList<String>();
                            for (Exclusion e : d.getExclusions()) {
                                exclusions.add(String.valueOf(e.getGroupId()) + ":" + e.getArtifactId());
                            }
                            ExcludesArtifactFilter eaf = new ExcludesArtifactFilter(exclusions);
                            artifact.setDependencyFilter(eaf);
                        } else {
                            artifact.setDependencyFilter(null);
                        }
                        map.put(d.getManagementKey(), artifact);
                    }
                    catch (InvalidVersionSpecificationException e) {
                        void pomFile;
                        throw new InvalidDependencyVersionException((String)projectId, d, (File)pomFile, e);
                    }
                }
            } else if (map == null) {
                map = Collections.EMPTY_MAP;
            }
            return map;
        }
        catch (ProjectBuildingException projectBuildingException) {
            if (PBEDerivativeReporterAspect.ajc$cflowCounter$2.isValid()) {
                PBEDerivativeReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$9$8ca2645c(file2, projectBuildingException);
            }
            throw projectBuildingException;
        }
    }

    private MavenProject buildFromSourceFileInternal(File projectDescriptor, ProjectBuilderConfiguration config) throws ProjectBuildingException {
        MavenProject project = this.projectWorkspace.getProject(projectDescriptor);
        if (project == null) {
            Model model = this.readModel("unknown", projectDescriptor, true);
            project = this.buildInternal(model, config, this.buildArtifactRepositories(this.getSuperModel()), projectDescriptor, true, true, true);
        }
        return project;
    }

    private Model findModelFromRepository(Artifact artifact, List remoteArtifactRepositories, ArtifactRepository localRepository) throws ProjectBuildingException {
        Model model;
        Artifact projectArtifact;
        String projectId = this.safeVersionlessKey(artifact.getGroupId(), artifact.getArtifactId());
        remoteArtifactRepositories = this.normalizeToArtifactRepositories(remoteArtifactRepositories, projectId);
        if ("pom".equals(artifact.getType())) {
            projectArtifact = artifact;
        } else {
            this.getLogger().warn("Attempting to build MavenProject instance for Artifact (" + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ") of type: " + artifact.getType() + "; constructing POM artifact instead.");
            projectArtifact = this.artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getScope());
        }
        try {
            this.artifactResolver.resolve(projectArtifact, remoteArtifactRepositories, localRepository);
            File file = projectArtifact.getFile();
            model = this.readModel(projectId, file, true);
            String downloadUrl = null;
            ArtifactStatus status = ArtifactStatus.NONE;
            DistributionManagement distributionManagement = model.getDistributionManagement();
            if (distributionManagement != null) {
                downloadUrl = distributionManagement.getDownloadUrl();
                status = ArtifactStatus.valueOf(distributionManagement.getStatus());
            }
            this.checkStatusAndUpdate(projectArtifact, status, file, remoteArtifactRepositories, localRepository);
            if (downloadUrl != null) {
                projectArtifact.setDownloadUrl(downloadUrl);
            } else {
                projectArtifact.setDownloadUrl(model.getUrl());
            }
        }
        catch (ArtifactResolutionException e) {
            throw new ProjectBuildingException(projectId, "Error getting POM for '" + projectId + "' from the repository: " + e.getMessage(), e);
        }
        catch (ArtifactNotFoundException e) {
            throw new ProjectBuildingException(projectId, "POM '" + projectId + "' not found in repository: " + e.getMessage(), e);
        }
        return model;
    }

    private List normalizeToArtifactRepositories(List remoteArtifactRepositories, String projectId) throws ProjectBuildingException {
        ArrayList normalized = new ArrayList(remoteArtifactRepositories.size());
        boolean normalizationNeeded = false;
        for (Object item : remoteArtifactRepositories) {
            if (item instanceof ArtifactRepository) {
                normalized.add(item);
                continue;
            }
            if (item instanceof Repository) {
                Repository repo = (Repository)item;
                try {
                    item = this.mavenTools.buildArtifactRepository(repo);
                    normalized.add(item);
                    normalizationNeeded = true;
                    continue;
                }
                catch (InvalidRepositoryException e) {
                    throw new ProjectBuildingException(projectId, "Error building artifact repository for id: " + repo.getId(), e);
                }
            }
            throw new ProjectBuildingException(projectId, "Error building artifact repository from non-repository information item: " + item);
        }
        if (normalizationNeeded) {
            return normalized;
        }
        return remoteArtifactRepositories;
    }

    private void checkStatusAndUpdate(Artifact projectArtifact, ArtifactStatus status, File file, List remoteArtifactRepositories, ArtifactRepository localRepository) throws ArtifactNotFoundException {
        if (!projectArtifact.isSnapshot() && status.compareTo(ArtifactStatus.DEPLOYED) < 0) {
            ArtifactRepositoryPolicy policy = new ArtifactRepositoryPolicy();
            policy.setUpdatePolicy("never");
            if (policy.checkOutOfDate(new Date(file.lastModified()))) {
                this.getLogger().info(String.valueOf(projectArtifact.getArtifactId()) + ": updating metadata due to status of '" + status + "'");
                try {
                    projectArtifact.setResolved(false);
                    this.artifactResolver.resolveAlways(projectArtifact, remoteArtifactRepositories, localRepository);
                }
                catch (ArtifactResolutionException e) {
                    this.getLogger().warn("Error updating POM - using existing version");
                    this.getLogger().debug("Cause", e);
                }
                catch (ArtifactNotFoundException e) {
                    this.getLogger().warn("Error updating POM - not found. Removing local copy.");
                    this.getLogger().debug("Cause", e);
                    file.delete();
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private MavenProject buildInternal(Model model, ProjectBuilderConfiguration projectBuilderConfiguration, List list, File file, boolean bl, boolean bl2, boolean bl3) throws ProjectBuildingException {
        MavenProject mavenProject;
        PBEDerivativeReporterAspect.ajc$cflowCounter$2.inc();
        try {
            MavenProject mavenProject2;
            try {
                MavenProject mavenProject3;
                PBEDerivativeReporterAspect.ajc$cflowCounter$3.inc();
                try {
                    DependencyManagement dependencyManagement;
                    void fromSourceTree;
                    MavenProject project;
                    void strict;
                    void parentSearchRepositories;
                    void isReactorProject;
                    ProfileActivationContext profileActivationContext;
                    void projectDescriptor;
                    void config;
                    void model2;
                    Model superModel = this.getSuperModel();
                    MavenProject superProject = new MavenProject(superModel);
                    String projectId = this.safeVersionlessKey(model2.getGroupId(), model2.getArtifactId());
                    ProfileManager externalProfileManager = config.getGlobalProfileManager();
                    if (externalProfileManager != null) {
                        try {
                            externalProfileManager.getActiveProfiles();
                        }
                        catch (ProfileActivationException e) {
                            throw new ProjectBuildingException(projectId, "Failed to activate external profiles.", (File)projectDescriptor, e);
                        }
                        profileActivationContext = externalProfileManager.getProfileActivationContext();
                    } else {
                        profileActivationContext = new DefaultProfileActivationContext(config.getExecutionProperties(), false);
                    }
                    LinkedHashSet activeInSuperPom = new LinkedHashSet();
                    List activated = this.profileAdvisor.applyActivatedProfiles(superModel, (File)projectDescriptor, (boolean)isReactorProject, profileActivationContext);
                    if (!activated.isEmpty()) {
                        activeInSuperPom.addAll(activated);
                    }
                    if (!(activated = this.profileAdvisor.applyActivatedExternalProfiles(superModel, (File)projectDescriptor, externalProfileManager)).isEmpty()) {
                        activeInSuperPom.addAll(activated);
                    }
                    superProject.setActiveProfiles(activated);
                    LinkedList lineage = new LinkedList();
                    LinkedHashSet aggregatedRemoteWagonRepositories = this.collectInitialRepositories((Model)model2, superModel, (List)parentSearchRepositories, (File)projectDescriptor, (boolean)isReactorProject, profileActivationContext);
                    Model originalModel = ModelUtils.cloneModel((Model)model2);
                    try {
                        project = this.assembleLineage((Model)model2, lineage, (ProjectBuilderConfiguration)config, (File)projectDescriptor, aggregatedRemoteWagonRepositories, (boolean)strict, (boolean)isReactorProject);
                    }
                    catch (InvalidRepositoryException e) {
                        throw new ProjectBuildingException(projectId, e.getMessage(), e);
                    }
                    project.setOriginalModel(originalModel);
                    MavenProject previousProject = superProject;
                    Model previous = superProject.getModel();
                    for (MavenProject currentProject : lineage) {
                        Model current = currentProject.getModel();
                        String pathAdjustment = null;
                        try {
                            pathAdjustment = previousProject.getModulePathAdjustment(currentProject);
                        }
                        catch (IOException e) {
                            this.getLogger().debug("Cannot determine whether " + currentProject.getId() + " is a module of " + previousProject.getId() + ". Reason: " + e.getMessage(), e);
                        }
                        this.modelInheritanceAssembler.assembleModelInheritance(current, previous, pathAdjustment);
                        previous = current;
                        previousProject = currentProject;
                    }
                    ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>(aggregatedRemoteWagonRepositories);
                    List superRepositories = this.buildArtifactRepositories(superModel);
                    for (ArtifactRepository repository : superRepositories) {
                        if (repositories.contains(repository)) continue;
                        repositories.add(repository);
                    }
                    ModelUtils.mergeDuplicatePluginDefinitions(project.getModel().getBuild());
                    try {
                        project = this.processProjectLogic(project, (File)projectDescriptor, (ProjectBuilderConfiguration)config, repositories, (boolean)strict, false);
                    }
                    catch (ModelInterpolationException e) {
                        throw new InvalidProjectModelException(projectId, e.getMessage(), (File)projectDescriptor, e);
                    }
                    catch (InvalidRepositoryException e) {
                        throw new InvalidProjectModelException(projectId, e.getMessage(), (File)projectDescriptor, e);
                    }
                    if (fromSourceTree != false) {
                        Build build = project.getBuild();
                        project.addScriptSourceRoot(build.getScriptSourceDirectory());
                        this.getLogger().debug("Aligning project: " + project.getId() + " to base directory: " + projectDescriptor.getParentFile());
                        this.pathTranslator.alignToBaseDirectory(project.getModel(), projectDescriptor.getParentFile());
                        project.addCompileSourceRoot(build.getSourceDirectory());
                        project.addTestCompileSourceRoot(build.getTestSourceDirectory());
                        project.setFile((File)projectDescriptor);
                    }
                    this.projectWorkspace.storeProjectByCoordinate(project);
                    this.projectWorkspace.storeProjectByFile(project);
                    MavenProject mavenProject4 = project;
                    try {
                        dependencyManagement = mavenProject4.getDependencyManagement();
                    }
                    finally {
                        if (PBEDerivativeReporterAspect.ajc$cflowCounter$2.isValid() && !PBEDerivativeReporterAspect.ajc$cflowCounter$3.isValid()) {
                            PBEDerivativeReporterAspect.aspectOf().ajc$after$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$7$96d9e7ca(mavenProject4);
                        }
                    }
                    project.setManagedVersionMap(this.createManagedVersionMap(projectId, dependencyManagement, (File)projectDescriptor));
                    mavenProject3 = project;
                }
                finally {
                    PBEDerivativeReporterAspect.ajc$cflowCounter$3.dec();
                }
                mavenProject2 = mavenProject3;
            }
            finally {
                PBEDerivativeReporterAspect.aspectOf().ajc$after$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$8$50df3e15();
            }
            mavenProject = mavenProject2;
        }
        finally {
            PBEDerivativeReporterAspect.ajc$cflowCounter$2.dec();
        }
        return mavenProject;
    }

    private LinkedHashSet collectInitialRepositories(Model model, Model superModel, List parentSearchRepositories, File pomFile, boolean validProfilesXmlLocation, ProfileActivationContext profileActivationContext) throws ProjectBuildingException {
        LinkedHashSet collected = new LinkedHashSet();
        this.collectInitialRepositoriesFromModel(collected, model, pomFile, validProfilesXmlLocation, profileActivationContext);
        this.collectInitialRepositoriesFromModel(collected, superModel, null, validProfilesXmlLocation, profileActivationContext);
        if (parentSearchRepositories != null && !parentSearchRepositories.isEmpty()) {
            collected.addAll(parentSearchRepositories);
        }
        return collected;
    }

    private void collectInitialRepositoriesFromModel(LinkedHashSet collected, Model model, File pomFile, boolean validProfilesXmlLocation, ProfileActivationContext profileActivationContext) throws ProjectBuildingException {
        List modelRepos;
        LinkedHashSet reposFromProfiles = this.profileAdvisor.getArtifactRepositoriesFromActiveProfiles(model, pomFile, validProfilesXmlLocation, profileActivationContext);
        if (reposFromProfiles != null && !reposFromProfiles.isEmpty()) {
            collected.addAll(reposFromProfiles);
        }
        if ((modelRepos = model.getRepositories()) != null && !modelRepos.isEmpty()) {
            try {
                collected.addAll(this.mavenTools.buildArtifactRepositories(modelRepos));
            }
            catch (InvalidRepositoryException e) {
                throw new ProjectBuildingException(this.safeVersionlessKey(model.getGroupId(), model.getArtifactId()), "Failed to construct ArtifactRepository instances for repositories declared in: " + model.getId(), e);
            }
        }
    }

    private String safeVersionlessKey(String groupId, String artifactId) {
        String aid;
        String gid = groupId;
        if (StringUtils.isEmpty(gid)) {
            gid = "unknown";
        }
        if (StringUtils.isEmpty(aid = artifactId)) {
            aid = "unknown";
        }
        return ArtifactUtils.versionlessKey(gid, aid);
    }

    private List buildArtifactRepositories(Model model) throws ProjectBuildingException {
        try {
            return this.mavenTools.buildArtifactRepositories(model.getRepositories());
        }
        catch (InvalidRepositoryException e) {
            String projectId = this.safeVersionlessKey(model.getGroupId(), model.getArtifactId());
            throw new ProjectBuildingException(projectId, e.getMessage(), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private MavenProject processProjectLogic(MavenProject mavenProject, File file, ProjectBuilderConfiguration projectBuilderConfiguration, List list, boolean bl, boolean bl2) throws ProjectBuildingException, ModelInterpolationException, InvalidRepositoryException {
        MavenProject mavenProject2;
        MavenProject mavenProject3 = mavenProject;
        File file2 = file;
        ProjectBuilderConfiguration projectBuilderConfiguration2 = projectBuilderConfiguration;
        List list2 = list;
        boolean bl3 = bl;
        boolean bl4 = bl2;
        Object[] objectArray = new Object[]{mavenProject3, file2};
        PBEDerivativeReporterAspect.ajc$cflowStack$0.push(objectArray);
        try {
            try {
                Set set;
                Set set2;
                Set set3;
                void isSuperPom;
                void pomFile;
                void config;
                MavenProject project;
                Model model = project.getModel();
                List activeProfiles = project.getActiveProfiles();
                HashMap<Object, Object> context = new HashMap<Object, Object>();
                if (config.getExecutionProperties() != null && !config.getExecutionProperties().isEmpty()) {
                    context.putAll(config.getExecutionProperties());
                }
                File projectDir = null;
                if (pomFile != null) {
                    projectDir = pomFile.getAbsoluteFile().getParentFile();
                }
                HashMap<Object, Object> overrideContext = new HashMap<Object, Object>();
                if (isSuperPom == false && config.getUserProperties() != null && !config.getUserProperties().isEmpty()) {
                    overrideContext.putAll(config.getUserProperties());
                }
                model = this.modelInterpolator.interpolate(model, context, overrideContext, projectDir, true);
                if (isSuperPom == false) {
                    void remoteRepositories;
                    this.mergeManagedDependencies(model, config.getLocalRepository(), (List)remoteRepositories);
                }
                this.modelDefaultsInjector.injectDefaults(model);
                MavenProject parentProject = project.getParent();
                Model originalModel = project.getOriginalModel();
                Artifact parentArtifact = project.getParentArtifact();
                project = new MavenProject(model);
                project.setOriginalModel(originalModel);
                project.setActiveProfiles(activeProfiles);
                Artifact projectArtifact = this.artifactFactory.createBuildArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), project.getPackaging());
                project.setArtifact(projectArtifact);
                DistributionManagement dm = model.getDistributionManagement();
                if (dm != null) {
                    ArtifactRepository artifactRepository;
                    DeploymentRepository deploymentRepository = dm.getRepository();
                    try {
                        artifactRepository = this.mavenTools.buildDeploymentArtifactRepository(deploymentRepository);
                    }
                    catch (InvalidRepositoryException invalidRepositoryException) {
                        if (PBEDerivativeReporterAspect.ajc$cflowStack$0.isValid()) {
                            PBEDerivativeReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$1$c9ecf671((MavenProject)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(0), (File)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(1), deploymentRepository, invalidRepositoryException);
                        }
                        throw invalidRepositoryException;
                    }
                    ArtifactRepository repo = artifactRepository;
                    project.setReleaseArtifactRepository(repo);
                    if (dm.getSnapshotRepository() != null) {
                        ArtifactRepository artifactRepository2;
                        DeploymentRepository deploymentRepository2 = dm.getSnapshotRepository();
                        try {
                            artifactRepository2 = this.mavenTools.buildDeploymentArtifactRepository(deploymentRepository2);
                        }
                        catch (InvalidRepositoryException invalidRepositoryException) {
                            if (PBEDerivativeReporterAspect.ajc$cflowStack$0.isValid()) {
                                PBEDerivativeReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$1$c9ecf671((MavenProject)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(0), (File)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(1), deploymentRepository2, invalidRepositoryException);
                            }
                            throw invalidRepositoryException;
                        }
                        repo = artifactRepository2;
                        project.setSnapshotArtifactRepository(repo);
                    }
                }
                project.setParent(parentProject);
                if (parentProject != null) {
                    project.setParentArtifact(parentArtifact);
                }
                this.validateModel(model, (File)pomFile);
                try {
                    LinkedHashSet repoSet = new LinkedHashSet();
                    if (model.getRepositories() != null && !model.getRepositories().isEmpty()) {
                        repoSet.addAll(model.getRepositories());
                    }
                    if (model.getPluginRepositories() != null && !model.getPluginRepositories().isEmpty()) {
                        repoSet.addAll(model.getPluginRepositories());
                    }
                    project.setRemoteArtifactRepositories(this.mavenTools.buildArtifactRepositories(new ArrayList(repoSet)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String projectId = this.safeVersionlessKey(model.getGroupId(), model.getArtifactId());
                try {
                    set3 = this.createPluginArtifacts(projectId, project.getBuildPlugins(), (File)pomFile);
                }
                catch (ProjectBuildingException projectBuildingException) {
                    if (PBEDerivativeReporterAspect.ajc$cflowStack$0.isValid()) {
                        PBEDerivativeReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$5$75526fa3((MavenProject)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(0), (File)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(1), projectBuildingException);
                    }
                    throw projectBuildingException;
                }
                project.setPluginArtifacts(set3);
                try {
                    set2 = this.createReportArtifacts(projectId, project.getReportPlugins(), (File)pomFile);
                }
                catch (ProjectBuildingException projectBuildingException) {
                    if (PBEDerivativeReporterAspect.ajc$cflowStack$0.isValid()) {
                        PBEDerivativeReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$5$75526fa3((MavenProject)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(0), (File)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(1), projectBuildingException);
                    }
                    throw projectBuildingException;
                }
                project.setReportArtifacts(set2);
                try {
                    set = this.createExtensionArtifacts(projectId, project.getBuildExtensions(), (File)pomFile);
                }
                catch (ProjectBuildingException projectBuildingException) {
                    if (PBEDerivativeReporterAspect.ajc$cflowStack$0.isValid()) {
                        PBEDerivativeReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$5$75526fa3((MavenProject)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(0), (File)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(1), projectBuildingException);
                    }
                    throw projectBuildingException;
                }
                project.setExtensionArtifacts(set);
                mavenProject2 = project;
            }
            catch (ModelInterpolationException modelInterpolationException) {
                PBEDerivativeReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$4$d0ee7141(mavenProject3, file2, modelInterpolationException);
                throw modelInterpolationException;
            }
        }
        finally {
            PBEDerivativeReporterAspect.ajc$cflowStack$0.pop();
        }
        return mavenProject2;
    }

    private void validateModel(Model model, File pomFile) throws InvalidProjectModelException {
        try {
            ModelValidationResult validationResult = this.validator.validate(model);
            String projectId = this.safeVersionlessKey(model.getGroupId(), model.getArtifactId());
            if (validationResult.getMessageCount() > 0) {
                throw new InvalidProjectModelException(projectId, "Failed to validate POM", pomFile, validationResult);
            }
            return;
        }
        catch (InvalidProjectModelException invalidProjectModelException) {
            if (PBEDerivativeReporterAspect.ajc$cflowStack$0.isValid()) {
                PBEDerivativeReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$6$a894ddb((MavenProject)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(0), (File)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(1), invalidProjectModelException);
            }
            throw invalidProjectModelException;
        }
    }

    private MavenProject assembleLineage(Model model, LinkedList lineage, ProjectBuilderConfiguration config, File pomFile, Set aggregatedRemoteWagonRepositories, boolean strict, boolean isReactorProject) throws ProjectBuildingException, InvalidRepositoryException {
        DefaultModelLineage modelLineage = new DefaultModelLineage();
        modelLineage.setOrigin(model, pomFile, new ArrayList(aggregatedRemoteWagonRepositories), isReactorProject);
        this.modelLineageBuilder.resumeBuildingModelLineage(modelLineage, config, !strict, isReactorProject);
        ProfileManager externalProfileManager = config.getGlobalProfileManager();
        ProfileActivationContext profileActivationContext = externalProfileManager != null ? externalProfileManager.getProfileActivationContext() : new DefaultProfileActivationContext(config.getExecutionProperties(), false);
        MavenProject lastProject = null;
        ModelLineageIterator it = modelLineage.lineageIterator();
        while (it.hasNext()) {
            Model currentModel = (Model)it.next();
            File currentPom = it.getPOMFile();
            MavenProject project = new MavenProject(currentModel);
            project.setFile(currentPom);
            if (lastProject != null) {
                lastProject.setParent(project);
                project = lastProject.getParent();
                lastProject.setParentArtifact(this.artifactFactory.createParentArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion()));
            }
            project.setActiveProfiles(this.profileAdvisor.applyActivatedProfiles(project.getModel(), project.getFile(), isReactorProject, profileActivationContext));
            lineage.addFirst(project);
            lastProject = project;
        }
        MavenProject result = (MavenProject)lineage.getLast();
        if (externalProfileManager != null) {
            LinkedHashSet active = new LinkedHashSet();
            List existingActiveProfiles = result.getActiveProfiles();
            if (existingActiveProfiles != null && !existingActiveProfiles.isEmpty()) {
                active.addAll(existingActiveProfiles);
            }
            this.profileAdvisor.applyActivatedExternalProfiles(result.getModel(), pomFile, externalProfileManager);
        }
        return result;
    }

    private void mergeManagedDependencies(Model model, ArtifactRepository localRepository, List parentSearchRepositories) throws ProjectBuildingException {
        DependencyManagement modelDepMgmt = model.getDependencyManagement();
        if (modelDepMgmt != null) {
            TreeMap<String, Dependency> depsMap = new TreeMap<String, Dependency>();
            Iterator iter = modelDepMgmt.getDependencies().iterator();
            boolean doInclude = false;
            while (iter.hasNext()) {
                Dependency dep = (Dependency)iter.next();
                depsMap.put(dep.getManagementKey(), dep);
                if (!dep.getType().equals("pom") || !"import".equals(dep.getScope())) continue;
                doInclude = true;
            }
            TreeMap<String, Dependency> newDeps = new TreeMap<String, Dependency>((Map<String, Dependency>)depsMap);
            iter = modelDepMgmt.getDependencies().iterator();
            if (doInclude) {
                while (iter.hasNext()) {
                    DependencyManagement dependencyManagement;
                    MavenProject project;
                    Dependency dep = (Dependency)iter.next();
                    if (!dep.getType().equals("pom") || !"import".equals(dep.getScope())) continue;
                    Artifact artifact = this.artifactFactory.createProjectArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getScope());
                    MavenProject mavenProject = project = this.buildFromRepository(artifact, parentSearchRepositories, localRepository, false);
                    try {
                        dependencyManagement = mavenProject.getDependencyManagement();
                    }
                    finally {
                        if (PBEDerivativeReporterAspect.ajc$cflowCounter$2.isValid() && !PBEDerivativeReporterAspect.ajc$cflowCounter$3.isValid()) {
                            PBEDerivativeReporterAspect.aspectOf().ajc$after$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$7$96d9e7ca(mavenProject);
                        }
                    }
                    DependencyManagement depMgmt = dependencyManagement;
                    if (depMgmt == null) continue;
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Importing managed dependencies for " + dep.toString());
                    }
                    for (Dependency includedDep : depMgmt.getDependencies()) {
                        String key = includedDep.getManagementKey();
                        if (newDeps.containsKey(key)) continue;
                        newDeps.put(includedDep.getManagementKey(), includedDep);
                    }
                    newDeps.remove(dep.getManagementKey());
                }
                ArrayList deps = new ArrayList(newDeps.values());
                modelDepMgmt.setDependencies(deps);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private Model readModel(String var1_1, File var2_2, boolean var3_3) throws ProjectBuildingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkModelVersion(String modelSource, String projectId, File file) throws InvalidProjectModelException {
        if (modelSource.indexOf("<modelVersion>4.0.0") < 0) {
            throw new InvalidProjectModelException(projectId, "Not a v4.0.0 POM.", file);
        }
    }

    protected Set createPluginArtifacts(String projectId, List plugins, String pomLocation) throws ProjectBuildingException {
        Set set;
        try {
            set = this.createPluginArtifacts(projectId, plugins, new File(pomLocation));
        }
        catch (ProjectBuildingException projectBuildingException) {
            if (PBEDerivativeReporterAspect.ajc$cflowStack$0.isValid()) {
                PBEDerivativeReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$5$75526fa3((MavenProject)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(0), (File)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(1), projectBuildingException);
            }
            throw projectBuildingException;
        }
        return set;
    }

    protected Set createPluginArtifacts(String projectId, List plugins, File pomLocation) throws ProjectBuildingException {
        HashSet<Artifact> pluginArtifacts = new HashSet<Artifact>();
        for (Plugin p : plugins) {
            Artifact artifact;
            String version = StringUtils.isEmpty(p.getVersion()) ? "RELEASE" : p.getVersion();
            try {
                artifact = this.artifactFactory.createPluginArtifact(p.getGroupId(), p.getArtifactId(), VersionRange.createFromVersionSpec(version));
            }
            catch (InvalidVersionSpecificationException e) {
                throw new InvalidProjectVersionException(projectId, "Plugin: " + p.getKey(), version, pomLocation, e);
            }
            if (artifact == null) continue;
            pluginArtifacts.add(artifact);
        }
        return pluginArtifacts;
    }

    protected Set createReportArtifacts(String projectId, List reports, String pomLocation) throws ProjectBuildingException {
        Set set;
        try {
            set = this.createReportArtifacts(projectId, reports, new File(pomLocation));
        }
        catch (ProjectBuildingException projectBuildingException) {
            if (PBEDerivativeReporterAspect.ajc$cflowStack$0.isValid()) {
                PBEDerivativeReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$5$75526fa3((MavenProject)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(0), (File)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(1), projectBuildingException);
            }
            throw projectBuildingException;
        }
        return set;
    }

    protected Set createReportArtifacts(String projectId, List reports, File pomLocation) throws ProjectBuildingException {
        HashSet<Artifact> pluginArtifacts = new HashSet<Artifact>();
        if (reports != null) {
            for (ReportPlugin p : reports) {
                Artifact artifact;
                String version = StringUtils.isEmpty(p.getVersion()) ? "RELEASE" : p.getVersion();
                try {
                    artifact = this.artifactFactory.createPluginArtifact(p.getGroupId(), p.getArtifactId(), VersionRange.createFromVersionSpec(version));
                }
                catch (InvalidVersionSpecificationException e) {
                    throw new InvalidProjectVersionException(projectId, "Report plugin: " + p.getKey(), version, pomLocation, e);
                }
                if (artifact == null) continue;
                pluginArtifacts.add(artifact);
            }
        }
        return pluginArtifacts;
    }

    protected Set createExtensionArtifacts(String projectId, List extensions, String pomLocation) throws ProjectBuildingException {
        Set set;
        try {
            set = this.createExtensionArtifacts(projectId, extensions, new File(pomLocation));
        }
        catch (ProjectBuildingException projectBuildingException) {
            if (PBEDerivativeReporterAspect.ajc$cflowStack$0.isValid()) {
                PBEDerivativeReporterAspect.aspectOf().ajc$afterThrowing$org_apache_maven_project_aspect_PBEDerivativeReporterAspect$5$75526fa3((MavenProject)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(0), (File)PBEDerivativeReporterAspect.ajc$cflowStack$0.get(1), projectBuildingException);
            }
            throw projectBuildingException;
        }
        return set;
    }

    protected Set createExtensionArtifacts(String projectId, List extensions, File pomFile) throws ProjectBuildingException {
        HashSet<Artifact> extensionArtifacts = new HashSet<Artifact>();
        if (extensions != null) {
            for (Extension ext : extensions) {
                Artifact artifact;
                String version = StringUtils.isEmpty(ext.getVersion()) ? "RELEASE" : ext.getVersion();
                try {
                    VersionRange versionRange = VersionRange.createFromVersionSpec(version);
                    artifact = this.artifactFactory.createExtensionArtifact(ext.getGroupId(), ext.getArtifactId(), versionRange);
                }
                catch (InvalidVersionSpecificationException e) {
                    String key = ArtifactUtils.versionlessKey(ext.getGroupId(), ext.getArtifactId());
                    throw new InvalidProjectVersionException(projectId, "Extension: " + key, version, pomFile, e);
                }
                if (artifact == null) continue;
                extensionArtifacts.add(artifact);
            }
        }
        return extensionArtifacts;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Model getSuperModel() throws ProjectBuildingException {
        if (this.superModel != null) {
            return this.superModel;
        }
        URL url = DefaultMavenProjectBuilder.class.getResource("pom-4.0.0.xml");
        String projectId = this.safeVersionlessKey("org.apache.maven", "super-pom");
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader(url.openStream());
            String modelSource = IOUtil.toString(reader);
            this.checkModelVersion(modelSource, projectId, null);
            StringReader sReader = new StringReader(modelSource);
            Model model = this.modelReader.read(sReader, true);
            return model;
        }
        catch (XmlPullParserException e) {
            throw new InvalidProjectModelException(projectId, "Parse error reading POM. Reason: " + e.getMessage(), e);
            catch (IOException e2) {
                IOException iOException = e2;
                String string = "Failed build model from URL '" + url.toExternalForm() + "'\nError: '" + e2.getLocalizedMessage() + "'";
                String string2 = projectId;
                if (!ProjectIOErrorReporterAspect.ajc$cflowStack$0.isValid()) throw new ProjectBuildingException(string2, string, iOException);
                if (ProjectIOErrorReporterAspect.ajc$cflowCounter$1.isValid()) throw new ProjectBuildingException(string2, string, iOException);
                ProjectIOErrorReporterAspect.aspectOf().ajc$before$org_apache_maven_project_aspect_ProjectIOErrorReporterAspect$2$1878ea4d((String)ProjectIOErrorReporterAspect.ajc$cflowStack$0.get(0), (File)ProjectIOErrorReporterAspect.ajc$cflowStack$0.get(1), iOException);
                throw new ProjectBuildingException(string2, string, iOException);
            }
        }
        finally {
            IOUtil.close(reader);
        }
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }
}

