/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.container.initialization;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.discovery.ComponentDiscoverer;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentRepositoryException;
import org.codehaus.plexus.configuration.PlexusComponentDescriptorMerger;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.container.initialization.AbstractContainerInitializationPhase;
import org.codehaus.plexus.container.initialization.ContainerInitializationContext;
import org.codehaus.plexus.container.initialization.ContainerInitializationException;

public class ComponentDiscoveryPhase
extends AbstractContainerInitializationPhase {
    public void execute(ContainerInitializationContext context) throws ContainerInitializationException {
        try {
            ComponentDiscoveryPhase.discoverComponents(context.getContainer(), context.getContainer().getContainerRealm(), false);
        }
        catch (PlexusConfigurationException e) {
            throw new ContainerInitializationException("Error discovering components.", e);
        }
        catch (ComponentRepositoryException e) {
            throw new ContainerInitializationException("Error discovering components.", e);
        }
    }

    public static List discoverComponents(DefaultPlexusContainer container, ClassRealm realm) throws PlexusConfigurationException, ComponentRepositoryException {
        return ComponentDiscoveryPhase.discoverComponents(container, realm, false);
    }

    public static List discoverComponents(DefaultPlexusContainer container, ClassRealm realm, boolean override) throws PlexusConfigurationException, ComponentRepositoryException {
        ArrayList<ComponentDescriptor> discoveredComponentDescriptors = new ArrayList<ComponentDescriptor>();
        for (ComponentDiscoverer componentDiscoverer : container.getComponentDiscovererManager().getComponentDiscoverers()) {
            List componentSetDescriptors = componentDiscoverer.findComponents(container.getContext(), realm);
            for (ComponentSetDescriptor componentSet : componentSetDescriptors) {
                List componentDescriptors = componentSet.getComponents();
                if (componentDescriptors == null) continue;
                for (ComponentDescriptor componentDescriptor : componentDescriptors) {
                    componentDescriptor.setComponentSetDescriptor(componentSet);
                    ComponentDescriptor orig = container.getComponentDescriptor(componentDescriptor.getRole(), componentDescriptor.getRoleHint(), realm);
                    if (orig == null) {
                        componentDescriptor.setRealmId(realm.getId());
                        container.addComponentDescriptor(componentDescriptor);
                        discoveredComponentDescriptors.add(componentDescriptor);
                        continue;
                    }
                    if (!override) continue;
                    if (orig.getRealmId() != null && !orig.getRealmId().equals(componentDescriptor.getRealmId())) {
                        if (container.getLogger().isDebugEnabled()) {
                            container.getLogger().debug("Duplicate component found, merging:\n  Original: " + orig.getRealmId() + ": " + orig.getRole() + " [" + orig.getRoleHint() + "] impl=" + orig.getImplementation() + "\n  Config: " + orig.getConfiguration() + "\n  New:      " + componentDescriptor.getRealmId() + ": " + componentDescriptor.getRole() + " [" + orig.getRoleHint() + "] impl=" + componentDescriptor.getImplementation() + "\n  Config: " + orig.getConfiguration());
                        }
                        PlexusComponentDescriptorMerger.merge(componentDescriptor, orig);
                        continue;
                    }
                    if (orig.getRealmId() == null || !orig.getRealmId().equals(componentDescriptor.getRealmId()) || !container.getLogger().isDebugEnabled()) continue;
                    container.getLogger().debug("Duplicate component found, not replacing:\n  Original: " + orig.getRealmId() + ": " + orig.getRole() + " [" + orig.getRoleHint() + "] impl=" + orig.getImplementation() + "\n  Config: " + orig.getConfiguration() + "\n  New:      " + componentDescriptor.getRealmId() + ": " + componentDescriptor.getRole() + " [" + orig.getRoleHint() + "] impl=" + componentDescriptor.getImplementation() + "\n  Config: " + orig.getConfiguration());
                }
            }
        }
        return discoveredComponentDescriptors;
    }
}

