/*
 * Decompiled with CFR 0.152.
 */
package org.easymock;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import junit.framework.AssertionFailedError;
import org.easymock.ArgumentsMatcher;
import org.easymock.internal.AlwaysMatcher;
import org.easymock.internal.ArrayMatcher;
import org.easymock.internal.AssertionFailedErrorWrapper;
import org.easymock.internal.EqualsMatcher;
import org.easymock.internal.IBehavior;
import org.easymock.internal.IBehaviorFactory;
import org.easymock.internal.IMockControlState;
import org.easymock.internal.IProxyFactory;
import org.easymock.internal.JavaProxyFactory;
import org.easymock.internal.NiceBehavior;
import org.easymock.internal.ObjectMethodsFilter;
import org.easymock.internal.OrderedBehavior;
import org.easymock.internal.Range;
import org.easymock.internal.RecordState;
import org.easymock.internal.ReplayState;
import org.easymock.internal.RuntimeExceptionWrapper;
import org.easymock.internal.ThrowableWrapper;
import org.easymock.internal.UnorderedBehavior;

public class MockControl {
    private IMockControlState state;
    private Object mock;
    private IBehavior behavior;
    private IBehaviorFactory behaviorFactory;
    protected static final IBehaviorFactory NICE_BEHAVIOR_FACTORY = new IBehaviorFactory(){

        public IBehavior createBehavior() {
            return new NiceBehavior();
        }
    };
    protected static final IBehaviorFactory ORDERED_BEHAVIOR_FACTORY = new IBehaviorFactory(){

        public IBehavior createBehavior() {
            return new OrderedBehavior();
        }
    };
    protected static final IBehaviorFactory UNORDERED_BEHAVIOR_FACTORY = new IBehaviorFactory(){

        public IBehavior createBehavior() {
            return new UnorderedBehavior();
        }
    };
    private static final JavaProxyFactory PROXY_FACTORY = new JavaProxyFactory();
    public static final Range ONE = new Range(1);
    public static final Range ONE_OR_MORE = new Range(1, Integer.MAX_VALUE);
    public static final Range ZERO_OR_MORE = new Range(0, Integer.MAX_VALUE);
    public static final ArgumentsMatcher EQUALS_MATCHER = new EqualsMatcher();
    public static final ArgumentsMatcher ALWAYS_MATCHER = new AlwaysMatcher();
    public static final ArgumentsMatcher ARRAY_MATCHER = new ArrayMatcher();

    public static MockControl createControl(Class toMock) {
        return new MockControl(toMock, PROXY_FACTORY, UNORDERED_BEHAVIOR_FACTORY);
    }

    public static MockControl createStrictControl(Class toMock) {
        return new MockControl(toMock, PROXY_FACTORY, ORDERED_BEHAVIOR_FACTORY);
    }

    public static MockControl createNiceControl(Class toMock) {
        return new MockControl(toMock, PROXY_FACTORY, NICE_BEHAVIOR_FACTORY);
    }

    protected MockControl(Class toMock, IProxyFactory proxyFactory, IBehaviorFactory behaviorFactory) {
        this.mock = proxyFactory.createProxy(toMock, new ObjectMethodsFilter(this.createDelegator()));
        this.behaviorFactory = behaviorFactory;
        this.reset();
    }

    private InvocationHandler createDelegator() {
        return new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    return MockControl.this.state.invoke(proxy, method, args);
                }
                catch (RuntimeExceptionWrapper e) {
                    throw e.getRuntimeException().fillInStackTrace();
                }
                catch (AssertionFailedErrorWrapper e) {
                    throw e.getAssertionFailedError().fillInStackTrace();
                }
                catch (ThrowableWrapper t) {
                    throw t.getThrowable().fillInStackTrace();
                }
            }
        };
    }

    public Object getMock() {
        return this.mock;
    }

    public final void reset() {
        this.behavior = this.behaviorFactory.createBehavior();
        this.state = new RecordState(this.behavior);
    }

    public void replay() {
        try {
            this.state.replay();
            this.state = new ReplayState(this.behavior);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void verify() {
        try {
            this.state.verify();
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
        catch (AssertionFailedErrorWrapper e) {
            throw (AssertionFailedError)e.getAssertionFailedError().fillInStackTrace();
        }
    }

    public void setVoidCallable() {
        try {
            this.state.setVoidCallable(ONE);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setThrowable(Throwable throwable) {
        try {
            this.state.setThrowable(throwable, ONE);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setReturnValue(boolean value) {
        try {
            this.state.setReturnValue(value, ONE);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setReturnValue(long value) {
        try {
            this.state.setReturnValue(value, ONE);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setReturnValue(float value) {
        try {
            this.state.setReturnValue(value, ONE);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setReturnValue(double value) {
        try {
            this.state.setReturnValue(value, ONE);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setReturnValue(Object value) {
        try {
            this.state.setReturnValue(value, ONE);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setVoidCallable(int times) {
        try {
            this.state.setVoidCallable(new Range(times));
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setThrowable(Throwable throwable, int times) {
        try {
            this.state.setThrowable(throwable, new Range(times));
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setReturnValue(boolean value, int times) {
        try {
            this.state.setReturnValue(value, new Range(times));
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setReturnValue(double value, int times) {
        try {
            this.state.setReturnValue(value, new Range(times));
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setReturnValue(float value, int times) {
        try {
            this.state.setReturnValue(value, new Range(times));
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setReturnValue(long value, int times) {
        try {
            this.state.setReturnValue(value, new Range(times));
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setReturnValue(Object value, int times) {
        try {
            this.state.setReturnValue(value, new Range(times));
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setVoidCallable(Range range) {
        try {
            this.state.setVoidCallable(range);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setThrowable(Throwable throwable, Range range) {
        try {
            this.state.setThrowable(throwable, range);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setReturnValue(boolean value, Range range) {
        try {
            this.state.setReturnValue(value, range);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setReturnValue(double value, Range range) {
        try {
            this.state.setReturnValue(value, range);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setReturnValue(float value, Range range) {
        try {
            this.state.setReturnValue(value, range);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setReturnValue(long value, Range range) {
        try {
            this.state.setReturnValue(value, range);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setReturnValue(Object value, Range range) {
        try {
            this.state.setReturnValue(value, range);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setDefaultVoidCallable() {
        try {
            this.state.setDefaultVoidCallable();
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setDefaultThrowable(Throwable throwable) {
        try {
            this.state.setDefaultThrowable(throwable);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setDefaultReturnValue(boolean value) {
        try {
            this.state.setDefaultReturnValue(value);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setDefaultReturnValue(long value) {
        try {
            this.state.setDefaultReturnValue(value);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setDefaultReturnValue(float value) {
        try {
            this.state.setDefaultReturnValue(value);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setDefaultReturnValue(double value) {
        try {
            this.state.setDefaultReturnValue(value);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setDefaultReturnValue(Object value) {
        try {
            this.state.setDefaultReturnValue(value);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setMatcher(ArgumentsMatcher matcher) {
        try {
            this.state.setMatcher(matcher);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setVoidCallable(int minCount, int maxCount) {
        try {
            this.state.setVoidCallable(new Range(minCount, maxCount));
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setThrowable(Throwable throwable, int minCount, int maxCount) {
        try {
            this.state.setThrowable(throwable, new Range(minCount, maxCount));
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setReturnValue(boolean value, int minCount, int maxCount) {
        try {
            this.state.setReturnValue(value, new Range(minCount, maxCount));
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setReturnValue(long value, int minCount, int maxCount) {
        try {
            this.state.setReturnValue(value, new Range(minCount, maxCount));
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setReturnValue(float value, int minCount, int maxCount) {
        try {
            this.state.setReturnValue(value, new Range(minCount, maxCount));
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setReturnValue(double value, int minCount, int maxCount) {
        try {
            this.state.setReturnValue(value, new Range(minCount, maxCount));
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setReturnValue(Object value, int minCount, int maxCount) {
        try {
            this.state.setReturnValue(value, new Range(minCount, maxCount));
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void setDefaultMatcher(ArgumentsMatcher matcher) {
        try {
            this.state.setDefaultMatcher(matcher);
        }
        catch (RuntimeExceptionWrapper e) {
            throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
        }
    }

    public void expectAndReturn(boolean ignored, boolean value) {
        this.setReturnValue(value);
    }

    public void expectAndReturn(long ignored, long value) {
        this.setReturnValue(value);
    }

    public void expectAndReturn(float ignored, float value) {
        this.setReturnValue(value);
    }

    public void expectAndReturn(double ignored, double value) {
        this.setReturnValue(value);
    }

    public void expectAndReturn(Object ignored, Object value) {
        this.setReturnValue(value);
    }

    public void expectAndReturn(boolean ignored, boolean value, Range range) {
        this.setReturnValue(value, range);
    }

    public void expectAndReturn(long ignored, long value, Range range) {
        this.setReturnValue(value, range);
    }

    public void expectAndReturn(float ignored, float value, Range range) {
        this.setReturnValue(value, range);
    }

    public void expectAndReturn(double ignored, double value, Range range) {
        this.setReturnValue(value, range);
    }

    public void expectAndReturn(Object ignored, Object value, Range range) {
        this.setReturnValue(value, range);
    }

    public void expectAndReturn(boolean ignored, boolean value, int count) {
        this.setReturnValue(value, count);
    }

    public void expectAndReturn(long ignored, long value, int count) {
        this.setReturnValue(value, count);
    }

    public void expectAndReturn(float ignored, float value, int count) {
        this.setReturnValue(value, count);
    }

    public void expectAndReturn(double ignored, double value, int count) {
        this.setReturnValue(value, count);
    }

    public void expectAndReturn(Object ignored, Object value, int count) {
        this.setReturnValue(value, count);
    }

    public void expectAndReturn(boolean ignored, boolean value, int min, int max) {
        this.setReturnValue(value, min, max);
    }

    public void expectAndReturn(long ignored, long value, int min, int max) {
        this.setReturnValue(value, min, max);
    }

    public void expectAndReturn(float ignored, float value, int min, int max) {
        this.setReturnValue(value, min, max);
    }

    public void expectAndReturn(double ignored, double value, int min, int max) {
        this.setReturnValue(value, min, max);
    }

    public void expectAndReturn(Object ignored, Object value, int min, int max) {
        this.setReturnValue(value, min, max);
    }

    public void expectAndThrow(boolean ignored, Throwable throwable) {
        this.setThrowable(throwable);
    }

    public void expectAndThrow(long ignored, Throwable throwable) {
        this.setThrowable(throwable);
    }

    public void expectAndThrow(float ignored, Throwable throwable) {
        this.setThrowable(throwable);
    }

    public void expectAndThrow(double ignored, Throwable throwable) {
        this.setThrowable(throwable);
    }

    public void expectAndThrow(Object ignored, Throwable throwable) {
        this.setThrowable(throwable);
    }

    public void expectAndThrow(boolean ignored, Throwable throwable, Range range) {
        this.setThrowable(throwable, range);
    }

    public void expectAndThrow(long ignored, Throwable throwable, Range range) {
        this.setThrowable(throwable, range);
    }

    public void expectAndThrow(float ignored, Throwable throwable, Range range) {
        this.setThrowable(throwable, range);
    }

    public void expectAndThrow(double ignored, Throwable throwable, Range range) {
        this.setThrowable(throwable, range);
    }

    public void expectAndThrow(Object ignored, Throwable throwable, Range range) {
        this.setThrowable(throwable, range);
    }

    public void expectAndThrow(boolean ignored, Throwable throwable, int count) {
        this.setThrowable(throwable, count);
    }

    public void expectAndThrow(long ignored, Throwable throwable, int count) {
        this.setThrowable(throwable, count);
    }

    public void expectAndThrow(float ignored, Throwable throwable, int count) {
        this.setThrowable(throwable, count);
    }

    public void expectAndThrow(double ignored, Throwable throwable, int count) {
        this.setThrowable(throwable, count);
    }

    public void expectAndThrow(Object ignored, Throwable throwable, int count) {
        this.setThrowable(throwable, count);
    }

    public void expectAndThrow(boolean ignored, Throwable throwable, int min, int max) {
        this.setThrowable(throwable, min, max);
    }

    public void expectAndThrow(long ignored, Throwable throwable, int min, int max) {
        this.setThrowable(throwable, min, max);
    }

    public void expectAndThrow(float ignored, Throwable throwable, int min, int max) {
        this.setThrowable(throwable, min, max);
    }

    public void expectAndThrow(double ignored, Throwable throwable, int min, int max) {
        this.setThrowable(throwable, min, max);
    }

    public void expectAndThrow(Object ignored, Throwable throwable, int min, int max) {
        this.setThrowable(throwable, min, max);
    }

    public void expectAndDefaultReturn(boolean ignored, boolean value) {
        this.setDefaultReturnValue(value);
    }

    public void expectAndDefaultReturn(long ignored, long value) {
        this.setDefaultReturnValue(value);
    }

    public void expectAndDefaultReturn(float ignored, float value) {
        this.setDefaultReturnValue(value);
    }

    public void expectAndDefaultReturn(double ignored, double value) {
        this.setDefaultReturnValue(value);
    }

    public void expectAndDefaultReturn(Object ignored, Object value) {
        this.setDefaultReturnValue(value);
    }

    public void expectAndDefaultThrow(boolean ignored, Throwable throwable) {
        this.setDefaultThrowable(throwable);
    }

    public void expectAndDefaultThrow(long ignored, Throwable throwable) {
        this.setDefaultThrowable(throwable);
    }

    public void expectAndDefaultThrow(float ignored, Throwable throwable) {
        this.setDefaultThrowable(throwable);
    }

    public void expectAndDefaultThrow(double ignored, Throwable throwable) {
        this.setDefaultThrowable(throwable);
    }

    public void expectAndDefaultThrow(Object ignored, Throwable throwable) {
        this.setDefaultThrowable(throwable);
    }
}

