/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import javax.swing.JComponent;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.JellyVersion;
import org.netbeans.jellytools.actions.AttachWindowAction;
import org.netbeans.jellytools.actions.CloneViewAction;
import org.netbeans.jellytools.actions.CloseAllDocumentsAction;
import org.netbeans.jellytools.actions.CloseViewAction;
import org.netbeans.jellytools.actions.MaximizeWindowAction;
import org.netbeans.jellytools.actions.RestoreWindowAction;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.LightDriver;
import org.netbeans.jemmy.drivers.input.MouseRobotDriver;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.swing.tabcontrol.TabbedContainer;
import org.openide.cookies.SaveCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;

public class TopComponentOperator
extends JComponentOperator {
    private static final String closeWindowItem = Bundle.getStringTrimmed("org.netbeans.core.windows.actions.Bundle", "LBL_CloseWindowAction");
    private static final String closeAllDocumentsItem = Bundle.getStringTrimmed("org.netbeans.core.windows.actions.Bundle", "LBL_CloseAllDocumentsAction");

    public TopComponentOperator(ContainerOperator contOper, String topComponentName, int index) {
        super(TopComponentOperator.waitTopComponent(contOper, topComponentName, index, null));
        this.copyEnvironment((Operator)contOper);
        this.makeComponentVisible();
    }

    public TopComponentOperator(ContainerOperator contOper, String topComponentName) {
        this(contOper, topComponentName, 0);
    }

    public TopComponentOperator(ContainerOperator contOper, int index) {
        this(contOper, null, index);
    }

    public TopComponentOperator(ContainerOperator contOper) {
        this(contOper, null, 0);
    }

    public TopComponentOperator(String topComponentName, int index) {
        this(TopComponentOperator.waitTopComponent(topComponentName, index));
    }

    public TopComponentOperator(String topComponentName) {
        this(topComponentName, 0);
    }

    public TopComponentOperator(JComponent jComponent) {
        super(jComponent);
        this.makeComponentVisible();
    }

    public void makeComponentVisible() {
        super.makeComponentVisible();
        if (this.getSource() instanceof TopComponent) {
            this.runMapping(new Operator.MapVoidAction("requestActive"){

                public void map() {
                    ((TopComponent)TopComponentOperator.this.getSource()).requestActive();
                }
            });
        }
    }

    public void attachTo(String targetTopComponentName, String side) {
        new AttachWindowAction(targetTopComponentName, side).perform((ComponentOperator)this);
    }

    public void attachTo(TopComponentOperator targetTopComponentOperator, String side) {
        new AttachWindowAction(targetTopComponentOperator, side).perform((ComponentOperator)this);
    }

    public void maximize() {
        new MaximizeWindowAction().perform((ComponentOperator)this);
    }

    public void restore() {
        new RestoreWindowAction().perform((ComponentOperator)this);
    }

    public void cloneDocument() {
        new CloneViewAction().perform((ComponentOperator)this);
    }

    public void closeWindow() {
        if (this.isModified()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    TopComponentOperator.this.pushMenuOnTab(closeWindowItem);
                }
            }, "thread to close TopComponent").start();
        } else {
            new CloseViewAction().perform((ComponentOperator)this);
            this.waitComponentShowing(false);
        }
    }

    public void closeDiscard() {
        this.setUnmodified();
        this.close();
    }

    public void setUnmodified() {
        TopComponentOperator parentTco;
        Node[] nodes = ((TopComponent)this.getSource()).getActivatedNodes();
        if (nodes == null && (parentTco = this.findParentTopComponent()) != null) {
            parentTco.setUnmodified();
        }
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                DataObject dob = (DataObject)nodes[i].getCookie(DataObject.class);
                dob.setModified(false);
            }
        }
    }

    public boolean isModified() {
        TopComponentOperator parentTco;
        Node[] nodes = ((TopComponent)this.getSource()).getActivatedNodes();
        if (nodes == null && (parentTco = this.findParentTopComponent()) != null) {
            return parentTco.isModified();
        }
        boolean modified = false;
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                DataObject dob = (DataObject)nodes[i].getCookie(DataObject.class);
                if (dob == null) continue;
                modified = modified || dob.isModified();
            }
        }
        return modified;
    }

    public void save() {
        TopComponentOperator parentTco;
        Node[] nodes = ((TopComponent)this.getSource()).getActivatedNodes();
        if (nodes == null && (parentTco = this.findParentTopComponent()) != null) {
            parentTco.save();
        }
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                SaveCookie sc = (SaveCookie)nodes[i].getCookie(SaveCookie.class);
                if (sc == null) continue;
                try {
                    sc.save();
                    continue;
                }
                catch (IOException e) {
                    throw new JemmyException("Exception while saving this TopComponent.", (Throwable)e);
                }
            }
        }
    }

    public void close() {
        if (this.isModified()) {
            this.closeWindow();
        } else {
            if (this.isOpened()) {
                this.runMapping(new Operator.MapVoidAction("close"){

                    public void map() {
                        ((TopComponent)TopComponentOperator.this.getSource()).close();
                    }
                });
            } else {
                TopComponentOperator parent = this.findParentTopComponent();
                if (parent != null) {
                    parent.close();
                }
            }
            this.waitComponentShowing(false);
        }
    }

    public void closeAllDocuments() {
        DataObject[] modifs = DataObject.getRegistry().getModified();
        if (modifs.length != 0) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    TopComponentOperator.this.pushMenuOnTab(closeAllDocumentsItem);
                }
            }, "thread to closeAllDocuments").start();
        } else {
            new CloseAllDocumentsAction().perform((ComponentOperator)this);
            this.waitComponentShowing(false);
        }
    }

    public void saveDocument() {
        String saveItem = Bundle.getStringTrimmed("org.netbeans.core.windows.actions.Bundle", "LBL_SaveDocumentAction");
        this.pushMenuOnTab(saveItem);
    }

    public static JComponent findTopComponent(String name, int index) {
        return TopComponentOperator.findTopComponent(null, name, index, null);
    }

    protected static JComponent findTopComponent(final ContainerOperator cont, final String name, final int index, final ComponentChooser subchooser) {
        return (JComponent)new QueueTool().invokeSmoothly(new QueueTool.QueueAction("findTopComponent"){

            public Object launch() {
                JComponent result;
                TopComponent c;
                int i;
                int counter = index;
                Object[] tc = TopComponent.getRegistry().getOpened().toArray();
                Operator.StringComparator comparator = cont == null ? Operator.getDefaultStringComparator() : cont.getComparator();
                for (i = 0; i < tc.length; ++i) {
                    c = (TopComponent)tc[i];
                    if (!c.isShowing() || !comparator.equals(c.getName(), name) && !comparator.equals(c.getDisplayName(), name) || !TopComponentOperator.isUnder(cont, (Component)c) || (result = TopComponentOperator.checkSubchooser(c, subchooser)) == null || --counter >= 0) continue;
                    return result;
                }
                for (i = 0; i < tc.length; ++i) {
                    c = (TopComponent)tc[i];
                    if (c.isShowing() || !TopComponentOperator.isParentShowing((Component)c) || !comparator.equals(c.getName(), name) && !comparator.equals(c.getDisplayName(), name) || !TopComponentOperator.isUnder(cont, (Component)c) || (result = TopComponentOperator.checkSubchooser(c, subchooser)) == null || --counter >= 0) continue;
                    return result;
                }
                return null;
            }
        });
    }

    private static JComponent checkSubchooser(TopComponent c, ComponentChooser subchooser) {
        if (subchooser == null) {
            return c;
        }
        boolean isMultiView = false;
        try {
            isMultiView = TopComponentOperator.isMultyView(c);
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (isMultiView) {
            TopComponentOperator tco = new TopComponentOperator((JComponent)c);
            tco.setOutput(TestOut.getNullOutput());
            return (JComponent)tco.findSubComponent(subchooser);
        }
        if (subchooser.checkComponent((Component)c)) {
            return c;
        }
        return null;
    }

    private static boolean isMultyView(TopComponent c) {
        Class<?> clz = c.getClass();
        do {
            if (!clz.getName().equals("org.netbeans.core.multiview.MultiViewCloneableTopComponent")) continue;
            return true;
        } while ((clz = clz.getSuperclass()) != null);
        return false;
    }

    private static boolean isParentShowing(Component c) {
        while (c != null) {
            if (c.isShowing()) {
                return true;
            }
            c = c.getParent();
        }
        return false;
    }

    private static boolean isUnder(ContainerOperator cont, Component c) {
        if (cont == null) {
            return true;
        }
        Component comp = cont.getSource();
        while (comp != c && c != null) {
            c = c.getParent();
        }
        return comp == c;
    }

    protected static JComponent waitTopComponent(String name, int index) {
        return TopComponentOperator.waitTopComponent(null, name, index, null);
    }

    protected static JComponent waitTopComponent(final ContainerOperator cont, final String name, final int index, final ComponentChooser subchooser) {
        try {
            Waiter waiter = new Waiter(new Waitable(){

                public Object actionProduced(Object obj) {
                    return TopComponentOperator.findTopComponent(cont, name, index, subchooser);
                }

                public String getDescription() {
                    return "Wait TopComponent with name=" + name + " index=" + String.valueOf(index) + (subchooser == null ? "" : " subchooser=" + subchooser.getDescription()) + " loaded";
                }
            });
            Timeouts times = JemmyProperties.getCurrentTimeouts().cloneThis();
            times.setTimeout("Waiter.WaitingTime", times.getTimeout("ComponentOperator.WaitComponentTimeout"));
            waiter.setTimeouts(times);
            waiter.setOutput(JemmyProperties.getCurrentOutput());
            return (JComponent)waiter.waitAction(null);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public void pushMenuOnTab(String popupPath) {
        if (this.isOpened()) {
            this.makeComponentVisible();
            TabbedContainer ta = this.findTabbedAdapter();
            int index = ta.indexOf((Component)((TopComponent)this.getSource()));
            Rectangle r = new Rectangle();
            ta.getTabRect(index, r);
            Point p = new Point(r.x + r.width / 2, r.y + r.height / 2);
            Component tabsComp = ta.getComponentAt(p);
            new JPopupMenuOperator(JPopupMenuOperator.callPopup((Component)tabsComp, (int)p.x, (int)p.y)).pushMenu(popupPath);
        } else {
            TopComponentOperator parent = this.findParentTopComponent();
            if (parent != null) {
                parent.pushMenuOnTab(popupPath);
            }
        }
    }

    public TabbedContainer findTabbedAdapter() {
        for (Container parent = this.getSource().getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof TabbedContainer)) continue;
            return (TabbedContainer)parent;
        }
        return null;
    }

    public Container findTabDisplayer() {
        return ContainerOperator.findContainer((Container)this.findTabbedAdapter(), (ComponentChooser)new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return comp.getClass().getName().endsWith("TabDisplayer");
            }

            public String getDescription() {
                return "org.netbeans.swing.tabcontrol.TabDisplayer";
            }
        });
    }

    public void waitClosed() {
        this.getOutput().printLine("Wait topcomponent to be closed \n    : " + this.getSource().toString());
        this.getOutput().printGolden("Wait topcomponent to be closed");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return !comp.isVisible();
            }

            public String getDescription() {
                return "Closed topcomponent";
            }
        });
    }

    protected boolean isOpened() {
        return this.runMapping(new Operator.MapBooleanAction("isOpened"){

            public boolean map() {
                return ((TopComponent)TopComponentOperator.this.getSource()).isOpened();
            }
        });
    }

    protected TopComponentOperator findParentTopComponent() {
        for (Container parent = this.getSource().getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof TopComponent)) continue;
            return new TopComponentOperator((JComponent)parent);
        }
        return null;
    }

    static {
        JellyVersion.checkJemmyVersion();
        JemmyProperties.getCurrentTimeouts();
        Timeouts.initDefault((String)"EventDispatcher.RobotAutoDelay", (long)0L);
        DriverManager.setDriver((String)"drivers.mouse", (LightDriver)new MouseRobotDriver(JemmyProperties.getCurrentTimeouts().create("EventDispatcher.RobotAutoDelay"), new String[]{TopComponentOperator.class.getName()}));
    }
}

