/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.annotationsupport;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JEditorPane;
import org.netbeans.modules.dlight.annotationsupport.LineAnnotationInfo;

public class FileAnnotationInfo {
    private JEditorPane editorPane;
    private String filePath;
    private String tooltip = null;
    private final List<LineAnnotationInfo> lineAnnotationsInfo = new ArrayList<LineAnnotationInfo>();
    private final List<LineAnnotationInfo> blockAnnotationsInfo = new ArrayList<LineAnnotationInfo>();
    private boolean annotated = false;
    private String[] columnNames;
    private int[] maxColumnWidth;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAnnotationLength() {
        List<LineAnnotationInfo> list = this.lineAnnotationsInfo;
        synchronized (list) {
            if (this.lineAnnotationsInfo.size() > 0) {
                return this.lineAnnotationsInfo.get(0).getAnnotation().length();
            }
        }
        list = this.blockAnnotationsInfo;
        synchronized (list) {
            if (this.blockAnnotationsInfo.size() > 0) {
                return this.blockAnnotationsInfo.get(0).getAnnotation().length();
            }
        }
        return 0;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LineAnnotationInfo> getLineAnnotationInfo() {
        List<LineAnnotationInfo> list = this.lineAnnotationsInfo;
        synchronized (list) {
            return new ArrayList<LineAnnotationInfo>(this.lineAnnotationsInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLineAnnotationInfo(LineAnnotationInfo lineAnnotationInfo) {
        List<LineAnnotationInfo> list = this.lineAnnotationsInfo;
        synchronized (list) {
            this.lineAnnotationsInfo.add(lineAnnotationInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineAnnotationInfo getLineAnnotationInfoByLineOffset(int offset) {
        List<LineAnnotationInfo> list = this.lineAnnotationsInfo;
        synchronized (list) {
            for (LineAnnotationInfo lineInfo : this.lineAnnotationsInfo) {
                if (lineInfo.getPosition() == null || lineInfo.getPosition().getOffset() != offset) continue;
                return lineInfo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineAnnotationInfo getBlockAnnotationInfoByLineOffset(int offset) {
        List<LineAnnotationInfo> list = this.blockAnnotationsInfo;
        synchronized (list) {
            for (LineAnnotationInfo lineInfo : this.blockAnnotationsInfo) {
                if (lineInfo.getPosition() == null || lineInfo.getPosition().getOffset() != offset) continue;
                return lineInfo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineAnnotationInfo getLineAnnotationInfoByYCoordinate(int y) {
        List<LineAnnotationInfo> list = this.lineAnnotationsInfo;
        synchronized (list) {
            for (LineAnnotationInfo lineInfo : this.lineAnnotationsInfo) {
                if (lineInfo.getPosition() == null || lineInfo.getY1() > y || y > lineInfo.getY2()) continue;
                return lineInfo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineAnnotationInfo getBlockAnnotationInfoByYCoordinate(int y) {
        List<LineAnnotationInfo> list = this.blockAnnotationsInfo;
        synchronized (list) {
            for (LineAnnotationInfo lineInfo : this.blockAnnotationsInfo) {
                if (lineInfo.getPosition() == null || lineInfo.getY1() > y || y > lineInfo.getY2()) continue;
                return lineInfo;
            }
        }
        return null;
    }

    public boolean isAnnotated() {
        return this.annotated;
    }

    public void setAnnotated(boolean annotated) {
        this.annotated = annotated;
    }

    public synchronized String getTooltip() {
        if (this.tooltip == null) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            sb.append("<html><body>");
            for (String col : this.getColumnNames()) {
                if (first) {
                    first = false;
                } else {
                    sb.append("<br>");
                }
                sb.append(col);
            }
            sb.append("</body></html>");
            this.tooltip = sb.toString();
        }
        return this.tooltip;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Line Annotations:\n");
        for (LineAnnotationInfo line : this.getLineAnnotationInfo()) {
            buf.append('\t').append(line.toString()).append('\n');
        }
        buf.append("Block Annotations:\n");
        for (LineAnnotationInfo line : this.getBlockAnnotationInfo()) {
            buf.append('\t').append(line.toString()).append('\n');
        }
        return buf.toString();
    }

    public JEditorPane getEditorPane() {
        return this.editorPane;
    }

    public void setEditorPane(JEditorPane editorPane) {
        this.editorPane = editorPane;
    }

    public int[] getMaxColumnWidth() {
        return this.maxColumnWidth;
    }

    public void setMaxColumnWidth(int[] maxColumnWidth) {
        this.maxColumnWidth = maxColumnWidth;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LineAnnotationInfo> getBlockAnnotationInfo() {
        List<LineAnnotationInfo> list = this.blockAnnotationsInfo;
        synchronized (list) {
            return new ArrayList<LineAnnotationInfo>(this.blockAnnotationsInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBlockAnnotationInfo(LineAnnotationInfo lineAnnotationInfo) {
        List<LineAnnotationInfo> list = this.blockAnnotationsInfo;
        synchronized (list) {
            this.blockAnnotationsInfo.add(lineAnnotationInfo);
        }
    }
}

