/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.ProfilingEventListener;
import org.netbeans.lib.profiler.client.AppStatusHandler;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.client.ProfilingPointsProcessor;
import org.netbeans.lib.profiler.global.CalibrationDataFileIO;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.EventBufferProcessor;
import org.netbeans.lib.profiler.results.cpu.CPUCCTContainer;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.lib.profiler.wireprotocol.AsyncMessageCommand;
import org.netbeans.lib.profiler.wireprotocol.Command;
import org.netbeans.lib.profiler.wireprotocol.InternalStatsResponse;

public class TargetAppRunner
implements CommonConstants {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.Bundle");
    private static final String CLASSPATH_SETTINGS_IGNORED_MSG = messages.getString("TargetAppRunner_ClasspathSettingsIgnoredMsg");
    private static final String ERROR_STARTING_JVM_MSG = messages.getString("TargetAppRunner_ErrorStartingJvmMsg");
    private static final String CALIBRATION_SUMMARY_SHORT_MSG = messages.getString("TargetAppRunner_CalibrationSummaryShortMsg");
    private static final String CALIBRATION_SUMMARY_DETAILS_MSG = messages.getString("TargetAppRunner_CalibrationSummaryDetailsMsg");
    private static final String FAILED_ESTABLISH_CONN_MSG = messages.getString("TargetAppRunner_FailedEstablishConnMsg");
    private static final String UNEXPECTED_PROBLEM_STARTING_APP_MSG = messages.getString("TargetAppRunner_UnexpectedProblemStartingAppMsg");
    private static final String JVM_TERMINATED_NOTRESPOND_STRING = messages.getString("TargetAppRunner_JvmTerminatedNotRespondString");
    private static final String INTERNAL_PROBLEM_STRING = messages.getString("TargetAppRunner_InternalProblemString");
    private static final String FAILED_START_APP_CAUSE_MSG = messages.getString("TargetAppRunner_FailedStartAppCauseMsg");
    private static final String CALIBRATION_RESULTS_MSG = messages.getString("TargetAppRunner_CalibrationResultsMsg");
    private static final String CALIBRATION_ERROR_MSG = messages.getString("TargetAppRunner_CalibrationErrorMsg");
    private static final String INTERNAL_STATISTICS_ONLY_MSG = messages.getString("TargetAppRunner_InternalStatisticsOnlyMsg");
    private static final String INSTR_METHODS_COUNT_MSG = messages.getString("TargetAppRunner_InstrMethodsCountMsg");
    private static final String CLASSLOAD_FIRSTINV_COUNT_MSG = messages.getString("TargetAppRunner_ClassLoadFirstInvCountMsg");
    private static final String NON_EMPTY_IMG_COUNT_MSG = messages.getString("TargetAppRunner_NonEmptyImgCountMsg");
    private static final String EMPTY_IMG_COUNT_MSG = messages.getString("TargetAppRunner_EmptyImgCountMsg");
    private static final String SINGLE_IMG_COUNT_MSG = messages.getString("TargetAppRunner_SingleImgCountMsg");
    private static final String AVG_METHOD_TIME_MSG = messages.getString("TargetAppRunner_AvgMethodTimeMsg");
    private static final String MIN_METHOD_TIME_MSG = messages.getString("TargetAppRunner_MinMethodTimeMsg");
    private static final String MAX_METHOD_TIME_MSG = messages.getString("TargetAppRunner_MaxMethodTimeMsg");
    private static final String TOTAL_RUN_TIME_MSG = messages.getString("TargetAppRunner_TotalRunTimeMsg");
    private static final String INJ_INSTR_TIME_MSG = messages.getString("TargetAppRunner_InjInstrTimeMsg");
    private static final String TOTAL_INSTR_HOTSWAP_TIME_MSG = messages.getString("TargetAppRunner_TotalInstrHotSwapTimeMsg");
    private static final String BYTECODE_COMM_TIME_MSG = messages.getString("TargetAppRunner_ByteCodeCommTimeMsg");
    private static final String CLIENT_BYTECODE_TIME_MSG = messages.getString("TargetAppRunner_ClientByteCodeTimeMsg");
    private static final String CLIENT_DISK_PROCESS_MSG = messages.getString("TargetAppRunner_ClientDiskProcessTimeMsg");
    private static final String CLIENT_RESULTS_PROCESS_MSG = messages.getString("TargetAppRunner_ClientResultsProcessTimeMsg");
    private static final String PERFORMING_CALIBRATION_MSG = messages.getString("TargetAppRunner_PerformingCalibrationMsg");
    private static final boolean DEBUG = System.getProperty("org.netbeans.lib.profiler.TargetAppRunner") != null;
    private static TargetAppRunner defaultTAR;
    private static final int EVENT_STARTED = 0;
    private static final int EVENT_STOPPED = 1;
    private static final int EVENT_SUSPENDED = 2;
    private static final int EVENT_RESUMED = 3;
    private static final int EVENT_ATTACHED = 4;
    private static final int EVENT_TERMINATED = 5;
    private static final int EVENT_DETACHED = 6;
    private AppStatusHandler.AsyncDialog waitDialog;
    private AppStatusHandler appStatusHandler;
    private Process runningAppProcess;
    private ProfilerClient profilerClient;
    private ProfilerEngineSettings settings;
    private ProfilingPointsProcessor profilingPointProcessor;
    private ProfilingSessionStatus status;
    private Vector listeners = new Vector();
    private boolean targetAppIsSuspended;

    public TargetAppRunner(ProfilerEngineSettings settings, AppStatusHandler ash, ProfilingPointsProcessor ppp) {
        this.settings = settings;
        this.status = new ProfilingSessionStatus();
        this.appStatusHandler = ash;
        this.profilingPointProcessor = ppp;
        this.profilerClient = new ProfilerClient(settings, this.status, this.appStatusHandler, new AppStatusHandler.ServerCommandHandler(){

            @Override
            public void handleServerCommand(Command cmd) {
                if (cmd != null) {
                    if (cmd.getType() == 14) {
                        AsyncMessageCommand msg = (AsyncMessageCommand)cmd;
                        if (msg.isPositive()) {
                            TargetAppRunner.this.appStatusHandler.displayNotification(msg.getMessage());
                        } else {
                            TargetAppRunner.this.appStatusHandler.displayError(msg.getMessage());
                        }
                    } else if (cmd.getType() == 38) {
                        TargetAppRunner.this.appStatusHandler.resultsAvailable();
                    } else if (cmd.getType() == 39) {
                        TargetAppRunner.this.appStatusHandler.takeSnapshot();
                    }
                }
            }
        });
        defaultTAR = this;
    }

    public static TargetAppRunner getDefault() {
        return defaultTAR;
    }

    public AppStatusHandler getAppStatusHandler() {
        return this.appStatusHandler;
    }

    public String getInternalStats() throws ClientUtils.TargetAppOrVMTerminated {
        InternalStatsResponse stats = this.status.savedInternalStats != null ? this.status.savedInternalStats : this.profilerClient.getInternalStats();
        return this.getInternalStatsText(stats);
    }

    public ProfilerClient getProfilerClient() {
        return this.profilerClient;
    }

    public ProfilerEngineSettings getProfilerEngineSettings() {
        return this.settings;
    }

    public ProfilingPointsProcessor getProfilingPointsProcessor() {
        return this.profilingPointProcessor;
    }

    public ProfilingSessionStatus getProfilingSessionStatus() {
        return this.status;
    }

    public Process getRunningAppProcess() {
        return this.runningAppProcess;
    }

    public void addProfilingEventListener(ProfilingEventListener profilingEventListener) {
        this.listeners.add(profilingEventListener);
    }

    public boolean attachToTargetJVM(File tvmDir) throws IOException {
        if (this.connectToStartedVMAndStartTA(1, false)) {
            this.status.runningInAttachedMode = true;
            this.notifyListeners(4);
            return true;
        }
        return false;
    }

    public boolean attachToTargetVM() {
        if (this.connectToStartedVMAndStartTA(1, false)) {
            this.status.runningInAttachedMode = true;
            this.notifyListeners(4);
            return true;
        }
        return false;
    }

    public boolean attachToTargetVMOnStartup() {
        if (this.connectToStartedVMAndStartTA(2, false)) {
            this.status.runningInAttachedMode = true;
            this.notifyListeners(4);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean calibrateInstrumentationCode() {
        this.status.targetJDKVersionString = this.settings.getTargetJDKVersionString();
        this.waitDialog = this.appStatusHandler.getAsyncDialogInstance(PERFORMING_CALIBRATION_MSG, false, false);
        this.waitDialog.display();
        boolean res = false;
        try {
            if (!this.runJVMToCalibrateInstrumentation()) {
                boolean bl = false;
                return bl;
            }
            res = CalibrationDataFileIO.saveCalibrationData(this.status);
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.waitDialog != null) {
                this.waitDialog.close();
            }
            if (res) {
                StringBuffer s = new StringBuffer();
                s.append(CALIBRATION_SUMMARY_DETAILS_MSG);
                this.appendCalibrationData(s);
                this.appStatusHandler.displayNotificationWithDetailsAndWaitForConfirm(CALIBRATION_SUMMARY_SHORT_MSG, s.toString());
            } else {
                this.appStatusHandler.displayErrorAndWaitForConfirm(CalibrationDataFileIO.getErrorMessage());
            }
        }
    }

    public boolean connectToStartedVMAndStartTA() {
        return this.connectToStartedVMAndStartTA(false);
    }

    public void detachFromTargetJVM() {
        if (this.targetAppIsSuspended) {
            try {
                this.profilerClient.resumeTargetAppThreads();
            }
            catch (ClientUtils.TargetAppOrVMTerminated ex) {
                // empty catch block
            }
            this.targetAppIsSuspended = false;
        }
        try {
            this.profilerClient.detachFromTargetJVM();
            this.notifyListeners(6);
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            // empty catch block
        }
        this.targetAppIsSuspended = false;
    }

    public boolean hasSupportedJDKForHeapDump() {
        String fullJDKString;
        int minorVersion;
        String jdkVersion = this.getProfilerEngineSettings().getTargetJDKVersionString();
        if ("jdk16".equals(jdkVersion) || "jdk17".equals(jdkVersion)) {
            return true;
        }
        return "jdk15".equals(jdkVersion) && (minorVersion = Platform.getJDKMinorNumber(fullJDKString = this.getProfilingSessionStatus().fullTargetJDKVersionString)) >= 12;
    }

    public boolean initiateSession(int attachMode, boolean calibrationOnlyRun) {
        if (this.targetJVMIsAlive()) {
            return true;
        }
        return this.profilerClient.establishConnectionWithServer(attachMode, calibrationOnlyRun);
    }

    public boolean readSavedCalibrationData() {
        this.status.targetJDKVersionString = this.settings.getTargetJDKVersionString();
        int res = CalibrationDataFileIO.readSavedCalibrationData(this.status);
        if (res < 0) {
            this.appStatusHandler.displayErrorAndWaitForConfirm(CalibrationDataFileIO.getErrorMessage());
        }
        return res == 0;
    }

    public void removeProfilingEventListener(ProfilingEventListener profilingEventListener) {
        this.listeners.remove(profilingEventListener);
    }

    public void resetTimers() throws ClientUtils.TargetAppOrVMTerminated {
        this.profilerClient.resetProfilerCollectors();
    }

    public void resumeTargetAppIfSuspended() throws ClientUtils.TargetAppOrVMTerminated {
        if (this.targetAppIsSuspended) {
            this.profilerClient.resumeTargetAppThreads();
            this.targetAppIsSuspended = false;
            this.notifyListeners(3);
        }
    }

    public void runGC() throws ClientUtils.TargetAppOrVMTerminated {
        this.profilerClient.runGC();
    }

    public boolean startTargetVM() {
        return this.startTargetVM(this.settings.getJVMArgs(), this.settings.getMainClassName(), this.settings.getMainArgs(), this.settings.getWorkingDir(), this.settings.getSeparateConsole());
    }

    public void suspendTargetAppIfRunning() throws ClientUtils.TargetAppOrVMTerminated {
        if (!this.targetAppIsSuspended) {
            this.profilerClient.suspendTargetAppThreads();
            this.targetAppIsSuspended = true;
            this.notifyListeners(2);
        }
    }

    public boolean targetAppIsRunning() {
        return this.status.targetAppRunning;
    }

    public boolean targetAppSuspended() {
        return this.targetAppIsSuspended;
    }

    public boolean targetJVMIsAlive() {
        return this.profilerClient.targetJVMIsAlive();
    }

    public void terminateTargetJVM() {
        if (this.targetAppIsSuspended) {
            try {
                this.profilerClient.resumeTargetAppThreads();
            }
            catch (ClientUtils.TargetAppOrVMTerminated ex) {
                // empty catch block
            }
            this.targetAppIsSuspended = false;
        }
        try {
            this.profilerClient.terminateTargetJVM();
            this.notifyListeners(5);
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            // empty catch block
        }
        this.targetAppIsSuspended = false;
    }

    private String getInternalStatsText(InternalStatsResponse r) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        StringBuffer s = new StringBuffer(1000);
        s.append(INTERNAL_STATISTICS_ONLY_MSG);
        double wholeGraphGrossTimeAbs = CPUCCTContainer.getWholeGraphGrossTimeAbsForDisplayedThread();
        double timeInInjectedCode = CPUCCTContainer.getTimeInInjectedCodeForDisplayedThread();
        double totalRunTime = wholeGraphGrossTimeAbs + r.totalHotswappingTime + r.clientInstrTime + r.clientDataProcTime;
        s.append(MessageFormat.format(INSTR_METHODS_COUNT_MSG, "" + r.nTotalInstrMethods));
        s.append("\n");
        s.append(MessageFormat.format(CLASSLOAD_FIRSTINV_COUNT_MSG, "" + r.nClassLoads, "" + r.nFirstMethodInvocations));
        s.append("\n");
        s.append(MessageFormat.format(NON_EMPTY_IMG_COUNT_MSG, "" + r.nNonEmptyInstrMethodGroupResponses));
        s.append("\n");
        s.append(MessageFormat.format(EMPTY_IMG_COUNT_MSG, "" + r.nEmptyInstrMethodGroupResponses));
        s.append("\n");
        s.append(MessageFormat.format(SINGLE_IMG_COUNT_MSG, "" + r.nSingleMethodInstrMethodGroupResponses));
        s.append("\n");
        if (r.nNonEmptyInstrMethodGroupResponses > 0) {
            s.append(MessageFormat.format(AVG_METHOD_TIME_MSG, nf.format(r.averageHotswappingTime)));
            s.append("\n");
            s.append(MessageFormat.format(MIN_METHOD_TIME_MSG, nf.format(r.minHotswappingTime)));
            s.append("\n");
            s.append(MessageFormat.format(MAX_METHOD_TIME_MSG, nf.format(r.maxHotswappingTime)));
            s.append("\n");
        }
        s.append("\n");
        s.append(MessageFormat.format(TOTAL_RUN_TIME_MSG, nf.format(totalRunTime)));
        s.append("\n");
        if (totalRunTime == 0.0) {
            totalRunTime = 1.0;
        }
        s.append(MessageFormat.format(INJ_INSTR_TIME_MSG, nf.format(timeInInjectedCode), nf.format(timeInInjectedCode / totalRunTime * 100.0)));
        s.append("\n");
        s.append(MessageFormat.format(TOTAL_INSTR_HOTSWAP_TIME_MSG, nf.format(r.totalHotswappingTime), nf.format(r.totalHotswappingTime / totalRunTime * 100.0)));
        s.append("\n");
        s.append(MessageFormat.format(BYTECODE_COMM_TIME_MSG, nf.format(r.clientInstrTime), nf.format(r.clientInstrTime / totalRunTime * 100.0)));
        s.append("\n");
        s.append(MessageFormat.format(CLIENT_BYTECODE_TIME_MSG, "" + this.profilerClient.getInstrProcessingTime()));
        s.append("\n");
        s.append(MessageFormat.format(CLIENT_DISK_PROCESS_MSG, nf.format(r.clientDataProcTime), nf.format(r.clientDataProcTime / totalRunTime * 100.0)));
        s.append("\n");
        long dataProcessingTime = EventBufferProcessor.getDataProcessingTime();
        s.append(MessageFormat.format(CLIENT_RESULTS_PROCESS_MSG, "" + dataProcessingTime));
        s.append("\n");
        s.append("\n");
        this.appendCalibrationData(s);
        s.append("\n");
        return s.toString();
    }

    private void appendCalibrationData(StringBuffer s) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(4);
        long cntsInSec = this.status.timerCountsInSecond[0];
        double m0 = this.status.methodEntryExitCallTime[0] * 1000000.0 / (double)cntsInSec;
        double m1 = this.status.methodEntryExitCallTime[1] * 1000000.0 / (double)cntsInSec;
        double m2 = this.status.methodEntryExitCallTime[2] * 1000000.0 / (double)cntsInSec;
        double m4 = this.status.methodEntryExitCallTime[4] * 1000000.0 / (double)cntsInSec;
        s.append(MessageFormat.format(CALIBRATION_RESULTS_MSG, nf.format(m0), nf.format(m1), nf.format(m2), nf.format(m4)));
    }

    private boolean connectToStartedVMAndStartTA(boolean calibrationOnlyRun) {
        if (!this.connectToStartedVMAndStartTA(0, calibrationOnlyRun)) {
            return false;
        }
        this.status.runningInAttachedMode = false;
        this.notifyListeners(0);
        return true;
    }

    private boolean connectToStartedVMAndStartTA(int attachMode, boolean calibrationOnlyRun) {
        if (calibrationOnlyRun) {
            return true;
        }
        boolean sendExplicitStartCommand = attachMode != 1;
        try {
            return this.profilerClient.startTargetApp(sendExplicitStartCommand);
        }
        catch (ClientUtils.TargetAppOrVMTerminated e1) {
            String message = UNEXPECTED_PROBLEM_STARTING_APP_MSG;
            message = e1.isVMTerminated() ? message + JVM_TERMINATED_NOTRESPOND_STRING : message + INTERNAL_PROBLEM_STRING;
            this.appStatusHandler.displayError(message);
            return false;
        }
        catch (ClientUtils.TargetAppFailedToStart e2) {
            this.appStatusHandler.displayError(MessageFormat.format(FAILED_START_APP_CAUSE_MSG, e2.getOrigCause()));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(int event) {
        Vector targets = null;
        TargetAppRunner targetAppRunner = this;
        synchronized (targetAppRunner) {
            if (this.listeners != null) {
                targets = (Vector)this.listeners.clone();
            }
        }
        if (targets != null) {
            block12: for (int i = 0; i < targets.size(); ++i) {
                ProfilingEventListener target = (ProfilingEventListener)targets.elementAt(i);
                switch (event) {
                    case 0: {
                        target.targetAppStarted();
                        continue block12;
                    }
                    case 1: {
                        target.targetAppStopped();
                        continue block12;
                    }
                    case 2: {
                        target.targetAppSuspended();
                        continue block12;
                    }
                    case 3: {
                        target.targetAppResumed();
                        continue block12;
                    }
                    case 5: {
                        target.targetVMTerminated();
                        continue block12;
                    }
                    case 4: {
                        target.attachedToTarget();
                        continue block12;
                    }
                    case 6: {
                        target.detachedFromTarget();
                    }
                }
            }
        }
    }

    private boolean runJVMToCalibrateInstrumentation() {
        boolean result = this.startTargetVM(new String[0], "____Profiler+Calibration+Run____", new String[0], ".", this.settings.getSeparateConsole());
        if (!result) {
            return false;
        }
        result = this.initiateSession(0, true);
        while (this.targetJVMIsAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        if (this.status.timerCountsInSecond[0] == 0L) {
            this.appStatusHandler.displayErrorAndWaitForConfirm(CALIBRATION_ERROR_MSG);
            return false;
        }
        return true;
    }

    private boolean startTargetVM(String[] jvmArgs, String mainClassName, String[] mainArgs, String workingDir, boolean separateConsole) {
        boolean isWindows = Platform.isWindows();
        this.status.savedInternalStats = null;
        File dir = new File(workingDir);
        String classPathArg = this.settings.getMainClassPath();
        String libPath = this.settings.getJFluidRootDirName();
        String jdkVer = this.settings.getTargetJDKVersionString();
        if (jdkVer.equals("jdk16") || jdkVer.equals("jdk17")) {
            jdkVer = "jdk15";
        }
        jdkVer = jdkVer.substring(3);
        String jFluidCP = libPath + File.separator + "jfluid-server.jar" + File.pathSeparator + libPath + File.separator + "jfluid-server-" + jdkVer + ".jar";
        String[] newJVMArgs = new String[jvmArgs.length];
        int idx = 0;
        for (int i = 0; i < jvmArgs.length; ++i) {
            if ((jvmArgs[i].equals("-classpath") || jvmArgs[i].equals("-cp")) && i + 1 < jvmArgs.length) {
                this.appStatusHandler.displayWarning(CLASSPATH_SETTINGS_IGNORED_MSG);
                ++i;
                continue;
            }
            newJVMArgs[idx++] = jvmArgs[i];
        }
        ArrayList<String> commands = new ArrayList<String>(10);
        if (separateConsole) {
            if (isWindows) {
                commands.add("cmd.exe");
                commands.add("/K");
                commands.add("start");
                commands.add("\"Profiled Application Console\"");
                if (this.settings.getTargetWindowRemains()) {
                    commands.add("cmd");
                    commands.add("/K");
                }
            } else {
                commands.add("xterm");
                commands.add("-sb");
                commands.add("-sl");
                commands.add("1000");
                commands.add("-e");
            }
        }
        commands.add(this.settings.getTargetJVMExeFile());
        if (this.settings.getTargetJDKVersionString().equals("jdk15") || this.settings.getTargetJDKVersionString().equals("jdk16") || this.settings.getTargetJDKVersionString().equals("jdk17")) {
            String jfNativeLibFullName = Platform.getAgentNativeLibFullName(this.settings.getJFluidRootDirName(), false, this.settings.getTargetJDKVersionString(), this.settings.getSystemArchitecture());
            commands.add("-agentpath:" + jfNativeLibFullName);
        }
        commands.add("-Xbootclasspath/a:" + jFluidCP);
        if (classPathArg != null && !classPathArg.equals("")) {
            commands.add("-classpath");
            commands.add(classPathArg);
        }
        if (!isWindows && this.settings.getTargetWindowRemains()) {
            commands.add("-XX:+ShowMessageBoxOnError");
        }
        for (int i = 0; i < newJVMArgs.length; ++i) {
            commands.add(newJVMArgs[i]);
        }
        if (System.getProperty("org.netbeans.lib.profiler.wireprotocol.WireIO.agent") != null) {
            commands.add("-Dorg.netbeans.lib.profiler.wireprotocol.WireIO=true");
        }
        if (System.getProperty("org.netbeans.lib.profiler.server.ProfilerInterface.classLoadHook") != null) {
            commands.add("-Dorg.netbeans.lib.profiler.server.ProfilerInterface.classLoadHook=true");
        }
        commands.add("org.netbeans.lib.profiler.server.ProfilerServer");
        commands.add(Platform.getJFluidNativeLibDirName(this.settings.getJFluidRootDirName(), this.settings.getTargetJDKVersionString(), this.settings.getSystemArchitecture()));
        commands.add(Integer.toString(this.settings.getPortNo()));
        String timeOut = System.getProperty("profiler.agent.connect.timeout", "10");
        commands.add(timeOut);
        if (mainClassName != null) {
            commands.add(mainClassName);
        }
        for (int i = 0; i < mainArgs.length; ++i) {
            commands.add(mainArgs[i]);
        }
        String[] cmdArray = new String[commands.size()];
        commands.toArray(cmdArray);
        MiscUtils.printInfoMessage("Starting target application...");
        MiscUtils.printVerboseInfoMessage(cmdArray);
        if (DEBUG) {
            System.err.println("TargetAppRunner.DEBUG: Starting VM with " + cmdArray.length + " commands.");
            for (int i = 0; i < cmdArray.length; ++i) {
                System.err.println("TargetAppRunner.DEBUG: cmd[" + i + "] = >" + cmdArray[i] + "<");
            }
        }
        try {
            this.runningAppProcess = Runtime.getRuntime().exec(cmdArray, null, dir);
        }
        catch (IOException ex) {
            String s = "";
            for (int i = 0; i < cmdArray.length; ++i) {
                s = s + cmdArray[i] + "\n";
            }
            this.appStatusHandler.displayError(MessageFormat.format(ERROR_STARTING_JVM_MSG, s, ex));
            return false;
        }
        return true;
    }
}

