/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.results.EventBufferProcessor;
import org.netbeans.lib.profiler.results.ProfilingResultsProvider;

public class EventBufferResultsProvider
implements ProfilingResultsProvider {
    private static final Logger LOGGER = Logger.getLogger(EventBufferResultsProvider.class.getName());
    private static final EventBufferResultsProvider instance = new EventBufferResultsProvider();
    private final Set listeners = Collections.synchronizedSet(new HashSet());

    private EventBufferResultsProvider() {
    }

    public static EventBufferResultsProvider getDefault() {
        return instance;
    }

    @Override
    public void addDispatcher(ProfilingResultsProvider.Dispatcher dispatcher) {
        this.listeners.add(dispatcher);
    }

    @Override
    public void dataReady(int buffsize, int instrumentationType) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Profiling data ready " + buffsize);
        }
        byte[] data = new byte[buffsize];
        System.arraycopy(EventBufferProcessor.buf, 0, data, 0, buffsize);
        this.fireProcessData(data, instrumentationType);
    }

    @Override
    public void removeDispatcher(ProfilingResultsProvider.Dispatcher dispatcher) {
        this.listeners.remove(dispatcher);
    }

    @Override
    public void shutdown() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Shutting down profiler");
        }
        this.fireShutdown();
    }

    @Override
    public void startup(ProfilerClient client) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Starting up profiler");
        }
        this.fireStartup(client);
    }

    private void fireProcessData(byte[] data, int instrumentationType) {
        for (ProfilingResultsProvider.Dispatcher dispatcher : this.listeners) {
            dispatcher.dataFrameReceived(data, instrumentationType);
        }
    }

    private void fireShutdown() {
        for (ProfilingResultsProvider.Dispatcher dispatcher : this.listeners) {
            dispatcher.shutdown();
        }
    }

    private void fireStartup(ProfilerClient client) {
        for (ProfilingResultsProvider.Dispatcher dispatcher : this.listeners) {
            dispatcher.startup(client);
        }
    }
}

