/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class ExportDataDumper {
    public static final int BUFFER_SIZE = 32000;
    BufferedOutputStream bos;
    IOException caughtEx;
    int numExceptions = 0;

    public ExportDataDumper(FileOutputStream fw) {
        this.bos = new BufferedOutputStream(fw, 32000);
    }

    public IOException getCaughtException() {
        return this.caughtEx;
    }

    public int getNumExceptions() {
        return this.numExceptions;
    }

    public void dumpData(StringBuffer s) {
        if (this.caughtEx != null) {
            return;
        }
        try {
            if (s != null) {
                this.bos.write(s.toString().getBytes());
            }
        }
        catch (IOException ex) {
            this.caughtEx = ex;
            System.out.println(s);
            ++this.numExceptions;
            System.err.println(ex.getMessage());
        }
    }

    public void close() {
        try {
            this.bos.close();
        }
        catch (IOException ex) {
            this.caughtEx = ex;
            System.err.println(ex.getMessage());
        }
    }

    public void dumpDataAndClose(StringBuffer s) {
        this.dumpData(s);
        this.close();
    }

    public BufferedOutputStream getOutputStream() {
        return this.bos;
    }
}

