/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.awt.Image;
import java.beans.IntrospectionException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.modules.beans.BeanUtils;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PatternAnalyser;

public class PropertyPattern
extends Pattern {
    public static final int READ_WRITE = 1;
    public static final int READ_ONLY = 2;
    public static final int WRITE_ONLY = 4;
    static final String PROPERTY_CHANGE = "firePropertyChange";
    static final String VETOABLE_CHANGE = "fireVetoableChange";
    protected ElementHandle<ExecutableElement> getterMethod;
    protected ElementHandle<ExecutableElement> setterMethod;
    protected ElementHandle<VariableElement> estimatedField;
    protected String typeName;

    public PropertyPattern(PatternAnalyser patternAnalyser, ExecutableElement executableElement, ExecutableElement executableElement2, VariableElement variableElement, TypeMirror typeMirror, String string) throws IntrospectionException {
        super(patternAnalyser, Pattern.Kind.PROPERTY, string, (TypeMirrorHandle<TypeMirror>)TypeMirrorHandle.create((TypeMirror)typeMirror));
        this.getterMethod = executableElement == null ? null : ElementHandle.create((Element)executableElement);
        this.setterMethod = executableElement2 == null ? null : ElementHandle.create((Element)executableElement2);
        this.estimatedField = variableElement == null ? null : ElementHandle.create((Element)variableElement);
        this.typeName = BeanUtils.typeAsString(typeMirror);
    }

    @Override
    public Image getIcon() {
        switch (this.getMode()) {
            case 2: {
                return PROPERTY_READ;
            }
            case 4: {
                return PROPERTY_WRITE;
            }
            case 1: {
                return PROPERTY_READ_WRITE;
            }
        }
        return null;
    }

    @Override
    public String getHtmlDisplayName() {
        return this.name + " : <font color=" + "#707070" + "> " + this.typeName + "</font>";
    }

    public ElementHandle<VariableElement> getEstimatedField() {
        return this.estimatedField;
    }

    public ElementHandle<ExecutableElement> getGetterMethod() {
        return this.getterMethod;
    }

    public ElementHandle<ExecutableElement> getSetterMethod() {
        return this.setterMethod;
    }

    @Override
    public void setName(String string) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public int getMode() {
        if (this.setterMethod != null && this.getterMethod != null) {
            return 1;
        }
        if (this.getterMethod != null && this.setterMethod == null) {
            return 2;
        }
        if (this.setterMethod != null && this.getterMethod == null) {
            return 4;
        }
        return 0;
    }
}

