/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.impl.ParserAccessor;
import org.netbeans.modules.parsing.impl.SourceAccessor;
import org.netbeans.modules.parsing.impl.SourceCache;
import org.netbeans.modules.parsing.impl.SourceFlags;
import org.netbeans.modules.parsing.impl.Utilities;
import org.netbeans.modules.parsing.impl.indexing.RepositoryUpdater;
import org.netbeans.modules.parsing.impl.indexing.Util;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.Parameters;

public class TaskProcessor {
    private static final Logger LOGGER = Logger.getLogger(TaskProcessor.class.getName());
    private static final int SLOW_CANCEL_LIMIT = 50;
    private static final int DEFAULT_REPARSE_DELAY = 500;
    public static int reparseDelay = 500;
    private static final PriorityBlockingQueue<Request> requests = new PriorityBlockingQueue<Request>(10, new RequestPriorityComparator());
    private static final Map<Source, Collection<Request>> finishedRequests = new WeakHashMap<Source, Collection<Request>>();
    private static final Map<Source, Collection<Request>> waitingRequests = new WeakHashMap<Source, Collection<Request>>();
    private static final Collection<SchedulerTask> toRemove = new LinkedList<SchedulerTask>();
    static final WorkerThreadFactory factory = new WorkerThreadFactory();
    private static final CurrentRequestReference currentRequest = new CurrentRequestReference();
    private static final List<DeferredTask> todo = Collections.synchronizedList(new LinkedList());
    public static final Object INTERNAL_LOCK = new InternalLock();
    private static final ReentrantLock parserLock = new ReentrantLock(true);
    private static int lockCount = 0;
    private static final Pattern excludedTasks;
    private static final Pattern includedTasks;
    private static final Set<StackTraceElement> warnedAboutRunInEQ;
    private static final AtomicReference<Request> rst;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runUserTask(final Mutex.ExceptionAction<Void> task, Collection<Source> sources) throws ParseException {
        StackTraceElement stackTraceElement;
        Parameters.notNull((CharSequence)"task", task);
        if (sources.size() == 1) {
            SourceAccessor.getINSTANCE().assignListeners(sources.iterator().next());
        }
        boolean a = false;
        if (!$assertionsDisabled) {
            a = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (a && SwingUtilities.isEventDispatchThread() && (stackTraceElement = Util.findCaller(Thread.currentThread().getStackTrace(), TaskProcessor.class, ParserManager.class, "org.netbeans.api.java.source.JavaSource", "org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper")) != null && warnedAboutRunInEQ.add(stackTraceElement)) {
            LOGGER.warning("ParserManager.parse called in AWT event thread by: " + stackTraceElement);
        }
        Request request = currentRequest.getTaskToCancel();
        try {
            if (request != null) {
                request.task.cancel();
            }
            parserLock.lock();
            try {
                if (lockCount < 1) {
                    for (Source source : sources) {
                        SourceAccessor.getINSTANCE().invalidate(source, false);
                    }
                }
                ++lockCount;
                Utilities.runPriorityIO(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        task.run();
                        return null;
                    }
                });
            }
            catch (Exception e) {
                ParseException ioe = new ParseException();
                ioe.initCause(e);
                throw ioe;
            }
            finally {
                --lockCount;
                parserLock.unlock();
            }
        }
        finally {
            currentRequest.cancelCompleted(request);
        }
    }

    /*
     * Exception decompiling
     */
    public static Future<Void> runWhenScanFinished(Mutex.ExceptionAction<Void> task, Collection<Source> sources) throws ParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK], 4[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void addPhaseCompletionTasks(Collection<SchedulerTask> tasks, SourceCache cache, boolean bridge, Class<? extends Scheduler> schedulerType) {
        TaskProcessor.addPhaseCompletionTasks(tasks, cache, cache.getSnapshot().getSource(), bridge, schedulerType);
    }

    private static void addPhaseCompletionTasks(Collection<SchedulerTask> tasks, SourceCache cache, Source source, boolean bridge, Class<? extends Scheduler> schedulerType) {
        Parameters.notNull((CharSequence)"task", tasks);
        Parameters.notNull((CharSequence)"source", (Object)source);
        Parameters.notNull((CharSequence)"cache", (Object)cache);
        ArrayList<Request> _requests = new ArrayList<Request>();
        for (SchedulerTask task : tasks) {
            String taskClassName = task.getClass().getName();
            if (excludedTasks != null && excludedTasks.matcher(taskClassName).matches() && (includedTasks == null || !includedTasks.matcher(taskClassName).matches())) continue;
            _requests.add(new Request(task, cache, true, bridge, schedulerType));
        }
        if (!_requests.isEmpty()) {
            TaskProcessor.handleAddRequests(source, _requests);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePhaseCompletionTasks(Collection<? extends SchedulerTask> tasks, Source source) {
        Parameters.notNull((CharSequence)"task", tasks);
        Parameters.notNull((CharSequence)"source", (Object)source);
        Object object = INTERNAL_LOCK;
        synchronized (object) {
            Collection<Request> rqs = finishedRequests.get(source);
            boolean found = false;
            for (SchedulerTask schedulerTask : tasks) {
                String taskClassName = schedulerTask.getClass().getName();
                if (excludedTasks != null && excludedTasks.matcher(taskClassName).matches() && (includedTasks == null || !includedTasks.matcher(taskClassName).matches())) continue;
                if (rqs != null) {
                    Iterator<Request> it = rqs.iterator();
                    while (it.hasNext()) {
                        Request rq = it.next();
                        if (rq.task != schedulerTask) continue;
                        it.remove();
                        found = true;
                    }
                }
                if (!found) {
                    toRemove.add(schedulerTask);
                    requests.add(Request.NONE);
                }
                SourceAccessor.getINSTANCE().taskRemoved(source);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rescheduleTasks(Collection<SchedulerTask> tasks, Source source, Class<? extends Scheduler> schedulerType) {
        Parameters.notNull((CharSequence)"task", tasks);
        Parameters.notNull((CharSequence)"source", (Object)source);
        Object object = INTERNAL_LOCK;
        synchronized (object) {
            Request request = currentRequest.getTaskToCancel(tasks);
            try {
                Collection<Request> cr = finishedRequests.get(source);
                if (cr != null) {
                    for (SchedulerTask task : tasks) {
                        if (request != null && request.task == task) continue;
                        ArrayList<Request> aRequests = new ArrayList<Request>();
                        Iterator<Request> it = cr.iterator();
                        while (it.hasNext()) {
                            Request fr = it.next();
                            if (task != fr.task) continue;
                            it.remove();
                            fr.schedulerType = schedulerType;
                            aRequests.add(fr);
                            if (cr.size() != 0) break;
                            finishedRequests.remove(source);
                            break;
                        }
                        requests.addAll(aRequests);
                    }
                }
            }
            finally {
                if (request != null) {
                    currentRequest.cancelCompleted(request);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePhaseCompletionTask(Collection<SchedulerTask> add, Collection<SchedulerTask> remove, Source source, SourceCache cache, Class<? extends Scheduler> schedulerType) {
        Parameters.notNull((CharSequence)"add", add);
        Parameters.notNull((CharSequence)"remove", remove);
        Parameters.notNull((CharSequence)"source", (Object)source);
        Parameters.notNull((CharSequence)"cache", (Object)cache);
        Object object = INTERNAL_LOCK;
        synchronized (object) {
            TaskProcessor.removePhaseCompletionTasks(remove, source);
            TaskProcessor.addPhaseCompletionTasks(add, cache, source, false, schedulerType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Request resetState(Source source, boolean mayInterruptParser, boolean sync) {
        assert (source != null);
        Request r = currentRequest.getTaskToCancel(mayInterruptParser);
        if (r != null) {
            try {
                r.task.cancel();
            }
            finally {
                if (sync) {
                    Request oldR = rst.getAndSet(r);
                    assert (oldR == null);
                }
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetStateImpl(Source source) {
        Request r = rst.getAndSet(null);
        currentRequest.cancelCompleted(r);
        if (source != null) {
            Object object = INTERNAL_LOCK;
            synchronized (object) {
                Collection<Request> cr;
                boolean reschedule = SourceAccessor.getINSTANCE().testAndCleanFlags(source, SourceFlags.RESCHEDULE_FINISHED_TASKS, EnumSet.of(SourceFlags.RESCHEDULE_FINISHED_TASKS, SourceFlags.CHANGE_EXPECTED));
                if (reschedule && (cr = finishedRequests.remove(source)) != null && cr.size() > 0) {
                    requests.addAll(cr);
                }
                if ((cr = waitingRequests.remove(source)) != null && cr.size() > 0) {
                    requests.addAll(cr);
                }
            }
        }
    }

    static void acquireParserLock() {
        parserLock.lock();
    }

    static void releaseParserLock() {
        parserLock.unlock();
    }

    static boolean holdsParserLock() {
        return parserLock.isHeldByCurrentThread();
    }

    static void scheduleSpecialTask(SchedulerTask task) {
        assert (task != null);
        Request rq = new Request(task, null, false, true, null);
        TaskProcessor.handleAddRequests(null, Collections.singletonList(rq));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleAddRequests(Source source, List<Request> requests) {
        assert (requests != null);
        if (requests.isEmpty()) {
            return;
        }
        if (source != null) {
            SourceAccessor.getINSTANCE().assignListeners(source);
        }
        int priority = Integer.MAX_VALUE;
        Object object = INTERNAL_LOCK;
        synchronized (object) {
            for (Request request : requests) {
                toRemove.remove(request.task);
                priority = Math.min(priority, request.task.getPriority());
            }
            TaskProcessor.requests.addAll(requests);
        }
        Request request = currentRequest.getTaskToCancel(priority);
        try {
            if (request != null) {
                request.task.cancel();
            }
        }
        finally {
            currentRequest.cancelCompleted(request);
        }
    }

    private static boolean holdsDocumentWriteLock(Iterable<Source> sources) {
        assert (sources != null);
        Class<AbstractDocument> docClass = AbstractDocument.class;
        try {
            Method method = docClass.getDeclaredMethod("getCurrentWriter", new Class[0]);
            method.setAccessible(true);
            Thread currentThread = Thread.currentThread();
            for (Source source : sources) {
                try {
                    Object result;
                    Document doc = source.getDocument(true);
                    if (!(doc instanceof AbstractDocument) || (result = method.invoke((Object)doc, new Object[0])) != currentThread) continue;
                    return true;
                }
                catch (Exception e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        }
        catch (NoSuchMethodException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return false;
    }

    static /* synthetic */ Collection access$700() {
        return toRemove;
    }

    static /* synthetic */ Map access$800() {
        return finishedRequests;
    }

    static /* synthetic */ PriorityBlockingQueue access$900() {
        return requests;
    }

    static /* synthetic */ CurrentRequestReference access$1000() {
        return currentRequest;
    }

    static /* synthetic */ Logger access$1300() {
        return LOGGER;
    }

    static /* synthetic */ Map access$1500() {
        return waitingRequests;
    }

    static /* synthetic */ int access$1608() {
        return lockCount++;
    }

    static /* synthetic */ int access$1610() {
        return lockCount--;
    }

    static {
        warnedAboutRunInEQ = new HashSet<StackTraceElement>();
        Executors.newSingleThreadExecutor(factory).submit(new CompilationJob());
        Pattern _excludedTasks = null;
        try {
            String excludedValue = System.getProperty("org.netbeans.modules.parsing.impl.Source.excludedTasks");
            if (excludedValue != null) {
                _excludedTasks = Pattern.compile(excludedValue);
            }
        }
        catch (PatternSyntaxException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        excludedTasks = _excludedTasks;
        Pattern _includedTasks = null;
        try {
            String includedValue = System.getProperty("org.netbeans.modules.parsing.impl.Source.includedTasks");
            if (includedValue != null) {
                _includedTasks = Pattern.compile(includedValue);
            }
        }
        catch (PatternSyntaxException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        includedTasks = _includedTasks;
        rst = new AtomicReference();
    }

    static final class DeferredTask {
        final Collection<Source> sources;
        final Mutex.ExceptionAction<Void> task;
        final ScanSync sync;

        public DeferredTask(Collection<Source> sources, Mutex.ExceptionAction<Void> task, ScanSync sync) {
            assert (sources != null);
            assert (task != null);
            assert (sync != null);
            this.sources = sources;
            this.task = task;
            this.sync = sync;
        }
    }

    static final class ScanSync
    implements Future<Void> {
        private Mutex.ExceptionAction<Void> task;
        private final CountDownLatch sync;
        private final AtomicBoolean canceled;

        public ScanSync(Mutex.ExceptionAction<Void> task) {
            assert (task != null);
            this.task = task;
            this.sync = new CountDownLatch(1);
            this.canceled = new AtomicBoolean(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.sync.getCount() == 0L) {
                return false;
            }
            List list = todo;
            synchronized (list) {
                boolean _canceled = this.canceled.getAndSet(true);
                if (!_canceled) {
                    Iterator it = todo.iterator();
                    while (it.hasNext()) {
                        DeferredTask t = (DeferredTask)it.next();
                        if (t.task != this.task) continue;
                        it.remove();
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public boolean isCancelled() {
            return this.canceled.get();
        }

        @Override
        public synchronized boolean isDone() {
            return this.sync.getCount() == 0L;
        }

        @Override
        public Void get() throws InterruptedException, ExecutionException {
            this.checkCaller();
            this.sync.await();
            return null;
        }

        @Override
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.checkCaller();
            this.sync.await(timeout, unit);
            return null;
        }

        private void taskFinished() {
            this.sync.countDown();
        }

        private void checkCaller() {
            if (RepositoryUpdater.getDefault().isProtectedModeOwner(Thread.currentThread())) {
                throw new IllegalStateException("ScanSync.get called by protected mode owner.");
            }
        }

        static /* synthetic */ void access$500(ScanSync x0) {
            x0.taskFinished();
        }
    }

    private static final class CurrentRequestReference {
        private Request reference;
        private Request canceledReference;
        private Parser activeParser;
        private long cancelTime;
        private boolean canceled;
        private static final Object CRR_LOCK = new CRRLock();

        private CurrentRequestReference() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean setCurrentTask(Request reference) throws InterruptedException {
            boolean result = false;
            assert (!parserLock.isHeldByCurrentThread());
            assert (reference == null || reference.cache == null || !Thread.holdsLock(INTERNAL_LOCK));
            Object object = CRR_LOCK;
            synchronized (object) {
                while (this.canceledReference != null) {
                    CRR_LOCK.wait();
                }
                result = this.canceled;
                this.canceled = false;
                this.cancelTime = 0L;
                this.activeParser = null;
                this.reference = reference;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clearCurrentTask() {
            Object object = CRR_LOCK;
            synchronized (object) {
                this.reference = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setCurrentParser(Parser parser) {
            Object object = CRR_LOCK;
            synchronized (object) {
                this.activeParser = parser;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Request getTaskToCancel(int priority) {
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                Object object = CRR_LOCK;
                synchronized (object) {
                    if (this.reference != null && priority < this.reference.task.getPriority()) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request = this.reference;
                        this.reference = null;
                        this.canceled = true;
                        this.cancelTime = System.currentTimeMillis();
                    }
                }
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Request getTaskToCancel(Collection<? extends SchedulerTask> tasks) {
            assert (tasks != null);
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                Object object = CRR_LOCK;
                synchronized (object) {
                    if (this.reference != null && tasks.contains(this.reference.task)) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request = this.reference;
                        this.reference = null;
                        this.canceled = true;
                    }
                }
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Request getTaskToCancel() {
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                Object object = CRR_LOCK;
                synchronized (object) {
                    request = this.reference;
                    if (request != null) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request;
                        this.reference = null;
                        this.canceled = true;
                        this.cancelTime = System.currentTimeMillis();
                    }
                }
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Request getTaskToCancel(boolean mayCancelParser) {
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                Parser parser;
                Object object = CRR_LOCK;
                synchronized (object) {
                    if (this.reference != null) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request = this.reference;
                        this.reference = null;
                        this.canceled = true;
                        this.cancelTime = System.currentTimeMillis();
                    } else if (this.canceledReference == null) {
                        this.canceledReference = request = Request.DUMMY;
                        this.cancelTime = System.currentTimeMillis();
                    }
                    parser = this.activeParser;
                }
                if (parser != null && mayCancelParser) {
                    parser.cancel();
                }
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean getTaskToCancel(Request[] request) {
            assert (request != null);
            assert (request.length == 1);
            boolean result = false;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                Object object = CRR_LOCK;
                synchronized (object) {
                    request[0] = this.reference;
                    if (request[0] != null) {
                        boolean bl = result = request[0].cache == null;
                        assert (this.canceledReference == null);
                        if (!result) {
                            this.canceledReference = request[0];
                            this.reference = null;
                        }
                        this.canceled = result;
                        this.cancelTime = System.currentTimeMillis();
                    }
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isCanceled() {
            Object object = CRR_LOCK;
            synchronized (object) {
                return this.canceled;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long getCancelTime() {
            Object object = CRR_LOCK;
            synchronized (object) {
                return this.cancelTime;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancelCompleted(Request request) {
            if (request != null) {
                Object object = CRR_LOCK;
                synchronized (object) {
                    assert (request == this.canceledReference);
                    this.canceledReference = null;
                    CRR_LOCK.notify();
                }
            }
        }

        private static class CRRLock {
            private CRRLock() {
            }
        }
    }

    static class WorkerThreadFactory
    implements ThreadFactory {
        private Thread t;

        WorkerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            assert (this.t == null);
            this.t = new Thread(r, "Parsing & Indexing Loop (" + System.getProperty("netbeans.buildnumber") + ")");
            return this.t;
        }

        public boolean isDispatchThread(Thread t) {
            assert (t != null);
            return this.t == t;
        }
    }

    private static class RequestPriorityComparator
    implements Comparator<Request> {
        private RequestPriorityComparator() {
        }

        @Override
        public int compare(Request r1, Request r2) {
            assert (r1 != null && r2 != null);
            return r1.task.getPriority() - r2.task.getPriority();
        }
    }

    public static class Request {
        static final Request DUMMY = new Request();
        static final Request NONE = new Request();
        private final SchedulerTask task;
        private final SourceCache cache;
        private final boolean reschedule;
        private final boolean bridge;
        private Class<? extends Scheduler> schedulerType;

        public Request(SchedulerTask task, SourceCache cache, boolean reschedule, boolean bridge, Class<? extends Scheduler> schedulerType) {
            assert (task != null);
            this.task = task;
            this.cache = cache;
            this.reschedule = reschedule;
            this.bridge = bridge;
            this.schedulerType = schedulerType;
        }

        private Request() {
            this(new ParserResultTask(){

                @Override
                public int getPriority() {
                    return 0;
                }

                @Override
                public Class<? extends Scheduler> getSchedulerClass() {
                    return null;
                }

                @Override
                public void cancel() {
                }

                public void run(Parser.Result result, SchedulerEvent event) {
                }
            }, null, false, false, null);
        }

        public String toString() {
            if (this.reschedule) {
                return String.format("Periodic request to perform: %s on: %s", this.task == null ? null : this.task.toString(), this.cache == null ? null : this.cache.toString());
            }
            return String.format("One time request to perform: %s on: %s", this.task == null ? null : this.task.toString(), this.cache == null ? null : this.cache.toString());
        }

        public int hashCode() {
            return this.task == null ? 0 : this.task.getPriority();
        }

        public boolean equals(Object other) {
            if (other instanceof Request) {
                Request otherRequest = (Request)other;
                return this.reschedule == otherRequest.reschedule && (this.cache == null ? otherRequest.cache == null : this.cache.equals(otherRequest.cache)) && (this.task == null ? otherRequest.task == null : this.task.equals(otherRequest.task));
            }
            return false;
        }

        static /* synthetic */ Class access$600(Request x0) {
            return x0.schedulerType;
        }

        static /* synthetic */ boolean access$1700(Request x0) {
            return x0.reschedule;
        }

        static /* synthetic */ boolean access$1800(Request x0) {
            return x0.bridge;
        }
    }

    private static class CompilationJob
    implements Runnable {
        private CompilationJob() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                while (true) {
                    try {}
                    catch (Throwable e) {
                        if (e instanceof InterruptedException) {
                            throw (InterruptedException)e;
                        }
                        if (e instanceof ThreadDeath) {
                            throw (ThreadDeath)e;
                        }
                        Exceptions.printStackTrace((Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
                return;
            }
            block45: while (true) {
                block74: {
                    block76: {
                        var1_1 = TaskProcessor.INTERNAL_LOCK;
                        // MONITORENTER : var1_1
                        if (!TaskProcessor.access$700().isEmpty()) {
                            it = TaskProcessor.access$800().values().iterator();
                            while (it.hasNext()) {
                                cr = (Collection)it.next();
                                it2 = cr.iterator();
                                while (it2.hasNext()) {
                                    fr = (Request)it2.next();
                                    if (!TaskProcessor.access$700().remove(Request.access$400(fr))) continue;
                                    it2.remove();
                                }
                                if (cr.size() != 0) continue;
                                it.remove();
                            }
                        }
                        // MONITOREXIT : var1_1
                        r = (Request)TaskProcessor.access$900().take();
                        if (r == null || r == Request.NONE) continue;
                        TaskProcessor.access$1000().setCurrentTask(r);
                        sourceCache = Request.access$1100(r);
                        if (sourceCache == null) {
                            if (!CompilationJob.$assertionsDisabled && !(Request.access$400(r) instanceof ParserResultTask)) {
                                throw new AssertionError((Object)"Illegal request: EmbeddingProvider has to be bound to Source");
                            }
                            TaskProcessor.access$1200().lock();
                            try {
                                try {
                                    if (TaskProcessor.access$1300().isLoggable(Level.FINE)) {
                                        TaskProcessor.access$1300().fine("Running Special Task: " + r.toString());
                                    }
                                    ((ParserResultTask)Request.access$400(r)).run(null, null);
                                    TaskProcessor.access$1000().clearCurrentTask();
                                    cancelled = TaskProcessor.access$900().contains(r);
                                    if (cancelled) continue;
                                }
                                catch (Throwable var10_30) {
                                    TaskProcessor.access$1000().clearCurrentTask();
                                    cancelled = TaskProcessor.access$900().contains(r);
                                    if (cancelled != false) throw var10_30;
                                    var13_29 = TaskProcessor.access$1400();
                                    // MONITORENTER : var13_29
                                    _todo = TaskProcessor.access$1400().toArray(new DeferredTask[TaskProcessor.access$1400().size()]);
                                    TaskProcessor.access$1400().clear();
                                    // MONITOREXIT : var13_29
                                    arr$ = _todo;
                                    len$ = arr$.length;
                                    i$ = 0;
                                    while (i$ < len$) {
                                        rq = arr$[i$];
                                        try {
                                            TaskProcessor.runUserTask(rq.task, rq.sources);
                                        }
                                        finally {
                                            ScanSync.access$500(rq.sync);
                                        }
                                        ++i$;
                                    }
                                    throw var10_30;
                                }
                                fr = TaskProcessor.access$1400();
                                // MONITORENTER : fr
                                _todo = TaskProcessor.access$1400().toArray(new DeferredTask[TaskProcessor.access$1400().size()]);
                                TaskProcessor.access$1400().clear();
                                // MONITOREXIT : fr
                                arr$ = _todo;
                                len$ = arr$.length;
                                i$ = 0;
                                break block74;
                            }
                            catch (RuntimeException re) {
                                Exceptions.printStackTrace((Throwable)re);
                                continue;
                            }
                            finally {
                                TaskProcessor.access$1200().unlock();
                            }
                        }
                        source = sourceCache.getSnapshot().getSource();
                        if (!CompilationJob.$assertionsDisabled && source == null) {
                            throw new AssertionError();
                        }
                        _todo = TaskProcessor.INTERNAL_LOCK;
                        // MONITORENTER : org.netbeans.modules.parsing.impl.TaskProcessor.INTERNAL_LOCK
                        if (!TaskProcessor.access$700().remove(Request.access$400(r))) break block76;
                        // MONITOREXIT : _todo
                        TaskProcessor.access$1000().setCurrentTask(null);
                        continue;
                    }
                    changeExpected = SourceAccessor.getINSTANCE().testFlag(source, SourceFlags.CHANGE_EXPECTED);
                    if (changeExpected) {
                        rc = (LinkedList<Request>)TaskProcessor.access$1500().get(source);
                        if (rc == null) {
                            rc = new LinkedList<Request>();
                            TaskProcessor.access$1500().put(source, rc);
                        }
                        rc.add(r);
                        // MONITOREXIT : _todo
                        TaskProcessor.access$1000().setCurrentTask(null);
                        continue;
                    }
                    try {
                        block77: {
                            // MONITOREXIT : _todo
                            snapshot = null;
                            id = new long[]{-1L};
                            if (SourceAccessor.getINSTANCE().testFlag(source, SourceFlags.INVALID)) {
                                snapshot = sourceCache.createSnapshot(id);
                            }
                            reschedule = false;
                            TaskProcessor.access$1200().lock();
                            try {
                                if (SourceAccessor.getINSTANCE().invalidate(source, id[0], snapshot)) {
                                    TaskProcessor.access$1608();
                                    try {
                                        if (Request.access$400(r) instanceof EmbeddingProvider) {
                                            sourceCache.refresh((EmbeddingProvider)Request.access$400(r), Request.access$600(r));
                                            break block77;
                                        }
                                        TaskProcessor.access$1000().setCurrentParser(sourceCache.getParser());
                                        currentResult = sourceCache.getResult(Request.access$400(r));
                                        if (currentResult == null) break block77;
                                        try {
                                            v0 = shouldCall = SourceAccessor.getINSTANCE().testFlag(source, SourceFlags.INVALID) == false;
                                            if (!shouldCall) break block77;
                                            try {
                                                startTime = System.currentTimeMillis();
                                                if (Request.access$400(r) instanceof ParserResultTask) {
                                                    if (TaskProcessor.access$1300().isLoggable(Level.FINE)) {
                                                        TaskProcessor.access$1300().fine("Running Task: " + r.toString());
                                                    }
                                                    parserResultTask = (ParserResultTask)Request.access$400(r);
                                                    schedulerEvent = SourceAccessor.getINSTANCE().getSchedulerEvent(source, parserResultTask.getSchedulerClass());
                                                    parserResultTask.run(currentResult, schedulerEvent);
                                                } else if (!CompilationJob.$assertionsDisabled) {
                                                    throw new AssertionError((Object)("Unknown task type: " + Request.access$400(r).getClass()));
                                                }
                                                endTime = System.currentTimeMillis();
                                                if (TaskProcessor.access$1300().isLoggable(Level.FINEST)) {
                                                    TaskProcessor.access$1300().finest(String.format("Executed task: %s in %d ms.", new Object[]{Request.access$400(r).getClass().toString(), endTime - startTime}));
                                                }
                                                if (TaskProcessor.access$1300().isLoggable(Level.FINER) && (cancelTime = TaskProcessor.access$1000().getCancelTime()) >= startTime && endTime - cancelTime > 50L) {
                                                    TaskProcessor.access$1300().finer(String.format("Task: %s ignored cancel for %d ms.", new Object[]{Request.access$400(r).getClass().toString(), endTime - cancelTime}));
                                                }
                                                break block77;
                                            }
                                            catch (Exception re) {
                                                Exceptions.printStackTrace((Throwable)re);
                                            }
                                            break block77;
                                        }
                                        finally {
                                            ParserAccessor.getINSTANCE().invalidate(currentResult);
                                        }
                                    }
                                    finally {
                                        TaskProcessor.access$1610();
                                    }
                                }
                                reschedule = true;
                            }
                            finally {
                                TaskProcessor.access$1200().unlock();
                            }
                        }
                        if (Request.access$1700(r)) {
                            var7_17 = TaskProcessor.INTERNAL_LOCK;
                            // MONITORENTER : var7_17
                            if ((reschedule |= TaskProcessor.access$1000().setCurrentTask(null)) || SourceAccessor.getINSTANCE().testFlag(source, SourceFlags.INVALID)) {
                                TaskProcessor.access$900().add(r);
                            } else if (Request.access$1800(r)) {
                                rc = (LinkedList<Request>)TaskProcessor.access$800().get(Request.access$1100(r).getSnapshot().getSource());
                                if (rc == null) {
                                    rc = new LinkedList<Request>();
                                    TaskProcessor.access$800().put(Request.access$1100(r).getSnapshot().getSource(), rc);
                                }
                                rc.add(r);
                            }
                            // MONITOREXIT : var7_17
                        }
                        SourceAccessor.getINSTANCE().taskRemoved(source);
                    }
                    finally {
                        TaskProcessor.access$1000().setCurrentTask(null);
                    }
                    continue;
                }
                while (true) {
                    if (i$ < len$) ** break;
                    continue block45;
                    rq = arr$[i$];
                    try {
                        TaskProcessor.runUserTask(rq.task, rq.sources);
                    }
                    finally {
                        ScanSync.access$500(rq.sync);
                    }
                    ++i$;
                }
                break;
            }
        }
    }

    private static class InternalLock {
        private InternalLock() {
        }
    }
}

