/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.netbeans.modules.parsing.impl.indexing.IndexableImpl;
import org.netbeans.modules.parsing.impl.indexing.ProxyIterable;
import org.netbeans.modules.parsing.impl.indexing.SPIAccessor;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.openide.util.Parameters;

public final class ClusteredIndexables {
    private final List<IndexableImpl> indexables;
    private final Map<String, List<Indexable>> mimeTypeClusters = new HashMap<String, List<Indexable>>();
    private static final String ALL_MIME_TYPES = "";

    public ClusteredIndexables(Collection<IndexableImpl> indexables) {
        Parameters.notNull((CharSequence)"indexables", indexables);
        this.indexables = new LinkedList<IndexableImpl>(indexables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Indexable> getIndexablesFor(String mimeType) {
        Map<String, List<Indexable>> map = this.mimeTypeClusters;
        synchronized (map) {
            List<Indexable> cluster;
            if (mimeType == null) {
                mimeType = ALL_MIME_TYPES;
            }
            if ((cluster = this.mimeTypeClusters.get(mimeType)) == null) {
                cluster = new LinkedList<Indexable>();
                if (mimeType.length() == 0) {
                    for (IndexableImpl iimpl : this.indexables) {
                        cluster.add(SPIAccessor.getInstance().create(iimpl));
                    }
                } else {
                    boolean resolved = false;
                    ListIterator<IndexableImpl> it = this.indexables.listIterator();
                    while (it.hasNext()) {
                        IndexableImpl iimpl = it.next();
                        if (!iimpl.isTypeOf(mimeType)) continue;
                        it.remove();
                        cluster.add(SPIAccessor.getInstance().create(iimpl));
                        resolved = true;
                    }
                    if (resolved) {
                        this.mimeTypeClusters.remove(ALL_MIME_TYPES);
                    }
                }
                this.mimeTypeClusters.put(mimeType, cluster);
            }
            if (mimeType.length() == 0) {
                return new ProxyIterable<Indexable>(this.mimeTypeClusters.values());
            }
            return cluster;
        }
    }
}

