/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing.lucene;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.netbeans.modules.parsing.impl.indexing.IndexDocumentImpl;
import org.netbeans.modules.parsing.impl.indexing.lucene.DocumentUtil;
import org.netbeans.modules.parsing.spi.indexing.Indexable;

public class LuceneDocument
implements IndexDocumentImpl {
    public final Document doc;

    LuceneDocument(Indexable indexable) {
        assert (indexable != null);
        this.doc = new Document();
        this.doc.add(DocumentUtil.sourceNameField(indexable.getRelativePath()));
    }

    public LuceneDocument(Document doc) {
        assert (doc != null);
        this.doc = doc;
    }

    @Override
    public void addPair(String key, String value, boolean searchable, boolean stored) {
        Field field = new Field(key, value, stored ? Field.Store.YES : Field.Store.NO, searchable ? Field.Index.NO_NORMS : Field.Index.NO);
        this.doc.add((Fieldable)field);
    }

    @Override
    public String getSourceName() {
        return this.doc.get("_sn");
    }

    @Override
    public String getValue(String key) {
        return this.doc.get(key);
    }

    @Override
    public String[] getValues(String key) {
        return this.doc.getValues(key);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + "; " + this.getSourceName();
    }
}

