/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.extras.api.support;

import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.dlight.extras.api.AxisMark;
import org.netbeans.modules.dlight.extras.api.support.AbstractCachingAxisMarksProvider;
import org.netbeans.modules.dlight.util.DLightMath;
import org.netbeans.modules.dlight.util.TimeFormatter;

public final class TimeMarksProvider
extends AbstractCachingAxisMarksProvider {
    private static final long[] INTERVALS = new long[]{100000000L, 500000000L, 1000000000L, 5000000000L, 10000000000L, 30000000000L, 60000000000L, 300000000000L, 600000000000L};
    private static final String LABEL_TEXT = "99:99";
    private static final TimeFormatter TIME_FORMATTER = new TimeFormatter();

    public static TimeMarksProvider newInstance() {
        return new TimeMarksProvider();
    }

    private TimeMarksProvider() {
    }

    @Override
    protected List<AxisMark> getAxisMarksImpl(long viewportStart, long viewportEnd, int axisSize, FontMetrics axisFontMetrics) {
        if (viewportStart == viewportEnd || axisSize < 10) {
            return Collections.emptyList();
        }
        long tickInterval = this.getTickInterval(viewportEnd - viewportStart, axisSize);
        long labelInterval = this.getLabelInterval(viewportEnd - viewportStart, axisSize, axisFontMetrics);
        ArrayList<AxisMark> marks = new ArrayList<AxisMark>();
        long value = viewportStart;
        while (value <= viewportEnd) {
            if (value % tickInterval == 0L) {
                String text = null;
                if (value % labelInterval == 0L) {
                    text = TIME_FORMATTER.format(value);
                }
                marks.add(new AxisMark((int)DLightMath.map((long)value, (long)viewportStart, (long)viewportEnd, (long)0L, (long)axisSize), text));
            }
            value = DLightMath.nextMultipleOf((long)tickInterval, (long)value);
        }
        return marks;
    }

    private long getTickInterval(long viewportSize, int axisSize) {
        float pixelsPerNano = (float)axisSize / (float)viewportSize;
        for (int i = 0; i < INTERVALS.length; ++i) {
            if (!(10.0f <= (float)INTERVALS[i] * pixelsPerNano)) continue;
            return INTERVALS[i];
        }
        return INTERVALS[INTERVALS.length - 1];
    }

    private long getLabelInterval(long viewportSize, int axisSize, FontMetrics axisFontMetrics) {
        float pixelsPerNano = (float)axisSize / (float)viewportSize;
        for (int i = 0; i < INTERVALS.length; ++i) {
            if (!((float)(4 * axisFontMetrics.stringWidth(LABEL_TEXT) / 3) <= (float)INTERVALS[i] * pixelsPerNano)) continue;
            return INTERVALS[i];
        }
        return INTERVALS[INTERVALS.length - 1];
    }
}

