/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.testrunner.ui;

import java.awt.event.ActionEvent;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.testrunner.ui.BaseTestMethodNodeAction;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.spi.project.ActionProvider;
import org.openide.util.lookup.Lookups;

final class RunTestSuiteAction
extends BaseTestMethodNodeAction {
    private final boolean debug;

    public RunTestSuiteAction(Testcase testcase, Project project, String name, boolean debug) {
        super(testcase, project, name);
        this.debug = debug;
    }

    protected void doActionPerformed(ActionEvent e) {
        Folder targetFolder;
        ActionProvider ap = (ActionProvider)this.project.getLookup().lookup(ActionProvider.class);
        if (ap != null && (targetFolder = this.findTestFolder()) != null) {
            if (this.debug) {
                ap.invokeAction("debug", Lookups.fixed((Object[])new Object[]{this.project, targetFolder}));
            } else {
                ap.invokeAction("test.single", Lookups.fixed((Object[])new Object[]{this.project, targetFolder}));
            }
        }
    }

    private Folder findTestFolder() {
        MakeConfigurationDescriptor mcd = MakeConfigurationDescriptor.getMakeConfigurationDescriptor((Project)this.project);
        Folder root = mcd.getLogicalFolders();
        Folder testRootFolder = null;
        for (Folder folder : root.getFolders()) {
            if (!folder.isTestRootFolder()) continue;
            testRootFolder = folder;
            break;
        }
        if (testRootFolder != null) {
            for (Folder folder : testRootFolder.getAllTests()) {
                Item[] items = folder.getAllItemsAsArray();
                for (int k = 0; k < items.length; ++k) {
                    if (!items[k].getName().replaceFirst("\\..*", "").equals(this.testcase.getClassName())) continue;
                    return folder;
                }
            }
        }
        return null;
    }
}

