/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.e2e.wsdl.wsdl2java;

import java.io.File;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.netbeans.modules.e2e.api.schema.Element;
import org.netbeans.modules.e2e.api.schema.SchemaConstruct;
import org.netbeans.modules.e2e.api.schema.Type;
import org.netbeans.modules.e2e.api.wsdl.Binding;
import org.netbeans.modules.e2e.api.wsdl.BindingOperation;
import org.netbeans.modules.e2e.api.wsdl.Definition;
import org.netbeans.modules.e2e.api.wsdl.Input;
import org.netbeans.modules.e2e.api.wsdl.Message;
import org.netbeans.modules.e2e.api.wsdl.Operation;
import org.netbeans.modules.e2e.api.wsdl.Output;
import org.netbeans.modules.e2e.api.wsdl.Part;
import org.netbeans.modules.e2e.api.wsdl.Port;
import org.netbeans.modules.e2e.api.wsdl.PortType;
import org.netbeans.modules.e2e.api.wsdl.Service;
import org.netbeans.modules.e2e.api.wsdl.extensions.ExtensibilityElement;
import org.netbeans.modules.e2e.api.wsdl.extensions.soap.SOAPAddress;
import org.netbeans.modules.e2e.api.wsdl.extensions.soap.SOAPOperation;
import org.netbeans.modules.e2e.api.wsdl.wsdl2java.WSDL2Java;
import org.netbeans.modules.e2e.schema.SchemaConstants;
import org.netbeans.modules.e2e.wsdl.WSDLException;
import org.netbeans.modules.e2e.wsdl.WSDLParser;
import org.netbeans.modules.e2e.wsdl.extensions.soap.SOAPConstants;
import org.netbeans.modules.e2e.wsdl.wsdl2java.OutputFileFormatter;
import org.netbeans.modules.e2e.wsdl.wsdl2java.WSDLValidator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class WSDL2JavaImpl
implements WSDL2Java {
    private WSDLParser wsdlParser;
    private Definition definition;
    private Set<QName> usedParameterTypes;
    private Set<QName> usedReturnTypes;
    private Map<QName, Integer> uniqueTypeName;
    private WSDL2Java.Configuration configuration;

    public WSDL2JavaImpl(WSDL2Java.Configuration configuration) {
        this.configuration = configuration;
        this.wsdlParser = new WSDLParser(configuration.getOriginalWSDLUrl());
    }

    @Override
    public boolean generate() {
        this.uniqueTypeName = new HashMap<QName, Integer>();
        try {
            this.definition = this.wsdlParser.parse(this.configuration.getWSDLFileName());
            boolean valid = true;
            for (WSDL2Java.ValidationResult vr : this.validate()) {
                if (!WSDL2Java.ValidationResult.ErrorLevel.FATAL.equals((Object)vr.getErrorLevel())) continue;
                valid = false;
                break;
            }
            if (valid) {
                this.generateInterfaces();
                this.generateTypes();
                this.generateStub();
            }
        }
        catch (WSDLException e) {
            e.printStackTrace();
            return false;
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "xxxxxx", e);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public List<WSDL2Java.ValidationResult> validate() {
        List<WSDL2Java.ValidationResult> validationResults = new ArrayList<WSDL2Java.ValidationResult>();
        try {
            this.definition = this.wsdlParser.parse(this.configuration.getWSDLFileName());
            validationResults.addAll(this.wsdlParser.getValidationResults());
            for (WSDL2Java.ValidationResult result : validationResults) {
                if (!WSDL2Java.ValidationResult.ErrorLevel.FATAL.equals((Object)result.getErrorLevel())) continue;
                return validationResults;
            }
            WSDLValidator validator = new WSDLValidator(this.wsdlParser.getValidationResults(), this.definition);
            validationResults = validator.validate();
        }
        catch (WSDLException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return validationResults;
    }

    public Element getReturnElement(Element element) {
        if (element.getMaxOccurs() > 1) {
            return element;
        }
        Type type = element.getType();
        if (3 == type.getFlavor()) {
            return element;
        }
        if (1 == type.getFlavor()) {
            if (type.getSubconstructs().size() == 0) {
                return element;
            }
            if (type.getSubconstructs().size() == 1) {
                return this.getSimplifiedElement((Element)type.getSubconstructs().get(0));
            }
        }
        return element;
    }

    public List<Element> getParameterElements(Element element) {
        ArrayList<Element> params = new ArrayList<Element>();
        params.add(element);
        if (element.getMaxOccurs() > 1) {
            return params;
        }
        Type type = element.getType();
        if (3 == type.getFlavor()) {
            return params;
        }
        if (1 == type.getFlavor()) {
            params = new ArrayList();
            for (SchemaConstruct sc : type.getSubconstructs()) {
                if (!SchemaConstruct.ConstructType.ELEMENT.equals((Object)sc.getConstructType())) continue;
                Element sce = (Element)sc;
                params.add(sce);
            }
            return params;
        }
        return params;
    }

    public String getJavaTypeName(Element e) {
        boolean isArray = e.getMaxOccurs() > 1;
        String javaTypeName = "";
        Type type = e.getType();
        if (3 == type.getFlavor()) {
            javaTypeName = e.isNillable() || e.getMinOccurs() == 0 ? this.getWrapperTypeName(e.getType()) : type.getJavaTypeName();
        } else if (1 == type.getFlavor()) {
            javaTypeName = type.getSubconstructs().size() == 0 ? "void" : (e.getType().getName() == null ? e.getName().getLocalPart() : e.getType().getName().getLocalPart());
        }
        return javaTypeName + (isArray ? "[]" : "");
    }

    private boolean isElementComplex(Element e) {
        boolean isArray;
        boolean bl = isArray = e.getMaxOccurs() > 1;
        if (isArray) {
            return true;
        }
        Type type = e.getType();
        if (3 == type.getFlavor()) {
            return e.isNillable();
        }
        if (1 == type.getFlavor()) {
            return type.getSubconstructs().size() != 0;
        }
        return true;
    }

    private void generateInterfaces() throws Exception {
        HashSet<QName> usedTypes = new HashSet<QName>();
        this.usedReturnTypes = new HashSet<QName>();
        this.usedParameterTypes = new HashSet<QName>();
        HashSet<QName> usedReturnTypeNames = new HashSet<QName>();
        HashSet<QName> usedParameterTypeNames = new HashSet<QName>();
        for (String serviceName : this.definition.getServices().keySet()) {
            File outputDirectoryF = new File(this.configuration.getOutputDirectory());
            FileObject outputDirectoryFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)outputDirectoryF));
            FileObject outputFileDirectoryFO = outputDirectoryFO.getFileObject(this.configuration.getPackageName().replace('.', '/'));
            FileObject outputFile = outputFileDirectoryFO.getFileObject(serviceName, "java");
            if (outputFile == null) {
                outputFile = outputFileDirectoryFO.createData(serviceName, "java");
            }
            OutputFileFormatter off = new OutputFileFormatter(outputFile);
            Service service = this.definition.getService(serviceName);
            if (this.configuration.getPackageName() != null && !"".equals(this.configuration.getPackageName().trim())) {
                off.write("package " + this.configuration.getPackageName() + ";\t\t");
            }
            off.write("\n");
            off.write("import javax.xml.namespace.QName;\n");
            off.write("\n");
            off.write("public interface " + serviceName + " extends java.rmi.Remote {\n");
            for (Port port : service.getPorts()) {
                for (ExtensibilityElement ee : port.getExtensibilityElements()) {
                    if (!SOAPConstants.ADDRESS.equals(ee.getElementType())) continue;
                    PortType portType = port.getBinding().getPortType();
                    for (Operation operation : portType.getOperations()) {
                        String operationDocumentation = operation.getDocumentation();
                        if (operationDocumentation == null) {
                            operationDocumentation = "";
                        }
                        off.write("\n/**\n * " + operationDocumentation + "\n*/\n");
                        Output output = operation.getOutput();
                        if (output != null) {
                            Iterator<Part> i$ = output.getMessage().getParts().iterator();
                            if (i$.hasNext()) {
                                Part part = i$.next();
                                Element re = this.definition.getSchemaHolder().getSchemaElement(part.getElementName());
                                Element e = this.getReturnElement(re);
                                if (this.isElementComplex(e)) {
                                    usedTypes.add(e.getName());
                                    usedReturnTypeNames.add(re.getName());
                                }
                                String javaTypeName = this.getJavaTypeName(e);
                                off.write("public " + javaTypeName + " ");
                            }
                        } else {
                            off.write("public void ");
                        }
                        off.write(operation.getJavaName() + "(");
                        Input input = operation.getInput();
                        if (input != null) {
                            for (Part part : input.getMessage().getParts()) {
                                Element element = this.definition.getSchemaHolder().getSchemaElement(part.getElementName());
                                List<Element> params = this.getParameterElements(element);
                                Iterator<Element> it = params.iterator();
                                while (it.hasNext()) {
                                    Element e = it.next();
                                    if (this.isElementComplex(e)) {
                                        usedTypes.add(e.getName());
                                        usedParameterTypeNames.add(e.getName());
                                    }
                                    Type type = e.getType();
                                    String javaTypeName = this.getJavaTypeName(e);
                                    off.write(javaTypeName + " " + e.getName().getLocalPart());
                                    if (!it.hasNext()) continue;
                                    off.write(", ");
                                }
                            }
                        }
                        off.write(") throws java.rmi.RemoteException;\n");
                    }
                }
            }
            off.write("\n}\n");
            off.close();
        }
        for (QName typeName : usedParameterTypeNames) {
            this.usedParameterTypes.addAll(this.traverseTypes(usedParameterTypeNames, typeName));
        }
        for (QName typeName : usedReturnTypeNames) {
            this.usedReturnTypes.addAll(this.traverseTypes(usedParameterTypeNames, typeName));
        }
    }

    private String getWrapperTypeName(Type type) {
        QName typeName = type.getName();
        if (SchemaConstants.TYPE_INT.equals(typeName)) {
            return "Integer";
        }
        if (SchemaConstants.TYPE_BOOLEAN.equals(typeName)) {
            return "Boolean";
        }
        if (SchemaConstants.TYPE_BYTE.equals(typeName)) {
            return "Byte";
        }
        if (SchemaConstants.TYPE_DOUBLE.equals(typeName)) {
            return "Double";
        }
        if (SchemaConstants.TYPE_FLOAT.equals(typeName)) {
            return "Float";
        }
        if (SchemaConstants.TYPE_LONG.equals(typeName)) {
            return "Long";
        }
        if (SchemaConstants.TYPE_SHORT.equals(typeName)) {
            return "Short";
        }
        if (SchemaConstants.TYPE_BASE64_BINARY.equals(typeName)) {
            return "byte[]";
        }
        if (SchemaConstants.TYPE_HEX_BINARY.equals(typeName)) {
            return "byte[]";
        }
        if (SchemaConstants.TYPE_STRING.equals(typeName)) {
            return "String";
        }
        return type.getName().getLocalPart();
    }

    public Set<QName> traverseTypes(Set<QName> types, QName typeName) {
        HashSet<QName> result = new HashSet<QName>();
        result.add(typeName);
        Element element = this.definition.getSchemaHolder().getSchemaElement(typeName);
        Type type = element.getType();
        if (type == null) {
            throw new IllegalArgumentException("Invalid element type.");
        }
        if (1 == type.getFlavor()) {
            for (SchemaConstruct sc : type.getSubconstructs()) {
                Element sce;
                if (SchemaConstruct.ConstructType.ELEMENT != sc.getConstructType() || 1 != (sce = (Element)sc).getType().getFlavor()) continue;
                result.add(sce.getName());
                result.addAll(this.traverseTypes(types, sce.getName()));
            }
        }
        return result;
    }

    private Set<QName> getUsedTypes(QName typeName) {
        HashSet<QName> result = new HashSet<QName>();
        Element element = this.definition.getSchemaHolder().getSchemaElement(typeName);
        Type type = null;
        type = element == null ? this.definition.getSchemaHolder().getSchemaType(typeName) : element.getType();
        if (3 == type.getFlavor()) {
            return result;
        }
        if (1 == type.getFlavor()) {
            result.add(type.getName());
            SchemaConstruct parent = type.getParent();
            if (parent != null) {
                result.addAll(this.getUsedTypes(parent.getName()));
            }
            for (SchemaConstruct sc : type.getSubconstructs()) {
                Element sce;
                if (SchemaConstruct.ConstructType.ELEMENT != sc.getConstructType() || 1 != (sce = (Element)sc).getType().getFlavor()) continue;
                result.addAll(this.getUsedTypes(sce.getName()));
            }
        }
        return result;
    }

    private void generateTypes() throws Exception {
        Element e;
        HashSet<Element> usedArrayTypes = new HashSet<Element>();
        for (QName type : this.usedReturnTypes) {
            e = this.getReturnElement(this.definition.getSchemaHolder().getSchemaElement(type));
            usedArrayTypes.addAll(this.generateType(e));
        }
        for (QName type : this.usedParameterTypes) {
            e = this.definition.getSchemaHolder().getSchemaElement(type);
            usedArrayTypes.addAll(this.generateType(e));
        }
        if (this.configuration.getGenerateDataBinding()) {
            this.generateDataBindingArrays(usedArrayTypes);
        }
    }

    private Set<Element> generateType(Element element) throws Exception {
        boolean isArray;
        String propertyType;
        String propertyVariableName;
        String propertyName;
        Element sce;
        Type parentType;
        HashSet<Element> arrayTypes = new HashSet<Element>();
        Type type = element.getType();
        if (type == null) {
            throw new IllegalArgumentException("Invalid element type.");
        }
        if (3 == type.getFlavor()) {
            return arrayTypes;
        }
        String name = type.getName() == null ? element.getName().getLocalPart() : type.getName().getLocalPart();
        File outputDirectoryF = new File(this.configuration.getOutputDirectory());
        FileObject outputDirectoryFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)outputDirectoryF));
        FileObject outputFileDirectoryFO = outputDirectoryFO.getFileObject(this.configuration.getPackageName().replace('.', '/'));
        FileObject outputFile = outputFileDirectoryFO.getFileObject(name, "java");
        if (outputFile == null) {
            outputFile = outputFileDirectoryFO.createData(name, "java");
        }
        OutputFileFormatter off = new OutputFileFormatter(outputFile);
        if (this.configuration.getPackageName() != null && !"".equals(this.configuration.getPackageName().trim())) {
            off.write("package " + this.configuration.getPackageName() + ";\n");
        }
        off.write("\n");
        off.write("import javax.xml.namespace.QName;\n");
        if (this.configuration.getGenerateDataBinding()) {
            off.write("import org.netbeans.microedition.databinding.DataSet;\n");
            off.write("import org.netbeans.microedition.databinding.DataBindingException;\n");
            off.write("\n");
            if (type.getParent() == null) {
                off.write("public class " + name + " implements DataSet {\n");
            } else {
                parentType = this.definition.getSchemaHolder().getSchemaType(type.getParent().getName());
                String string = parentType.getName().getLocalPart();
                off.write("public class " + name + " extends " + string + " implements DataSet {\n");
            }
        } else if (type.getParent() == null) {
            off.write("public class " + name + " {\n");
        } else {
            parentType = this.definition.getSchemaHolder().getSchemaType(type.getParent().getName());
            String string = parentType.getName().getLocalPart();
            off.write("public class " + name + " extends " + string + " {\n");
        }
        for (Element element2 : this.getElements(type)) {
            if (SchemaConstruct.ConstructType.ELEMENT != element2.getConstructType()) continue;
            sce = element2;
            sce = this.getSimplifiedElement(sce);
            propertyName = this.getPropertyName(sce);
            propertyVariableName = propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1);
            propertyType = this.getPropertyType(sce);
            boolean bl = isArray = sce.getMaxOccurs() > 1;
            if (3 == sce.getType().getFlavor()) {
                propertyType = sce.getMinOccurs() == 0 || sce.isNillable() ? this.getWrapperTypeName(sce.getType()) : sce.getType().getJavaTypeName();
            }
            if (1 == this.configuration.getGenerateType()) {
                off.write("\n");
                if (!this.configuration.getGenerateDataBinding()) {
                    off.write("private " + propertyType + (isArray ? "[] " : " ") + propertyVariableName + ";\n");
                } else if (!isArray) {
                    off.write("private " + propertyType + " " + propertyVariableName + ";\n");
                } else {
                    off.write("private " + propertyType + "ArrayItem " + propertyVariableName + "_array_item = " + "new " + propertyType + "ArrayItem();\n");
                }
                off.write("\n");
                off.write("public void " + this.setter(propertyName) + "( " + propertyType + (isArray ? "[] " : " ") + propertyVariableName + " ) {\n");
                if (isArray && this.configuration.getGenerateDataBinding()) {
                    off.write(propertyVariableName + "_array_item.setArray(" + propertyVariableName + ");\n");
                } else {
                    off.write("this." + propertyVariableName + " = " + propertyVariableName + ";\n");
                }
                off.write("}\n\n");
                off.write("public " + propertyType + (isArray ? "[] " : " ") + this.getter(propertyName) + "() {\n");
                if (isArray && this.configuration.getGenerateDataBinding()) {
                    off.write("return " + propertyVariableName + "_array_item.getArray();\n");
                } else {
                    off.write("return " + propertyVariableName + ";\n");
                }
                off.write("}\n");
            } else if (2 == this.configuration.getGenerateType()) {
                off.write("\n");
                off.write("public " + propertyType + (isArray ? "[] " : " ") + propertyVariableName + ";\n");
            }
            if (sce.getMaxOccurs() <= 1) continue;
            arrayTypes.add(sce);
        }
        off.write("\n");
        if (this.configuration.getGenerateDataBinding()) {
            off.write("public Class getType(String dataItemName) {\n");
            for (SchemaConstruct schemaConstruct : type.getSubconstructs()) {
                if (SchemaConstruct.ConstructType.ELEMENT != schemaConstruct.getConstructType()) continue;
                sce = this.getSimplifiedElement((Element)schemaConstruct);
                propertyName = sce.getName().getLocalPart();
                propertyVariableName = propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1);
                propertyType = sce.getType().getName().getLocalPart();
                boolean bl = isArray = sce.getMaxOccurs() > 1;
                if (3 == sce.getType().getFlavor()) {
                    propertyType = this.getWrapperTypeName(sce.getType());
                }
                off.write("if( \"" + propertyVariableName + "\".equals(dataItemName)) {\n");
                if (isArray) {
                    off.write("return org.netbeans.microedition.databinding.IndexableDataSet.class;\n");
                } else {
                    off.write("return " + propertyType + ".class;\n");
                }
                off.write("}\n");
            }
            off.write("throw new IllegalArgumentException( \"Invalid data item name \" + dataItemName );\n");
            off.write("}\n");
            off.write("\n");
            off.write("public Object getValue(String dataItemName) {\n");
            for (SchemaConstruct schemaConstruct : type.getSubconstructs()) {
                if (SchemaConstruct.ConstructType.ELEMENT != schemaConstruct.getConstructType()) continue;
                sce = this.getSimplifiedElement((Element)schemaConstruct);
                propertyName = sce.getName().getLocalPart();
                propertyVariableName = propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1);
                off.write("if( \"" + propertyVariableName + "\".equals(dataItemName)) {\n");
                if (sce.getMaxOccurs() > 1) {
                    off.write("return " + propertyVariableName + "_array_item;\n");
                } else {
                    off.write("return " + this.wrapPrimitiveType(sce.getType(), propertyVariableName) + ";\n");
                }
                off.write("}\n");
            }
            off.write("throw new IllegalArgumentException( \"Invalid data item name \" + dataItemName );\n");
            off.write("}\n");
            off.write("\n");
            off.write("public void setValue(String dataItemName, Object value) throws DataBindingException {\n");
            for (SchemaConstruct schemaConstruct : type.getSubconstructs()) {
                if (SchemaConstruct.ConstructType.ELEMENT != schemaConstruct.getConstructType()) continue;
                sce = this.getSimplifiedElement((Element)schemaConstruct);
                propertyName = sce.getName().getLocalPart();
                propertyVariableName = propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1);
                propertyType = sce.getType().getName().getLocalPart();
                if (sce.getMaxOccurs() > 1) continue;
                off.write("if( \"" + propertyVariableName + "\".equals(dataItemName)) {\n");
                if (3 == sce.getType().getFlavor()) {
                    off.write(propertyVariableName + " = " + this.unwrapPrimitiveType(sce, " value") + ";\n");
                } else {
                    off.write(propertyVariableName + " = (" + propertyType + ") value;\n");
                }
                off.write("}\n");
            }
            off.write("}\n");
            off.write("\n");
            off.write("public void setAsString(String dataItemName, String value) throws DataBindingException {\n");
            for (SchemaConstruct schemaConstruct : type.getSubconstructs()) {
                if (SchemaConstruct.ConstructType.ELEMENT != schemaConstruct.getConstructType()) continue;
                sce = this.getSimplifiedElement((Element)schemaConstruct);
                propertyName = sce.getName().getLocalPart();
                propertyVariableName = propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1);
                if (sce.getMaxOccurs() > 1) continue;
                off.write("if( \"" + propertyVariableName + "\".equals(dataItemName)) {\n");
                if (3 == sce.getType().getFlavor()) {
                    off.write(propertyVariableName + " = " + this.parsePrimitiveType(sce, "value") + ";\n");
                } else {
                    off.write("throw new DataBindingException( \"Illegal assigment.\");\n");
                }
                off.write("}\n");
            }
            off.write("}\n");
            off.write("\n");
            off.write("public boolean isReadOnly(String dataItemName) {\n");
            off.write("return false;\n");
            off.write("}\n");
        }
        off.write("}\n");
        off.close();
        return arrayTypes;
    }

    private String getPropertyName(Element e) {
        QName propertyQName = e.getName();
        if (propertyQName == null && e.getType().getFlavor() == 1 && e.getType().getSubconstructs().size() == 1) {
            propertyQName = ((Element)e.getType().getSubconstructs().get(0)).getName();
            if (propertyQName != null) {
                return propertyQName.getLocalPart();
            }
            throw new IllegalStateException("Cannot get name for element.");
        }
        return propertyQName.getLocalPart();
    }

    private String getPropertyType(Element e) {
        QName propertyQName = e.getType().getName();
        if (propertyQName == null && e.getType().getFlavor() == 1) {
            if (e.getType().getSubconstructs().size() == 1) {
                propertyQName = ((Element)e.getType().getSubconstructs().get(0)).getType().getName();
                if (propertyQName != null) {
                    return propertyQName.getLocalPart();
                }
                throw new IllegalStateException("Cannot get name for element.");
            }
            return this.getSimplifiedElement(e).getName().getLocalPart();
        }
        return propertyQName.getLocalPart();
    }

    private Element getSimplifiedElement(Element e) {
        SchemaConstruct sc;
        Element result = e;
        if (e.getType().getFlavor() == 1 && e.getType().getSubconstructs().size() == 1 && (sc = e.getType().getSubconstructs().get(0)).getConstructType() == SchemaConstruct.ConstructType.ELEMENT) {
            result = this.getSimplifiedElement((Element)sc);
        }
        return result;
    }

    private void generateDataBindingArrays(Set<Element> types) throws Exception {
        for (Element element : types) {
            Type type = element.getType();
            if (type == null) {
                throw new IllegalArgumentException("Invalid element type.");
            }
            String typeName = "";
            typeName = 3 == type.getFlavor() ? type.getJavaTypeName() : (type.getName() == null ? element.getName().getLocalPart() : type.getName().getLocalPart());
            String name = typeName + "ArrayItem";
            File outputDirectoryF = new File(this.configuration.getOutputDirectory());
            FileObject outputDirectoryFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)outputDirectoryF));
            FileObject outputFileDirectoryFO = outputDirectoryFO.getFileObject(this.configuration.getPackageName().replace('.', '/'));
            FileObject outputFile = outputFileDirectoryFO.getFileObject(name, "java");
            if (outputFile == null) {
                outputFile = outputFileDirectoryFO.createData(name, "java");
            }
            OutputFileFormatter off = new OutputFileFormatter(outputFile);
            if (this.configuration.getPackageName() != null && !"".equals(this.configuration.getPackageName().trim())) {
                off.write("package " + this.configuration.getPackageName() + ";\n");
            }
            off.write("\n");
            off.write("import org.netbeans.microedition.databinding.IndexableDataSet;\n");
            off.write("import org.netbeans.microedition.databinding.DataBinder;\n");
            off.write("import org.netbeans.microedition.databinding.DataBindingException;\n");
            off.write("\n");
            if (type.getParent() == null) {
                off.write("public class " + name + " implements IndexableDataSet {\n");
            } else {
                Type parentType = this.definition.getSchemaHolder().getSchemaType(type.getParent().getName());
                String parentName = parentType.getName().getLocalPart();
                off.write("public class " + name + " extends " + parentName + " implements IndexableDataSet {\n");
            }
            off.write("\n");
            off.write("private " + typeName + "[] values = new " + typeName + "[] {};\n");
            off.write("\n");
            off.write("/**\n");
            off.write(" * Public default constructor for class " + name + "\n");
            off.write(" */\n");
            off.write("public " + name + "() {\n");
            off.write("}\n");
            off.write("\n");
            off.write("public " + name + "( " + typeName + "[] values ) {\n");
            off.write("this.values = values;\n");
            off.write("}\n");
            off.write("\n");
            off.write("public boolean isReadOnly() {\n");
            off.write("return false;\n");
            off.write("}\n");
            off.write("\n");
            off.write("public int getSize() {\n");
            off.write("return values.length;\n");
            off.write("}\n");
            off.write("\n");
            off.write("public Object getRow(int index) throws DataBindingException {\n");
            off.write("if(index >=0 && index < values.length) {\n");
            if (type.getFlavor() == 3) {
                off.write("return " + this.wrapPrimitiveType(type, "values[index]") + ";\n");
            } else {
                off.write("return values[index];\n");
            }
            off.write("}\n");
            off.write("throw new DataBindingException(\"Index is out of range.\");\n");
            off.write("}\n");
            off.write("\n");
            off.write("public void setRow( int index, Object value ) throws DataBindingException {\n");
            off.write("if( index >=0 && index < values.length ) {\n");
            if (type.getFlavor() == 3) {
                if (element == null) {
                    off.write("values[index] = " + this.unwrapPrimitiveType(type, "value") + ";\n");
                } else {
                    off.write("values[index] = " + this.unwrapPrimitiveType(element, "value") + ";\n");
                }
            } else {
                off.write("values[index] = (" + typeName + ") value;\n");
            }
            off.write("DataBinder.fireDataSetChanged( this, new Integer( index ));\n");
            off.write("}\n");
            off.write("throw new DataBindingException(\"Index is out of range.\");\n");
            off.write("}\n");
            off.write("\n");
            off.write("public void insertRow(int index, Object value) throws DataBindingException {\n");
            off.write("if( index >= 0 && index <= values.length ) {\n");
            off.write(typeName + " _newArray[] = new " + typeName + "[values.length + 1];\n");
            off.write("if( index > 1 ) System.arraycopy(values, 0, _newArray, 0, index - 1 );\n");
            off.write("if( index < values.length ) System.arraycopy(values, index, _newArray, index + 1, values.length - index );\n");
            off.write("_newArray[index] = (" + typeName + ")value;\n");
            off.write("values = _newArray;\n");
            off.write("DataBinder.fireDataSetChanged( this, new Integer( index ));");
            off.write("}\n");
            off.write("}\n");
            off.write("\n");
            off.write("public void deleteRow(int index) throws DataBindingException {\n");
            off.write("if( index >= 0 && index < values.length ) {\n");
            off.write(typeName + " _newArray[] = new " + typeName + "[values.length - 1];\n");
            off.write("if(index > 0) System.arraycopy(values, 0, _newArray, 0, index - 1);\n");
            off.write("if(index == 0) System.arraycopy(values, index + 1, _newArray, index, values.length - index - 1 );\n");
            off.write("}\n");
            off.write("DataBinder.fireDataSetChanged( this, new Integer( index ));");
            off.write("}\n");
            off.write("\n");
            off.write("public Class getType( String arg0 ) throws DataBindingException {\n");
            off.write("return " + typeName + ".class;\n");
            off.write("}\n");
            off.write("\n");
            off.write("public Object getValue(String attribute) throws DataBindingException {\n");
            off.write("if( \"length\".equals( attribute )) {\n");
            off.write("return new Integer( values.length );\n");
            off.write("}\n");
            off.write("throw new DataBindingException( \"Invalid attribute name.\" );\n");
            off.write("}\n");
            off.write("\n");
            off.write("public void setValue(String attribute, Object value) throws DataBindingException {\n");
            off.write("throw new DataBindingException(\"Invalid attribute name.\");\n");
            off.write("}\n");
            off.write("\n");
            off.write("public void setAsString(String attribute, String value) throws DataBindingException {\n");
            off.write("throw new DataBindingException(\"Invalid attribute name.\");\n");
            off.write("}\n");
            off.write("\n");
            off.write("public boolean isReadOnly(String attribute) throws DataBindingException {\n");
            off.write("return true;\n");
            off.write("}\n");
            off.write(typeName + "[] getArray() {\n");
            off.write("return values;\n");
            off.write("}\n");
            off.write("\n");
            off.write("void setArray(" + typeName + " values[] ) {\n");
            off.write("this.values = values;\n");
            off.write("}\n");
            off.write("}\n");
            off.close();
        }
    }

    private void generateStub() throws Exception {
        this.usedParameterTypes = new HashSet<QName>();
        HashSet<QName> primitiveTypeArrays = new HashSet<QName>();
        HashSet<QName> operationQNames = new HashSet<QName>();
        for (String serviceName : this.definition.getServices().keySet()) {
            Service service = this.definition.getService(serviceName);
            for (Port port : service.getPorts()) {
                for (ExtensibilityElement ee : port.getExtensibilityElements()) {
                    Element sc;
                    Element e;
                    Element e2;
                    if (!SOAPConstants.ADDRESS.equals(ee.getElementType())) continue;
                    SOAPAddress soapAddress = (SOAPAddress)ee;
                    File outputDirectoryF = new File(this.configuration.getOutputDirectory());
                    FileObject outputDirectoryFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)outputDirectoryF));
                    FileObject outputFileDirectoryFO = outputDirectoryFO.getFileObject(this.configuration.getPackageName().replace('.', '/'));
                    FileObject outputFile = outputFileDirectoryFO.getFileObject(serviceName + "_Stub", "java");
                    if (outputFile == null) {
                        outputFile = outputFileDirectoryFO.createData(serviceName + "_Stub", "java");
                    }
                    OutputFileFormatter off = new OutputFileFormatter(outputFile);
                    if (this.configuration.getPackageName() != null && !"".equals(this.configuration.getPackageName().trim())) {
                        off.write("package " + this.configuration.getPackageName() + ";\n");
                    }
                    off.write("\n");
                    off.write("import javax.xml.rpc.JAXRPCException;\n");
                    off.write("import javax.xml.namespace.QName;\n");
                    off.write("import javax.microedition.xml.rpc.Operation;\n");
                    off.write("import javax.microedition.xml.rpc.Type;\n");
                    off.write("import javax.microedition.xml.rpc.ComplexType;\n");
                    off.write("import javax.microedition.xml.rpc.Element;\n\n");
                    off.write("public class " + serviceName + "_Stub implements " + serviceName + ", javax.xml.rpc.Stub {\n");
                    off.write("\n");
                    off.write("private String[] _propertyNames;\n");
                    off.write("private Object[] _propertyValues;\n");
                    off.write("\n");
                    off.write("public " + serviceName + "_Stub() {\n");
                    off.write("_propertyNames = new String[] { ENDPOINT_ADDRESS_PROPERTY };\n");
                    off.write("_propertyValues = new Object[] { \"" + soapAddress.getLocationURI() + "\" };\n");
                    off.write("}\n\n");
                    off.write("public void _setProperty( String name, Object value ) {\n");
                    off.write("int size = _propertyNames.length;\n");
                    off.write("for (int i = 0; i < size; ++i) {\n");
                    off.write("if( _propertyNames[i].equals( name )) {\n");
                    off.write("_propertyValues[i] = value;\n");
                    off.write("return;\n");
                    off.write("}\n");
                    off.write("}\n");
                    off.write("String[] newPropNames = new String[size + 1];\n");
                    off.write("System.arraycopy(_propertyNames, 0, newPropNames, 0, size);\n");
                    off.write("_propertyNames = newPropNames;\n");
                    off.write("Object[] newPropValues = new Object[size + 1];\n");
                    off.write("System.arraycopy(_propertyValues, 0, newPropValues, 0, size);\n");
                    off.write("_propertyValues = newPropValues;\n");
                    off.write("\n");
                    off.write("_propertyNames[size] = name;\n");
                    off.write("_propertyValues[size] = value;\n");
                    off.write("}\n\n");
                    off.write("public Object _getProperty(String name) {\n");
                    off.write("for (int i = 0; i < _propertyNames.length; ++i) {\n");
                    off.write("if (_propertyNames[i].equals(name)) {\n");
                    off.write("return _propertyValues[i];\n");
                    off.write("}\n");
                    off.write("}\n");
                    off.write("if (ENDPOINT_ADDRESS_PROPERTY.equals(name) || USERNAME_PROPERTY.equals(name) || PASSWORD_PROPERTY.equals(name)) {\n");
                    off.write("return null;\n");
                    off.write("}\n");
                    off.write("if (SESSION_MAINTAIN_PROPERTY.equals(name)) {\n");
                    off.write("return new Boolean(false);\n");
                    off.write("}\n");
                    off.write("throw new JAXRPCException(\"Stub does not recognize property: \" + name);\n");
                    off.write("}\n\n");
                    off.write("protected void _prepOperation(Operation op) {\n");
                    off.write("for (int i = 0; i < _propertyNames.length; ++i) {\n");
                    off.write("op.setProperty(_propertyNames[i], _propertyValues[i].toString());\n");
                    off.write("}\n");
                    off.write("}\n");
                    Binding binding = port.getBinding();
                    PortType portType = binding.getPortType();
                    String returnTypeName = "";
                    String paramTypeName = "";
                    HashSet<Element> fromObjects = new HashSet<Element>();
                    HashSet<Element> toObjects = new HashSet<Element>();
                    for (Operation operation : portType.getOperations()) {
                        Iterator<Part> i$;
                        BindingOperation bindingOperation = binding.getBindingOperation(operation.getName());
                        operationQNames.add(new QName(this.definition.getTargetNamespace(), operation.getName()));
                        QName messageName = operation.getOutput().getMessage().getQName();
                        Message message = this.definition.getMessage(messageName);
                        Iterator<Part> i$2 = message.getParts().iterator();
                        if (i$2.hasNext()) {
                            Part part = i$2.next();
                            Element element = this.definition.getSchemaHolder().getSchemaElement(part.getElementName());
                            returnTypeName = element.getName().getLocalPart();
                            e2 = this.getReturnElement(element);
                            String javaTypeName = this.getJavaTypeName(e2);
                            off.write("\n");
                            off.write("public " + javaTypeName + " ");
                            this.usedParameterTypes.add(element.getName());
                        }
                        off.write(operation.getJavaName() + "(");
                        Input input = operation.getInput();
                        if (input != null) {
                            for (Part part : input.getMessage().getParts()) {
                                Element element = this.definition.getSchemaHolder().getSchemaElement(part.getElementName());
                                paramTypeName = element.getName().getLocalPart();
                                this.usedParameterTypes.add(element.getName());
                                List<Element> params = this.getParameterElements(element);
                                Iterator<Element> it = params.iterator();
                                while (it.hasNext()) {
                                    Element e3 = it.next();
                                    Type type = e3.getType();
                                    String javaTypeName = this.getJavaTypeName(e3);
                                    off.write(javaTypeName + " " + e3.getName().getLocalPart());
                                    if (!it.hasNext()) continue;
                                    off.write(", ");
                                }
                            }
                        }
                        off.write(") throws java.rmi.RemoteException {\n");
                        for (Part part : input.getMessage().getParts()) {
                            e2 = this.definition.getSchemaHolder().getSchemaElement(part.getElementName());
                            Type type = e2.getType();
                            if (3 == type.getFlavor()) {
                                if (e2.isNillable() || e2.getMinOccurs() == 0) {
                                    off.write("Object inputObject = " + e2.getName().getLocalPart() + ";\n");
                                    continue;
                                }
                                off.write("Object inputObject = " + this.wrapPrimitiveType(type, e2.getName().getLocalPart()) + ";\n");
                                continue;
                            }
                            if (1 != type.getFlavor()) continue;
                            off.write("Object inputObject[] = new Object[] {\n");
                            Iterator<SchemaConstruct> scit = type.getSubconstructs().iterator();
                            while (scit.hasNext()) {
                                SchemaConstruct sc2 = scit.next();
                                if (!SchemaConstruct.ConstructType.ELEMENT.equals((Object)sc2.getConstructType())) continue;
                                Element sce = (Element)sc2;
                                boolean isArray = sce.getMaxOccurs() > 1;
                                Type t = sce.getType();
                                if (3 == t.getFlavor()) {
                                    if (!isArray) {
                                        if (sce.isNillable() || sce.getMinOccurs() == 0) {
                                            off.write(sce.getName().getLocalPart());
                                        } else {
                                            off.write(this.wrapPrimitiveType(t, sce.getName().getLocalPart()));
                                        }
                                    } else if (sce.isNillable() || sce.getMinOccurs() == 0) {
                                        off.write(sce.getName().getLocalPart());
                                    } else {
                                        off.write(sce.getName().getLocalPart());
                                    }
                                } else if (1 == t.getFlavor()) {
                                    String typeName = sce.getType().getJavaName();
                                    if (typeName == null) {
                                        typeName = sce.getType().getName() == null ? sce.getName().getLocalPart() : sce.getType().getName().getLocalPart();
                                    }
                                    off.write(typeName + "_" + (isArray ? "Array" : "") + "toObject( " + sce.getName().getLocalPart() + " )");
                                    toObjects.add(sce);
                                }
                                if (scit.hasNext()) {
                                    off.write(", ");
                                }
                                off.write("\n");
                            }
                            off.write("};\n");
                        }
                        off.write("\n");
                        off.write("Operation op = Operation.newInstance( _qname_operation_" + operation.getName() + ", _type_" + paramTypeName + ", _type_" + returnTypeName + " );\n");
                        off.write("_prepOperation( op );\n");
                        for (ExtensibilityElement exe : bindingOperation.getExtensibilityElements()) {
                            SOAPOperation so;
                            if (!(exe instanceof SOAPOperation) || (so = (SOAPOperation)exe).getSoapActionURI() == null) continue;
                            off.write("op.setProperty( Operation.SOAPACTION_URI_PROPERTY, \"");
                            off.write(so.getSoapActionURI());
                            off.write("\" );\n");
                        }
                        off.write("Object resultObj;\n");
                        off.write("try {\n");
                        off.write("resultObj = op.invoke( inputObject );\n");
                        off.write("} catch( JAXRPCException e ) {\n");
                        off.write("Throwable cause = e.getLinkedCause();\n");
                        off.write("if( cause instanceof java.rmi.RemoteException ) {\n");
                        off.write("throw (java.rmi.RemoteException) cause;\n");
                        off.write("}\n");
                        off.write("throw e;\n");
                        off.write("}\n");
                        off.write("\n");
                        Output output = operation.getOutput();
                        if (output != null && (i$ = (message = this.definition.getMessage(output.getMessage().getQName())).getParts().iterator()).hasNext()) {
                            boolean isArray;
                            Part part = i$.next();
                            e = this.getReturnElement(this.definition.getSchemaHolder().getSchemaElement(part.getElementName()));
                            Type type = e.getType();
                            boolean bl = isArray = e.getMaxOccurs() > 1;
                            if (3 == type.getFlavor()) {
                                if (!isArray) {
                                    off.write("return " + this.unwrapPrimitiveType(e, "((Object[])resultObj)[0]") + ";\n");
                                } else if (!e.isNillable() && e.getMinOccurs() != 0) {
                                    off.write("return " + type.getJavaTypeName().replace('.', '_') + "_ArrayfromObject((Object []) resultObj);\n");
                                } else if (SchemaConstants.TYPE_STRING.equals(type.getName())) {
                                    off.write("String[] _res = new String[((Object [])((Object []) resultObj)[0]).length];\n");
                                    off.write("System.arraycopy(((Object []) resultObj)[0], 0, _res, 0, _res.length);\n");
                                    off.write("return _res;\n");
                                } else {
                                    off.write("return " + this.unwrapPrimitiveType(e, "((Object[])resultObj)[0]") + ";\n");
                                }
                            } else if (1 == type.getFlavor() && type.getSubconstructs().size() != 0) {
                                String typeName = e.getType().getJavaTypeName();
                                if (typeName == null) {
                                    String string = typeName = e.getType().getName() == null ? e.getName().getLocalPart() : e.getType().getName().getLocalPart();
                                }
                                if (!isArray) {
                                    off.write("return " + typeName.replace('.', '_') + "_fromObject((Object[])resultObj);\n");
                                } else {
                                    off.write("return " + typeName.replace('.', '_') + "_ArrayfromObject((Object[]) resultObj);\n");
                                }
                                fromObjects.add(e);
                            }
                        }
                        off.write("}\n");
                    }
                    HashSet<SchemaConstruct> to = new HashSet<SchemaConstruct>();
                    for (Element e4 : toObjects) {
                        to.addAll(this.traverseObjectElements(this.getSimplifiedElement(e4), to));
                    }
                    HashSet<SchemaConstruct> from = new HashSet<SchemaConstruct>();
                    for (Element e5 : fromObjects) {
                        from.addAll(this.traverseObjectElements(this.getSimplifiedElement(e5), from));
                    }
                    HashSet<String> usedToMethods = new HashSet<String>();
                    for (SchemaConstruct sc3 : to) {
                        String resultVariableName;
                        String methodName;
                        String typeName = sc3.getName().getLocalPart();
                        boolean isA = false;
                        if (SchemaConstruct.ConstructType.ELEMENT.equals((Object)sc3.getConstructType())) {
                            Element e6 = (Element)sc3;
                            if (e6.getMaxOccurs() > 1) {
                                isA = true;
                            }
                            if (e6.getType().getName() != null) {
                                typeName = e6.getType().getName().getLocalPart();
                            }
                        }
                        if (usedToMethods.contains(methodName = typeName + "_" + (isA ? "Array" : "") + "toObject")) continue;
                        usedToMethods.add(methodName);
                        off.write("\n");
                        off.write("private static Object " + methodName + "( " + typeName + (isA ? "[]" : "") + " obj ) {\n");
                        off.write("if(obj == null) return null;\n");
                        Type type = null;
                        if (SchemaConstruct.ConstructType.ELEMENT.equals((Object)sc3.getConstructType())) {
                            e = (Element)sc3;
                            type = e.getType();
                        } else if (SchemaConstruct.ConstructType.TYPE.equals((Object)sc3.getConstructType())) {
                            type = (Type)sc3;
                        } else {
                            throw new InvalidParameterException("Invalid SchemaConstruct type");
                        }
                        String string = resultVariableName = isA ? "resultArray" : "result";
                        if (isA) {
                            off.write("Object result[] = new Object[ obj.length ];\n");
                            off.write("for( int i = 0; i < obj.length; i++ ) {\n");
                            off.write("Object[] " + resultVariableName + " = new Object[ " + type.getSubconstructs().size() + " ];\n");
                        } else {
                            off.write("Object result[] = new Object[ " + type.getSubconstructs().size() + " ];\n");
                        }
                        int i = 0;
                        for (Element sce : this.getElements(type)) {
                            Type t = sce.getType();
                            String variableName = sce.getName().getLocalPart();
                            boolean isArray = sce.getMaxOccurs() > 1;
                            off.write(resultVariableName + "[" + i + "] = ");
                            if (3 == t.getFlavor()) {
                                if (!isArray) {
                                    if (sce.isNillable() || sce.getMinOccurs() == 0 && sce.getMaxOccurs() == 1) {
                                        off.write("obj" + (isA ? "[i]" : "") + "." + this.getter(variableName) + "()");
                                    } else {
                                        off.write(this.wrapPrimitiveType(t, "obj" + (isA ? "[i]" : "") + "." + this.getter(variableName) + "()"));
                                    }
                                } else if (sce.isNillable()) {
                                    off.write("obj" + (isA ? "[i]" : "") + "." + this.getter(variableName) + "()");
                                } else {
                                    off.write("???");
                                }
                            } else if (1 == t.getFlavor()) {
                                String tn;
                                String string2 = tn = t.getName() == null ? sce.getName().getLocalPart() : t.getName().getLocalPart();
                                if (!isArray) {
                                    off.write(tn + "_toObject( obj" + (isA ? "[i]" : "") + "." + this.getter(variableName) + "())");
                                } else {
                                    off.write(tn + "_ArraytoObject( obj" + (isA ? "[i]" : "") + "." + this.getter(variableName) + "())");
                                }
                            }
                            off.write(";\n");
                            ++i;
                        }
                        if (isA) {
                            off.write("result[i] = " + resultVariableName + ";\n");
                            off.write("}\n");
                        }
                        off.write("return result;\n");
                        off.write("}\n");
                    }
                    HashSet<String> usedFromMethods = new HashSet<String>();
                    for (SchemaConstruct sc4 : from) {
                        String objectVariableName;
                        String methodName;
                        String typeName = sc4.getName().getLocalPart();
                        boolean isA = false;
                        if (SchemaConstruct.ConstructType.ELEMENT.equals((Object)sc4.getConstructType())) {
                            e2 = (Element)sc4;
                            if (e2.getMaxOccurs() > 1) {
                                isA = true;
                            }
                            typeName = e2.getType().getJavaTypeName();
                            typeName = this.getPropertyType(e2);
                        }
                        if (usedFromMethods.contains(methodName = typeName.replace('.', '_') + "_" + (isA ? "Array" : "") + "fromObject")) continue;
                        usedFromMethods.add(methodName);
                        off.write("\n");
                        off.write("private static " + typeName + (isA ? "[]" : "") + " " + methodName + "( Object obj[] ) {\n");
                        off.write("if(obj == null) return null;\n");
                        off.write(typeName + " result" + (isA ? "[]" : "") + " = new " + typeName + (isA ? "[obj.length]" : "()") + ";\n");
                        String string = objectVariableName = isA ? "oo" : "obj";
                        if (isA) {
                            off.write("for( int i = 0; i < obj.length; i++ ) {\n");
                            off.write("result[i] = new " + typeName + "();\n");
                            off.write("Object[] " + objectVariableName + " = (Object[]) obj[i];\n");
                        }
                        Type type = null;
                        if (SchemaConstruct.ConstructType.ELEMENT.equals((Object)sc4.getConstructType())) {
                            Element e7 = (Element)sc4;
                            type = e7.getType();
                        } else if (SchemaConstruct.ConstructType.TYPE.equals((Object)sc4.getConstructType())) {
                            type = (Type)sc4;
                        } else {
                            throw new InvalidParameterException("Invalid SchemaConstruct type");
                        }
                        int i = 0;
                        for (Element sce : this.getElements(type)) {
                            String tn;
                            boolean isArray;
                            Element e8 = this.getSimplifiedElement(sce);
                            Type t = e8.getType();
                            String variableName = this.getPropertyName(e8);
                            boolean bl = isArray = e8.getMaxOccurs() > 1;
                            if (3 == t.getFlavor()) {
                                tn = this.getPropertyType(e8);
                                if (!isArray) {
                                    off.write("result" + (isA ? "[i]" : "") + "." + this.setter(variableName) + "(" + this.unwrapPrimitiveType(sce, objectVariableName + "[" + i + "]") + ");\n");
                                } else if (SchemaConstants.TYPE_STRING.equals(t.getName())) {
                                    off.write("result" + (isA ? "[i]" : "") + "." + this.setter(variableName) + "((String[])" + objectVariableName + "[" + i + "]" + ");\n");
                                } else {
                                    primitiveTypeArrays.add(t.getName());
                                    off.write("result" + (isA ? "[i]" : "") + "." + this.setter(variableName) + "( Unroll_" + tn + "_Array((" + this.getWrapperTypeName(t) + "[]) " + objectVariableName + "[" + i + "]" + "));\n");
                                }
                            } else if (1 == t.getFlavor()) {
                                tn = this.getPropertyType(e8);
                                if (!isArray) {
                                    off.write("result" + (isA ? "[i]" : "") + "." + this.setter(variableName) + "(" + tn + "_fromObject((Object[]) " + objectVariableName + "[" + i + "] ));\n");
                                } else {
                                    off.write("result" + (isA ? "[i]" : "") + "." + this.setter(variableName) + "(" + tn + "_ArrayfromObject((Object[]) " + objectVariableName + "[" + i + "] ));\n");
                                }
                            }
                            ++i;
                        }
                        if (isA) {
                            off.write("}\n");
                        }
                        off.write("return result;\n");
                        off.write("}\n");
                    }
                    for (QName qn : primitiveTypeArrays) {
                        off.write("\n");
                        String typeName = null;
                        String wrapperName = null;
                        if (SchemaConstants.TYPE_INT.equals(qn)) {
                            typeName = "int";
                            wrapperName = "Integer";
                        } else if (SchemaConstants.TYPE_BOOLEAN.equals(qn)) {
                            typeName = "boolean";
                            wrapperName = "Boolean";
                        } else if (SchemaConstants.TYPE_BYTE.equals(qn)) {
                            typeName = "byte";
                            wrapperName = "Byte";
                        } else if (SchemaConstants.TYPE_DOUBLE.equals(qn)) {
                            typeName = "double";
                            wrapperName = "Double";
                        } else if (SchemaConstants.TYPE_FLOAT.equals(qn)) {
                            typeName = "float";
                            wrapperName = "Float";
                        } else if (SchemaConstants.TYPE_LONG.equals(qn)) {
                            typeName = "long";
                            wrapperName = "Long";
                        } else if (SchemaConstants.TYPE_SHORT.equals(qn)) {
                            typeName = "short";
                            wrapperName = "Short";
                        }
                        off.write("private static " + typeName + "[] Unroll_" + typeName + "_Array( " + wrapperName + " a[] ) {\n");
                        off.write(typeName + " result[] = new " + typeName + "[ a.length ];\n");
                        off.write("for( int i = 0; i < a.length; i++ ) {\n");
                        off.write("result[i] = a[i]." + typeName + "Value();\n");
                        off.write("}\n");
                        off.write("return result;\n");
                        off.write("}");
                        Integer a = 5;
                    }
                    HashSet<QName> qnames = new HashSet<QName>();
                    HashSet<Element> elements = new HashSet<Element>();
                    for (QName parameterName : this.usedParameterTypes) {
                        sc = this.definition.getSchemaHolder().getSchemaElement(parameterName);
                        if (sc == null) continue;
                        this.traverseParameterTypes(sc, qnames, elements);
                    }
                    off.write("\n");
                    for (QName q : operationQNames) {
                        off.write("protected static final QName ");
                        off.write("_qname_operation_" + q.getLocalPart() + " = new QName( ");
                        off.write('\"' + q.getNamespaceURI() + "\", \"" + q.getLocalPart() + "\" );\n");
                    }
                    for (QName q : qnames) {
                        off.write("protected static final QName ");
                        off.write("_qname_" + q.getLocalPart() + " = new QName( ");
                        off.write('\"' + q.getNamespaceURI() + "\", \"" + q.getLocalPart() + "\" );\n");
                    }
                    for (Element e9 : elements) {
                        off.write("protected static final Element _type_" + e9.getName().getLocalPart() + ";\n");
                    }
                    off.write("\nstatic {\n");
                    for (QName parameterName : this.usedParameterTypes) {
                        sc = this.definition.getSchemaHolder().getSchemaElement(parameterName);
                        off.write("_type_" + sc.getName().getLocalPart() + " = ");
                        this.initTypes(off, sc, qnames, elements);
                        off.write(";\n");
                    }
                    off.write("}\n\n");
                    off.write("private static ComplexType _complexType( Element[] elements ) {\n");
                    off.write("ComplexType result = new ComplexType();\n");
                    off.write("result.elements = elements;\n");
                    off.write("return result;\n");
                    off.write("}\n");
                    off.write("}\n");
                    off.close();
                }
            }
        }
    }

    public List<Element> getElements(Type type) {
        ArrayList<Element> elements = new ArrayList<Element>();
        if (type.getParent() != null) {
            elements.addAll(this.getElements((Type)type.getParent()));
        }
        for (SchemaConstruct sc : type.getSubconstructs()) {
            if (SchemaConstruct.ConstructType.ELEMENT != sc.getConstructType()) continue;
            Element e = (Element)sc;
            elements.add(e);
        }
        return elements;
    }

    private Set<SchemaConstruct> traverseObjectElements(SchemaConstruct schemaConstruct, Set<SchemaConstruct> elements) {
        HashSet<SchemaConstruct> result = new HashSet<SchemaConstruct>();
        if (result.contains(schemaConstruct)) {
            return Collections.emptySet();
        }
        elements.add(schemaConstruct);
        Type type = null;
        Element element = null;
        if (SchemaConstruct.ConstructType.ELEMENT.equals((Object)schemaConstruct.getConstructType())) {
            element = (Element)schemaConstruct;
            type = element.getType();
        } else if (SchemaConstruct.ConstructType.TYPE.equals((Object)schemaConstruct.getConstructType())) {
            type = (Type)schemaConstruct;
        } else {
            throw new InvalidParameterException("Invalid SchemaConstruct type");
        }
        if (3 == type.getFlavor()) {
            if (element != null && element.getMaxOccurs() > 1) {
                result.add(element);
                return result;
            }
        } else if (1 == type.getFlavor()) {
            for (SchemaConstruct sc : type.getSubconstructs()) {
                Element sce;
                Type scetype;
                if (!SchemaConstruct.ConstructType.ELEMENT.equals((Object)sc.getConstructType()) || 1 != (scetype = (sce = this.getSimplifiedElement((Element)sc)).getType()).getFlavor()) continue;
                elements.add(sce);
                result.addAll(this.traverseObjectElements(sce, elements));
            }
        }
        return result;
    }

    private String wrapPrimitiveType(Type type, String value) {
        QName typeName = type.getName();
        if (SchemaConstants.TYPE_INT.equals(typeName)) {
            return "new Integer(" + value + ")";
        }
        if (SchemaConstants.TYPE_BOOLEAN.equals(typeName)) {
            return "new Boolean(" + value + ")";
        }
        if (SchemaConstants.TYPE_BYTE.equals(typeName)) {
            return "new Byte(" + value + ")";
        }
        if (SchemaConstants.TYPE_DOUBLE.equals(typeName)) {
            return "new Double(" + value + ")";
        }
        if (SchemaConstants.TYPE_FLOAT.equals(typeName)) {
            return "new Float(" + value + ")";
        }
        if (SchemaConstants.TYPE_LONG.equals(typeName)) {
            return "new Long(" + value + ")";
        }
        if (SchemaConstants.TYPE_SHORT.equals(typeName)) {
            return "new Short(" + value + ")";
        }
        return value;
    }

    private String unwrapPrimitiveType(Type type, String value) {
        QName typeName = type.getName();
        if (SchemaConstants.TYPE_INT.equals(typeName)) {
            return "((Integer)" + value + ").intValue()";
        }
        if (SchemaConstants.TYPE_BOOLEAN.equals(typeName)) {
            return "((Boolean)" + value + ").booleanValue()";
        }
        if (SchemaConstants.TYPE_BYTE.equals(typeName)) {
            return "((Byte)" + value + ").byteValue()";
        }
        if (SchemaConstants.TYPE_DOUBLE.equals(typeName)) {
            return "((Double)" + value + ").doubleValue()";
        }
        if (SchemaConstants.TYPE_FLOAT.equals(typeName)) {
            return "((Float)" + value + ").floatValue()";
        }
        if (SchemaConstants.TYPE_LONG.equals(typeName)) {
            return "((Long)" + value + ").longValue()";
        }
        if (SchemaConstants.TYPE_SHORT.equals(typeName)) {
            return "((Short)" + value + ").shortValue()";
        }
        if (SchemaConstants.TYPE_STRING.equals(typeName)) {
            return "(String)" + value;
        }
        return value;
    }

    private String unwrapPrimitiveType(Element element, String value) {
        Type type = element.getType();
        QName typeName = type.getName();
        String unwrapped = "";
        if (element.getMaxOccurs() == Integer.MAX_VALUE) {
            unwrapped = "[]";
        }
        unwrapped = SchemaConstants.TYPE_INT.equals(typeName) ? "(Integer " + unwrapped + ")" : (SchemaConstants.TYPE_BOOLEAN.equals(typeName) ? "(Boolean " + unwrapped + ")" : (SchemaConstants.TYPE_BYTE.equals(typeName) ? "(Byte " + unwrapped + ")" : (SchemaConstants.TYPE_DOUBLE.equals(typeName) ? "(Double " + unwrapped + ")" : (SchemaConstants.TYPE_FLOAT.equals(typeName) ? "(Float " + unwrapped + ")" : (SchemaConstants.TYPE_LONG.equals(typeName) ? "(Long " + unwrapped + ")" : (SchemaConstants.TYPE_SHORT.equals(typeName) ? "(Short " + unwrapped + ")" : "(" + type.getJavaTypeName() + " " + unwrapped + ")"))))));
        unwrapped = unwrapped + value;
        if (element.getMinOccurs() > 0 && !element.isNillable()) {
            if (SchemaConstants.TYPE_INT.equals(typeName)) {
                unwrapped = "(" + unwrapped + ").intValue()";
            } else if (SchemaConstants.TYPE_BOOLEAN.equals(typeName)) {
                unwrapped = "(" + unwrapped + ").booleanValue()";
            } else if (SchemaConstants.TYPE_BYTE.equals(typeName)) {
                unwrapped = "(" + unwrapped + ").byteValue()";
            } else if (SchemaConstants.TYPE_DOUBLE.equals(typeName)) {
                unwrapped = "(" + unwrapped + ").doubleValue()";
            } else if (SchemaConstants.TYPE_FLOAT.equals(typeName)) {
                unwrapped = "(" + unwrapped + ").floatValue()";
            } else if (SchemaConstants.TYPE_LONG.equals(typeName)) {
                unwrapped = "(" + unwrapped + ").longValue()";
            } else if (SchemaConstants.TYPE_SHORT.equals(typeName)) {
                unwrapped = "(" + unwrapped + ").shortValue()";
            }
        }
        return unwrapped;
    }

    private String parsePrimitiveType(Element element, String value) {
        Type type = element.getType();
        QName typeName = type.getName();
        String parse = this.wrapPrimitiveType(type, value);
        if (element.getMinOccurs() > 0 && !element.isNillable()) {
            if (SchemaConstants.TYPE_INT.equals(typeName)) {
                parse = "Integer.parseInt(" + value + ")";
            } else if (SchemaConstants.TYPE_BOOLEAN.equals(typeName)) {
                parse = "value.equals( \"true\" ) ? true : false";
            } else if (SchemaConstants.TYPE_BYTE.equals(typeName)) {
                parse = "Byte.parseByte(" + value + ")";
            } else if (SchemaConstants.TYPE_DOUBLE.equals(typeName)) {
                parse = "Double.parseDouble(" + value + ")";
            } else if (SchemaConstants.TYPE_FLOAT.equals(typeName)) {
                parse = "Float.parseFloat(" + value + ")";
            } else if (SchemaConstants.TYPE_LONG.equals(typeName)) {
                parse = "Long.parseLong(" + value + ")";
            } else if (SchemaConstants.TYPE_SHORT.equals(typeName)) {
                parse = "Short.parseShort(" + value + ")";
            }
        }
        return parse;
    }

    private String getter(String variable) {
        return "get" + variable.substring(0, 1).toUpperCase() + variable.substring(1);
    }

    private String setter(String variable) {
        return "set" + variable.substring(0, 1).toUpperCase() + variable.substring(1);
    }

    private void initTypes(OutputFileFormatter off, SchemaConstruct sc, Set<QName> qnames, Set<Element> elements) {
        if (SchemaConstruct.ConstructType.ELEMENT.equals((Object)sc.getConstructType())) {
            Element e = (Element)sc;
            Type t = e.getType();
            QName elementName = e.getName();
            if (1 == e.getType().getFlavor()) {
                String ctName = elementName.getLocalPart();
                off.write("new Element( ");
                if (qnames.contains(e.getName())) {
                    off.write("_qname_" + ctName);
                } else {
                    off.write("new QName( \"" + e.getName().getNamespaceURI() + "\", \"" + e.getName().getLocalPart() + "\" )");
                }
                off.write(", _complexType( new Element[] {\n");
                Iterator<Element> scit = this.getElements(t).iterator();
                while (scit.hasNext()) {
                    this.initTypes(off, scit.next(), qnames, elements);
                    if (!scit.hasNext()) continue;
                    off.write(",\n");
                }
                if (e.getMinOccurs() != 0 || e.getMaxOccurs() != 1 || e.isNillable()) {
                    off.write("}), " + e.getMinOccurs() + ", " + (e.getMaxOccurs() == Integer.MAX_VALUE ? "Element.UNBOUNDED" : Integer.valueOf(e.getMaxOccurs())) + ", " + e.isNillable() + " )");
                } else {
                    off.write("}))");
                }
            } else if (3 == e.getType().getFlavor()) {
                String eName = e.getName().getLocalPart();
                off.write("new Element( ");
                if (qnames.contains(e.getName())) {
                    off.write("_qname_" + eName + ", ");
                } else {
                    off.write("new QName( \"" + e.getName().getNamespaceURI() + "\", \"" + e.getName().getLocalPart() + "\" ), ");
                }
                int minOccurs = e.getMinOccurs();
                int maxOccurs = e.getMaxOccurs();
                if (SchemaConstants.TYPE_STRING.equals(t.getName())) {
                    off.write("Type.STRING");
                } else if (SchemaConstants.TYPE_INT.equals(t.getName())) {
                    off.write("Type.INT");
                } else if (SchemaConstants.TYPE_BOOLEAN.equals(t.getName())) {
                    off.write("Type.BOOLEAN");
                } else if (SchemaConstants.TYPE_SHORT.equals(t.getName())) {
                    off.write("Type.SHORT");
                } else if (SchemaConstants.TYPE_BYTE.equals(t.getName())) {
                    off.write("Type.BYTE");
                } else if (SchemaConstants.TYPE_LONG.equals(t.getName())) {
                    off.write("Type.LONG");
                } else if (SchemaConstants.TYPE_FLOAT.equals(t.getName())) {
                    off.write("Type.FLOAT");
                } else if (SchemaConstants.TYPE_DOUBLE.equals(t.getName())) {
                    off.write("Type.DOUBLE");
                } else if (SchemaConstants.TYPE_BASE64_BINARY.equals(t.getName())) {
                    off.write("Type.BYTE");
                    maxOccurs = Integer.MAX_VALUE;
                } else if (SchemaConstants.TYPE_HEX_BINARY.equals(t.getName())) {
                    off.write("Type.BYTE");
                    maxOccurs = Integer.MAX_VALUE;
                } else if (SchemaConstants.TYPE_QNAME.equals(t.getName())) {
                    off.write("new ComplexType() /* TODO: Must implement */");
                }
                if (minOccurs != 1 || maxOccurs != 1 || e.isNillable()) {
                    off.write(", " + minOccurs + ", ");
                    if (maxOccurs == Integer.MAX_VALUE) {
                        off.write("Element.UNBOUNDED");
                    } else {
                        off.write("" + maxOccurs);
                    }
                    off.write(", " + e.isNillable());
                }
                off.write(" )");
            }
        }
    }

    public void traverseParameterTypes(SchemaConstruct sc, Set<QName> qnames, Set<Element> elements) {
        if (SchemaConstruct.ConstructType.ELEMENT.equals((Object)sc.getConstructType())) {
            Element e = (Element)sc;
            qnames.add(e.getName());
            elements.add(e);
        }
    }

    public String getUniqueTypeName(QName name) {
        Integer index = this.uniqueTypeName.get(name);
        if (index != null) {
            return name.getLocalPart() + "_" + index;
        }
        int max = 0;
        for (QName q : this.uniqueTypeName.keySet()) {
            int i;
            if (!q.getLocalPart().equals(name.getLocalPart()) || (i = this.uniqueTypeName.get(q).intValue()) <= max) continue;
            max = i;
        }
        this.uniqueTypeName.put(name, ++max);
        return name.getLocalPart() + "_" + max;
    }
}

