/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.categories;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.marker.Marker;
import org.netbeans.lib.profiler.results.cpu.marking.MarkMapping;
import org.netbeans.modules.profiler.categories.Category;
import org.netbeans.modules.profiler.categories.CategoryBuilder;
import org.netbeans.modules.profiler.categories.CategoryContainer;
import org.netbeans.modules.profiler.categories.CategoryDefinitionProcessor;
import org.netbeans.modules.profiler.categories.MarkerProcessor;
import org.netbeans.modules.profiler.utilities.Visitable;
import org.netbeans.modules.profiler.utilities.Visitor;
import org.openide.util.NbBundle;

public final class Categorization
implements Marker {
    private Project project;
    private Map<Category, Set<Mark>> inheritedMarkMap;
    private Map<Mark, Category> reverseMap;
    private CategoryContainer root = null;

    public Categorization(Project project) {
        this.project = project;
        this.inheritedMarkMap = null;
    }

    public synchronized void reset() {
        this.root = null;
        this.inheritedMarkMap = null;
        this.reverseMap = null;
    }

    private synchronized Map<Category, Set<Mark>> getInheritedMap() {
        if (this.inheritedMarkMap == null && this.reverseMap == null) {
            this.initInternals();
        }
        return this.inheritedMarkMap;
    }

    private synchronized Map<Mark, Category> getReverseMap() {
        if (this.inheritedMarkMap == null && this.reverseMap == null) {
            this.initInternals();
        }
        return this.reverseMap;
    }

    private void initInternals() {
        this.inheritedMarkMap = new HashMap<Category, Set<Mark>>();
        this.reverseMap = new WeakHashMap<Mark, Category>();
        Stack<Category> stack = new Stack<Category>();
        stack.add(this.getRoot());
        this.initInternals(stack);
    }

    private void initInternals(Stack<Category> stack) {
        Category category = stack.peek();
        this.reverseMap.put(category.getAssignedMark(), category);
        for (Category category2 : stack) {
            Set<Mark> set = this.inheritedMarkMap.get(category2);
            if (set == null) {
                set = new HashSet<Mark>();
                this.inheritedMarkMap.put(category2, set);
            }
            set.add(category.getAssignedMark());
        }
        for (Category category2 : category.getSubcategories()) {
            stack.push(category2);
            this.initInternals(stack);
            stack.pop();
        }
    }

    public Category getRoot() {
        if (this.root == null) {
            this.root = new CategoryContainer("ROOT", NbBundle.getMessage(CategoryBuilder.class, (String)"ROOT_CATEGORY_NAME"), Mark.DEFAULT);
            for (CategoryBuilder categoryBuilder : this.project.getLookup().lookupAll(CategoryBuilder.class)) {
                this.root.addAll(categoryBuilder.getRootCategory().getSubcategories());
            }
        }
        return this.root;
    }

    public Category getCategoryForMark(Mark mark) {
        return this.getReverseMap().get(mark);
    }

    public Set<Mark> getAllMarks(Category category) {
        Set<Mark> set = this.getInheritedMap().get(category);
        return set != null ? Collections.unmodifiableSet(set) : Collections.EMPTY_SET;
    }

    public boolean isAvailable() {
        return Categorization.isAvailable(this.project);
    }

    public static boolean isAvailable(Project project) {
        if (project == null) {
            return false;
        }
        return project.getLookup().lookup(CategoryBuilder.class) != null;
    }

    public MarkMapping[] getMappings() {
        MarkerProcessor markerProcessor = new MarkerProcessor(this.project);
        this.getRoot().accept((Visitor)new Visitor<Visitable<Category>, Void, CategoryDefinitionProcessor>(){

            public Void visit(Visitable<Category> visitable, CategoryDefinitionProcessor categoryDefinitionProcessor) {
                ((Category)visitable.getValue()).processDefinitionsWith(categoryDefinitionProcessor);
                return null;
            }
        }, markerProcessor);
        return markerProcessor.getMappings();
    }

    public Mark[] getMarks() {
        return this.getAllMarks(this.getRoot()).toArray(new Mark[0]);
    }
}

