/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JExtendedTable;
import org.netbeans.lib.profiler.ui.components.table.EnhancedTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.ExtendedTableModel;
import org.netbeans.lib.profiler.ui.components.table.JExtendedTablePanel;
import org.netbeans.lib.profiler.ui.components.table.SortableTableModel;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ProfilerIDESettings;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.InsertProfilingPointAction;
import org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class ProfilingPointsWindowUI
extends JPanel
implements ActionListener,
ListSelectionListener,
PropertyChangeListener,
MouseListener,
MouseMotionListener,
KeyListener {
    private static final String ALL_PROJECTS_STRING = NbBundle.getMessage(ProfilingPointsWindowUI.class, (String)"ProfilingPointsWindowUI_AllProjectsString");
    private static final String PROJECT_LABEL_TEXT = NbBundle.getMessage(ProfilingPointsWindowUI.class, (String)"ProfilingPointsWindowUI_ProjectLabelText");
    private static final String INCL_SUBPROJ_CHECKBOX_TEXT = NbBundle.getMessage(ProfilingPointsWindowUI.class, (String)"ProfilingPointsWindowUI_InclSubprojCheckboxText");
    private static final String ADD_BUTTON_TOOLTIP = NbBundle.getMessage(ProfilingPointsWindowUI.class, (String)"ProfilingPointsWindowUI_AddButtonToolTip");
    private static final String REMOVE_BUTTON_TOOLTIP = NbBundle.getMessage(ProfilingPointsWindowUI.class, (String)"ProfilingPointsWindowUI_RemoveButtonToolTip");
    private static final String EDIT_BUTTON_TOOLTIP = NbBundle.getMessage(ProfilingPointsWindowUI.class, (String)"ProfilingPointsWindowUI_EditButtonToolTip");
    private static final String DISABLE_BUTTON_TOOLTIP = NbBundle.getMessage(ProfilingPointsWindowUI.class, (String)"ProfilingPointsWindowUI_DisableButtonToolTip");
    private static final String SHOW_SOURCE_ITEM_TEXT = NbBundle.getMessage(ProfilingPointsWindowUI.class, (String)"ProfilingPointsWindowUI_ShowSourceItemText");
    private static final String SHOW_START_ITEM_TEXT = NbBundle.getMessage(ProfilingPointsWindowUI.class, (String)"ProfilingPointsWindowUI_ShowStartItemText");
    private static final String SHOW_END_ITEM_TEXT = NbBundle.getMessage(ProfilingPointsWindowUI.class, (String)"ProfilingPointsWindowUI_ShowEndItemText");
    private static final String SHOW_REPORT_ITEM_TEXT = NbBundle.getMessage(ProfilingPointsWindowUI.class, (String)"ProfilingPointsWindowUI_ShowReportItemText");
    private static final String ENABLE_ITEM_TEXT = NbBundle.getMessage(ProfilingPointsWindowUI.class, (String)"ProfilingPointsWindowUI_EnableItemText");
    private static final String DISABLE_ITEM_TEXT = NbBundle.getMessage(ProfilingPointsWindowUI.class, (String)"ProfilingPointsWindowUI_DisableItemText");
    private static final String ENABLE_DISABLE_ITEM_TEXT = NbBundle.getMessage(ProfilingPointsWindowUI.class, (String)"ProfilingPointsWindowUI_EnableDisableItemText");
    private static final String EDIT_ITEM_TEXT = NbBundle.getMessage(ProfilingPointsWindowUI.class, (String)"ProfilingPointsWindowUI_EditItemText");
    private static final String REMOVE_ITEM_TEXT = NbBundle.getMessage(ProfilingPointsWindowUI.class, (String)"ProfilingPointsWindowUI_RemoveItemText");
    private static final String SCOPE_COLUMN_NAME = NbBundle.getMessage(ProfilingPointsWindowUI.class, (String)"ProfilingPointsWindowUI_ScopeColumnName");
    private static final String PROJECT_COLUMN_NAME = NbBundle.getMessage(ProfilingPointsWindowUI.class, (String)"ProfilingPointsWindowUI_ProjectColumnName");
    private static final String PP_COLUMN_NAME = NbBundle.getMessage(ProfilingPointsWindowUI.class, (String)"ProfilingPointsWindowUI_PpColumnName");
    private static final String RESULTS_COLUMN_NAME = NbBundle.getMessage(ProfilingPointsWindowUI.class, (String)"ProfilingPointsWindowUI_ResultsColumnName");
    private static final String SCOPE_COLUMN_TOOLTIP = NbBundle.getMessage(ProfilingPointsWindowUI.class, (String)"ProfilingPointsWindowUI_ScopeColumnToolTip");
    private static final String PROJECT_COLUMN_TOOLTIP = NbBundle.getMessage(ProfilingPointsWindowUI.class, (String)"ProfilingPointsWindowUI_ProjectColumnToolTip");
    private static final String PP_COLUMN_TOOLTIP = NbBundle.getMessage(ProfilingPointsWindowUI.class, (String)"ProfilingPointsWindowUI_PpColumnToolTip");
    private static final String RESULTS_COLUMN_TOOLTIP = NbBundle.getMessage(ProfilingPointsWindowUI.class, (String)"ProfilingPointsWindowUI_ResultsColumnToolTip");
    private static final String NO_START_DEFINED_MSG = NbBundle.getMessage(ProfilingPointsWindowUI.class, (String)"ProfilingPointsWindowUI_NoStartDefinedMsg");
    private static final String NO_END_DEFINED_MSG = NbBundle.getMessage(ProfilingPointsWindowUI.class, (String)"ProfilingPointsWindowUI_NoEndDefinedMsg");
    private static final ImageIcon PPOINT_ADD_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/ppoints/ui/resources/ppointAdd.png", (boolean)false);
    private static final ImageIcon PPOINT_REMOVE_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/ppoints/ui/resources/ppointRemove.png", (boolean)false);
    private static final ImageIcon PPOINT_EDIT_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/ppoints/ui/resources/ppointEdit.png", (boolean)false);
    private static final ImageIcon PPOINT_ENABLE_DISABLE_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/ppoints/ui/resources/ppointEnableDisable.png", (boolean)false);
    protected String[] columnNames;
    protected TableCellRenderer[] columnRenderers;
    protected String[] columnToolTips;
    protected Class[] columnTypes;
    protected int[] columnWidths;
    protected boolean sortOrder;
    protected int sortBy;
    private ExtendedTableModel profilingPointsTableModel;
    private JButton addButton;
    private JButton disableButton;
    private JButton editButton;
    private JButton removeButton;
    private JCheckBox dependenciesCheckbox;
    private JComboBox projectsCombo;
    private JExtendedTable profilingPointsTable;
    private JLabel projectLabel;
    private JMenuItem disableItem;
    private JMenuItem editItem;
    private JMenuItem enableDisableItem;
    private JMenuItem enableItem;
    private JMenuItem removeItem;
    private JMenuItem showEndInSourceItem;
    private JMenuItem showInSourceItem;
    private JMenuItem showReportItem;
    private JMenuItem showStartInSourceItem;
    private JPopupMenu profilingPointsPopup;
    private JToolBar toolbar;
    private ProfilingPoint[] profilingPoints = new ProfilingPoint[0];
    private boolean profilingInProgress = false;
    private int initialSortingColumn;
    private int minProfilingPointColumnWidth;
    private boolean internalComboChange;

    public ProfilingPointsWindowUI() {
        this.setDefaultSorting();
        this.initColumnsData();
        this.initComponents();
        this.updateProjectsCombo();
        this.updateButtons();
        ProfilingPointsManager.getDefault().addPropertyChangeListener(this);
    }

    public void setDefaultSorting() {
        this.setSorting(1, true);
    }

    public Project getSelectedProject() {
        return this.projectsCombo.getSelectedItem() instanceof Project ? (Project)this.projectsCombo.getSelectedItem() : null;
    }

    public void setSorting(int n, boolean bl) {
        if (n == -1) {
            this.setDefaultSorting();
        } else {
            this.initialSortingColumn = n;
            this.sortBy = this.getSortBy(this.initialSortingColumn);
            this.sortOrder = bl;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.projectsCombo) {
            if (!this.internalComboChange) {
                this.refreshProfilingPoints();
            }
        } else if (actionEvent.getSource() == this.addButton) {
            ((InsertProfilingPointAction)SystemAction.get(InsertProfilingPointAction.class)).performAction(this.getSelectedProject());
        } else if (actionEvent.getSource() == this.removeButton) {
            int[] nArray = this.profilingPointsTable.getSelectedRows();
            ProfilingPoint[] profilingPointArray = new ProfilingPoint[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                profilingPointArray[i] = this.getProfilingPointAt(nArray[i]);
            }
            ProfilingPointsManager.getDefault().removeProfilingPoints(profilingPointArray);
        } else if (actionEvent.getSource() == this.editButton) {
            ProfilingPoint profilingPoint = this.getProfilingPointAt(this.profilingPointsTable.getSelectedRow());
            profilingPoint.customize();
        } else if (actionEvent.getSource() == this.disableButton) {
            int[] nArray;
            for (int n : nArray = this.profilingPointsTable.getSelectedRows()) {
                ProfilingPoint profilingPoint;
                profilingPoint.setEnabled(!(profilingPoint = this.getProfilingPointAt(n)).isEnabled());
                this.repaint();
            }
        } else if (actionEvent.getSource() == this.showInSourceItem) {
            CodeProfilingPoint codeProfilingPoint = (CodeProfilingPoint)this.getProfilingPointAt(this.profilingPointsTable.getSelectedRow());
            Utils.openLocation(codeProfilingPoint.getLocation());
        } else if (actionEvent.getSource() == this.showStartInSourceItem) {
            CodeProfilingPoint.Paired paired = (CodeProfilingPoint.Paired)this.getProfilingPointAt(this.profilingPointsTable.getSelectedRow());
            CodeProfilingPoint.Location location = paired.getStartLocation();
            if (location == null) {
                NetBeansProfiler.getDefaultNB().displayWarning(NO_START_DEFINED_MSG);
            } else {
                Utils.openLocation(location);
            }
        } else if (actionEvent.getSource() == this.showEndInSourceItem) {
            CodeProfilingPoint.Paired paired = (CodeProfilingPoint.Paired)this.getProfilingPointAt(this.profilingPointsTable.getSelectedRow());
            CodeProfilingPoint.Location location = paired.getEndLocation();
            if (location == null) {
                NetBeansProfiler.getDefaultNB().displayWarning(NO_END_DEFINED_MSG);
            } else {
                Utils.openLocation(location);
            }
        } else if (actionEvent.getSource() == this.showReportItem) {
            int[] nArray = this.profilingPointsTable.getSelectedRows();
            if (nArray.length == 0) {
                return;
            }
            for (int n : nArray) {
                ProfilingPoint profilingPoint = this.getProfilingPointAt(n);
                profilingPoint.showResults(null);
            }
        } else if (actionEvent.getSource() == this.enableItem) {
            int n = this.profilingPointsTable.getSelectedRow();
            if (n == -1) {
                return;
            }
            ProfilingPoint profilingPoint = this.getProfilingPointAt(n);
            profilingPoint.setEnabled(true);
        } else if (actionEvent.getSource() == this.disableItem) {
            int n = this.profilingPointsTable.getSelectedRow();
            if (n == -1) {
                return;
            }
            ProfilingPoint profilingPoint = this.getProfilingPointAt(n);
            profilingPoint.setEnabled(false);
        } else if (actionEvent.getSource() == this.enableDisableItem) {
            int[] nArray = this.profilingPointsTable.getSelectedRows();
            if (nArray.length == 0) {
                return;
            }
            for (int n : nArray) {
                ProfilingPoint profilingPoint;
                profilingPoint.setEnabled(!(profilingPoint = this.getProfilingPointAt(n)).isEnabled());
            }
        } else if (actionEvent.getSource() == this.editItem) {
            int n = this.profilingPointsTable.getSelectedRow();
            if (n == -1) {
                return;
            }
            ProfilingPoint profilingPoint = this.getProfilingPointAt(n);
            profilingPoint.customize();
        } else if (actionEvent.getSource() == this.removeItem) {
            this.deletePPs();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 525 || keyEvent.getKeyCode() == 121 && keyEvent.getModifiers() == 1) {
            int[] nArray = this.profilingPointsTable.getSelectedRows();
            if (nArray.length != 0) {
                Rectangle rectangle = this.profilingPointsTable.getCellRect(nArray[0], 1, true);
                this.showProfilingPointsPopup(keyEvent.getComponent(), rectangle.x + 20, rectangle.y + this.profilingPointsTable.getRowHeight() / 2);
            }
        } else if (keyEvent.getKeyCode() == 127) {
            this.deletePPs();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getModifiers() == 16) {
            ProfilingPoint profilingPoint;
            int n2 = this.profilingPointsTable.rowAtPoint(mouseEvent.getPoint());
            if (n2 != -1 && mouseEvent.getClickCount() == 2 && (profilingPoint = this.getProfilingPointAt(n2)) instanceof CodeProfilingPoint) {
                Utils.openLocation(((CodeProfilingPoint)profilingPoint).getLocation());
            }
        } else if (mouseEvent.getModifiers() == 4 && (n = this.profilingPointsTable.rowAtPoint(mouseEvent.getPoint())) != -1 && this.profilingPointsTable.getSelectedRowCount() != 0) {
            this.showProfilingPointsPopup(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            return;
        }
        this.dispatchResultsRendererEvent(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.dispatchResultsRendererEvent(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.dispatchResultsRendererEvent(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.dispatchResultsRendererEvent(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.dispatchResultsRendererEvent(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getModifiers() == 4 && (n = this.profilingPointsTable.rowAtPoint(mouseEvent.getPoint())) != -1) {
            int[] nArray = this.profilingPointsTable.getSelectedRows();
            if (nArray.length == 0) {
                this.profilingPointsTable.setRowSelectionInterval(n, n);
            } else {
                boolean bl = true;
                for (int n2 : nArray) {
                    if (n2 != n) continue;
                    bl = false;
                }
                if (bl) {
                    this.profilingPointsTable.setRowSelectionInterval(n, n);
                }
            }
        }
        this.dispatchResultsRendererEvent(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.dispatchResultsRendererEvent(mouseEvent);
    }

    public void notifyProfilingStateChanged() {
        this.profilingInProgress = ProfilingPointsManager.getDefault().isProfilingSessionInProgress();
        this.updateButtons();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "p_projects_changed") {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProfilingPointsWindowUI.this.updateProjectsCombo();
                }
            });
        } else if (propertyChangeEvent.getPropertyName() == "p_profiling_points_changed") {
            this.refreshProfilingPoints();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateButtons();
    }

    protected void initColumnsData() {
        this.minProfilingPointColumnWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 30;
        EnhancedTableCellRenderer enhancedTableCellRenderer = Utils.getScopeRenderer();
        EnhancedTableCellRenderer enhancedTableCellRenderer2 = Utils.getProjectRenderer();
        EnhancedTableCellRenderer enhancedTableCellRenderer3 = Utils.getPresenterRenderer();
        this.columnNames = new String[]{SCOPE_COLUMN_NAME, PROJECT_COLUMN_NAME, PP_COLUMN_NAME, RESULTS_COLUMN_NAME};
        this.columnToolTips = new String[]{SCOPE_COLUMN_TOOLTIP, PROJECT_COLUMN_TOOLTIP, PP_COLUMN_TOOLTIP, RESULTS_COLUMN_TOOLTIP};
        this.columnTypes = new Class[]{Integer.class, Project.class, ProfilingPoint.class, ProfilingPoint.ResultsRenderer.class};
        this.columnRenderers = new TableCellRenderer[]{enhancedTableCellRenderer, enhancedTableCellRenderer2, enhancedTableCellRenderer3, null};
        this.columnWidths = new int[]{50, 165, -1, 200};
    }

    private void setColumnsData() {
        TableColumnModel tableColumnModel = this.profilingPointsTable.getColumnModel();
        tableColumnModel.getColumn(2).setPreferredWidth(this.minProfilingPointColumnWidth);
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            int n = this.profilingPointsTableModel.getRealColumn(i);
            tableColumnModel.getColumn(i).setPreferredWidth(n == 2 ? this.minProfilingPointColumnWidth : this.columnWidths[n]);
            tableColumnModel.getColumn(i).setCellRenderer(this.columnRenderers[n]);
        }
    }

    private ProfilingPoint getProfilingPointAt(int n) {
        return (ProfilingPoint)this.profilingPointsTable.getValueAt(n, 0);
    }

    private int getSortBy(int n) {
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return -1;
    }

    private void createProfilingPointsTable() {
        this.profilingPointsTableModel = new ExtendedTableModel(new SortableTableModel(){

            public String getColumnName(int n) {
                return ProfilingPointsWindowUI.this.columnNames[n];
            }

            public int getRowCount() {
                return ProfilingPointsWindowUI.this.profilingPoints.length;
            }

            public int getColumnCount() {
                return ProfilingPointsWindowUI.this.columnNames.length;
            }

            public Class getColumnClass(int n) {
                return ProfilingPointsWindowUI.this.columnTypes[n];
            }

            public Object getValueAt(int n, int n2) {
                return ProfilingPointsWindowUI.this.profilingPoints[n];
            }

            public String getColumnToolTipText(int n) {
                return ProfilingPointsWindowUI.this.columnToolTips[n];
            }

            public void sortByColumn(int n, boolean bl) {
                ProfilingPointsWindowUI.this.sortBy = ProfilingPointsWindowUI.this.getSortBy(n);
                ProfilingPointsWindowUI.this.sortOrder = bl;
                ProfilingPointsWindowUI.this.refreshProfilingPoints();
            }

            public boolean getInitialSorting(int n) {
                return true;
            }
        });
        this.profilingPointsTable = new JExtendedTable((TableModel)this.profilingPointsTableModel){

            public TableCellRenderer getCellRenderer(int n, int n2) {
                if (this.getColumnClass(n2) == ProfilingPoint.ResultsRenderer.class) {
                    return ProfilingPointsWindowUI.this.getProfilingPointAt(n).getResultsRenderer();
                }
                return super.getCellRenderer(n, n2);
            }

            public void doLayout() {
                int n = 0;
                int n2 = -1;
                for (int i = 0; i < ProfilingPointsWindowUI.this.profilingPointsTableModel.getColumnCount(); ++i) {
                    int n3 = ProfilingPointsWindowUI.this.profilingPointsTableModel.getRealColumn(i);
                    if (n3 == 2) {
                        n2 = i;
                        continue;
                    }
                    n += this.getColumnModel().getColumn(i).getPreferredWidth();
                }
                if (n2 != -1) {
                    this.getColumnModel().getColumn(n2).setPreferredWidth(Math.max(this.getWidth() - n, ProfilingPointsWindowUI.this.minProfilingPointColumnWidth));
                }
                super.doLayout();
            }
        };
        this.profilingPointsTableModel.setTable((JTable)this.profilingPointsTable);
        this.profilingPointsTableModel.setInitialSorting(this.initialSortingColumn, this.sortOrder);
        this.profilingPointsTable.setRowSelectionAllowed(true);
        this.profilingPointsTable.setSelectionMode(2);
        this.profilingPointsTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.profilingPointsTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.profilingPointsTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.profilingPointsTable.setShowHorizontalLines(false);
        this.profilingPointsTable.setShowVerticalLines(true);
        this.profilingPointsTable.setRowMargin(0);
        this.profilingPointsTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.profilingPointsTable.getSelectionModel().addListSelectionListener(this);
        this.profilingPointsTable.addMouseListener((MouseListener)this);
        this.profilingPointsTable.addMouseMotionListener((MouseMotionListener)this);
        this.profilingPointsTable.addKeyListener((KeyListener)this);
        this.setColumnsData();
    }

    private void deletePPs() {
        int[] nArray = this.profilingPointsTable.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        ArrayList<ProfilingPoint> arrayList = new ArrayList<ProfilingPoint>();
        for (int n : nArray) {
            ProfilingPoint profilingPoint = this.getProfilingPointAt(n);
            arrayList.add(profilingPoint);
        }
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            ProfilingPoint profilingPoint = (ProfilingPoint)object.next();
            ProfilingPointsManager.getDefault().removeProfilingPoint(profilingPoint);
        }
    }

    private void dispatchResultsRendererEvent(MouseEvent mouseEvent) {
        int n = this.profilingPointsTable.columnAtPoint(mouseEvent.getPoint());
        if (n != 3) {
            this.profilingPointsTable.setCursor(Cursor.getDefaultCursor());
            return;
        }
        int n2 = this.profilingPointsTable.rowAtPoint(mouseEvent.getPoint());
        if (n2 == -1) {
            return;
        }
        ProfilingPoint profilingPoint = this.getProfilingPointAt(n2);
        ProfilingPoint.ResultsRenderer resultsRenderer = profilingPoint.getResultsRenderer();
        Rectangle rectangle = this.profilingPointsTable.getCellRect(n2, n, true);
        MouseEvent mouseEvent2 = new MouseEvent((Component)this.profilingPointsTable, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - rectangle.x, mouseEvent.getY() - rectangle.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
        resultsRenderer.dispatchMouseEvent(mouseEvent2);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.toolbar = new JToolBar(){

            @Override
            public Component add(Component component) {
                if (component instanceof JButton) {
                    UIUtils.fixButtonUI((AbstractButton)((JButton)component));
                }
                return super.add(component);
            }
        };
        this.toolbar.setFloatable(false);
        this.toolbar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.toolbar.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        this.projectLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)PROJECT_LABEL_TEXT);
        this.projectLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.projectsCombo = new JComboBox(new Object[]{ALL_PROJECTS_STRING}){

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(200, super.getPreferredSize().height);
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.projectLabel.setLabelFor(this.projectsCombo);
        this.projectsCombo.addActionListener(this);
        this.projectsCombo.setRenderer(Utils.getProjectListRenderer());
        this.toolbar.add(this.projectLabel);
        this.toolbar.add(this.projectsCombo);
        this.dependenciesCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.dependenciesCheckbox, (String)INCL_SUBPROJ_CHECKBOX_TEXT);
        this.dependenciesCheckbox.setSelected(ProfilerIDESettings.getInstance().getIncludeProfilingPointsDependencies());
        this.toolbar.add(this.dependenciesCheckbox);
        this.dependenciesCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfilerIDESettings.getInstance().setIncludeProfilingPointsDependencies(ProfilingPointsWindowUI.this.dependenciesCheckbox.isSelected());
                ProfilingPointsWindowUI.this.refreshProfilingPoints();
            }
        });
        this.toolbar.add(new JToolBar.Separator());
        this.addButton = new JButton(PPOINT_ADD_ICON);
        this.addButton.setToolTipText(ADD_BUTTON_TOOLTIP);
        this.addButton.addActionListener(this);
        this.toolbar.add(this.addButton);
        this.removeButton = new JButton(PPOINT_REMOVE_ICON);
        this.removeButton.setToolTipText(REMOVE_BUTTON_TOOLTIP);
        this.removeButton.addActionListener(this);
        this.toolbar.add(this.removeButton);
        this.toolbar.add(new JToolBar.Separator());
        this.editButton = new JButton(PPOINT_EDIT_ICON);
        this.editButton.setToolTipText(EDIT_BUTTON_TOOLTIP);
        this.editButton.addActionListener(this);
        this.toolbar.add(this.editButton);
        this.disableButton = new JButton(PPOINT_ENABLE_DISABLE_ICON);
        this.disableButton.setToolTipText(DISABLE_BUTTON_TOOLTIP);
        this.disableButton.addActionListener(this);
        this.toolbar.add(this.disableButton);
        this.createProfilingPointsTable();
        JPanel jPanel = new JPanel(new BorderLayout());
        JSeparator jSeparator = new JSeparator(){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, 1);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 1);
            }
        };
        jSeparator.setBackground(this.toolbar.getBackground());
        JExtendedTablePanel jExtendedTablePanel = new JExtendedTablePanel(this.profilingPointsTable);
        jExtendedTablePanel.setBorder(BorderFactory.createEmptyBorder());
        jPanel.add((Component)jSeparator, "North");
        jPanel.add((Component)jExtendedTablePanel, "Center");
        this.showInSourceItem = new JMenuItem(SHOW_SOURCE_ITEM_TEXT);
        this.showInSourceItem.setFont(this.showInSourceItem.getFont().deriveFont(1));
        this.showInSourceItem.addActionListener(this);
        this.showStartInSourceItem = new JMenuItem(SHOW_START_ITEM_TEXT);
        this.showStartInSourceItem.setFont(this.showInSourceItem.getFont().deriveFont(1));
        this.showStartInSourceItem.addActionListener(this);
        this.showEndInSourceItem = new JMenuItem(SHOW_END_ITEM_TEXT);
        this.showEndInSourceItem.addActionListener(this);
        this.showReportItem = new JMenuItem(SHOW_REPORT_ITEM_TEXT);
        this.showReportItem.addActionListener(this);
        this.enableItem = new JMenuItem(ENABLE_ITEM_TEXT);
        this.enableItem.addActionListener(this);
        this.disableItem = new JMenuItem(DISABLE_ITEM_TEXT);
        this.disableItem.addActionListener(this);
        this.enableDisableItem = new JMenuItem(ENABLE_DISABLE_ITEM_TEXT);
        this.enableDisableItem.addActionListener(this);
        this.editItem = new JMenuItem(EDIT_ITEM_TEXT);
        this.editItem.addActionListener(this);
        this.removeItem = new JMenuItem(REMOVE_ITEM_TEXT);
        this.removeItem.addActionListener(this);
        this.profilingPointsPopup = new JPopupMenu();
        this.profilingPointsPopup.add(this.showInSourceItem);
        this.profilingPointsPopup.add(this.showStartInSourceItem);
        this.profilingPointsPopup.add(this.showEndInSourceItem);
        this.profilingPointsPopup.add(this.showReportItem);
        this.profilingPointsPopup.addSeparator();
        this.profilingPointsPopup.add(this.editItem);
        this.profilingPointsPopup.add(this.enableItem);
        this.profilingPointsPopup.add(this.disableItem);
        this.profilingPointsPopup.add(this.enableDisableItem);
        this.profilingPointsPopup.addSeparator();
        this.profilingPointsPopup.add(this.removeItem);
        this.add((Component)this.toolbar, "North");
        this.add((Component)jPanel, "Center");
    }

    private void refreshProfilingPoints() {
        int[] nArray = this.profilingPointsTable.getSelectedRows();
        Object[] objectArray = new ProfilingPoint[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray[i] = this.getProfilingPointAt(nArray[i]);
        }
        List<ProfilingPoint> list = ProfilingPointsManager.getDefault().getSortedProfilingPoints(this.getSelectedProject(), this.sortBy, this.sortOrder);
        this.profilingPoints = list.toArray(new ProfilingPoint[list.size()]);
        this.profilingPointsTableModel.fireTableDataChanged();
        if (objectArray.length > 0) {
            this.profilingPointsTable.selectRowsByInstances(objectArray, 0, true);
        }
        this.repaint();
    }

    private void showProfilingPointsPopup(Component component, int n, int n2) {
        int[] nArray = this.profilingPointsTable.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        boolean bl = nArray.length == 1;
        ProfilingPoint profilingPoint = this.getProfilingPointAt(nArray[0]);
        this.showInSourceItem.setVisible(!bl || profilingPoint instanceof CodeProfilingPoint.Single);
        this.showInSourceItem.setEnabled(bl);
        this.showStartInSourceItem.setVisible(bl && profilingPoint instanceof CodeProfilingPoint.Paired);
        this.showEndInSourceItem.setVisible(bl && profilingPoint instanceof CodeProfilingPoint.Paired);
        this.showReportItem.setEnabled(true);
        this.enableItem.setVisible(bl && !profilingPoint.isEnabled());
        this.enableItem.setEnabled(!this.profilingInProgress);
        this.disableItem.setVisible(bl && profilingPoint.isEnabled());
        this.disableItem.setEnabled(!this.profilingInProgress);
        this.enableDisableItem.setVisible(!bl);
        this.enableDisableItem.setEnabled(!this.profilingInProgress);
        this.editItem.setEnabled(bl && !this.profilingInProgress);
        this.removeItem.setEnabled(!this.profilingInProgress);
        this.profilingPointsPopup.show(component, n, n2);
    }

    private void updateButtons() {
        int[] nArray = this.profilingPointsTable.getSelectedRows();
        this.addButton.setEnabled(!this.profilingInProgress);
        if (nArray.length == 0) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.disableButton.setEnabled(false);
        } else if (nArray.length == 1) {
            this.editButton.setEnabled(!this.profilingInProgress);
            this.removeButton.setEnabled(!this.profilingInProgress);
            this.disableButton.setEnabled(!this.profilingInProgress);
        } else {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(!this.profilingInProgress);
            this.disableButton.setEnabled(!this.profilingInProgress);
        }
    }

    private void updateProjectsCombo() {
        Project[] projectArray = ProjectUtilities.getSortedProjects((Project[])ProjectUtilities.getOpenedProjects());
        Vector<Object> vector = new Vector<Object>(projectArray.length + 1);
        for (int i = 0; i < projectArray.length; ++i) {
            vector.add(projectArray[i]);
        }
        vector.add(0, ALL_PROJECTS_STRING);
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.projectsCombo.getModel();
        Object object = this.projectsCombo.getSelectedItem();
        this.internalComboChange = true;
        defaultComboBoxModel.removeAllElements();
        for (int i = 0; i < vector.size(); ++i) {
            defaultComboBoxModel.addElement(vector.get(i));
        }
        if (object != null && defaultComboBoxModel.getIndexOf(object) != -1) {
            this.projectsCombo.setSelectedItem(object);
        } else {
            this.projectsCombo.setSelectedItem(ALL_PROJECTS_STRING);
        }
        this.internalComboChange = false;
        this.refreshProfilingPoints();
    }
}

