/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.Document;
import org.apache.maven.model.Plugin;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.hints.pom.spi.Configuration;
import org.netbeans.modules.maven.hints.pom.spi.POMErrorFixProvider;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.BuildBase;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Profile;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public class OverridePluginManagementError
implements POMErrorFixProvider {
    private Configuration configuration = new Configuration("OverridePluginManagementError", NbBundle.getMessage(OverridePluginManagementError.class, (String)"TIT_OverridePluginManagementError"), NbBundle.getMessage(OverridePluginManagementError.class, (String)"DESC_OverridePluginManagementError"), true, Configuration.HintSeverity.WARNING);

    @Override
    public List<ErrorDescription> getErrorsForDocument(POMModel pOMModel, Project project) {
        List list;
        assert (pOMModel != null);
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        if (project == null) {
            return arrayList;
        }
        Map<String, String> map = this.collectManaged(project);
        if (map.size() == 0) {
            return arrayList;
        }
        Build build = pOMModel.getProject().getBuild();
        if (build != null) {
            this.checkPluginList(build.getPlugins(), pOMModel, arrayList, map);
        }
        if ((list = pOMModel.getProject().getProfiles()) != null) {
            for (Profile profile : list) {
                BuildBase buildBase = profile.getBuildBase();
                if (buildBase == null) continue;
                this.checkPluginList(buildBase.getPlugins(), pOMModel, arrayList, map);
            }
        }
        return arrayList;
    }

    private void checkPluginList(List<org.netbeans.modules.maven.model.pom.Plugin> list, POMModel pOMModel, List<ErrorDescription> list2, Map<String, String> map) {
        if (list != null) {
            for (org.netbeans.modules.maven.model.pom.Plugin plugin : list) {
                String string = plugin.getVersion();
                if (string == null) continue;
                String string2 = plugin.getArtifactId();
                String string3 = plugin.getGroupId();
                string3 = string3 != null ? string3 : "org.apache.maven.plugins";
                String string4 = string3 + ":" + string2;
                if (!map.keySet().contains(string4)) continue;
                int n = plugin.findChildElementPosition(pOMModel.getPOMQNames().VERSION.getQName());
                Line line = NbEditorUtilities.getLine((Document)pOMModel.getBaseDocument(), (int)n, (boolean)false);
                String string5 = map.get(string4);
                list2.add(ErrorDescriptionFactory.createErrorDescription((Severity)this.configuration.getSeverity(this.configuration.getPreferences()).toEditorSeverity(), (String)NbBundle.getMessage(OverridePluginManagementError.class, (String)"TXT_OverridePluginManagementError", (Object)string5), Collections.singletonList(new OverrideFix(plugin)), (Document)pOMModel.getBaseDocument(), (int)(line.getLineNumber() + 1)));
            }
        }
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    private Map<String, String> collectManaged(Project project) {
        NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (nbMavenProject == null) {
            return hashMap;
        }
        List list = nbMavenProject.getMavenProject().getPluginManagement().getPlugins();
        for (Plugin plugin : list) {
            hashMap.put(plugin.getKey(), plugin.getVersion());
        }
        return hashMap;
    }

    private static class OverrideFix
    implements Fix {
        private org.netbeans.modules.maven.model.pom.Plugin plugin;

        OverrideFix(org.netbeans.modules.maven.model.pom.Plugin plugin) {
            this.plugin = plugin;
        }

        public String getText() {
            return NbBundle.getMessage(OverridePluginManagementError.class, (String)"TEXT_OverridePluginFix");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChangeInfo implement() throws Exception {
            ChangeInfo changeInfo = new ChangeInfo();
            POMModel pOMModel = this.plugin.getModel();
            if (!pOMModel.getState().equals((Object)Model.State.VALID)) {
                return changeInfo;
            }
            pOMModel.startTransaction();
            try {
                this.plugin.setVersion(null);
            }
            finally {
                pOMModel.endTransaction();
            }
            return changeInfo;
        }
    }
}

