/*
 * Decompiled with CFR 0.152.
 */
import java.util.Collection;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.runtime.Frame;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class CallsiteHook
extends RcovHook {
    private static CallsiteHook callsiteHook;
    private boolean active;
    private RubyHash defsites;
    private RubyHash callsites;

    public static CallsiteHook getCallsiteHook() {
        if (callsiteHook == null) {
            callsiteHook = new CallsiteHook();
        }
        return callsiteHook;
    }

    private CallsiteHook() {
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isInterestedInEvent(RubyEvent event) {
        return event == RubyEvent.CALL || event == RubyEvent.C_CALL;
    }

    public RubyArray getCallsiteInfo(Ruby runtime) {
        RubyArray info = runtime.newArray();
        info.add((Object)this.getCallsites(runtime));
        info.add((Object)this.getDefsites(runtime));
        return info;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public RubyHash resetDefsites() {
        this.defsites.clear();
        return this.defsites;
    }

    public void eventHandler(ThreadContext context, String event, String file, int line, String name, IRubyObject type) {
        RubyArray callerArray;
        RubyHash hash;
        RubyArray currentMethod = context.getRuntime().newArray();
        currentMethod.add((Object)context.getFrameKlazz());
        currentMethod.add((Object)context.getRuntime().newSymbol(name));
        RubyArray fileLoc = context.getRuntime().newArray();
        fileLoc.add((Object)file);
        fileLoc.add((Object)line);
        this.defsites = this.getDefsites(context.getRuntime());
        this.defsites.put((Object)currentMethod, (Object)fileLoc);
        this.callsites = this.getCallsites(context.getRuntime());
        if (!this.callsites.containsKey((Object)currentMethod)) {
            this.callsites.put((Object)currentMethod, (Object)RubyHash.newHash((Ruby)context.getRuntime()));
        }
        if (!(hash = (RubyHash)this.callsites.get((Object)currentMethod)).containsKey((Object)(callerArray = this.customBacktrace(context)))) {
            hash.put((Object)callerArray, (Object)0L);
        }
        Long count = (Long)hash.get((Object)callerArray);
        long itCount = count + 1L;
        hash.put((Object)callerArray, (Object)itCount);
    }

    private RubyArray customBacktrace(ThreadContext context) {
        Frame[] frames = context.createBacktrace(1, false);
        RubyArray ary = context.getRuntime().newArray();
        ary.addAll((Collection)this.formatBacktrace(context.getRuntime(), frames[frames.length - 1]));
        return context.getRuntime().newArray((IRubyObject)ary);
    }

    private RubyArray formatBacktrace(Ruby runtime, Frame backtrace) {
        RubyArray ary = runtime.newArray();
        if (backtrace == null) {
            ary.add((Object)runtime.getNil());
            ary.add((Object)runtime.getNil());
            ary.add((Object)"");
            ary.add((Object)0L);
        } else {
            ary.add((Object)backtrace.getKlazz());
            ary.add(backtrace.getName() == null ? runtime.getNil() : runtime.newSymbol(backtrace.getName()));
            ary.add((Object)backtrace.getFile());
            ary.add((Object)(backtrace.getLine() + 1));
        }
        return ary;
    }

    private RubyHash getCallsites(Ruby runtime) {
        if (this.callsites == null) {
            this.callsites = RubyHash.newHash((Ruby)runtime);
        }
        return this.callsites;
    }

    private RubyHash getDefsites(Ruby runtime) {
        if (this.defsites == null) {
            this.defsites = RubyHash.newHash((Ruby)runtime);
        }
        return this.defsites;
    }
}

