/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.kenai;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.bugtracking.kenai.KenaiAccessorImpl;
import org.netbeans.modules.bugtracking.kenai.QueryAccessorImpl;
import org.netbeans.modules.bugtracking.kenai.QueryDescriptor;
import org.netbeans.modules.bugtracking.kenai.QueryHandleImpl;
import org.netbeans.modules.bugtracking.kenai.Support;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiSupport;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiUtil;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiNotification;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.spi.Dashboard;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.spi.QueryHandle;
import org.netbeans.modules.kenai.ui.spi.QueryResultHandle;
import org.openide.util.NbBundle;

class KenaiHandler {
    private final QueryAccessorImpl qaImpl;
    private final Kenai kenai;
    private final Map<String, ProjectListener> projectListeners = new HashMap<String, ProjectListener>();
    private final Map<String, KenaiRepositoryListener> kenaiRepoListeners = new HashMap<String, KenaiRepositoryListener>();
    private final Map<String, Map<String, QueryHandle>> queryHandles = new HashMap<String, Map<String, QueryHandle>>();
    private String lastLoggedUser = null;

    public KenaiHandler(QueryAccessorImpl qaImpl, Kenai kenai) {
        this.qaImpl = qaImpl;
        this.kenai = kenai;
        this.kenai.addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("login")) {
                    if (evt.getNewValue() == null) {
                        ProjectListener[] pls;
                        Map map = KenaiHandler.this.projectListeners;
                        synchronized (map) {
                            pls = KenaiHandler.this.projectListeners.values().toArray(new ProjectListener[KenaiHandler.this.projectListeners.values().size()]);
                        }
                        for (ProjectListener pl : pls) {
                            pl.closeQueries();
                        }
                    } else {
                        String user = KenaiHandler.this.getKenaiUser();
                        if (!user.equals(KenaiHandler.this.lastLoggedUser)) {
                            for (Map m : KenaiHandler.this.queryHandles.values()) {
                                for (QueryHandle qh : m.values()) {
                                    if (!(qh instanceof LoginAwareQueryHandle)) continue;
                                    ((LoginAwareQueryHandle)qh).needsRefresh();
                                }
                            }
                        }
                        String string = KenaiHandler.this.lastLoggedUser;
                    }
                    KenaiHandler.this.refreshKenaiQueries();
                }
            }
        });
        Dashboard.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("refreshRequest") && KenaiHandler.this.kenai.equals((Object)((Dashboard)evt.getSource()))) {
                    KenaiHandler.this.clear();
                }
            }
        });
        this.lastLoggedUser = this.getKenaiUser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<QueryHandle> getQueryHandles(ProjectHandle project, Query ... queries) {
        ArrayList<QueryHandle> ret = new ArrayList<QueryHandle>();
        Map<String, Map<String, QueryHandle>> map = this.queryHandles;
        synchronized (map) {
            Map<String, QueryHandle> m = this.queryHandles.get(project.getId());
            if (m == null) {
                m = new HashMap<String, QueryHandle>();
                this.queryHandles.put(project.getId(), m);
            } else {
                ArrayList<String> l = new ArrayList<String>();
                for (Query q : queries) {
                    if (q == null) continue;
                    String qName = q.getDisplayName();
                    l.add(qName);
                }
                m.keySet().retainAll(l);
            }
            for (Query q : queries) {
                String qName = q.getDisplayName();
                QueryHandle qh = m.get(qName);
                if (qh == null) {
                    Issue[] issues = q.getIssues();
                    qh = issues != null && issues.length > 0 ? this.createQueryHandle(q, false) : this.createQueryHandle(q, true);
                    m.put(qName, qh);
                }
                ret.add(qh);
            }
        }
        this.sortQueries(ret);
        return ret;
    }

    private QueryHandleImpl createQueryHandle(Query q, boolean needsRefresh) {
        Repository repo = q.getRepository();
        KenaiSupport support = (KenaiSupport)repo.getLookup().lookup(KenaiSupport.class);
        boolean predefined = false;
        if (support != null) {
            boolean needsLogin = support.needsLogin(q);
            boolean bl = predefined = support.getAllIssuesQuery(repo) == q || support.getMyIssuesQuery(repo) == q;
            if (needsLogin) {
                return new LoginAwareQueryHandle(q, needsRefresh, predefined);
            }
        }
        return new QueryHandleImpl(q, needsRefresh, predefined);
    }

    List<QueryHandle> getQueryHandles(Repository repo, ProjectHandle projectHandle) {
        Query[] queries = repo.getQueries();
        if (queries == null) {
            return Collections.emptyList();
        }
        return this.getQueryHandles(projectHandle, queries);
    }

    private void sortQueries(List<QueryHandle> queryHandles) {
        Collections.sort(queryHandles, new Comparator<QueryHandle>(){

            @Override
            public int compare(QueryHandle qh1, QueryHandle qh2) {
                if (qh1 == null && qh1 == null) {
                    return 0;
                }
                if (qh2 == null) {
                    return 1;
                }
                if (qh1 == null) {
                    return -1;
                }
                boolean predefined1 = false;
                boolean predefined2 = false;
                if (qh1 instanceof QueryDescriptor && ((QueryDescriptor)qh1).isPredefined()) {
                    predefined1 = true;
                }
                if (qh2 instanceof QueryDescriptor && ((QueryDescriptor)qh2).isPredefined()) {
                    predefined2 = true;
                }
                if (predefined1 && !predefined2) {
                    return -1;
                }
                if (predefined1 && !predefined2) {
                    return 1;
                }
                return qh1.getDisplayName().compareTo(qh2.getDisplayName());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerProject(ProjectHandle project, List<QueryHandle> queries) {
        ProjectListener pl;
        Map<String, ProjectListener> map = this.projectListeners;
        synchronized (map) {
            pl = this.projectListeners.get(project.getId());
        }
        if (pl != null) {
            project.removePropertyChangeListener((PropertyChangeListener)pl);
            project.getKenaiProject().removePropertyChangeListener((PropertyChangeListener)pl);
        }
        pl = new ProjectListener(project, queries);
        project.addPropertyChangeListener((PropertyChangeListener)pl);
        project.getKenaiProject().addPropertyChangeListener((PropertyChangeListener)pl);
        map = this.projectListeners;
        synchronized (map) {
            this.projectListeners.put(project.getId(), pl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerRepository(Repository repo, ProjectHandle project) {
        KenaiRepositoryListener krl = null;
        Map<String, KenaiRepositoryListener> map = this.kenaiRepoListeners;
        synchronized (map) {
            String url = project.getKenaiProject().getKenai().getUrl().toString();
            krl = this.kenaiRepoListeners.get(repo.getID());
            if (krl == null) {
                krl = new KenaiRepositoryListener(repo, project);
                repo.addPropertyChangeListener((PropertyChangeListener)krl);
                this.kenaiRepoListeners.put(repo.getID(), krl);
            }
        }
    }

    private String getKenaiUser() {
        PasswordAuthentication pa = KenaiAccessorImpl.getPasswordAuthentication(this.kenai, false);
        return pa != null ? pa.getUserName() : null;
    }

    private void refreshKenaiQueries() {
        KenaiUtil.refreshOpenedQueries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Map<String, Object> map = this.projectListeners;
        synchronized (map) {
            this.projectListeners.clear();
        }
        map = this.kenaiRepoListeners;
        synchronized (map) {
            this.kenaiRepoListeners.clear();
        }
        map = this.queryHandles;
        synchronized (map) {
            this.queryHandles.clear();
        }
    }

    Action getFindIssuesAction(final Repository repo) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!KenaiAccessorImpl.isLoggedIn(KenaiHandler.this.kenai) && KenaiSupport.BugtrackingType.JIRA == KenaiHandler.this.getBugtrackingType(repo) && !KenaiAccessorImpl.showLoginIntern()) {
                    return;
                }
                Support.getInstance().post(new Runnable(){

                    @Override
                    public void run() {
                        BugtrackingUtil.openQuery(null, (Repository)repo, (boolean)true);
                    }
                });
            }
        };
    }

    Action getCreateIssueAction(final Repository repo) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!KenaiAccessorImpl.isLoggedIn(KenaiHandler.this.kenai) && KenaiSupport.BugtrackingType.JIRA == KenaiHandler.this.getBugtrackingType(repo) && !KenaiAccessorImpl.showLoginIntern()) {
                    return;
                }
                Support.getInstance().post(new Runnable(){

                    @Override
                    public void run() {
                        BugtrackingUtil.createIssue((Repository)repo);
                    }
                });
            }
        };
    }

    private KenaiSupport.BugtrackingType getBugtrackingType(Repository repo) {
        KenaiSupport support = (KenaiSupport)repo.getLookup().lookup(KenaiSupport.class);
        if (support != null) {
            return support.getType();
        }
        assert (false) : "no KenaiSupport available for repository [" + repo.getDisplayName() + "]";
        return null;
    }

    private class LoginAwareQueryHandle
    extends QueryHandleImpl {
        private String notLoggedIn;

        public LoginAwareQueryHandle(Query query, boolean needsRefresh, boolean predefined) {
            super(query, needsRefresh, predefined);
            this.notLoggedIn = NbBundle.getMessage(QueryAccessorImpl.class, (String)"LBL_NotLoggedIn");
        }

        @Override
        public String getDisplayName() {
            return super.getDisplayName() + (KenaiAccessorImpl.isLoggedIn(KenaiHandler.this.kenai) ? "" : " " + this.notLoggedIn);
        }

        @Override
        List<QueryResultHandle> getQueryResults() {
            return KenaiAccessorImpl.isLoggedIn(KenaiHandler.this.kenai) ? super.getQueryResults() : Collections.EMPTY_LIST;
        }

        @Override
        void refreshIfNeeded() {
            if (!KenaiAccessorImpl.isLoggedIn(KenaiHandler.this.kenai)) {
                return;
            }
            super.refreshIfNeeded();
        }

        void needsRefresh() {
            this.needsRefresh = true;
        }
    }

    private class KenaiRepositoryListener
    implements PropertyChangeListener {
        private final ProjectHandle ph;
        private Repository repo;

        public KenaiRepositoryListener(Repository repo, ProjectHandle ph) {
            this.ph = ph;
            this.repo = repo;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("bugtracking.repository.queries.changed")) {
                List<QueryHandle> queryHandles = KenaiHandler.this.getQueryHandles(this.repo, this.ph);
                for (QueryHandle queryHandle : queryHandles) {
                    QueryHandleImpl impl;
                    if (!(queryHandle instanceof QueryHandleImpl) || !(impl = (QueryHandleImpl)queryHandle).getQuery().isSaved()) continue;
                    impl.needsRefresh = false;
                }
                KenaiHandler.this.qaImpl.fireQueriesChanged(this.ph, queryHandles);
            }
        }
    }

    private class ProjectListener
    implements PropertyChangeListener {
        private List<QueryHandle> queries;
        private ProjectHandle ph;

        public ProjectListener(ProjectHandle ph, List<QueryHandle> queries) {
            this.queries = queries;
            this.ph = ph;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object newValue;
            if (evt.getPropertyName().equals("close")) {
                this.closeQueries();
            } else if (evt.getPropertyName().equals("project_notification") && (newValue = evt.getNewValue()) instanceof KenaiNotification) {
                KenaiNotification kn = (KenaiNotification)newValue;
                if (kn.getType() != KenaiService.Type.ISSUES) {
                    return;
                }
                for (QueryHandle qh : this.queries) {
                    if (!(qh instanceof QueryHandleImpl)) continue;
                    Query query = ((QueryHandleImpl)qh).getQuery();
                    KenaiSupport ks = (KenaiSupport)query.getRepository().getLookup().lookup(KenaiSupport.class);
                    assert (ks != null);
                    if (ks == null) continue;
                    ks.refresh(query, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeQueries() {
            for (QueryHandle qh : this.queries) {
                if (!(qh instanceof QueryHandleImpl)) continue;
                BugtrackingUtil.closeQuery((Query)((QueryHandleImpl)qh).getQuery());
            }
            Map map = KenaiHandler.this.projectListeners;
            synchronized (map) {
                this.ph.removePropertyChangeListener((PropertyChangeListener)this);
                this.ph.getKenaiProject().removePropertyChangeListener((PropertyChangeListener)this);
                KenaiHandler.this.projectListeners.remove(this.ph.getId());
            }
        }
    }
}

