/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.error.includes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import org.netbeans.modules.cnd.api.model.CsmErrorDirective;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;

public class ErrorIncludesModel
implements ListModel {
    private List<String> names = new ArrayList<String>();
    private List<List<CsmOffsetable>> includeList = new ArrayList<List<CsmOffsetable>>();
    private int errorFiles;
    private int errorIncludes;

    public ErrorIncludesModel(List<CsmInclude> includes, List<CsmErrorDirective> errors) {
        ArrayList<CsmErrorDirective> list;
        String name;
        this.errorIncludes = includes.size();
        TreeMap<String, ArrayList<CsmErrorDirective>> tree = new TreeMap<String, ArrayList<CsmErrorDirective>>();
        HashSet<CsmFile> files = new HashSet<CsmFile>();
        for (CsmInclude csmInclude : includes) {
            files.add(csmInclude.getContainingFile());
            name = csmInclude.isSystem() ? "<" + csmInclude.getIncludeName() + ">" : "\"" + csmInclude.getIncludeName() + "\"";
            list = (List)tree.get(name);
            if (list == null) {
                list = new ArrayList();
                tree.put(name, list);
            }
            list.add((CsmErrorDirective)csmInclude);
        }
        for (CsmErrorDirective csmErrorDirective : errors) {
            files.add(csmErrorDirective.getContainingFile());
            name = ((Object)csmErrorDirective.getText()).toString();
            list = (ArrayList<CsmErrorDirective>)tree.get(name);
            if (list == null) {
                list = new ArrayList<CsmErrorDirective>();
                tree.put(name, list);
            }
            list.add(csmErrorDirective);
        }
        for (Map.Entry entry : tree.entrySet()) {
            this.names.add((String)entry.getKey());
            this.includeList.add((List<CsmOffsetable>)entry.getValue());
        }
        this.errorFiles = files.size();
    }

    public int getFailedIncludesSize() {
        return this.errorIncludes;
    }

    public int getFailedFilesSize() {
        return this.errorFiles;
    }

    @Override
    public int getSize() {
        return this.names.size();
    }

    public Object getElementAt(int index) {
        return this.names.get(index);
    }

    public List<CsmOffsetable> getElementList(int index) {
        return this.includeList.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
    }
}

