/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.todo;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.tasklist.todo.SourceCodeCommentParser;
import org.netbeans.modules.tasklist.todo.settings.Settings;
import org.netbeans.spi.tasklist.FileTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class TodoTaskScanner
extends FileTaskScanner
implements PropertyChangeListener {
    private static final String GROUP_NAME = "nb-tasklist-todo";
    private Pattern regexp = null;
    private FileTaskScanner.Callback callback;

    TodoTaskScanner(String displayName, String description) {
        super(displayName, description, "Advanced/ToDo");
    }

    public static TodoTaskScanner create() {
        return new TodoTaskScanner(NbBundle.getBundle(TodoTaskScanner.class).getString("LBL_todotask"), NbBundle.getBundle(TodoTaskScanner.class).getString("HINT_todotask"));
    }

    public List<? extends Task> scan(FileObject resource) {
        if (!this.isSupported(resource)) {
            return null;
        }
        if (Settings.getDefault().isScanCommentsOnly()) {
            return this.scanComments(resource);
        }
        return this.scanAll(resource);
    }

    private List<? extends Task> scanAll(FileObject resource) {
        List<? extends Task> tasks = null;
        Collection<String> patterns = Settings.getDefault().getPatterns();
        try {
            String text = this.getContent(resource);
            int index = 0;
            int lineno = 1;
            int len = text.length();
            Matcher matcher = this.getScanRegexp().matcher(text);
            while (index < len && matcher.find(index)) {
                int begin;
                int end = matcher.end();
                int c = 97;
                int nonwhite = begin;
                for (begin = matcher.start(); begin >= index; --begin) {
                    char c2 = text.charAt(begin);
                    c = c2;
                    if (c2 == '\n') break;
                    if (c == 32 || c == 9) continue;
                    nonwhite = begin;
                }
                begin = nonwhite;
                nonwhite = end;
                while (end < len && (c = (int)text.charAt(end)) != 10 && c != 13) {
                    if (c != 32 && c != 9) {
                        nonwhite = end;
                    }
                    ++end;
                }
                for (int idx = index; idx <= begin; ++idx) {
                    if (text.charAt(idx) != '\n') continue;
                    ++lineno;
                }
                index = end;
                String description = new String(((Object)text.subSequence(begin, Math.min(nonwhite + 1, text.length()))).toString().toCharArray());
                description = this.trim(description, patterns);
                Task task = Task.create((FileObject)resource, (String)GROUP_NAME, (String)description, (int)lineno);
                if (null == tasks) {
                    tasks = new LinkedList<Task>();
                }
                tasks.add((Task)task);
            }
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, e);
        }
        catch (OutOfMemoryError oomE) {
            System.gc();
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, oomE);
        }
        return null == tasks ? this.getEmptyList() : tasks;
    }

    private List<? extends Task> scanComments(FileObject resource) {
        String ext = resource.getExt().toLowerCase();
        String mime = FileUtil.getMIMEType((FileObject)resource);
        String lineComment = Settings.getDefault().getLineComment(ext, mime);
        String blockCommentStart = Settings.getDefault().getBlockCommentStart(ext, mime);
        String blockCommentEnd = Settings.getDefault().getBlockCommentEnd(ext, mime);
        SourceCodeCommentParser sccp = new SourceCodeCommentParser(lineComment, blockCommentStart, blockCommentEnd);
        Collection<String> patterns = Settings.getDefault().getPatterns();
        List<? extends Task> tasks = null;
        try {
            String text = this.getContent(resource);
            sccp.setText(text);
            SourceCodeCommentParser.CommentRegion reg = new SourceCodeCommentParser.CommentRegion();
            Matcher matcher = this.getScanRegexp().matcher(text);
            int len = text.length();
            int lineno = 1;
            int index = 0;
            int idx = 0;
            if (!sccp.nextRegion(reg)) {
                return this.getEmptyList();
            }
            while (index < len && matcher.find(index)) {
                boolean goahead;
                int begin = matcher.start();
                int end = matcher.end();
                boolean toosoon = false;
                do {
                    goahead = true;
                    if (begin < reg.start) {
                        toosoon = true;
                        continue;
                    }
                    if (begin <= reg.stop) continue;
                    goahead = false;
                    if (sccp.nextRegion(reg)) continue;
                    return null == tasks ? this.getEmptyList() : tasks;
                } while (!goahead);
                if (toosoon) {
                    index = end;
                    continue;
                }
                int c = 97;
                int nonwhite = begin;
                while (begin >= index) {
                    char c2 = text.charAt(begin);
                    c = c2;
                    if (c2 == '\n') break;
                    if (c != 32 && c != 9) {
                        nonwhite = begin;
                    }
                    --begin;
                }
                begin = nonwhite;
                nonwhite = end;
                while (end < len && (c = (int)text.charAt(end)) != 10 && c != 13) {
                    if (c != 32 && c != 9) {
                        nonwhite = end;
                    }
                    ++end;
                }
                while (idx <= begin) {
                    if (text.charAt(idx) == '\n') {
                        ++lineno;
                    }
                    ++idx;
                }
                index = end;
                String description = new String(((Object)text.subSequence(begin, Math.min(nonwhite + 1, text.length()))).toString().toCharArray());
                description = this.trim(description, patterns);
                Task task = Task.create((FileObject)resource, (String)GROUP_NAME, (String)description, (int)lineno);
                if (null == tasks) {
                    tasks = new LinkedList<Task>();
                }
                tasks.add((Task)task);
            }
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, e);
        }
        catch (OutOfMemoryError oomE) {
            System.gc();
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, oomE);
        }
        return null == tasks ? this.getEmptyList() : tasks;
    }

    private boolean isSupported(FileObject file) {
        if (null == file || file.isFolder()) {
            return false;
        }
        return Settings.getDefault().isExtensionSupported(file.getExt()) || Settings.getDefault().isMimeTypeSupported(FileUtil.getMIMEType((FileObject)file));
    }

    Pattern getScanRegexp() {
        if (this.regexp == null) {
            StringBuffer sb = new StringBuffer(200);
            Collection<String> patterns = Settings.getDefault().getPatterns();
            boolean needSeparator = false;
            for (String s : patterns) {
                if (needSeparator) {
                    sb.append('|');
                }
                needSeparator = true;
                int n = s.length();
                if (Character.isJavaIdentifierPart(s.charAt(0))) {
                    sb.append("\\W");
                }
                for (int j = 0; j < n; ++j) {
                    char c = s.charAt(j);
                    if (c == '(' || c == ')' || c == '{' || c == '}' || c == '[' || c == ']' || c == '?' || c == '*' || c == '+' || c == '!' || c == '|' || c == '\\' || c == '^' || c == '$') {
                        sb.append('\\');
                    }
                    sb.append(c);
                }
                if (!Character.isJavaIdentifierPart(s.charAt(n - 1))) continue;
                sb.append("\\b");
            }
            try {
                this.regexp = Pattern.compile(sb.toString());
            }
            catch (PatternSyntaxException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, e);
                return null;
            }
        }
        return this.regexp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContent(FileObject fileObject) throws IOException {
        InputStream input = null;
        try {
            input = fileObject.getInputStream();
        }
        catch (FileNotFoundException fnfE) {
            // empty catch block
        }
        if (null == input) {
            return "";
        }
        char[] buf = new char[65536];
        StringBuffer sb = new StringBuffer();
        Charset charset = FileEncodingQuery.getEncoding((FileObject)fileObject);
        BufferedReader r = new BufferedReader(new InputStreamReader(input, charset));
        try {
            int len;
            while ((len = r.read(buf)) != -1) {
                sb.append(buf, 0, len);
            }
        }
        finally {
            ((Reader)r).close();
        }
        return sb.toString();
    }

    private List<? extends Task> getEmptyList() {
        List res = Collections.emptyList();
        return res;
    }

    public void attach(FileTaskScanner.Callback callback) {
        if (null == callback && null != this.callback) {
            this.regexp = null;
            Settings.getDefault().removePropertyChangeListener(this);
        } else if (null != callback && null == this.callback) {
            Settings.getDefault().addPropertyChangeListener(this);
        }
        this.callback = callback;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("patternList".equals(e.getPropertyName()) || "scanCommentsOnly".equals(e.getPropertyName())) {
            this.regexp = null;
            if (null != this.callback) {
                this.callback.refreshAll();
            }
        }
    }

    public void notifyPrepare() {
        this.getScanRegexp();
    }

    public void notifyFinish() {
        this.regexp = null;
    }

    private String trim(String comment, Collection<String> patterns) {
        int index = Integer.MAX_VALUE;
        for (String p : patterns) {
            int i = comment.indexOf(p);
            if (i <= 0 || i >= index) continue;
            index = i;
        }
        if (index > 0 && index < Integer.MAX_VALUE) {
            comment = comment.substring(index);
        }
        return comment;
    }
}

