/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rhtml;

import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.RubyCodeCompleter;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.rhtml.lexer.api.RhtmlTokenId;

public class RhtmlCompleter
extends RubyCodeCompleter {
    public CodeCompletionResult complete(CodeCompletionContext context) {
        ParserResult parserResult = context.getParserResult();
        int caretOffset = context.getCaretOffset();
        BaseDocument doc = RubyUtils.getDocument((Parser.Result)parserResult);
        if (doc != null && RhtmlCompleter.isWithinRuby((Document)doc, caretOffset)) {
            return super.complete(context);
        }
        return CodeCompletionResult.NONE;
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent component, String typedText) {
        int caretOffset;
        Document doc = component.getDocument();
        if (RhtmlCompleter.isWithinRuby(doc, caretOffset = component.getCaret().getDot())) {
            return super.getAutoQuery(component, typedText);
        }
        return CodeCompletionHandler.QueryType.NONE;
    }

    static boolean isWithinRuby(Document doc, int offset) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.move(offset);
        if (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
            TokenId tokenID = tokenSequence.token().id();
            if (tokenID == RhtmlTokenId.RUBY || tokenID == RhtmlTokenId.RUBY_EXPR) {
                return true;
            }
            if (tokenID == RhtmlTokenId.DELIMITER) {
                tokenSequence.movePrevious();
                if (tokenSequence.token().id() == RhtmlTokenId.RUBY || tokenSequence.token().id() == RhtmlTokenId.RUBY_EXPR) {
                    return true;
                }
            }
        }
        return false;
    }
}

