/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.filemodels;

import com.sun.javacard.AID;
import com.sun.javacard.Portability;
import com.sun.javacard.filemodels.FileModelEntry;

public final class AppletXmlAppletEntry
implements FileModelEntry {
    String displayName;
    final String clazz;
    AID aid;
    int order;

    public AppletXmlAppletEntry(String displayName, String clazz, AID aid, int order) {
        this.displayName = displayName;
        this.clazz = clazz;
        this.aid = aid;
        this.order = order;
    }

    public AppletXmlAppletEntry() {
        this(null, null, null, 0);
    }

    @Override
    public String getProblem() {
        if (this.displayName == null || this.displayName.trim().length() == 0) {
            return Portability.getString("MSG_NO_DISPLAY_NAME", this.clazz);
        }
        if (this.aid == null) {
            Portability.getString("MSG_NO_AID", this.clazz);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (AppletXmlAppletEntry.class != obj.getClass()) {
            return false;
        }
        AppletXmlAppletEntry other = (AppletXmlAppletEntry)obj;
        return this.toXml().equals(other.toXml());
    }

    @Override
    public String toXml() {
        StringBuilder sb = new StringBuilder("    <applet>\n");
        sb.append("        <display-name>");
        sb.append(this.displayName);
        sb.append("</display-name>\n");
        sb.append("        <applet-class>");
        sb.append(this.clazz);
        sb.append("</applet-class>\n");
        sb.append("        <applet-AID>");
        sb.append(this.aid);
        sb.append("</applet-AID>\n");
        sb.append("    </applet>\n\n");
        return sb.toString();
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + (this.displayName != null ? this.displayName.hashCode() : 0);
        hash = 13 * hash + (this.clazz != null ? this.clazz.hashCode() : 0);
        hash = 13 * hash + (this.aid != null ? this.aid.hashCode() : 0);
        return hash;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public int compareTo(FileModelEntry o) {
        assert (o == null || o.getClass() == this.getClass());
        return o == null ? 0 : this.getOrder() - o.getOrder();
    }

    public String getClassname() {
        return this.clazz;
    }

    public AID getAID() {
        return this.aid;
    }

    public void setAID(AID aid) {
        this.aid = aid;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }
}

