/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.core;

import java.util.Calendar;

public class DateUtil {
    public static String getIsoFormattedDate(Calendar calendar) {
        try {
            int monthInt = calendar.get(2) + 1;
            String month = "" + monthInt;
            if (monthInt < 10) {
                month = "0" + month;
            }
            int dateInt = calendar.get(5);
            String date = "" + dateInt;
            if (dateInt < 10) {
                date = "0" + date;
            }
            return String.valueOf(calendar.get(1)) + "-" + month + "-" + date;
        }
        catch (Exception exception) {
            return "<unresolved date>";
        }
    }

    public static String getIsoFormattedDateTime(Calendar calendar) {
        return String.valueOf(DateUtil.getIsoFormattedDate(calendar)) + "T" + calendar.get(10) + "-" + calendar.get(12) + "-" + calendar.get(13);
    }

    public static String getFormattedDurationShort(long duration) {
        if (duration <= 0L) {
            return "00:00";
        }
        long totalMinutes = duration / 1000L / 60L;
        long remainderMinutes = totalMinutes % 60L;
        long totalHours = totalMinutes / 60L;
        String hourString = "" + totalHours;
        String minuteString = "" + remainderMinutes;
        if (totalHours < 10L) {
            hourString = "0" + hourString;
        }
        if (remainderMinutes < 10L) {
            minuteString = "0" + remainderMinutes;
        }
        return String.valueOf(hourString) + ":" + minuteString;
    }

    @Deprecated
    public static String getFormattedDuration(long duration, boolean includeSeconds) {
        long seconds = duration / 1000L;
        long minutes = 0L;
        long hours = 0L;
        String formatted = "";
        String hour = "";
        String min = "";
        String sec = "";
        if (seconds >= 3600L) {
            hours = seconds / 3600L;
            if (hours == 1L) {
                hour = String.valueOf(hours) + " hour ";
            } else if (hours > 1L) {
                hour = String.valueOf(hours) + " hours ";
            }
            minutes = (seconds -= hours * 3600L) / 60L;
            if (minutes == 1L) {
                min = String.valueOf(minutes) + " minute ";
            } else if (minutes != 1L) {
                min = String.valueOf(minutes) + " minutes ";
            }
            if ((seconds -= minutes * 60L) == 1L) {
                sec = String.valueOf(seconds) + " second";
            } else if (seconds > 1L) {
                sec = String.valueOf(seconds) + " seconds";
            }
            formatted = String.valueOf(formatted) + hour + min;
            if (includeSeconds) {
                formatted = String.valueOf(formatted) + sec;
            }
        } else if (seconds >= 60L) {
            minutes = seconds / 60L;
            if (minutes == 1L) {
                min = String.valueOf(minutes) + " minute ";
            } else if (minutes != 1L) {
                min = String.valueOf(minutes) + " minutes ";
            }
            if ((seconds -= minutes * 60L) == 1L) {
                sec = String.valueOf(seconds) + " second";
            } else if (seconds > 1L) {
                sec = String.valueOf(seconds) + " seconds";
            }
            formatted = String.valueOf(formatted) + min;
            if (includeSeconds) {
                formatted = String.valueOf(formatted) + sec;
            }
        } else {
            if (seconds == 1L) {
                sec = String.valueOf(seconds) + " second";
            } else if (seconds > 1L) {
                sec = String.valueOf(seconds) + " seconds";
            }
            if (includeSeconds) {
                formatted = String.valueOf(formatted) + sec;
            }
        }
        return formatted;
    }
}

