/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.metadata.model.MetadataUtilities;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.Column;
import org.netbeans.modules.db.metadata.model.api.ForeignKey;
import org.netbeans.modules.db.metadata.model.api.ForeignKeyColumn;
import org.netbeans.modules.db.metadata.model.api.Index;
import org.netbeans.modules.db.metadata.model.api.IndexColumn;
import org.netbeans.modules.db.metadata.model.api.MetadataException;
import org.netbeans.modules.db.metadata.model.api.Ordering;
import org.netbeans.modules.db.metadata.model.api.PrimaryKey;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.netbeans.modules.db.metadata.model.api.Value;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCColumn;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCForeignKey;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCForeignKeyColumn;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCIndex;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCIndexColumn;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCMetadata;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCPrimaryKey;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCSchema;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCUtils;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCValue;
import org.netbeans.modules.db.metadata.model.spi.TableImplementation;
import org.openide.util.NbBundle;

public class JDBCTable
extends TableImplementation {
    private static final Logger LOGGER = Logger.getLogger(JDBCTable.class.getName());
    private final JDBCSchema jdbcSchema;
    private final String name;
    private Map<String, Column> columns;
    private Map<String, Index> indexes;
    private Map<String, ForeignKey> foreignKeys;
    private PrimaryKey primaryKey;
    private boolean primaryKeyInitialized = false;
    private static final String SQL_EXCEPTION_NOT_YET_IMPLEMENTED = "not yet implemented";

    public JDBCTable(JDBCSchema jdbcSchema, String name) {
        this.jdbcSchema = jdbcSchema;
        this.name = name;
    }

    @Override
    public final Schema getParent() {
        return this.jdbcSchema.getSchema();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Collection<Column> getColumns() {
        return this.initColumns().values();
    }

    @Override
    public final Column getColumn(String name) {
        return MetadataUtilities.find(name, this.initColumns());
    }

    @Override
    public PrimaryKey getPrimaryKey() {
        return this.initPrimaryKey();
    }

    @Override
    public Index getIndex(String indexName) {
        return MetadataUtilities.find(indexName, this.initIndexes());
    }

    @Override
    public Collection<Index> getIndexes() {
        return this.initIndexes().values();
    }

    @Override
    public Collection<ForeignKey> getForeignKeys() {
        return this.initForeignKeys().values();
    }

    @Override
    public ForeignKey getForeignKeyByInternalName(String name) {
        return MetadataUtilities.find(name, this.initForeignKeys());
    }

    @Override
    public final void refresh() {
        this.columns = null;
        this.primaryKey = null;
        this.primaryKeyInitialized = false;
    }

    public String toString() {
        return "JDBCTable[name='" + this.name + "']";
    }

    protected JDBCColumn createJDBCColumn(ResultSet rs) throws SQLException {
        JDBCValue jdbcValue;
        int position = 0;
        if (this.isOdbc(rs)) {
            jdbcValue = JDBCValue.createTableColumnValueODBC(rs);
        } else {
            position = rs.getInt("ORDINAL_POSITION");
            jdbcValue = JDBCValue.createTableColumnValue(rs);
        }
        return new JDBCColumn(this.getTable(), position, jdbcValue);
    }

    private boolean isOdbc(ResultSet rs) throws SQLException {
        boolean odbc = this.jdbcSchema.getJDBCCatalog().getJDBCMetadata().getDmd().getURL().startsWith("jdbc:odbc");
        if (odbc) {
            try {
                rs.getInt("PRECISION");
                return true;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return false;
    }

    protected JDBCPrimaryKey createJDBCPrimaryKey(String pkName, Collection<Column> pkcols) {
        return new JDBCPrimaryKey(this.getTable(), pkName, pkcols);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createColumns() {
        LinkedHashMap<String, Column> newColumns = new LinkedHashMap<String, Column>();
        try {
            ResultSet rs = this.jdbcSchema.getJDBCCatalog().getJDBCMetadata().getDmd().getColumns(this.jdbcSchema.getJDBCCatalog().getName(), this.jdbcSchema.getName(), this.name, "%");
            try {
                while (rs.next()) {
                    Column column = this.createJDBCColumn(rs).getColumn();
                    newColumns.put(column.getName(), column);
                    LOGGER.log(Level.FINE, "Created column {0}", column);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException e) {
            this.filterSQLException(e);
        }
        this.columns = Collections.unmodifiableMap(newColumns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createIndexes() {
        LinkedHashMap<String, Index> newIndexes = new LinkedHashMap<String, Index>();
        try {
            ResultSet rs = this.jdbcSchema.getJDBCCatalog().getJDBCMetadata().getDmd().getIndexInfo(this.jdbcSchema.getJDBCCatalog().getName(), this.jdbcSchema.getName(), this.name, false, true);
            try {
                JDBCIndex index = null;
                String currentIndexName = null;
                while (rs.next()) {
                    JDBCIndexColumn idx;
                    if (rs.getShort("TYPE") == 0) continue;
                    String indexName = rs.getString("INDEX_NAME");
                    if (index == null || !currentIndexName.equals(indexName)) {
                        index = this.createJDBCIndex(indexName, rs);
                        LOGGER.log(Level.FINE, "Created index " + index);
                        newIndexes.put(index.getName(), index.getIndex());
                        currentIndexName = indexName;
                    }
                    if ((idx = this.createJDBCIndexColumn(index, rs)) == null) {
                        LOGGER.log(Level.INFO, "Cannot create index column for " + indexName + " from " + rs);
                        continue;
                    }
                    IndexColumn col = idx.getIndexColumn();
                    index.addColumn(col);
                    LOGGER.log(Level.FINE, "Added column " + col.getName() + " to index " + indexName);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException e) {
            this.filterSQLException(e);
        }
        this.indexes = Collections.unmodifiableMap(newIndexes);
    }

    protected JDBCIndex createJDBCIndex(String name, ResultSet rs) {
        Index.IndexType type = Index.IndexType.OTHER;
        boolean isUnique = false;
        try {
            type = JDBCUtils.getIndexType(rs.getShort("TYPE"));
            isUnique = !rs.getBoolean("NON_UNIQUE");
        }
        catch (SQLException e) {
            this.filterSQLException(e);
        }
        return new JDBCIndex(this.getTable(), name, type, isUnique);
    }

    protected JDBCIndexColumn createJDBCIndexColumn(JDBCIndex parent, ResultSet rs) {
        Column column = null;
        int position = 0;
        Ordering ordering = Ordering.NOT_SUPPORTED;
        try {
            column = this.getColumn(rs.getString("COLUMN_NAME"));
            if (!this.isOdbc(rs)) {
                position = rs.getInt("ORDINAL_POSITION");
                ordering = JDBCUtils.getOrdering(rs.getString("ASC_OR_DESC"));
            }
        }
        catch (SQLException e) {
            this.filterSQLException(e);
        }
        if (column == null) {
            LOGGER.log(Level.INFO, "Cannot get column for index " + parent + " from " + rs);
            return null;
        }
        return new JDBCIndexColumn(parent.getIndex(), column.getName(), column, position, ordering);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createForeignKeys() {
        LinkedHashMap<String, ForeignKey> newKeys = new LinkedHashMap<String, ForeignKey>();
        try {
            ResultSet rs = this.jdbcSchema.getJDBCCatalog().getJDBCMetadata().getDmd().getImportedKeys(this.jdbcSchema.getJDBCCatalog().getName(), this.jdbcSchema.getName(), this.name);
            try {
                JDBCForeignKey fkey = null;
                String currentKeyName = null;
                while (rs.next()) {
                    String keyName = rs.getString("FK_NAME");
                    if (fkey == null || keyName == null || !currentKeyName.equals(keyName)) {
                        fkey = this.createJDBCForeignKey(keyName, rs);
                        LOGGER.log(Level.FINE, "Created foreign key " + keyName);
                        newKeys.put(fkey.getInternalName(), fkey.getForeignKey());
                        currentKeyName = keyName;
                    }
                    ForeignKeyColumn col = this.createJDBCForeignKeyColumn(fkey, rs).getForeignKeyColumn();
                    fkey.addColumn(col);
                    LOGGER.log(Level.FINE, "Added foreign key column " + col.getName() + " to foreign key " + keyName);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException e) {
            this.filterSQLException(e);
        }
        this.foreignKeys = Collections.unmodifiableMap(newKeys);
    }

    protected JDBCForeignKey createJDBCForeignKey(String name, ResultSet rs) {
        return new JDBCForeignKey(this.getTable(), name);
    }

    protected JDBCForeignKeyColumn createJDBCForeignKeyColumn(JDBCForeignKey parent, ResultSet rs) {
        Table table = this.findReferredTable(rs);
        String colname = null;
        Column referredColumn = null;
        colname = null;
        Value referringColumn = null;
        int position = 0;
        try {
            table = this.findReferredTable(rs);
            colname = rs.getString("PKCOLUMN_NAME");
            referredColumn = table.getColumn(colname);
            if (referredColumn == null) {
                throw new MetadataException(this.getMessage("ERR_COL_NOT_FOUND", table.getParent().getParent().getName(), table.getParent().getName(), table.getName(), colname));
            }
            colname = rs.getString("FKCOLUMN_NAME");
            referringColumn = this.getColumn(colname);
            position = rs.getInt("KEY_SEQ");
        }
        catch (SQLException e) {
            this.filterSQLException(e);
        }
        return new JDBCForeignKeyColumn(parent.getForeignKey(), referringColumn.getName(), (Column)referringColumn, referredColumn, position);
    }

    private String getMessage(String key, String ... args) {
        return NbBundle.getMessage(JDBCTable.class, (String)key, (Object[])args);
    }

    private Table findReferredTable(ResultSet rs) {
        JDBCMetadata metadata = this.jdbcSchema.getJDBCCatalog().getJDBCMetadata();
        Table table = null;
        try {
            Schema schema;
            Catalog catalog;
            String catalogName = rs.getString("PKTABLE_CAT");
            if (catalogName == null || catalogName.length() == 0) {
                catalog = this.jdbcSchema.getParent();
            } else {
                catalog = metadata.getCatalog(catalogName);
                if (catalog == null) {
                    throw new MetadataException(this.getMessage("ERR_CATALOG_NOT_FOUND", catalogName));
                }
            }
            String schemaName = rs.getString("PKTABLE_SCHEM");
            if (schemaName == null || schemaName.length() == 0) {
                schema = catalog.getSyntheticSchema();
            } else {
                schema = catalog.getSchema(schemaName);
                if (schema == null) {
                    throw new MetadataException(this.getMessage("ERR_SCHEMA_NOT_FOUND", schemaName, catalog.getName()));
                }
            }
            String tableName = rs.getString("PKTABLE_NAME");
            table = schema.getTable(tableName);
            if (table == null) {
                throw new MetadataException(this.getMessage("ERR_TABLE_NOT_FOUND", catalogName, schemaName, tableName));
            }
        }
        catch (SQLException e) {
            this.filterSQLException(e);
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createPrimaryKey() {
        String pkname = null;
        ArrayList<Column> pkcols = new ArrayList<Column>();
        try {
            ResultSet rs = this.jdbcSchema.getJDBCCatalog().getJDBCMetadata().getDmd().getPrimaryKeys(this.jdbcSchema.getJDBCCatalog().getName(), this.jdbcSchema.getName(), this.name);
            try {
                while (rs.next()) {
                    if (pkname == null) {
                        pkname = rs.getString("PK_NAME");
                    }
                    String colName = rs.getString("COLUMN_NAME");
                    pkcols.add(this.getColumn(colName));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException e) {
            this.filterSQLException(e);
        }
        this.primaryKey = this.createJDBCPrimaryKey(pkname, Collections.unmodifiableCollection(pkcols)).getPrimaryKey();
    }

    private Map<String, Column> initColumns() {
        if (this.columns != null) {
            return this.columns;
        }
        LOGGER.log(Level.FINE, "Initializing columns in {0}", this);
        this.createColumns();
        return this.columns;
    }

    private Map<String, Index> initIndexes() {
        if (this.indexes != null) {
            return this.indexes;
        }
        LOGGER.log(Level.FINE, "Initializing indexes in {0}", this);
        this.createIndexes();
        return this.indexes;
    }

    private Map<String, ForeignKey> initForeignKeys() {
        if (this.foreignKeys != null) {
            return this.foreignKeys;
        }
        LOGGER.log(Level.FINE, "Initializing foreign keys in {0}", this);
        this.createForeignKeys();
        return this.foreignKeys;
    }

    private PrimaryKey initPrimaryKey() {
        if (this.primaryKeyInitialized) {
            return this.primaryKey;
        }
        LOGGER.log(Level.FINE, "Initializing columns in {0}", this);
        this.getColumns();
        this.createPrimaryKey();
        this.primaryKeyInitialized = true;
        return this.primaryKey;
    }

    private void filterSQLException(SQLException x) throws MetadataException {
        if (!SQL_EXCEPTION_NOT_YET_IMPLEMENTED.equalsIgnoreCase(x.getMessage())) {
            throw new MetadataException(x);
        }
        Logger.getLogger(JDBCTable.class.getName()).log(Level.FINE, x.getLocalizedMessage(), x);
    }
}

