/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.BaseRubyCustomizerProvider;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class RubyConfigurationProvider
implements ProjectConfigurationProvider<Config> {
    private static final Logger LOGGER = Logger.getLogger(RubyConfigurationProvider.class.getName());
    public static final String PROP_CONFIG = "config";
    public static final String CONFIG_PROPS_PATH = "nbproject/private/config.properties";
    private static final Config DEFAULT = new Config(null, NbBundle.getMessage(RubyConfigurationProvider.class, (String)"RubyConfigurationProvider.default.label"));
    private final RubyBaseProject p;
    private final String customizerCategory;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final FileChangeListener fcl = new FileChangeAdapter(){

        public void fileFolderCreated(FileEvent fe) {
            this.update(fe);
        }

        public void fileDataCreated(FileEvent fe) {
            this.update(fe);
        }

        public void fileDeleted(FileEvent fe) {
            this.update(fe);
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.update((FileEvent)fe);
        }

        private void update(FileEvent ev) {
            LOGGER.log(Level.FINER, "Received {0}", ev);
            Set oldConfigs = RubyConfigurationProvider.this.configs != null ? RubyConfigurationProvider.this.configs.keySet() : Collections.emptySet();
            RubyConfigurationProvider.this.configDir = RubyConfigurationProvider.this.p.getProjectDirectory().getFileObject("nbproject/configs");
            if (RubyConfigurationProvider.this.configDir != null) {
                RubyConfigurationProvider.this.configDir.removeFileChangeListener(RubyConfigurationProvider.this.fclWeak);
                RubyConfigurationProvider.this.configDir.addFileChangeListener(RubyConfigurationProvider.this.fclWeak);
                LOGGER.log(Level.FINER, "(Re-)added listener to {0}", RubyConfigurationProvider.this.configDir);
            } else {
                LOGGER.log(Level.FINER, "No nbproject/configs exists");
            }
            RubyConfigurationProvider.this.calculateConfigs();
            Set newConfigs = RubyConfigurationProvider.this.configs.keySet();
            if (!((Object)oldConfigs).equals(newConfigs)) {
                LOGGER.log(Level.FINER, "Firing configurations: {0} -> {1}", new Object[]{oldConfigs, newConfigs});
                RubyConfigurationProvider.this.pcs.firePropertyChange("configurations", null, null);
            }
        }
    };
    private final FileChangeListener fclWeak;
    private final FileObject nbp;
    private FileObject configDir;
    private Map<String, Config> configs;

    public RubyConfigurationProvider(RubyBaseProject p, String customizerCategory) {
        this.p = p;
        this.customizerCategory = customizerCategory;
        this.fclWeak = FileUtil.weakFileChangeListener((FileChangeListener)this.fcl, null);
        this.nbp = p.getProjectDirectory().getFileObject("nbproject");
        if (this.nbp != null) {
            this.nbp.addFileChangeListener(this.fclWeak);
            LOGGER.log(Level.FINER, "Added listener to {0}", this.nbp);
            this.configDir = this.nbp.getFileObject("configs");
            if (this.configDir != null) {
                this.configDir.addFileChangeListener(this.fclWeak);
                LOGGER.log(Level.FINER, "Added listener to {0}", this.configDir);
            }
        }
        p.evaluator().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (RubyConfigurationProvider.PROP_CONFIG.equals(evt.getPropertyName())) {
                    LOGGER.log(Level.FINER, "Refiring config -> activeConfiguration");
                    RubyConfigurationProvider.this.pcs.firePropertyChange("activeConfiguration", null, null);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateConfigs() {
        this.configs = new HashMap<String, Config>();
        if (this.configDir != null) {
            for (FileObject kid : this.configDir.getChildren()) {
                if (!kid.hasExt("properties")) continue;
                try {
                    InputStream is = kid.getInputStream();
                    try {
                        Properties p = new Properties();
                        p.load(is);
                        String name = kid.getName();
                        String label = p.getProperty("$label");
                        this.configs.put(name, new Config(name, label != null ? label : name));
                    }
                    finally {
                        is.close();
                    }
                }
                catch (IOException x) {
                    LOGGER.log(Level.INFO, null, x);
                }
            }
        }
        LOGGER.log(Level.FINER, "Calculated configurations: {0}", this.configs);
    }

    public Collection<Config> getConfigurations() {
        this.calculateConfigs();
        ArrayList<Config> l = new ArrayList<Config>();
        l.addAll(this.configs.values());
        Collections.sort(l, new Comparator<Config>(){
            Collator c = Collator.getInstance();

            @Override
            public int compare(Config c1, Config c2) {
                return this.c.compare(c1.getDisplayName(), c2.getDisplayName());
            }
        });
        l.add(0, DEFAULT);
        return l;
    }

    public Config getActiveConfiguration() {
        this.calculateConfigs();
        String config = this.p.evaluator().getProperty(PROP_CONFIG);
        if (config != null && this.configs.containsKey(config)) {
            return this.configs.get(config);
        }
        return DEFAULT;
    }

    public void setActiveConfiguration(Config c) throws IllegalArgumentException, IOException {
        if (c != DEFAULT && !this.configs.values().contains(c)) {
            throw new IllegalArgumentException();
        }
        String n = c.name;
        EditableProperties ep = this.p.getUpdateHelper().getProperties(CONFIG_PROPS_PATH);
        if (Utilities.compareObjects((Object)n, (Object)ep.getProperty(PROP_CONFIG))) {
            return;
        }
        if (n != null) {
            ep.setProperty(PROP_CONFIG, n);
        } else {
            ep.remove((Object)PROP_CONFIG);
        }
        this.p.getUpdateHelper().putProperties(CONFIG_PROPS_PATH, ep);
        this.pcs.firePropertyChange("activeConfiguration", null, null);
        ProjectManager.getDefault().saveProject((Project)this.p);
        assert (this.p.getProjectDirectory().getFileObject(CONFIG_PROPS_PATH) != null);
    }

    public boolean hasCustomizer() {
        return true;
    }

    public void customize() {
        ((BaseRubyCustomizerProvider)this.p.getLookup().lookup(BaseRubyCustomizerProvider.class)).showCustomizer(this.customizerCategory);
    }

    public boolean configurationsAffectAction(String command) {
        return command.equals("run") || command.equals("debug");
    }

    public void addPropertyChangeListener(PropertyChangeListener lst) {
        this.pcs.addPropertyChangeListener(lst);
    }

    public void removePropertyChangeListener(PropertyChangeListener lst) {
        this.pcs.removePropertyChangeListener(lst);
    }

    public static final class Config
    implements ProjectConfiguration {
        public final String name;
        private final String displayName;

        public Config(String name, String displayName) {
            this.name = name;
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }

        public boolean equals(Object o) {
            return o instanceof Config && Utilities.compareObjects((Object)this.name, (Object)((Config)o).name);
        }

        public String toString() {
            return "RubyConfigurationProvider.Config[" + this.name + "," + this.displayName + "]";
        }
    }
}

