/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.rubyproject.RubyProject;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.EditableProperties;
import org.openide.util.NbBundle;

public class RubyProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOperationImplementation {
    private final RubyProject project;
    private static EditableProperties origPrivateProperties;

    public RubyProjectOperations(RubyProject project) {
        this.project = project;
    }

    private static void addFile(FileObject projectDirectory, String fileName, List<FileObject> result) {
        FileObject file = projectDirectory.getFileObject(fileName);
        if (file != null) {
            result.add(file);
        }
    }

    public List<FileObject> getMetadataFiles() {
        FileObject projectDirectory = this.project.getProjectDirectory();
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        RubyProjectOperations.addFile(projectDirectory, "nbproject", files);
        RubyProjectOperations.addFile(projectDirectory, "Capfile", files);
        RubyProjectOperations.addFile(projectDirectory, "README", files);
        RubyProjectOperations.addFile(projectDirectory, "LICENSE", files);
        return files;
    }

    public List<FileObject> getDataFiles() {
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        files.addAll(Arrays.asList(this.project.getSourceRoots().getRoots()));
        files.addAll(Arrays.asList(this.project.getTestSourceRoots().getRoots()));
        RubyProjectOperations.addFile(this.project.getProjectDirectory(), "Rakefile", files);
        return files;
    }

    public void notifyDeleting() throws IOException {
    }

    public void notifyDeleted() throws IOException {
        this.project.getRakeProjectHelper().notifyDeleted();
    }

    public void notifyCopying() {
        origPrivateProperties = this.project.getRakeProjectHelper().getProperties("nbproject/private/private.properties");
    }

    public void notifyCopied(Project original, File originalPath, String nueName) {
        if (original == null) {
            return;
        }
        this.project.getReferenceHelper().fixReferences(originalPath);
        this.project.setName(nueName);
        this.copyPrivateProps();
    }

    public void notifyMoving() throws IOException {
        origPrivateProperties = this.project.getRakeProjectHelper().getProperties("nbproject/private/private.properties");
        if (!this.project.getUpdateHelper().requestSave()) {
            throw new IOException(NbBundle.getMessage(RubyProjectOperations.class, (String)"MSG_OldProjectMetadata"));
        }
        this.notifyDeleting();
    }

    public void notifyMoved(Project original, File originalPath, String nueName) {
        if (original == null) {
            this.project.getRakeProjectHelper().notifyDeleted();
            return;
        }
        this.project.setName(nueName);
        this.project.getReferenceHelper().fixReferences(originalPath);
        this.copyPrivateProps();
    }

    private void copyPrivateProps() {
        this.project.getReferenceHelper().copyToPrivateProperties(origPrivateProperties);
        origPrivateProperties = null;
    }
}

